/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.fsm.draw;

import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KGraphElement;
import de.cau.cs.kieler.core.kgraph.KLabel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import ro.amiq.dvt.diagrams.fsm.draw.obj.FSMDLabel;
import ro.amiq.dvt.diagrams.fsm.draw.obj.FSMDObject;
import ro.amiq.dvt.diagrams.fsm.draw.obj.FSMDScene;
import ro.amiq.dvt.diagrams.fsm.model.FSMTransition;
import ro.amiq.dvt.diagrams.fsm.model.IFSMViewSelectable;
import ro.amiq.dvt.diagrams.fsm.model.IFSMViewSelectable2;
import ro.amiq.dvt.diagrams.klay.model.KLayWrapper;
import ro.amiq.dvt.draw.obj.interaction.DSelectable;
import ro.amiq.dvt.fsm.model.IFSMBase;

public interface FSMDrawUtils {
    public static KGraphElement getKElementFromFSMDObject(FSMDObject fmsdObject) {
        if (fmsdObject == null) {
            return null;
        }
        return fmsdObject.getProperty(FSMDObject.KELEMENT);
    }

    public static Map<String, Set<DSelectable>> addDriverAndLoadObjectsToSelection(Map<String, Set<DSelectable>> selection, IFSMViewSelectable2 fsmObject, FSMDScene scene) {
        HashSet<DSelectable> result;
        if (selection == null) {
            return null;
        }
        LinkedHashSet<KGraphElement> drivers = new LinkedHashSet<KGraphElement>(fsmObject.getDrivers());
        LinkedHashSet<KGraphElement> loads = new LinkedHashSet<KGraphElement>(fsmObject.getLoads());
        LinkedHashSet<KGraphElement> driversAndLoads = new LinkedHashSet<KGraphElement>(drivers);
        driversAndLoads.retainAll(loads);
        drivers.removeAll(driversAndLoads);
        loads.removeAll(driversAndLoads);
        if (!drivers.isEmpty()) {
            result = new HashSet<DSelectable>();
            for (KGraphElement element : drivers) {
                result.add((DSelectable)((Object)scene.getDObject(element)));
            }
            selection.put("DRIVER_SELECTION", result);
        }
        if (!loads.isEmpty()) {
            result = new HashSet();
            for (KGraphElement element : loads) {
                result.add((DSelectable)((Object)scene.getDObject(element)));
            }
            selection.put("LOAD_SELECTION", result);
        }
        if (!driversAndLoads.isEmpty()) {
            result = new HashSet();
            for (KGraphElement element : driversAndLoads) {
                result.add((DSelectable)((Object)scene.getDObject(element)));
            }
            selection.put("DRIVER_AND_LOAD_SELECTION", result);
        }
        return selection;
    }

    public static <T extends KGraphElement> T getKElementFromFSMDObject(FSMDObject fsmdObject, Class<T> resultClass) {
        if (fsmdObject == null) {
            return null;
        }
        KGraphElement kElement = fsmdObject.getProperty(FSMDObject.KELEMENT);
        if (!resultClass.isInstance(kElement)) {
            return null;
        }
        return (T)kElement;
    }

    public static Object getFSMObjectFromKElement(KGraphElement kElement) {
        if (kElement == null) {
            return null;
        }
        KLayWrapper wrapper = (KLayWrapper)kElement.getData(KLayWrapper.class);
        if (wrapper == null) {
            return null;
        }
        return wrapper.getOrigin();
    }

    public static <T> T getFSMObjectFromKElement(KGraphElement kElement, Class<T> resultClass) {
        if (kElement == null) {
            return null;
        }
        KLayWrapper wrapper = (KLayWrapper)kElement.getData(KLayWrapper.class);
        if (wrapper == null) {
            return null;
        }
        return wrapper.getOrigin(resultClass);
    }

    public static Object getFSMObjectFromFSMDObject(FSMDObject fsmdObject) {
        return FSMDrawUtils.getFSMObjectFromKElement(FSMDrawUtils.getKElementFromFSMDObject(fsmdObject));
    }

    public static <T> T getFSMObjectFromFSMDObject(FSMDObject fsmdObject, Class<T> resultClass) {
        Object result = FSMDrawUtils.getFSMObjectFromKElement(FSMDrawUtils.getKElementFromFSMDObject(fsmdObject));
        if (!resultClass.isInstance(result)) {
            return null;
        }
        return (T)result;
    }

    public static String getFSMNameFromFSMDObject(FSMDObject fsmdObject) {
        IFSMBase fsmObject = FSMDrawUtils.getFSMObjectFromFSMDObject(fsmdObject, IFSMBase.class);
        if (fsmObject == null) {
            return null;
        }
        return fsmObject.toString();
    }

    public static KGraphElement getKElementFromFSMObject(FSMDScene scene, Object object) {
        if (scene == null || object == null) {
            return null;
        }
        for (Map.Entry<KGraphElement, FSMDObject> entry : scene.getKDEntries()) {
            if (!object.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    public static FSMDObject getFSMDObjectFromFSMTransition(FSMDScene scene, FSMTransition object) {
        if (object == null || scene == null) {
            return null;
        }
        KEdge kEdge = object.getEdge();
        if (kEdge == null) {
            return null;
        }
        return scene.getDObject(kEdge);
    }

    public static List<FSMDLabel.FSMDSelectableLabel> getFSMDLabelsFromFSMTransition(FSMDScene scene, FSMTransition object) {
        if (object == null || scene == null) {
            return null;
        }
        KEdge kEdge = object.getEdge();
        if (kEdge == null) {
            return null;
        }
        EList labels = kEdge.getLabels();
        if (labels == null || labels.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<FSMDLabel.FSMDSelectableLabel> result = new ArrayList<FSMDLabel.FSMDSelectableLabel>(labels.size());
        for (KLabel kLabel : labels) {
            FSMDObject dLabel = scene.getDObject(kLabel);
            if (!(dLabel instanceof FSMDLabel.FSMDSelectableLabel)) continue;
            result.add((FSMDLabel.FSMDSelectableLabel)dLabel);
        }
        return result;
    }

    public static IFSMViewSelectable getFSMViewSelectable(DSelectable sel) {
        return FSMDrawUtils.unwrapFSMSelection(sel, IFSMViewSelectable.class);
    }

    public static <T> T unwrapFSMSelection(DSelectable sel, Class<T> clazz) {
        if (!(sel instanceof FSMDObject)) {
            return null;
        }
        IFSMBase obj = FSMDrawUtils.getFSMObjectFromFSMDObject((FSMDObject)((Object)sel), IFSMBase.class);
        return (T)(clazz.isInstance(obj) ? obj : null);
    }
}

