/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.fsm.draw.obj;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Rectangle;
import ro.amiq.dvt.diagrams.fsm.draw.FSMDrawUtils;
import ro.amiq.dvt.diagrams.fsm.draw.obj.FSMDObject;
import ro.amiq.dvt.diagrams.fsm.model.FSMState;
import ro.amiq.dvt.draw.obj.base.DObject;
import ro.amiq.dvt.draw.obj.base.DShape;
import ro.amiq.dvt.draw.obj.interaction.DSelectable;
import ro.amiq.dvt.draw.obj.primitive.DOval;
import ro.amiq.dvt.draw.obj.primitive.DRoundRectangle;
import ro.amiq.dvt.draw.obj.utils.DProperties;
import ro.amiq.dvt.draw.obj.utils.RGBV;

public class FSMDContainer
extends FSMDObject
implements DSelectable {
    public static final DProperties.Key<Shape> SHAPE = new DProperties.Key("FSMDContainer.SHAPE");
    protected DShape shape;

    @Override
    public void forge() {
        Rectangle layout = (Rectangle)this.getProperty(LAYOUT);
        this.shape = this.getProperty(SHAPE) == Shape.ELLIPSE ? new DOval(layout.x, layout.y, layout.width, layout.height) : new DRoundRectangle(layout.x, layout.y, layout.width, layout.height, 20);
        this.shape.setLineStyle((Integer)this.getProperty(LINE_STYLE));
        this.shape.setLineWidth((Integer)this.getProperty(LINE_WIDTH));
        this.shape.setLineColor((RGBV)this.getProperty(LINE_COLOR));
        this.shape.setFillColor((RGBV)this.getProperty(FILL_COLOR));
        this.shape.setLineCap(1);
        this.shape.setLineAutoScale(true);
        this.addChild(this.shape);
    }

    @Override
    public void select(boolean selected, String type) {
        if ("MAIN_SELECTION".equals(type)) {
            this.shape.setLineColor(selected ? (RGBV)this.getProperty(SELECTED_LINE_COLOR) : (RGBV)this.getProperty(LINE_COLOR));
            this.shape.setFillColor(selected ? (RGBV)this.getProperty(SELECTED_FILL_COLOR) : (RGBV)this.getProperty(FILL_COLOR));
            this.shape.setLineWidth(selected ? ((Integer)this.getProperty(SELECTED_LINE_WIDTH)).intValue() : ((Integer)this.getProperty(LINE_WIDTH)).intValue());
        } else if ("DRIVER_SELECTION".equals(type)) {
            this.shape.setLineColor(selected ? (RGBV)this.getProperty(SELECTED_DRIVER_LINE_COLOR) : (RGBV)this.getProperty(LINE_COLOR));
            this.shape.setFillColor(selected ? (RGBV)this.getProperty(SELECTED_DRIVER_FILL_COLOR) : (RGBV)this.getProperty(FILL_COLOR));
            this.shape.setLineWidth(selected ? ((Integer)this.getProperty(SELECTED_DRIVER_LINE_WIDTH)).intValue() : ((Integer)this.getProperty(LINE_WIDTH)).intValue());
        } else if ("LOAD_SELECTION".equals(type)) {
            this.shape.setLineColor(selected ? (RGBV)this.getProperty(SELECTED_LOAD_LINE_COLOR) : (RGBV)this.getProperty(LINE_COLOR));
            this.shape.setFillColor(selected ? (RGBV)this.getProperty(SELECTED_LOAD_FILL_COLOR) : (RGBV)this.getProperty(FILL_COLOR));
            this.shape.setLineWidth(selected ? ((Integer)this.getProperty(SELECTED_LOAD_LINE_WIDTH)).intValue() : ((Integer)this.getProperty(LINE_WIDTH)).intValue());
        } else if ("DRIVER_AND_LOAD_SELECTION".equals(type)) {
            this.shape.setLineColor(selected ? (RGBV)this.getProperty(SELECTED_DRIVER_AND_LOAD_LINE_COLOR) : (RGBV)this.getProperty(LINE_COLOR));
            this.shape.setFillColor(selected ? (RGBV)this.getProperty(SELECTED_DRIVER_AND_LOAD_FILL_COLOR) : (RGBV)this.getProperty(FILL_COLOR));
            this.shape.setLineWidth(selected ? ((Integer)this.getProperty(SELECTED_DRIVER_AND_LOAD_LINE_WIDTH)).intValue() : ((Integer)this.getProperty(LINE_WIDTH)).intValue());
        }
    }

    @Override
    public List<DObject> getSelectedObjects() {
        ArrayList<DObject> selectedObjects = new ArrayList<DObject>();
        selectedObjects.add(this.shape);
        return selectedObjects;
    }

    @Override
    public String shortValueString() {
        FSMState object = FSMDrawUtils.getFSMObjectFromFSMDObject(this, FSMState.class);
        return String.valueOf(object.toString()) + "\n" + super.shortValueString();
    }

    public static enum Shape {
        ELLIPSE,
        ROUNDED_RECTANGLE;

    }
}

