/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.fsm.draw.obj;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Point;
import ro.amiq.dvt.diagrams.fsm.draw.obj.FSMDObject;
import ro.amiq.dvt.draw.obj.base.DObject;
import ro.amiq.dvt.draw.obj.interaction.DSelectable;
import ro.amiq.dvt.draw.obj.primitive.DHeadClosedArrow;
import ro.amiq.dvt.draw.obj.primitive.DSpline;
import ro.amiq.dvt.draw.obj.utils.DProperties;
import ro.amiq.dvt.draw.obj.utils.RGBV;

public class FSMDEdge
extends FSMDObject
implements DSelectable {
    public static final DProperties.Key<List<Point>> BENDING_POINTS = new DProperties.Key("FSMDEdge.BENDING_POINTS");
    public static final DProperties.Key<Integer> ARROW_SIZE = new DProperties.Key("FSMDEdge.ARROW_SIZE");
    private DSpline spline;
    private DHeadClosedArrow arrowHead;

    @Override
    public void forge() {
        List<Point> bendingPoints = this.getProperty(BENDING_POINTS);
        this.spline = new DSpline(bendingPoints);
        this.spline.setLineWidth((Integer)this.getProperty(LINE_WIDTH));
        this.spline.setLineStyle((Integer)this.getProperty(LINE_STYLE));
        this.spline.setLineCap(3);
        this.addChild(this.spline);
        int x1 = bendingPoints.get((int)(bendingPoints.size() - 1)).x;
        int y1 = bendingPoints.get((int)(bendingPoints.size() - 1)).y;
        int x2 = bendingPoints.get((int)(bendingPoints.size() - 2)).x;
        int y2 = bendingPoints.get((int)(bendingPoints.size() - 2)).y;
        this.arrowHead = x1 - x2 == 0 ? new DHeadClosedArrow(this.getProperty(ARROW_SIZE), x1, y1 + 3 * Integer.signum(y1 - y2), x2, y2) : (y1 - y2 == 0 ? new DHeadClosedArrow(this.getProperty(ARROW_SIZE), x1 + 3 * Integer.signum(x1 - x2), y1, x2, y2) : new DHeadClosedArrow(this.getProperty(ARROW_SIZE), x1, y1, x2, y2));
        this.addChild(this.arrowHead);
        this.select(false, "MAIN_SELECTION");
    }

    @Override
    public void select(boolean selected, String type) {
        RGBV lineColor = null;
        int lineWidth = 0;
        if ("MAIN_SELECTION".equals(type)) {
            lineColor = selected ? (RGBV)this.getProperty(SELECTED_LINE_COLOR) : (RGBV)this.getProperty(LINE_COLOR);
            lineWidth = selected ? ((Integer)this.getProperty(SELECTED_LINE_WIDTH)).intValue() : ((Integer)this.getProperty(LINE_WIDTH)).intValue();
        } else if ("DRIVER_SELECTION".equals(type)) {
            lineColor = selected ? (RGBV)this.getProperty(SELECTED_DRIVER_LINE_COLOR) : (RGBV)this.getProperty(LINE_COLOR);
            lineWidth = selected ? ((Integer)this.getProperty(SELECTED_DRIVER_LINE_WIDTH)).intValue() : ((Integer)this.getProperty(LINE_WIDTH)).intValue();
        } else if ("LOAD_SELECTION".equals(type)) {
            lineColor = selected ? (RGBV)this.getProperty(SELECTED_LOAD_LINE_COLOR) : (RGBV)this.getProperty(LINE_COLOR);
            lineWidth = selected ? ((Integer)this.getProperty(SELECTED_LOAD_LINE_WIDTH)).intValue() : ((Integer)this.getProperty(LINE_WIDTH)).intValue();
        } else if ("DRIVER_AND_LOAD_SELECTION".equals(type)) {
            lineColor = selected ? (RGBV)this.getProperty(SELECTED_DRIVER_AND_LOAD_LINE_COLOR) : (RGBV)this.getProperty(LINE_COLOR);
            lineWidth = selected ? ((Integer)this.getProperty(SELECTED_DRIVER_AND_LOAD_LINE_WIDTH)).intValue() : ((Integer)this.getProperty(LINE_WIDTH)).intValue();
        }
        this.spline.setLineColor(lineColor);
        this.spline.setLineWidth(lineWidth);
        this.arrowHead.setLineColor(lineColor);
        this.arrowHead.setFillColor(lineColor);
        this.arrowHead.setLineWidth(lineWidth);
    }

    @Override
    public List<DObject> getSelectedObjects() {
        ArrayList<DObject> selectedObjects = new ArrayList<DObject>();
        selectedObjects.add(this.spline);
        selectedObjects.add(this.arrowHead);
        return selectedObjects;
    }
}

