/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.fsm.draw.obj;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Rectangle;
import ro.amiq.dvt.diagrams.fsm.draw.FSMDrawUtils;
import ro.amiq.dvt.diagrams.fsm.draw.obj.FSMDObject;
import ro.amiq.dvt.diagrams.fsm.model.FSMCondition;
import ro.amiq.dvt.draw.obj.base.DObject;
import ro.amiq.dvt.draw.obj.interaction.DSearchable;
import ro.amiq.dvt.draw.obj.interaction.DSelectable;
import ro.amiq.dvt.draw.obj.primitive.DText;
import ro.amiq.dvt.draw.obj.utils.DProperties;
import ro.amiq.dvt.draw.obj.utils.RGBV;
import ro.amiq.dvt.model.reflection.GoToInfo;

public class FSMDLabel
extends FSMDObject
implements DSearchable {
    public static final DProperties.Key<FontData> FONT = new DProperties.Key("FSMDLabel.FONT");
    public static final DProperties.Key<String> TEXT = new DProperties.Key("FSMDLabel.TEXT");
    protected DText text;

    @Override
    public void forge() {
        Rectangle layout = (Rectangle)this.getProperty(LAYOUT);
        this.text = new DText(this.getProperty(TEXT), layout.x, layout.y, layout.width, layout.height, this.getProperty(FONT));
        this.text.setTextColor((RGBV)this.getProperty(LINE_COLOR));
        this.addChild(this.text);
    }

    @Override
    public String getSearchText() {
        return this.getProperty(TEXT);
    }

    @Override
    public void highlightSearchMatch(DSearchable.Highlight highlight) {
        if (highlight == DSearchable.Highlight.NONE) {
            this.text.setHighlight(-1, -1);
        } else {
            this.text.setHighlightColor(highlight.getColor());
            this.text.setHighlight(2, this.getProperty(TEXT).length() - 1);
        }
    }

    @Override
    public String shortValueString() {
        GoToInfo marker;
        String result = this.getProperty(TEXT);
        FSMCondition object = FSMDrawUtils.getFSMObjectFromFSMDObject(this, FSMCondition.class);
        if (object != null && (marker = object.getFormula().getMarker()) != null) {
            result = marker + "\n" + result;
        }
        return result;
    }

    public static class FSMDSelectableLabel
    extends FSMDLabel
    implements DSelectable {
        @Override
        public void select(boolean selected, String type) {
            RGBV lineColor = selected ? (RGBV)this.getProperty(SELECTED_LINE_COLOR) : (RGBV)this.getProperty(LINE_COLOR);
            this.text.setTextColor(lineColor);
        }

        @Override
        public List<DObject> getSelectedObjects() {
            ArrayList<DObject> selectedObjects = new ArrayList<DObject>();
            selectedObjects.add(this.text);
            return selectedObjects;
        }
    }
}

