/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.fsm.editor;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.diagrams.DDiagram;
import ro.amiq.dvt.diagrams.editor.DDiagramEditor;
import ro.amiq.dvt.diagrams.editor.DDiagramEditorInput;
import ro.amiq.dvt.diagrams.editor.DMenuItem;
import ro.amiq.dvt.diagrams.fsm.FSMDiagram;
import ro.amiq.dvt.diagrams.fsm.FSMDiagramConfiguration;
import ro.amiq.dvt.diagrams.fsm.draw.FSMDrawUtils;
import ro.amiq.dvt.diagrams.fsm.draw.obj.FSMDEdge;
import ro.amiq.dvt.diagrams.fsm.draw.obj.FSMDLabel;
import ro.amiq.dvt.diagrams.fsm.draw.obj.FSMDObject;
import ro.amiq.dvt.diagrams.fsm.draw.obj.FSMDScene;
import ro.amiq.dvt.diagrams.fsm.editor.FSMTransitionTable;
import ro.amiq.dvt.diagrams.fsm.editor.FSMTransitionTableData;
import ro.amiq.dvt.diagrams.fsm.editor.FSMTransitionTableRow;
import ro.amiq.dvt.diagrams.fsm.editor.actions.TransitionLabelType;
import ro.amiq.dvt.diagrams.fsm.editor.actions.menu.DFSMMenuActionFactory;
import ro.amiq.dvt.diagrams.fsm.model.FSMTransition;
import ro.amiq.dvt.diagrams.fsm.model.IFSMViewSelectable2;
import ro.amiq.dvt.draw.obj.interaction.DSelectable;

public abstract class DFSMEditorContributorsCommon {
    public static List<DMenuItem> getMenuItems(DDiagramEditor diagramEditor, Set<DSelectable> selection) {
        return DFSMMenuActionFactory.createActions(selection, diagramEditor.getInput().getDiagram());
    }

    public static Map<String, Set<DSelectable>> getSelectedObjects(DDiagramEditor diagramEditor, DSelectable object) {
        LinkedHashMap<String, Set<DSelectable>> selection = new LinkedHashMap<String, Set<DSelectable>>();
        selection.put("MAIN_SELECTION", Collections.singleton(object));
        if (!(object instanceof FSMDObject)) {
            return selection;
        }
        boolean highlightPrevAndNext = DVTPlugin.getDefault().getPreferenceStore().getBoolean("designdiagrams.fsm_highlight_prev_and_next_states");
        if (!highlightPrevAndNext) {
            return selection;
        }
        IFSMViewSelectable2 fsmObject = FSMDrawUtils.getFSMObjectFromFSMDObject((FSMDObject)((Object)object), IFSMViewSelectable2.class);
        if (fsmObject == null) {
            return selection;
        }
        DDiagramEditorInput input = diagramEditor.getInput();
        FSMDScene content = (FSMDScene)diagramEditor.getCanvas().getContent();
        if (input != null && fsmObject instanceof FSMTransition) {
            List<FSMDLabel.FSMDSelectableLabel> fsmDLabels;
            DDiagram diagram = input.getDiagram();
            FSMDiagramConfiguration config = diagram instanceof FSMDiagram ? ((FSMDiagram)diagram).getConfig() : null;
            FSMTransition transition = (FSMTransition)fsmObject;
            if (object instanceof FSMDLabel.FSMDSelectableLabel) {
                FSMDObject fsmDObject = FSMDrawUtils.getFSMDObjectFromFSMTransition(content, transition);
                if (fsmDObject instanceof FSMDEdge) {
                    selection.put("MAIN_SELECTION", new HashSet<DSelectable>(Arrays.asList(object, (FSMDEdge)fsmDObject)));
                }
            } else if (object instanceof FSMDEdge && config != null && config.get(FSMDiagramConfiguration.FSMDiagramConfigurationKey.SHOW_TRANSITION_LABELS) == TransitionLabelType.INDEX && (fsmDLabels = FSMDrawUtils.getFSMDLabelsFromFSMTransition(content, transition)) != null && !fsmDLabels.isEmpty()) {
                selection.put("MAIN_SELECTION", new HashSet<DSelectable>(Arrays.asList(object, fsmDLabels.get(0))));
            }
        }
        return FSMDrawUtils.addDriverAndLoadObjectsToSelection(selection, fsmObject, content);
    }

    public static FSMTransitionTable getTransitionTable(DDiagramEditor diagramEditor) {
        FSMDiagram diagram = (FSMDiagram)diagramEditor.getInput().getDiagram();
        FSMTransitionTable transitionTable = diagramEditor.getTransitionTable();
        FSMTransitionTableData tableConstructor = diagram.getTableConstructor();
        if (tableConstructor == null) {
            return transitionTable;
        }
        List<FSMTransitionTableRow> rows = tableConstructor.getRows();
        if (rows != null) {
            transitionTable.setRows(rows);
        } else {
            transitionTable.setRows(Collections.emptyList());
        }
        return transitionTable;
    }
}

