/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.fsm.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import ro.amiq.dvt.diagrams.editor.DDiagramEditor;
import ro.amiq.dvt.diagrams.editor.DDiagramEditorSelection;
import ro.amiq.dvt.diagrams.fsm.draw.FSMDrawUtils;
import ro.amiq.dvt.diagrams.fsm.draw.obj.FSMDObject;
import ro.amiq.dvt.diagrams.fsm.editor.FSMTransitionTableCommon;
import ro.amiq.dvt.diagrams.fsm.editor.FSMTransitionTableRow;
import ro.amiq.dvt.diagrams.tables.TableExportFormat;
import ro.amiq.dvt.diagrams.tables.TableExportUtils;
import ro.amiq.dvt.draw.obj.interaction.DSelectable;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.ui.DVTImages;

public class FSMTransitionTable
extends FSMTransitionTableCommon {
    private static final String COPY_TABLE_TOOLTIP = "Copy Table to Clipboard As... ";
    public static final String COPY_TABLE_MENU_ENTRY = "Copy Table As...";
    private static final int DEFAULT_COLUMN_WIDTH = 120;
    public static final int TRANSITION_INDEX_ID = 0;
    public static final int CURRENT_STATE_ID = 1;
    public static final int NEXT_STATE_ID = 2;
    public static final int CONDITION_ID = 3;
    private final Color selectedColor;
    private boolean selectionInTable;
    private TableViewer tableViewer;
    private final Comparator<FSMTransitionTableRow> BY_CURRENT_STATE = new Comparator<FSMTransitionTableRow>(){

        @Override
        public int compare(FSMTransitionTableRow o1, FSMTransitionTableRow o2) {
            if (FSMTransitionTable.this.tableViewer.getTable().getSortDirection() == 128) {
                return o1.getCurrentState().toString().compareTo(o2.getCurrentState().toString());
            }
            return o2.getCurrentState().toString().compareTo(o1.getCurrentState().toString());
        }
    };
    private final Comparator<FSMTransitionTableRow> BY_NEXT_STATE = new Comparator<FSMTransitionTableRow>(){

        @Override
        public int compare(FSMTransitionTableRow o1, FSMTransitionTableRow o2) {
            if (FSMTransitionTable.this.tableViewer.getTable().getSortDirection() == 128) {
                return o1.getNextState().toString().compareTo(o2.getNextState().toString());
            }
            return o2.getNextState().toString().compareTo(o1.getNextState().toString());
        }
    };
    private final Comparator<FSMTransitionTableRow> BY_CONDITION = new Comparator<FSMTransitionTableRow>(){

        @Override
        public int compare(FSMTransitionTableRow o1, FSMTransitionTableRow o2) {
            if (FSMTransitionTable.this.tableViewer.getTable().getSortDirection() == 128) {
                return o1.getCondition().toString().compareTo(o2.getCondition().toString());
            }
            return o2.getCondition().toString().compareTo(o1.getCondition().toString());
        }
    };
    private final Comparator<FSMTransitionTableRow> BY_TRANSITION_INDEX = new Comparator<FSMTransitionTableRow>(){

        @Override
        public int compare(FSMTransitionTableRow o1, FSMTransitionTableRow o2) {
            if (FSMTransitionTable.this.tableViewer.getTable().getSortDirection() == 128) {
                return o1.getTransitionIndex() - o2.getTransitionIndex();
            }
            return o2.getTransitionIndex() - o1.getTransitionIndex();
        }
    };
    private final ISelectionChangedListener transitionTableSelectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            Display.getDefault().asyncExec(() -> FSMTransitionTable.this.updateSelection(((DDiagramEditorSelection)event.getSelection()).getElements()));
        }
    };

    public FSMTransitionTable(Composite parent, DDiagramEditor diagramEditor) {
        this.rows = new ArrayList();
        this.selectedColor = JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.filter.backgroundColor");
        this.createTableViewer(parent);
        this.diagramEditor = diagramEditor;
    }

    public FSMTransitionTable() {
        this.rows = new ArrayList();
        this.selectedColor = null;
    }

    public ISelectionChangedListener getTransitionTableSelectionChangedListener() {
        return this.transitionTableSelectionChangedListener;
    }

    @Override
    public void updateSelection(Set<DSelectable> selection) {
        Set<Object> selected = Collections.emptySet();
        if (!this.selectionInTable) {
            selected = selection.stream().filter(x -> x instanceof FSMDObject).map(x -> FSMDrawUtils.getFSMObjectFromFSMDObject((FSMDObject)((Object)x))).collect(Collectors.toSet());
        } else {
            this.selectionInTable = false;
        }
        this.selectRow(selected);
        this.update();
    }

    @Override
    protected boolean scrollToSelection(boolean scrolled, FSMTransitionTableRow row) {
        if (!scrolled) {
            this.tableViewer.getTable().setTopIndex(row.getTransitionIndex() - 1);
            scrolled = true;
        }
        return scrolled;
    }

    public void updateTransitionTableView() {
        Control control = this.tableViewer.getControl();
        if (control.isDisposed()) {
            return;
        }
        SashForm sashFormParent = (SashForm)this.tableViewer.getControl().getParent();
        if (!this.isHidden()) {
            this.update();
            this.setVisible(true);
            sashFormParent.setWeights(new int[]{67, 33});
        } else {
            this.update();
            this.setVisible(false);
        }
        sashFormParent.layout(true);
    }

    public void setVisible(boolean isVisible) {
        Control control = this.tableViewer.getControl();
        if (control.isDisposed()) {
            return;
        }
        this.tableViewer.getControl().setVisible(isVisible);
    }

    private int getColumnSize(int columnID) {
        GC gc = new GC((Drawable)this.tableViewer.getTable());
        int columnSize = 120;
        int currentSize = 120;
        for (FSMTransitionTableRow row : this.rows) {
            if (columnID == 1) {
                currentSize = gc.textExtent((String)row.getCurrentState().toString()).x;
            } else if (columnID == 2) {
                currentSize = gc.textExtent((String)row.getNextState().toString()).x;
            } else if (columnID == 3) {
                currentSize = gc.textExtent((String)this.trimCondition((String)row.getCondition().toString())).x;
            }
            int n = columnSize = currentSize > columnSize ? currentSize : columnSize;
        }
        gc.dispose();
        return columnSize + 15;
    }

    private void updateColumnWidth() {
        TableColumn[] columns = this.tableViewer.getTable().getColumns();
        columns[1].setWidth(this.getColumnSize(1));
        columns[2].setWidth(this.getColumnSize(2));
        columns[3].setWidth(this.getColumnSize(3));
    }

    public void update() {
        this.updateColumnWidth();
        this.tableViewer.setInput((Object)this.rows);
        this.tableViewer.refresh();
    }

    public TableViewer createTableViewer(Composite parent) {
        this.tableViewer = new TableViewer(parent, 268503810);
        this.createColumns();
        this.addColumnSelectionListeners();
        Table table = this.tableViewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ArrayList<FSMTransitionTableRow> selectedRowsTable = new ArrayList();
                ISelection selection = FSMTransitionTable.this.tableViewer.getSelection();
                if (selection instanceof IStructuredSelection) {
                    selectedRowsTable = ((IStructuredSelection)selection).toList();
                }
                FSMTransitionTable.this.selectionInTable = true;
                FSMTransitionTable.this.deselectRows();
                FSMTransitionTable.this.syncTableSelectionWithDiagramSelection(selectedRowsTable);
            }
        });
        GridData gridData = new GridData(4, 4, true, true);
        table.setLayoutData((Object)gridData);
        this.tableViewer.getControl().setLayoutData((Object)gridData);
        this.tableViewer.getControl().setMenu(this.getContextMenu());
        return this.tableViewer;
    }

    public Menu getContextMenu() {
        Control control = this.tableViewer.getControl();
        if (control.isDisposed()) {
            return null;
        }
        Menu contextMenu = new Menu((Decorations)control.getShell(), 8);
        MenuItem goToSource = new MenuItem(contextMenu, 8);
        goToSource.setText("Go To Source");
        goToSource.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ISelection selection = FSMTransitionTable.this.tableViewer.getSelection();
                if (!(selection instanceof IStructuredSelection)) {
                    return;
                }
                Object selected = ((IStructuredSelection)selection).getFirstElement();
                if (!(selected instanceof FSMTransitionTableRow)) {
                    return;
                }
                Set<GoToInfo> markers = ((FSMTransitionTableRow)selected).getTransition().getMarkers();
                if (markers == null || markers.isEmpty()) {
                    return;
                }
                IProject project = FSMTransitionTable.this.diagramEditor.getProject();
                GoToInfo marker = markers.iterator().next();
                marker.open(project, true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        MenuItem copyTableMenu = new MenuItem(contextMenu, 64);
        copyTableMenu.setText(COPY_TABLE_MENU_ENTRY);
        copyTableMenu.setToolTipText(COPY_TABLE_TOOLTIP);
        copyTableMenu.setImage(DVTImages.imageCache.getImage(DVTImages.IMG_TAB_GRAPHVIZ_COPY));
        Menu saveType = new Menu((Decorations)control.getShell(), 4);
        copyTableMenu.setMenu(saveType);
        TableExportFormat[] tableExportFormatArray = TableExportFormat.values();
        int n = tableExportFormatArray.length;
        int n2 = 0;
        while (n2 < n) {
            final TableExportFormat extension = tableExportFormatArray[n2];
            MenuItem format = new MenuItem(saveType, 8);
            format.setText(extension.toString());
            format.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    TableExportUtils.INSTANCE.copyToClipboard(extension, FSMTransitionTable.this);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            ++n2;
        }
        return contextMenu;
    }

    @Override
    public void renderSelection(Map<String, Set<DSelectable>> selection) {
        this.diagramEditor.getCanvas().getRenderer().render();
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    private void deselectRows() {
        this.rows.stream().map(x -> {
            x.selected = 0;
            return x.selected;
        }).collect(Collectors.toList());
    }

    private void addColumnSelectionListeners() {
        TableColumn[] columns = this.tableViewer.getTable().getColumns();
        int i = 0;
        while (i < columns.length) {
            this.addColumnSelectionListener(columns[i]);
            ++i;
        }
    }

    private void addColumnSelectionListener(TableColumn column) {
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FSMTransitionTable.this.tableColumnClicked((TableColumn)e.widget);
            }
        });
    }

    private void tableColumnClicked(TableColumn column) {
        Table table = column.getParent();
        if (column.equals(table.getSortColumn())) {
            table.setSortDirection(table.getSortDirection() == 128 ? 1024 : 128);
        } else {
            table.setSortColumn(column);
            table.setSortDirection(128);
        }
        TableColumn[] columns = table.getColumns();
        if (column == columns[1]) {
            Collections.sort(this.rows, this.BY_CURRENT_STATE);
        } else if (column == columns[2]) {
            Collections.sort(this.rows, this.BY_NEXT_STATE);
        } else if (column == columns[3]) {
            Collections.sort(this.rows, this.BY_CONDITION);
        } else {
            Collections.sort(this.rows, this.BY_TRANSITION_INDEX);
        }
        this.update();
    }

    private void createColumns() {
        String[] columnNames = COLUMNS_NAMES;
        int[] columnBounds = new int[]{50, 120, 120, 720};
        this.tableViewer.setColumnProperties(columnNames);
        TableViewerColumn col = this.createTableViewerColumn(columnNames[0], columnBounds[0]);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                FSMTransitionTableRow row = (FSMTransitionTableRow)element;
                return Integer.toString(row.getTransitionIndex());
            }

            public Color getBackground(Object element) {
                FSMTransitionTableRow row = (FSMTransitionTableRow)element;
                if (row.isSelectedEdge()) {
                    return FSMTransitionTable.this.selectedColor;
                }
                return super.getBackground(element);
            }
        });
        col = this.createTableViewerColumn(columnNames[1], columnBounds[1]);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                FSMTransitionTableRow row = (FSMTransitionTableRow)element;
                return row.getCurrentState().toString();
            }

            public Color getBackground(Object element) {
                FSMTransitionTableRow row = (FSMTransitionTableRow)element;
                if (row.isSelectedEdge() || row.isSelectedCurrentState()) {
                    return FSMTransitionTable.this.selectedColor;
                }
                return super.getBackground(element);
            }
        });
        col = this.createTableViewerColumn(columnNames[2], columnBounds[2]);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                FSMTransitionTableRow row = (FSMTransitionTableRow)element;
                return row.getNextState().toString();
            }

            public Color getBackground(Object element) {
                FSMTransitionTableRow row = (FSMTransitionTableRow)element;
                if (row.isSelectedEdge() || row.isSelectedNextState()) {
                    return FSMTransitionTable.this.selectedColor;
                }
                return super.getBackground(element);
            }
        });
        col = this.createTableViewerColumn(columnNames[3], columnBounds[3]);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                FSMTransitionTableRow row = (FSMTransitionTableRow)element;
                return FSMTransitionTable.this.trimCondition(row.getCondition().toString());
            }

            public Color getBackground(Object element) {
                FSMTransitionTableRow row = (FSMTransitionTableRow)element;
                if (row.isSelectedEdge()) {
                    return FSMTransitionTable.this.selectedColor;
                }
                return super.getBackground(element);
            }
        });
    }

    private String trimCondition(String rowCondition) {
        if (rowCondition.length() < 1000) {
            return rowCondition.substring(1, rowCondition.length() - 1);
        }
        return String.valueOf(rowCondition.substring(1, 999)) + "...";
    }

    private TableViewerColumn createTableViewerColumn(String title, int width) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.tableViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(width);
        column.setResizable(true);
        column.setMoveable(true);
        return viewerColumn;
    }

    public void dispose() {
        this.diagramEditor = null;
    }
}

