/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.fsm.editor;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.diagrams.DDiagram;
import ro.amiq.dvt.diagrams.editor.DDiagramEditor;
import ro.amiq.dvt.diagrams.editor.DDiagramEditorInput;
import ro.amiq.dvt.diagrams.fsm.draw.FSMDrawUtils;
import ro.amiq.dvt.diagrams.fsm.draw.obj.FSMDObject;
import ro.amiq.dvt.diagrams.fsm.draw.obj.FSMDScene;
import ro.amiq.dvt.diagrams.fsm.editor.FSMTransitionTableRow;
import ro.amiq.dvt.diagrams.fsm.model.FSMTransition;
import ro.amiq.dvt.diagrams.tables.ITableRowData;
import ro.amiq.dvt.diagrams.tables.ITableWrapper;
import ro.amiq.dvt.draw.obj.base.DGroup;
import ro.amiq.dvt.draw.obj.interaction.DSelectable;

public abstract class FSMTransitionTableCommon
implements ITableWrapper {
    public static final String TRANSITION_INDEX = "#";
    public static final String CURRENT_STATE = "Current State";
    public static final String NEXT_STATE = "Next State";
    public static final String CONDITION = "Condition";
    protected static final String[] COLUMNS_NAMES = new String[]{"#", "Current State", "Next State", "Condition"};
    private static final String DEFAULT_FSM_TABLE_NAME = "FSM Transitions Table";
    protected List<FSMTransitionTableRow> rows;
    protected DDiagramEditor diagramEditor;
    private boolean hideTransitionTableLayout = true;

    public void setRows(List<FSMTransitionTableRow> rows) {
        this.rows = rows;
    }

    public boolean isHidden() {
        return this.hideTransitionTableLayout;
    }

    public void hide(boolean hideTransitionTable) {
        this.hideTransitionTableLayout = hideTransitionTable;
    }

    public void selectNodes(Map<String, Set<DSelectable>> selection, List<FSMTransitionTableRow> selectedRowsTable) {
        boolean highlightPrevAndNext = DVTPlugin.getDefault().getPreferenceStore().getBoolean("designdiagrams.fsm_highlight_prev_and_next_states");
        if (!highlightPrevAndNext || selectedRowsTable.size() != 1) {
            return;
        }
        FSMTransition transition = selectedRowsTable.get(0).getTransition();
        FSMDrawUtils.addDriverAndLoadObjectsToSelection(selection, transition, (FSMDScene)this.diagramEditor.getCanvas().getContent());
    }

    public void selectEdges(Map<String, Set<DSelectable>> selection, DGroup diagramGroup, List<FSMTransitionTableRow> selectedRowsTable) {
        List selectedTransititions = selectedRowsTable.stream().map(e -> e.getTransition()).collect(Collectors.toList());
        List selectedLabels = selectedRowsTable.stream().map(e -> e.getCondition().getConditions()).flatMap(Collection::stream).collect(Collectors.toList());
        selection.put("MAIN_SELECTION", diagramGroup.getChildren().stream().filter(e -> selectedTransititions.contains(FSMDrawUtils.getFSMObjectFromFSMDObject((FSMDObject)e)) || selectedLabels.contains(FSMDrawUtils.getFSMObjectFromFSMDObject((FSMDObject)e))).map(e -> (DSelectable)((Object)e)).collect(Collectors.toSet()));
    }

    public void syncTableSelectionWithDiagramSelection(List<FSMTransitionTableRow> selectedRowsTable) {
        if (selectedRowsTable == null || selectedRowsTable.isEmpty()) {
            return;
        }
        HashMap<String, Set<DSelectable>> selection = new HashMap<String, Set<DSelectable>>();
        this.selectEdges(selection, (DGroup)this.diagramEditor.getCanvas().getContent(), selectedRowsTable);
        this.selectNodes(selection, selectedRowsTable);
        this.diagramEditor.getMouseManager().setSelection(selection);
        this.renderSelection(selection);
    }

    protected void selectRow(Set<Object> selected) {
        boolean scrolled = false;
        for (FSMTransitionTableRow row : this.rows) {
            row.selected = 0;
            if (selected.contains(row.getCurrentState())) {
                row.selected = row.selected | 4;
                scrolled = this.scrollToSelection(scrolled, row);
            }
            if (selected.contains(row.getNextState())) {
                row.selected = row.selected | 2;
                scrolled = this.scrollToSelection(scrolled, row);
            }
            if (!selected.contains(row.getTransition()) && Collections.disjoint(selected, row.getCondition().getConditions())) continue;
            row.selected = row.selected | 0xF;
            scrolled = this.scrollToSelection(scrolled, row);
        }
    }

    @Override
    public String getTableName() {
        DDiagramEditorInput input = this.diagramEditor.getInput();
        if (input == null) {
            return DEFAULT_FSM_TABLE_NAME;
        }
        DDiagram diagram = input.getDiagram();
        if (diagram == null) {
            return DEFAULT_FSM_TABLE_NAME;
        }
        return diagram.getFullName().replace("FSM", DEFAULT_FSM_TABLE_NAME);
    }

    @Override
    public List<String> getTableHeaders() {
        return Arrays.asList(COLUMNS_NAMES);
    }

    public List<FSMTransition> getTableRows() {
        return this.rows.stream().map(row -> row.getTransition()).sorted((t1, t2) -> t1.getIndex() - t2.getIndex()).collect(Collectors.toList());
    }

    @Override
    public String getTableColumnValue(ITableRowData row, int columnIndex) {
        if (!(row instanceof FSMTransition)) {
            return "";
        }
        FSMTransition transitionRow = (FSMTransition)row;
        switch (columnIndex) {
            case 0: {
                return String.valueOf(transitionRow.getIndex());
            }
            case 1: {
                return transitionRow.getSource().toString();
            }
            case 2: {
                return transitionRow.getDestination().toString();
            }
            case 3: {
                return transitionRow.getSourceInput().toString();
            }
        }
        return "";
    }

    protected abstract boolean scrollToSelection(boolean var1, FSMTransitionTableRow var2);

    public abstract void renderSelection(Map<String, Set<DSelectable>> var1);

    public abstract void updateSelection(Set<DSelectable> var1);
}

