/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.fsm.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import ro.amiq.dvt.diagrams.fsm.editor.FSMTransitionTableRow;
import ro.amiq.dvt.diagrams.fsm.model.FSMModel;
import ro.amiq.dvt.diagrams.fsm.model.FSMState;
import ro.amiq.dvt.fsm.model.IFSMTransition;
import ro.amiq.dvt.fsm.utils.FSMExecutors;
import ro.amiq.dvt.fsm.utils.FSMVisitors;
import ro.amiq.dvt.model.reflection.NotNull;

public class FSMTransitionTableData {
    private List<FSMTransitionTableRow> rows;

    public void doWork(FSMModel model) {
        this.createRows(model);
    }

    @NotNull
    public List<FSMTransitionTableRow> getRows() {
        return this.rows != null ? this.rows : Collections.emptyList();
    }

    private void createRows(FSMModel model) {
        if (model == null) {
            return;
        }
        this.rows = new ArrayList<FSMTransitionTableRow>();
        FSMExecutors.newBFS().setModel(model, true, (IProgressMonitor)new NullProgressMonitor()).addVisitor(new FSMVisitors.TransitionVisitor(){

            @Override
            public void visit(IFSMTransition transition) {
                if (transition.getSource() == FSMState.VOID) {
                    return;
                }
                FSMTransitionTableData.this.rows.add(new FSMTransitionTableRow(transition));
            }
        }).start();
    }

    public void clear() {
        if (this.rows == null) {
            return;
        }
        this.rows.clear();
    }
}

