/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.fsm.editor.actions;

import de.cau.cs.kieler.kiml.options.Direction;
import de.cau.cs.kieler.klay.layered.p4nodes.NodePlacementStrategy;
import de.cau.cs.kieler.klay.layered.properties.LayerConstraint;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.editor.DDiagramEditor;
import ro.amiq.dvt.diagrams.editor.utils.DEditorDialog;
import ro.amiq.dvt.diagrams.fsm.FSMDiagram;
import ro.amiq.dvt.diagrams.fsm.FSMDiagramConfiguration;
import ro.amiq.dvt.diagrams.fsm.editor.DFSMEditorFactory;
import ro.amiq.dvt.diagrams.fsm.editor.FSMTransitionTableData;
import ro.amiq.dvt.diagrams.fsm.editor.actions.TransitionLabelType;
import ro.amiq.dvt.diagrams.fsm.editor.actions.menu.DFSMActionMessages;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.utils.DVTStringUtil;

public class DFSMPreferencesDialog
extends DEditorDialog {
    private static final int SPINNER_CONSTANT_SIZE = 23;
    private Composite rowsComposite;
    private Combo diagramDirection;
    private Combo placementStrategy;
    private Combo enforceEdgePortSide;
    private Combo initialStateLayer;
    private Spinner spacing;
    private Spinner edgeNodeSpacingFactor;
    private Spinner edgeSpacingFactor;
    private Spinner objectLayerSpacingFactor;
    private Button mergeTransitions;
    private Button showLoopBack;
    private Button hideCommonExpressionInConditions;
    private Button showDefaultState;
    private Text filteredNames;
    private Label filteredNamesLabel;
    private FSMDiagramConfiguration config;
    private FSMDiagram fsmDiagram = (FSMDiagram)this.getDiagramEditor().getInput().getDiagram();
    private Combo transitionLabels;

    public DFSMPreferencesDialog(DDiagramEditor diagramEditor, Point location) {
        super(diagramEditor, location, false);
        this.config = this.fsmDiagram.getConfig().deepCopy();
    }

    @Override
    protected void createMainArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(composite);
        this.rowsComposite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(true).applyTo(this.rowsComposite);
        this.createDiagramDirectionComposite();
        this.createPlacementStrategyComposite();
        this.createEnforceTransitionPortSideComposite();
        this.createInitialStateLayerComposite();
        this.createSeparatorComposite();
        this.createShowDefaultStateComposite();
        this.createShowLoopBackTransitionsComposite();
        this.createShowEdgeLabelsComposite();
        this.createFilteredNamesInConditionsComposite();
        this.createFilterCommonExpressionsInConditionComposite();
    }

    private void createShowDefaultStateComposite() {
        if (this.fsmDiagram.getStateVar().getLanguageKind() == LanguageKind.VLOG) {
            this.createNewLabel(DFSMActionMessages.preferencesShowDefaultStateTextVlog);
        } else {
            this.createNewLabel(DFSMActionMessages.preferencesShowDefaultStateTextVHDL);
        }
        this.showDefaultState = new Button(this.rowsComposite, 32);
        this.showDefaultState.setText("");
        this.showDefaultState.setSelection(this.config.contains(FSMDiagramConfiguration.FSMDiagramConfigurationKey.SHOW_DEFAULT_STATE));
        this.showDefaultState.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DFSMPreferencesDialog.this.config.toggle(FSMDiagramConfiguration.FSMDiagramConfigurationKey.SHOW_DEFAULT_STATE);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    protected void createEmptyComposite(Composite parent) {
        Composite emptyOptionsComposite = new Composite(parent, 0);
        emptyOptionsComposite.setLayout((Layout)new FillLayout());
    }

    protected void createSeparatorComposite() {
        this.createSeparator(this.rowsComposite);
    }

    protected void createSeparator(Composite parent) {
        Label separator = new Label(parent, 258);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).applyTo((Control)separator);
    }

    private void createInitialStateLayerComposite() {
        this.createNewLabel(DFSMActionMessages.preferencesInitialStateNodeLayerText);
        final LayerConstraint[] values = new LayerConstraint[]{LayerConstraint.NONE, LayerConstraint.FIRST_SEPARATE, LayerConstraint.LAST_SEPARATE};
        LayerConstraint currentValue = this.config.get(FSMDiagramConfiguration.FSMDiagramConfigurationKey.ENFORCE_INITIAL_STATE_LAYER);
        this.initialStateLayer = new Combo(this.rowsComposite, 2056);
        this.initialStateLayer.setData((Object)values);
        this.initialStateLayer.add("Free");
        if (currentValue == LayerConstraint.NONE) {
            this.initialStateLayer.select(0);
        }
        this.initialStateLayer.add("First");
        if (currentValue == LayerConstraint.FIRST_SEPARATE) {
            this.initialStateLayer.select(1);
        }
        this.initialStateLayer.add("Last");
        if (currentValue == LayerConstraint.LAST_SEPARATE) {
            this.initialStateLayer.select(2);
        }
        this.initialStateLayer.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LayerConstraint newValue = values[DFSMPreferencesDialog.this.initialStateLayer.getSelectionIndex()];
                DFSMPreferencesDialog.this.config.set(FSMDiagramConfiguration.FSMDiagramConfigurationKey.ENFORCE_INITIAL_STATE_LAYER, newValue);
            }
        });
    }

    private void createEnforceTransitionPortSideComposite() {
        this.createNewLabel(DFSMActionMessages.preferencesEnforceEdgePortSideText);
        final FSMDiagramConfiguration.EnforceTransitionPortsOption[] values = FSMDiagramConfiguration.EnforceTransitionPortsOption.values();
        FSMDiagramConfiguration.EnforceTransitionPortsOption currentValue = this.config.get(FSMDiagramConfiguration.FSMDiagramConfigurationKey.ENFORCE_TRANSITION_PORTS);
        this.enforceEdgePortSide = this.createNewCombo((Object[])values, (Object)currentValue);
        this.enforceEdgePortSide.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FSMDiagramConfiguration.EnforceTransitionPortsOption newValue = values[DFSMPreferencesDialog.this.enforceEdgePortSide.getSelectionIndex()];
                DFSMPreferencesDialog.this.config.set(FSMDiagramConfiguration.FSMDiagramConfigurationKey.ENFORCE_TRANSITION_PORTS, newValue);
            }
        });
    }

    private Combo createNewCombo(Object[] values, Object currentValue) {
        Combo combo = new Combo(this.rowsComposite, 2056);
        combo.setData((Object)values);
        int i = 0;
        while (i < values.length) {
            Object value = values[i];
            combo.add(DVTStringUtil.toNiceTitleCase(value.toString()));
            if (value == currentValue) {
                combo.select(i);
            }
            ++i;
        }
        return combo;
    }

    private void createShowLoopBackTransitionsComposite() {
        this.createNewLabel(DFSMActionMessages.preferencesShowLoopBackEdgesText);
        this.showLoopBack = new Button(this.rowsComposite, 32);
        this.showLoopBack.setText("");
        this.showLoopBack.setSelection(!this.config.contains(FSMDiagramConfiguration.FSMDiagramConfigurationKey.REMOVE_LOOPBACK_TRANSITIONS));
        this.showLoopBack.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DFSMPreferencesDialog.this.config.toggle(FSMDiagramConfiguration.FSMDiagramConfigurationKey.REMOVE_LOOPBACK_TRANSITIONS);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void createFilterCommonExpressionsInConditionComposite() {
        this.createNewLabel(DFSMActionMessages.preferencesHideCommonExpressionInConditionText);
        this.hideCommonExpressionInConditions = new Button(this.rowsComposite, 32);
        this.hideCommonExpressionInConditions.setText("");
        this.hideCommonExpressionInConditions.setSelection(this.config.contains(FSMDiagramConfiguration.FSMDiagramConfigurationKey.FILTER_COMMON_EXPRESSIONS_IN_CONDITIONS));
        this.hideCommonExpressionInConditions.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DFSMPreferencesDialog.this.config.toggle(FSMDiagramConfiguration.FSMDiagramConfigurationKey.FILTER_COMMON_EXPRESSIONS_IN_CONDITIONS);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void createShowEdgeLabelsComposite() {
        this.createNewLabel(DFSMActionMessages.preferencesShowEdgeLabelsText);
        final TransitionLabelType[] values = TransitionLabelType.values();
        TransitionLabelType currentValue = this.config.get(FSMDiagramConfiguration.FSMDiagramConfigurationKey.SHOW_TRANSITION_LABELS);
        this.transitionLabels = this.createNewCombo((Object[])values, (Object)currentValue);
        this.transitionLabels.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TransitionLabelType newValue = values[DFSMPreferencesDialog.this.transitionLabels.getSelectionIndex()];
                DFSMPreferencesDialog.this.config.set(FSMDiagramConfiguration.FSMDiagramConfigurationKey.SHOW_TRANSITION_LABELS, newValue);
            }
        });
    }

    private void createFilteredNamesInConditionsComposite() {
        this.filteredNamesLabel = new Label(this.rowsComposite, 0);
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, false).applyTo((Control)this.filteredNamesLabel);
        this.filteredNamesLabel.setText(DFSMActionMessages.preferencesFilterNamesText);
        this.filteredNames = new Text(this.rowsComposite, 2052);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.filteredNames);
        Set<String> values = this.config.get(FSMDiagramConfiguration.FSMDiagramConfigurationKey.FILTER_NAMES_IN_CONDITIONS);
        String currentValue = DVTStringUtil.join(values, ", ");
        this.filteredNames.setText(currentValue);
        this.filteredNames.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String[] newValueArray = DFSMPreferencesDialog.this.filteredNames.getText().split(",");
                Set newValues = Collections.emptySet();
                if (newValueArray.length > 0) {
                    newValues = new LinkedHashSet(newValueArray.length);
                    String[] stringArray = newValueArray;
                    int n = newValueArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String newValue = stringArray[n2];
                        String trim = newValue.trim();
                        if (!trim.isEmpty()) {
                            newValues.add(trim);
                        }
                        ++n2;
                    }
                }
                DFSMPreferencesDialog.this.config.set(FSMDiagramConfiguration.FSMDiagramConfigurationKey.FILTER_NAMES_IN_CONDITIONS, newValues);
            }
        });
    }

    private void createPlacementStrategyComposite() {
        this.createNewLabel(DFSMActionMessages.preferencesPlacementStrategyText);
        final NodePlacementStrategy[] values = new NodePlacementStrategy[]{NodePlacementStrategy.BRANDES_KOEPF, NodePlacementStrategy.NETWORK_SIMPLEX};
        NodePlacementStrategy currentValue = this.config.get(FSMDiagramConfiguration.FSMDiagramConfigurationKey.NODE_PLACEMENT_STRATEGY);
        this.placementStrategy = new Combo(this.rowsComposite, 2056);
        this.placementStrategy.setData((Object)values);
        this.placementStrategy.add("Brandes-Koepf");
        if (currentValue == NodePlacementStrategy.BRANDES_KOEPF) {
            this.placementStrategy.select(0);
        }
        this.placementStrategy.add(DVTStringUtil.toNiceTitleCase(NodePlacementStrategy.NETWORK_SIMPLEX.toString()));
        if (currentValue == NodePlacementStrategy.NETWORK_SIMPLEX) {
            this.placementStrategy.select(1);
        }
        this.placementStrategy.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NodePlacementStrategy newValue = values[DFSMPreferencesDialog.this.placementStrategy.getSelectionIndex()];
                DFSMPreferencesDialog.this.config.set(FSMDiagramConfiguration.FSMDiagramConfigurationKey.NODE_PLACEMENT_STRATEGY, newValue);
            }
        });
    }

    private void createNewLabel(String text) {
        Label label = new Label(this.rowsComposite, 0);
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, false).applyTo((Control)label);
        label.setText(text);
    }

    private void createDiagramDirectionComposite() {
        this.createNewLabel(DFSMActionMessages.preferencesDirectionText);
        Object[] values = new Direction[]{Direction.UP, Direction.DOWN, Direction.LEFT, Direction.RIGHT};
        Direction currentValue = this.config.get(FSMDiagramConfiguration.FSMDiagramConfigurationKey.DIRECTION);
        this.diagramDirection = this.createNewCombo(values, currentValue);
        this.diagramDirection.addModifyListener(new ModifyListener((Direction[])values){
            private final /* synthetic */ Direction[] val$values;
            {
                this.val$values = directionArray;
            }

            public void modifyText(ModifyEvent e) {
                Direction newValue = this.val$values[DFSMPreferencesDialog.this.diagramDirection.getSelectionIndex()];
                DFSMPreferencesDialog.this.config.set(FSMDiagramConfiguration.FSMDiagramConfigurationKey.DIRECTION, newValue);
            }
        });
    }

    private void createSpacingComposite() {
        this.createNewLabel(DFSMActionMessages.preferencesNodeSpacingText);
        this.spacing = new Spinner(this.rowsComposite, 2304);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).hint(23, -1).grab(false, false).applyTo((Control)this.spacing);
        float value = this.config.get(FSMDiagramConfiguration.FSMDiagramConfigurationKey.SPACING).floatValue();
        this.spacing.setTextLimit(3);
        this.spacing.setValues((int)value, 10, 100, 0, 1, 5);
        this.spacing.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                float newValue = DFSMPreferencesDialog.this.spacing.getSelection();
                DFSMPreferencesDialog.this.config.set(FSMDiagramConfiguration.FSMDiagramConfigurationKey.SPACING, Float.valueOf(newValue));
            }
        });
    }

    private void createSpacingFactorComposite() {
        this.createNewLabel(DFSMActionMessages.preferencesObjectLayerSpacingText);
        this.objectLayerSpacingFactor = new Spinner(this.rowsComposite, 2304);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).hint(23, -1).grab(false, false).applyTo((Control)this.objectLayerSpacingFactor);
        float value = this.config.get(FSMDiagramConfiguration.FSMDiagramConfigurationKey.OBJ_SPACING_IN_LAYER_FACTOR).floatValue();
        this.objectLayerSpacingFactor.setTextLimit(3);
        this.objectLayerSpacingFactor.setValues((int)(value * 10.0f), 7, 70, 0, 1, 5);
        this.objectLayerSpacingFactor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                float newValue = (float)DFSMPreferencesDialog.this.objectLayerSpacingFactor.getSelection() / 10.0f;
                DFSMPreferencesDialog.this.config.set(FSMDiagramConfiguration.FSMDiagramConfigurationKey.OBJ_SPACING_IN_LAYER_FACTOR, Float.valueOf(newValue));
            }
        });
        this.createNewLabel(DFSMActionMessages.preferencesEdgeNodeSpacingText);
        this.edgeNodeSpacingFactor = new Spinner(this.rowsComposite, 2304);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).hint(23, -1).grab(false, false).applyTo((Control)this.edgeNodeSpacingFactor);
        value = this.config.get(FSMDiagramConfiguration.FSMDiagramConfigurationKey.EDGE_NODE_SPACING_FACTOR).floatValue();
        this.edgeNodeSpacingFactor.setTextLimit(3);
        this.edgeNodeSpacingFactor.setValues((int)(value * 10.0f), 7, 70, 0, 1, 5);
        this.edgeNodeSpacingFactor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                float newValue = (float)DFSMPreferencesDialog.this.edgeNodeSpacingFactor.getSelection() / 10.0f;
                DFSMPreferencesDialog.this.config.set(FSMDiagramConfiguration.FSMDiagramConfigurationKey.EDGE_NODE_SPACING_FACTOR, Float.valueOf(newValue));
            }
        });
        this.createNewLabel(DFSMActionMessages.preferencesEdgeSpacingText);
        this.edgeSpacingFactor = new Spinner(this.rowsComposite, 2304);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).hint(23, -1).grab(false, false).applyTo((Control)this.edgeSpacingFactor);
        value = this.config.get(FSMDiagramConfiguration.FSMDiagramConfigurationKey.EDGE_SPACING_FACTOR).floatValue();
        this.edgeSpacingFactor.setTextLimit(3);
        this.edgeSpacingFactor.setValues((int)(value * 10.0f), 7, 70, 0, 1, 5);
        this.edgeSpacingFactor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                float newValue = (float)DFSMPreferencesDialog.this.edgeSpacingFactor.getSelection() / 10.0f;
                DFSMPreferencesDialog.this.config.set(FSMDiagramConfiguration.FSMDiagramConfigurationKey.EDGE_SPACING_FACTOR, Float.valueOf(newValue));
            }
        });
    }

    @Override
    protected void createBottomArea(Composite parent) {
        Composite composite = this.createBottomComposite(parent, 2);
        this.createPreferencesLink("ro.amiq.dvt.diagrams.DFSMPreferencePage", composite);
        Composite buttonsComposite = this.createButtonsComposite(composite, 3);
        this.createButton(buttonsComposite, 8, "Cancel", () -> {
            boolean bl = this.close();
        });
        this.createButton(buttonsComposite, 8, "New", () -> this.openEditor(true));
        this.createButton(buttonsComposite, 8, "Apply", () -> this.openEditor(false));
    }

    private void openEditor(boolean newEditor) {
        FSMDiagram fsmDiagram = (FSMDiagram)this.getDiagramEditor().getInput().getDiagram();
        if (fsmDiagram == null) {
            return;
        }
        IRfFieldElement stateVar = fsmDiagram.getStateVar();
        IRfNamedElement stateVarScope = fsmDiagram.getStateVarScope();
        FSMTransitionTableData tableConstructor = fsmDiagram.getTableConstructor();
        DFSMEditorFactory factory = DFSMEditorFactory.newFSMDiagram(stateVar, stateVarScope, tableConstructor, this.config);
        this.close();
        if (factory != null) {
            if (newEditor) {
                factory.openNewEditor();
            } else {
                factory.openReuseEditor(this.getDiagramEditor());
            }
        }
    }

    @Override
    public boolean close() {
        this.transitionLabels.dispose();
        this.filteredNames.dispose();
        this.filteredNamesLabel.dispose();
        this.showDefaultState.dispose();
        this.hideCommonExpressionInConditions.dispose();
        this.showLoopBack.dispose();
        this.initialStateLayer.dispose();
        this.enforceEdgePortSide.dispose();
        this.placementStrategy.dispose();
        this.diagramDirection.dispose();
        this.rowsComposite.dispose();
        return super.close();
    }
}

