/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.fsm.editor.actions.menu;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.diagrams.DDiagram;
import ro.amiq.dvt.diagrams.editor.DDiagramEditor;
import ro.amiq.dvt.diagrams.editor.DDiagramEditorSelection;
import ro.amiq.dvt.diagrams.fsm.FSMDiagram;
import ro.amiq.dvt.diagrams.fsm.draw.FSMDrawUtils;
import ro.amiq.dvt.diagrams.fsm.draw.obj.FSMDObject;
import ro.amiq.dvt.diagrams.fsm.editor.FSMTransitionTable;
import ro.amiq.dvt.diagrams.fsm.model.FSMState;
import ro.amiq.dvt.diagrams.fsm.model.FSMTransition;
import ro.amiq.dvt.diagrams.tables.TableExportFormat;
import ro.amiq.dvt.diagrams.tables.TableExportUtils;
import ro.amiq.dvt.draw.obj.interaction.DSelectable;
import ro.amiq.dvt.fsm.model.IFSMTransition;

public class DFSMCopyTableToClipboardMenuActionHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart activeEditor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (!(activeEditor instanceof DDiagramEditor)) {
            return null;
        }
        DDiagramEditor diagramEditor = (DDiagramEditor)activeEditor;
        DDiagram diagram = diagramEditor.getInput().getDiagram();
        if (!(diagram instanceof FSMDiagram)) {
            return null;
        }
        FSMTransitionTable transitionTable = diagramEditor.getTransitionTable();
        if (transitionTable == null) {
            return null;
        }
        if (DVTPlugin.getDefault().getPreferenceStore().getBoolean("designdiagrams.fsm_transition_table_disabled")) {
            return null;
        }
        List<FSMTransition> selectedRows = this.computeSelectedRows(diagramEditor);
        if (selectedRows == null) {
            return null;
        }
        TableExportFormat format = this.getTableFormat();
        TableExportUtils.INSTANCE.copyToClipboard(format, transitionTable, selectedRows);
        return null;
    }

    private TableExportFormat getTableFormat() {
        IPreferenceStore store = DVTPlugin.getDefault().getPreferenceStore();
        TableExportFormat format = TableExportFormat.valueOf(store.getString("designdiagrams.fsm_export_table_format"));
        return format;
    }

    private List<FSMTransition> computeSelectedRows(DDiagramEditor diagramEditor) {
        DDiagramEditorSelection editorSelection = (DDiagramEditorSelection)diagramEditor.getSelection();
        if (editorSelection == null) {
            return null;
        }
        Set<DSelectable> selection = editorSelection.getElements();
        if (selection == null || selection.isEmpty()) {
            return null;
        }
        LinkedHashSet<FSMTransition> selectedTransition = new LinkedHashSet<FSMTransition>();
        for (DSelectable selectedElement : selection) {
            if (!(selectedElement instanceof FSMDObject)) continue;
            Object fsmObject = FSMDrawUtils.getFSMObjectFromFSMDObject((FSMDObject)((Object)selectedElement));
            if (fsmObject instanceof FSMTransition) {
                selectedTransition.add((FSMTransition)fsmObject);
                continue;
            }
            if (!(fsmObject instanceof FSMState)) continue;
            selectedTransition.addAll(this.getTransitions((FSMState)fsmObject));
        }
        if (selectedTransition.isEmpty()) {
            return null;
        }
        return selectedTransition.stream().sorted((t1, t2) -> t1.getIndex() - t2.getIndex()).collect(Collectors.toList());
    }

    private Set<FSMTransition> getTransitions(FSMState state) {
        HashSet<FSMTransition> transitions = new HashSet<FSMTransition>();
        for (IFSMTransition iFSMTransition : state.getOutgoingTransitions()) {
            if (!(iFSMTransition instanceof FSMTransition)) continue;
            transitions.add((FSMTransition)iFSMTransition);
        }
        for (IFSMTransition iFSMTransition : state.getIncomingTransitions()) {
            if (!(iFSMTransition instanceof FSMTransition)) continue;
            transitions.add((FSMTransition)iFSMTransition);
        }
        return transitions;
    }
}

