/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.fsm.editor.actions.menu;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.diagrams.DDiagram;
import ro.amiq.dvt.diagrams.editor.DMenuCascade;
import ro.amiq.dvt.diagrams.editor.DMenuItem;
import ro.amiq.dvt.diagrams.fsm.draw.FSMDrawUtils;
import ro.amiq.dvt.diagrams.fsm.editor.actions.menu.DFSMActionMessages;
import ro.amiq.dvt.diagrams.fsm.editor.actions.menu.DFSMGoToSourceMenuAction;
import ro.amiq.dvt.diagrams.fsm.model.IFSMViewSelectable;
import ro.amiq.dvt.draw.obj.interaction.DSelectable;
import ro.amiq.dvt.model.reflection.GoToInfo;

public final class DFSMMenuActionFactory {
    private DFSMMenuActionFactory() {
    }

    public static List<DMenuItem> createActions(Set<DSelectable> selection, DDiagram diagram) {
        if (diagram == null) {
            return Collections.emptyList();
        }
        DSelectable firstSelection = selection.stream().findFirst().orElse(null);
        if (firstSelection == null) {
            return Collections.emptyList();
        }
        return DFSMMenuActionFactory.createGoToSourceActions(firstSelection, diagram);
    }

    private static List<DMenuItem> createGoToSourceActions(DSelectable selection, DDiagram diagram) {
        IFSMViewSelectable fsmViewSelectable = FSMDrawUtils.getFSMViewSelectable(selection);
        if (fsmViewSelectable == null) {
            return Collections.emptyList();
        }
        Collection<GoToInfo> goTos = fsmViewSelectable.hasGoToSource();
        if (goTos == null || goTos.isEmpty()) {
            return Collections.emptyList();
        }
        if (goTos.size() == 1) {
            return Collections.singletonList(new DFSMGoToSourceMenuAction(diagram, goTos.iterator().next(), DFSMActionMessages.goToSourceTitle));
        }
        ArrayList<DMenuItem> subActions = new ArrayList<DMenuItem>(goTos.size());
        for (GoToInfo goTo : goTos) {
            subActions.add(new DFSMGoToSourceMenuAction(diagram, goTo, DFSMGoToSourceMenuAction.makeText(goTo)));
        }
        DMenuCascade cascade = new DMenuCascade(DFSMActionMessages.goToSourceTitle, subActions);
        return Collections.singletonList(cascade);
    }
}

