/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.fsm.model;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.fsm.model.FSMCondition;
import ro.amiq.dvt.diagrams.fsm.model.FSMInput;
import ro.amiq.dvt.diagrams.fsm.model.FSMModel;
import ro.amiq.dvt.diagrams.fsm.model.FSMState;
import ro.amiq.dvt.diagrams.fsm.model.FSMTransition;
import ro.amiq.dvt.fsm.model.IFSMCondition;
import ro.amiq.dvt.fsm.model.IFSMState;
import ro.amiq.dvt.fsm.model.IFSMTransition;
import ro.amiq.dvt.logic.form.model.LFFormula;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidImplicit;
import ro.amiq.dvt.utils.DVTStringUtil;

public final class FSMFactory {
    public static FSMModel createModel(LanguageKind kind) {
        return kind == LanguageKind.VLOG || kind == LanguageKind.VHDL ? new FSMModel(kind) : null;
    }

    public static FSMState createState(IHid hid, IRfNamedElement element, LanguageKind languageKind) {
        if (hid == null) {
            return null;
        }
        String uniqueID = HidUtils.toNiceString(hid);
        if (uniqueID.isEmpty()) {
            return null;
        }
        String niceID = uniqueID;
        if (languageKind == LanguageKind.VHDL) {
            uniqueID = uniqueID.toLowerCase();
        }
        String numberValueText = null;
        if (hid instanceof IHidImplicit && ((IHidImplicit)hid).isNumber()) {
            numberValueText = hid.getName();
        }
        Number numberValue = null;
        if (languageKind == LanguageKind.VLOG) {
            numberValue = DVTStringUtil.parseNumberVLOG(numberValueText, null, false);
        } else if (languageKind == LanguageKind.VHDL) {
            numberValue = DVTStringUtil.parseNumberVHDL(numberValueText, null);
        }
        int number = numberValue != null && !(numberValue instanceof Float) ? numberValue.intValue() : Integer.MIN_VALUE;
        return new FSMState(uniqueID, niceID, element == null ? null : RfElementPath.pathInProject(element), number);
    }

    public static FSMState createState(IRfNamedElement element, LanguageKind languageKind) {
        if (element == null) {
            return null;
        }
        String uniqueID = element.getName();
        if (uniqueID.isEmpty()) {
            return null;
        }
        String niceID = uniqueID;
        if (languageKind == LanguageKind.VHDL) {
            uniqueID = uniqueID.toLowerCase();
        }
        return new FSMState(uniqueID, niceID, RfElementPath.pathInProject(element), Integer.MIN_VALUE);
    }

    public static FSMCondition createCondition(LFFormula formula) {
        if (formula == null) {
            return null;
        }
        return new FSMCondition(formula);
    }

    public static FSMInput createInput(LFFormula formula) {
        if (formula == null) {
            return null;
        }
        return FSMFactory.createInput(Collections.singletonList(FSMFactory.createCondition(formula)));
    }

    public static FSMInput createInput(Collection<IFSMCondition> conditions) {
        if (conditions == null || conditions.isEmpty()) {
            return FSMInput.EMPTY;
        }
        FSMInput nf = new FSMInput();
        for (IFSMCondition condition : conditions) {
            if (condition == null) continue;
            nf.addCondition(condition);
        }
        if (nf.getConditions().isEmpty()) {
            return FSMInput.EMPTY;
        }
        return nf;
    }

    public static FSMTransition createStartTransition(IFSMState dest) {
        if (dest == null) {
            return null;
        }
        return new FSMTransition(FSMInput.EMPTY, FSMState.VOID, dest, null, null);
    }

    public static FSMTransition createTransition(FSMInput input, IFSMState src, IFSMState dest, String stateVarName, String nextStateVarName) {
        if (input == null || src == null || dest == null) {
            return null;
        }
        FSMTransition trans = new FSMTransition(input, src, dest, stateVarName, nextStateVarName);
        src.addOutgoingTransition(trans);
        dest.addIncomingTransition(trans);
        return trans;
    }

    public static boolean removeTransitions(IFSMState src, IFSMState dest) {
        if (src == null || dest == null) {
            return false;
        }
        Collection<? extends IFSMTransition> transitions = src.getOutgoingTransitions();
        if (transitions == null || transitions.isEmpty()) {
            return false;
        }
        boolean isRemoved = false;
        Iterator<? extends IFSMTransition> iterator = transitions.iterator();
        while (iterator.hasNext()) {
            IFSMTransition trans = iterator.next();
            if (trans.getDestination() != dest) continue;
            iterator.remove();
            dest.removeIncomingTransition(trans);
            isRemoved = true;
        }
        return isRemoved;
    }
}

