/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.fsm.model;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.fsm.model.IFSMModel;
import ro.amiq.dvt.fsm.model.IFSMState;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;

public class FSMModel
implements IFSMModel {
    private final Map<IFSMState, IFSMState> states = new LinkedHashMap<IFSMState, IFSMState>(8);
    private final Set<IFSMState> startStates = new LinkedHashSet<IFSMState>(2);
    private final LanguageKind languageKind;
    private boolean hasTransitions;
    private IRfActionBlockElement enclosingScope;
    private IRfFieldElement stateVar;
    private IRfFieldElement nextStateVar;

    public FSMModel(LanguageKind languageKind) {
        this.languageKind = languageKind;
    }

    public Collection<IFSMState> getStates() {
        return this.states.values();
    }

    public boolean isEmpty() {
        return this.states.isEmpty();
    }

    @Override
    public IFSMState addState(IFSMState state) {
        if (state == null) {
            return null;
        }
        this.states.put(state, state);
        return state;
    }

    @Override
    public IFSMState getDefaultState() {
        for (IFSMState state : this.getStates()) {
            if (!state.isDefault()) continue;
            return state;
        }
        return null;
    }

    @Override
    public void addStart(IFSMState start) {
        this.startStates.add(start);
    }

    @Override
    public Collection<? extends IFSMState> getStartStates() {
        return this.startStates;
    }

    @Override
    public boolean hasStartState(IFSMState state) {
        return !this.startStates.isEmpty() && this.startStates.contains(state);
    }

    public LanguageKind getLanguageKind() {
        return this.languageKind;
    }

    @Override
    public boolean hasTransitions() {
        return this.hasTransitions;
    }

    @Override
    public void setHasTransitions(boolean hasTransitions) {
        this.hasTransitions |= hasTransitions;
    }

    @Override
    public void setEnclosingScope(IRfActionBlockElement iRfActionBlockElement) {
        this.enclosingScope = iRfActionBlockElement;
    }

    @Override
    public IRfActionBlockElement getEnclosingScope() {
        return this.enclosingScope;
    }

    public void addStateVar(IRfFieldElement stateVar) {
        this.stateVar = stateVar;
    }

    public void addNextStateVar(IRfFieldElement nextStateVar) {
        this.nextStateVar = nextStateVar;
    }

    @Override
    public IRfFieldElement getStateVar() {
        return this.stateVar;
    }

    @Override
    public IRfFieldElement getNextStateVar() {
        return this.nextStateVar;
    }
}

