/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.fsm.model;

import de.cau.cs.kieler.core.kgraph.KGraphElement;
import de.cau.cs.kieler.core.kgraph.KNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.diagrams.fsm.model.FSMTransition;
import ro.amiq.dvt.diagrams.fsm.model.IFSMViewSelectable;
import ro.amiq.dvt.diagrams.fsm.model.IFSMViewSelectable2;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.fsm.debug.FSMDebugUtils;
import ro.amiq.dvt.fsm.model.IFSMInput;
import ro.amiq.dvt.fsm.model.IFSMState;
import ro.amiq.dvt.fsm.model.IFSMTransition;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.RfElementPathInProject;
import ro.amiq.dvt.model.reflection.semantic.extension.HidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidImplicitConstants;

public class FSMState
implements IFSMState,
IFSMViewSelectable,
IFSMViewSelectable2 {
    private String ID;
    private String niceID;
    private RfElementPathInProject elementPath;
    private int intValue = Integer.MIN_VALUE;
    private Map<IFSMInput, IFSMTransition> outgoingTransitions;
    private Set<IFSMTransition> incomingTransitions;
    private boolean isStart;
    private boolean isDefault;
    private GoToInfo marker;
    public static final String VOID_STATE_ID = "void";
    public static final FSMState VOID = new FSMState("void", "void", null, Integer.MIN_VALUE);
    public static final String ANY_STATE_ID = "[ ANY STATE ]";
    public static final HidImplicit ANY_STATE_IMPLICIT = HidUtils.makeStandInImplicit("[ ANY STATE ]", IHidImplicitConstants.ImplicitType.QUA_NUMBER.id);
    private KNode nodeCache;

    protected FSMState(String ID, String niceID, RfElementPathInProject element, int intValue) {
        this.ID = ID;
        this.niceID = niceID;
        this.elementPath = element;
        this.intValue = intValue;
    }

    @Override
    public String getID() {
        return this.ID;
    }

    @Override
    public String getNiceID() {
        return this.niceID;
    }

    @Override
    public void setNiceID(String label) {
        this.niceID = label;
    }

    public void setNode(KNode node) {
        this.nodeCache = node;
    }

    public KNode getNode() {
        return this.nodeCache;
    }

    @Override
    public IRfNamedElement getElement() {
        return this.elementPath != null ? this.elementPath.toNamedElement() : null;
    }

    @Override
    public boolean isStart() {
        return this.isStart;
    }

    @Override
    public void setIsStart(boolean isStart) {
        this.isStart = isStart;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    @Override
    public void setIsDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    @NotNull
    public Collection<IFSMTransition> getOutgoingTransitions() {
        return this.getOutgoingTransitions(false);
    }

    public Collection<IFSMTransition> getOutgoingTransitions(boolean sort) {
        if (this.outgoingTransitions == null) {
            return Collections.emptySet();
        }
        if (!sort) {
            return this.outgoingTransitions.values();
        }
        ArrayList<IFSMTransition> sortOutgoingTransitions = new ArrayList<IFSMTransition>(this.outgoingTransitions.values());
        Collections.sort(sortOutgoingTransitions, (o1, o2) -> {
            Iterator<GoToInfo> it1 = o1.getMarkers().iterator();
            Iterator<GoToInfo> it2 = o2.getMarkers().iterator();
            if (it1.hasNext() && it2.hasNext()) {
                return it1.next().offset - it2.next().offset;
            }
            return 0;
        });
        return sortOutgoingTransitions;
    }

    @Override
    public IFSMTransition getOutgoingTransition(IFSMInput input) {
        return this.outgoingTransitions == null ? null : this.outgoingTransitions.get(input);
    }

    @Override
    public void addOutgoingTransition(IFSMTransition transition) {
        IFSMTransition previousTrans;
        if (this.outgoingTransitions == null) {
            this.outgoingTransitions = new LinkedHashMap<IFSMInput, IFSMTransition>(4);
        }
        FSMDebugUtils.debugLevelOne((previousTrans = this.outgoingTransitions.put(transition.getSourceInput(), transition)) != null && previousTrans != transition, "Ambigous next state! Same input for different transactions", this, previousTrans, transition);
    }

    @Override
    public void addIncomingTransition(IFSMTransition trans) {
        if (this.incomingTransitions == null) {
            this.incomingTransitions = new LinkedHashSet<IFSMTransition>(4);
        }
        this.incomingTransitions.add(trans);
    }

    @Override
    public boolean removeIncomingTransition(IFSMTransition trans) {
        if (this.incomingTransitions == null || trans == null) {
            return false;
        }
        return this.incomingTransitions.remove(trans);
    }

    @Override
    @NotNull
    public Collection<? extends IFSMTransition> getIncomingTransitions() {
        return this.getIncomingTransitions(false);
    }

    @Override
    public Collection<? extends IFSMTransition> getIncomingTransitions(boolean sort) {
        if (this.incomingTransitions == null) {
            return Collections.emptySet();
        }
        if (!sort) {
            return this.incomingTransitions;
        }
        ArrayList<IFSMTransition> sortIncomingTransitions = new ArrayList<IFSMTransition>(this.incomingTransitions);
        Collections.sort(sortIncomingTransitions, (o1, o2) -> {
            Iterator<GoToInfo> it1 = o1.getMarkers().iterator();
            Iterator<GoToInfo> it2 = o2.getMarkers().iterator();
            if (it1.hasNext() && it2.hasNext()) {
                return it1.next().offset - it2.next().offset;
            }
            return 0;
        });
        return sortIncomingTransitions;
    }

    @Override
    public void addMarker(GoToInfo marker) {
        this.marker = marker;
    }

    public Set<GoToInfo> hasGoToSource() {
        return this.marker != null ? Collections.singleton(this.marker) : Collections.emptySet();
    }

    @Override
    public void goToSource(IProject project, boolean activateEditor) {
        if (this.marker != null) {
            this.marker.open(project, activateEditor);
        } else {
            FSMDebugUtils.debugLevelThree("Go to source null for state '" + this.getID() + "'", new Object[0]);
        }
    }

    @Override
    @NotNull
    public Set<KGraphElement> getDrivers() {
        KNode kElement;
        Set<IFSMState> prevStates = this.getPreviousStates();
        Collection<? extends IFSMTransition> prevTrans = this.getIncomingTransitions();
        LinkedHashSet<KGraphElement> prevs = new LinkedHashSet<KGraphElement>(prevStates.size() + prevTrans.size());
        for (IFSMState iFSMState : prevStates) {
            kElement = ((FSMState)iFSMState).getNode();
            if (kElement == null) continue;
            prevs.add((KGraphElement)kElement);
        }
        for (IFSMTransition iFSMTransition : prevTrans) {
            kElement = ((FSMTransition)iFSMTransition).getEdge();
            if (kElement == null) continue;
            prevs.add((KGraphElement)kElement);
        }
        return prevs;
    }

    @Override
    public Set<KGraphElement> getLoads() {
        KNode kElement;
        Set<IFSMState> nextStates = this.getNextStates();
        Collection<IFSMTransition> nextTrans = this.getOutgoingTransitions();
        LinkedHashSet<KGraphElement> prevs = new LinkedHashSet<KGraphElement>(nextStates.size() + nextTrans.size());
        for (IFSMState state : nextStates) {
            kElement = ((FSMState)state).getNode();
            if (kElement == null) continue;
            prevs.add((KGraphElement)kElement);
        }
        for (IFSMTransition trans : nextTrans) {
            kElement = ((FSMTransition)trans).getEdge();
            if (kElement == null) continue;
            prevs.add((KGraphElement)kElement);
        }
        return prevs;
    }

    public String toString() {
        return this.niceID;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.intValue == Integer.MIN_VALUE ? 0 : this.intValue);
        return result;
    }

    public boolean equals(Object obj) {
        IRfNamedElement otherElement;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FSMState other = (FSMState)obj;
        IRfNamedElement element = this.elementPath != null ? this.elementPath.toNamedElement() : null;
        IRfNamedElement iRfNamedElement = otherElement = other.elementPath != null ? other.elementPath.toNamedElement() : null;
        if (element != null && otherElement != null && (ELUtils.isVLOGConstant(element) || ELUtils.isVHDLConstant(element)) && (ELUtils.isVLOGConstant(otherElement) || ELUtils.isVHDLConstant(otherElement))) {
            return element.equals(otherElement);
        }
        if (this.intValue != Integer.MIN_VALUE && other.intValue != Integer.MIN_VALUE) {
            return this.intValue == other.intValue;
        }
        return !(this.ID == null ? other.ID != null : !this.ID.equals(other.ID));
    }
}

