/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.fsm.model;

import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KGraphElement;
import de.cau.cs.kieler.core.kgraph.KNode;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.diagrams.fsm.model.FSMInput;
import ro.amiq.dvt.diagrams.fsm.model.FSMState;
import ro.amiq.dvt.diagrams.fsm.model.IFSMViewSelectable;
import ro.amiq.dvt.diagrams.fsm.model.IFSMViewSelectable2;
import ro.amiq.dvt.diagrams.tables.ITableRowData;
import ro.amiq.dvt.fsm.debug.FSMDebugUtils;
import ro.amiq.dvt.fsm.model.IFSMInput;
import ro.amiq.dvt.fsm.model.IFSMState;
import ro.amiq.dvt.fsm.model.IFSMTransition;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.NotNull;

public class FSMTransition
implements IFSMTransition,
IFSMViewSelectable,
IFSMViewSelectable2,
ITableRowData {
    private final IFSMState src;
    private final IFSMInput srcInput;
    private final IFSMState dest;
    private int index;
    private Set<GoToInfo> markers;
    private KEdge edgeCache;
    private String nextStateVarName;
    private String stateVarName;

    protected FSMTransition(FSMInput srcInput, IFSMState src, IFSMState dest, String stateVarName, String nextStateVarName) {
        this.srcInput = srcInput;
        this.src = src;
        this.dest = dest;
        this.stateVarName = stateVarName;
        this.nextStateVarName = nextStateVarName;
    }

    @Override
    public IFSMState getSource() {
        return this.src;
    }

    public KEdge getEdge() {
        return this.edgeCache;
    }

    public void setEdge(KEdge edgeCache) {
        this.edgeCache = edgeCache;
    }

    @Override
    public IFSMState getDestination() {
        return this.dest;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    @NotNull
    public IFSMInput getSourceInput() {
        return this.srcInput;
    }

    public String getNextStateVarName() {
        return this.nextStateVarName;
    }

    public String getStateVarName() {
        return this.stateVarName;
    }

    @Override
    public void addMarker(GoToInfo marker) {
        if (marker == null) {
            return;
        }
        if (this.markers == null) {
            this.markers = new LinkedHashSet<GoToInfo>();
        }
        this.markers.add(marker);
    }

    @Override
    public Set<GoToInfo> getMarkers() {
        if (this.markers == null) {
            return Collections.emptySet();
        }
        return this.markers;
    }

    public void setMarkers(Collection<GoToInfo> markers) {
        this.markers = new LinkedHashSet<GoToInfo>(markers);
    }

    public Set<GoToInfo> hasGoToSource() {
        return this.markers != null && !this.markers.isEmpty() ? this.markers : Collections.emptySet();
    }

    @Override
    public void goToSource(IProject project, boolean activateEditor) {
        if (this.markers != null && !this.markers.isEmpty()) {
            this.markers.iterator().next().open(project, activateEditor);
        } else {
            FSMDebugUtils.debugLevelThree("Go to source null for transition '" + this.toString() + "'", new Object[0]);
        }
    }

    @Override
    public Set<KGraphElement> getDrivers() {
        KNode kElement = ((FSMState)this.src).getNode();
        if (kElement == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(kElement);
    }

    @Override
    public Set<KGraphElement> getLoads() {
        KNode kElement = ((FSMState)this.dest).getNode();
        if (kElement == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(kElement);
    }

    public String toString() {
        return this.src + " ---(" + this.srcInput + ")---> " + this.dest;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.dest == null ? 0 : this.dest.hashCode());
        result = 31 * result + (this.src == null ? 0 : this.src.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FSMTransition other = (FSMTransition)obj;
        if (this.dest == null ? other.dest != null : !this.dest.equals(other.dest)) {
            return false;
        }
        return !(this.src == null ? other.src != null : !this.src.equals(other.src));
    }

    @Override
    public boolean shouldFilterRow() {
        return false;
    }
}

