/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.fsm.rendering;

import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KLabel;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.kgraph.KPort;
import de.cau.cs.kieler.core.krendering.KColor;
import de.cau.cs.kieler.core.krendering.KFontBold;
import de.cau.cs.kieler.core.krendering.KFontItalic;
import de.cau.cs.kieler.core.krendering.KFontName;
import de.cau.cs.kieler.core.krendering.KFontSize;
import de.cau.cs.kieler.core.krendering.KRendering;
import de.cau.cs.kieler.core.krendering.KStyle;
import de.cau.cs.kieler.core.krendering.KText;
import de.cau.cs.kieler.core.krendering.LineStyle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.graphics.FontData;
import ro.amiq.dvt.diagrams.fsm.FSMDiagramConfiguration;
import ro.amiq.dvt.diagrams.fsm.rendering.FSMDefaultRendering;
import ro.amiq.dvt.diagrams.fsm.rendering.FSMRendering;
import ro.amiq.dvt.diagrams.fsm.rendering.IFSMRendering;
import ro.amiq.dvt.diagrams.klay.rendering.KLayStyleFactory;
import ro.amiq.dvt.draw.utils.ColorFactory;
import ro.amiq.dvt.draw.utils.FontFactory;
import ro.amiq.dvt.fsm.model.IFSMBase;
import ro.amiq.dvt.fsm.model.IFSMState;
import ro.amiq.dvt.fsm.model.IFSMTransition;
import ro.amiq.dvt.model.reflection.NotNull;

public interface FSMRenderingUtils {
    public static final KLayStyleFactory STYLE_FACTORY = KLayStyleFactory.INSTANCE;

    public static void renderGate(KNode node, IFSMState gate, FSMDiagramConfiguration bundle) {
        KRendering gateRendering = FSMRenderingUtils.getGateRenderingOrDefault(gate, bundle);
        if (gateRendering == null) {
            return;
        }
        EList styles = gateRendering.getStyles();
        KColor bgColor = FSMRenderingUtils.getColorOrDefault(gate, IFSMRendering.RenderingLayer.BACKGROUND);
        int bgAlpha = FSMRenderingUtils.getAlphaOrDefault(gate, IFSMRendering.RenderingLayer.BACKGROUND);
        styles.add((Object)STYLE_FACTORY.createBackground(bgColor, bgAlpha));
        KColor fgColor = FSMRenderingUtils.getColorOrDefault(gate, IFSMRendering.RenderingLayer.FOREGROUND);
        int fgAlpha = FSMRenderingUtils.getAlphaOrDefault(gate, IFSMRendering.RenderingLayer.FOREGROUND);
        styles.add((Object)STYLE_FACTORY.createForeground(fgColor, fgAlpha));
        float lineWidth = FSMRenderingUtils.getLineWidthOrDefault(gate, IFSMRendering.RenderingLayer.FOREGROUND);
        styles.add((Object)STYLE_FACTORY.createLineWidth(lineWidth));
        LineStyle lineStyle = FSMRenderingUtils.getLineStyleOrDefault(gate);
        styles.add((Object)STYLE_FACTORY.createLineStyle(lineStyle));
        bgColor = FSMRenderingUtils.getColorOrDefault(gate, IFSMRendering.RenderingLayer.SELECTION_BACKGROUND);
        bgAlpha = FSMRenderingUtils.getAlphaOrDefault(gate, IFSMRendering.RenderingLayer.SELECTION_BACKGROUND);
        styles.add((Object)STYLE_FACTORY.createSelectionBackground(bgColor, bgAlpha));
        fgColor = FSMRenderingUtils.getColorOrDefault(gate, IFSMRendering.RenderingLayer.SELECTION_FOREGROUND);
        fgAlpha = FSMRenderingUtils.getAlphaOrDefault(gate, IFSMRendering.RenderingLayer.SELECTION_FOREGROUND);
        styles.add((Object)STYLE_FACTORY.createSelectionForeground(fgColor, fgAlpha));
        lineWidth = FSMRenderingUtils.getLineWidthOrDefault(gate, IFSMRendering.RenderingLayer.SELECTION_FOREGROUND);
        styles.add((Object)STYLE_FACTORY.createSelectionLineWidth(lineWidth));
        bgColor = FSMRenderingUtils.getColorOrDefault(gate, IFSMRendering.RenderingLayer.SELECTION_DRIVER_BACKGROUND);
        bgAlpha = FSMRenderingUtils.getAlphaOrDefault(gate, IFSMRendering.RenderingLayer.SELECTION_DRIVER_BACKGROUND);
        styles.add((Object)STYLE_FACTORY.createSelectionDriverBackground(bgColor, bgAlpha));
        fgColor = FSMRenderingUtils.getColorOrDefault(gate, IFSMRendering.RenderingLayer.SELECTION_DRIVER_FOREGROUND);
        fgAlpha = FSMRenderingUtils.getAlphaOrDefault(gate, IFSMRendering.RenderingLayer.SELECTION_DRIVER_FOREGROUND);
        styles.add((Object)STYLE_FACTORY.createSelectionDriverForeground(fgColor, fgAlpha));
        lineWidth = FSMRenderingUtils.getLineWidthOrDefault(gate, IFSMRendering.RenderingLayer.SELECTION_DRIVER_FOREGROUND);
        styles.add((Object)STYLE_FACTORY.createSelectionDriverLineWidth(lineWidth));
        bgColor = FSMRenderingUtils.getColorOrDefault(gate, IFSMRendering.RenderingLayer.SELECTION_LOAD_BACKGROUND);
        bgAlpha = FSMRenderingUtils.getAlphaOrDefault(gate, IFSMRendering.RenderingLayer.SELECTION_LOAD_BACKGROUND);
        styles.add((Object)STYLE_FACTORY.createSelectionLoadBackground(bgColor, bgAlpha));
        fgColor = FSMRenderingUtils.getColorOrDefault(gate, IFSMRendering.RenderingLayer.SELECTION_LOAD_FOREGROUND);
        fgAlpha = FSMRenderingUtils.getAlphaOrDefault(gate, IFSMRendering.RenderingLayer.SELECTION_LOAD_FOREGROUND);
        styles.add((Object)STYLE_FACTORY.createSelectionLoadForeground(fgColor, fgAlpha));
        lineWidth = FSMRenderingUtils.getLineWidthOrDefault(gate, IFSMRendering.RenderingLayer.SELECTION_LOAD_FOREGROUND);
        styles.add((Object)STYLE_FACTORY.createSelectionLoadLineWidth(lineWidth));
        bgColor = FSMRenderingUtils.getColorOrDefault(gate, IFSMRendering.RenderingLayer.SELECTION_DRIVER_AND_LOAD_BACKGROUND);
        bgAlpha = FSMRenderingUtils.getAlphaOrDefault(gate, IFSMRendering.RenderingLayer.SELECTION_DRIVER_AND_LOAD_BACKGROUND);
        styles.add((Object)STYLE_FACTORY.createSelectionDriverAndLoadBackground(bgColor, bgAlpha));
        fgColor = FSMRenderingUtils.getColorOrDefault(gate, IFSMRendering.RenderingLayer.SELECTION_DRIVER_AND_LOAD_FOREGROUND);
        fgAlpha = FSMRenderingUtils.getAlphaOrDefault(gate, IFSMRendering.RenderingLayer.SELECTION_DRIVER_AND_LOAD_FOREGROUND);
        styles.add((Object)STYLE_FACTORY.createSelectionDriverAndLoadForeground(fgColor, fgAlpha));
        lineWidth = FSMRenderingUtils.getLineWidthOrDefault(gate, IFSMRendering.RenderingLayer.SELECTION_DRIVER_AND_LOAD_FOREGROUND);
        styles.add((Object)STYLE_FACTORY.createSelectionDriverAndLoadLineWidth(lineWidth));
        node.getData().add((Object)gateRendering);
    }

    public static void renderDummyGate(KNode dummyNode) {
        KRendering gateRendering = FSMRenderingUtils.getDummyGateRenderingOrDefault();
        if (gateRendering == null) {
            return;
        }
        EList styles = gateRendering.getStyles();
        KColor bgColor = KLayStyleFactory.createColorFromRGB(ColorFactory.getInstance().getRGB(255, 255, 255));
        int bgAlpha = 0;
        styles.add((Object)STYLE_FACTORY.createBackground(bgColor, bgAlpha));
        KColor fgColor = KLayStyleFactory.createColorFromRGB(ColorFactory.getInstance().getRGB(255, 255, 255));
        int fgAlpha = 0;
        styles.add((Object)STYLE_FACTORY.createForeground(fgColor, fgAlpha));
        dummyNode.getData().add((Object)gateRendering);
    }

    public static void renderPort(KPort port, FSMDiagramConfiguration bundle) {
        KRendering rendering = FSMRenderingUtils.getPortRenderingOrDefault();
        if (rendering == null) {
            return;
        }
        EList styles = rendering.getStyles();
        KColor bgColor = KLayStyleFactory.createColorFromRGB(ColorFactory.getInstance().getRGB(255, 255, 255));
        int bgAlpha = 0;
        styles.add((Object)STYLE_FACTORY.createBackground(bgColor, bgAlpha));
        KColor fgColor = KLayStyleFactory.createColorFromRGB(ColorFactory.getInstance().getRGB(255, 255, 255));
        int fgAlpha = 0;
        styles.add((Object)STYLE_FACTORY.createForeground(fgColor, fgAlpha));
        port.getData().add((Object)rendering);
    }

    public static void renderEdge(KEdge edge, IFSMTransition transaction, FSMDiagramConfiguration bundle) {
        KRendering edgeRendering = FSMRenderingUtils.getEdgeRenderingOrDefault(transaction, bundle);
        if (edgeRendering == null) {
            return;
        }
        EList styles = edgeRendering.getStyles();
        KColor fgColor = FSMRenderingUtils.getColorOrDefault(transaction, IFSMRendering.RenderingLayer.FOREGROUND);
        int fgAlpha = FSMRenderingUtils.getAlphaOrDefault(transaction, IFSMRendering.RenderingLayer.FOREGROUND);
        styles.add((Object)STYLE_FACTORY.createForeground(fgColor, fgAlpha));
        float lineWidth = FSMRenderingUtils.getLineWidthOrDefault(transaction, IFSMRendering.RenderingLayer.FOREGROUND);
        styles.add((Object)STYLE_FACTORY.createLineWidth(lineWidth));
        LineStyle lineStyle = FSMRenderingUtils.getLineStyleOrDefault(transaction);
        styles.add((Object)STYLE_FACTORY.createLineStyle(lineStyle));
        fgColor = FSMRenderingUtils.getColorOrDefault(transaction, IFSMRendering.RenderingLayer.SELECTION_FOREGROUND);
        fgAlpha = FSMRenderingUtils.getAlphaOrDefault(transaction, IFSMRendering.RenderingLayer.SELECTION_FOREGROUND);
        styles.add((Object)STYLE_FACTORY.createSelectionForeground(fgColor, fgAlpha));
        lineWidth = FSMRenderingUtils.getLineWidthOrDefault(transaction, IFSMRendering.RenderingLayer.SELECTION_FOREGROUND);
        styles.add((Object)STYLE_FACTORY.createSelectionLineWidth(lineWidth));
        fgColor = FSMRenderingUtils.getColorOrDefault(transaction, IFSMRendering.RenderingLayer.SELECTION_DRIVER_FOREGROUND);
        fgAlpha = FSMRenderingUtils.getAlphaOrDefault(transaction, IFSMRendering.RenderingLayer.SELECTION_DRIVER_FOREGROUND);
        styles.add((Object)STYLE_FACTORY.createSelectionDriverForeground(fgColor, fgAlpha));
        lineWidth = FSMRenderingUtils.getLineWidthOrDefault(transaction, IFSMRendering.RenderingLayer.SELECTION_DRIVER_FOREGROUND);
        styles.add((Object)STYLE_FACTORY.createSelectionDriverLineWidth(lineWidth));
        fgColor = FSMRenderingUtils.getColorOrDefault(transaction, IFSMRendering.RenderingLayer.SELECTION_LOAD_FOREGROUND);
        fgAlpha = FSMRenderingUtils.getAlphaOrDefault(transaction, IFSMRendering.RenderingLayer.SELECTION_LOAD_FOREGROUND);
        styles.add((Object)STYLE_FACTORY.createSelectionLoadForeground(fgColor, fgAlpha));
        lineWidth = FSMRenderingUtils.getLineWidthOrDefault(transaction, IFSMRendering.RenderingLayer.SELECTION_LOAD_FOREGROUND);
        styles.add((Object)STYLE_FACTORY.createSelectionLoadLineWidth(lineWidth));
        fgColor = FSMRenderingUtils.getColorOrDefault(transaction, IFSMRendering.RenderingLayer.SELECTION_DRIVER_AND_LOAD_FOREGROUND);
        fgAlpha = FSMRenderingUtils.getAlphaOrDefault(transaction, IFSMRendering.RenderingLayer.SELECTION_DRIVER_AND_LOAD_FOREGROUND);
        styles.add((Object)STYLE_FACTORY.createSelectionDriverAndLoadForeground(fgColor, fgAlpha));
        lineWidth = FSMRenderingUtils.getLineWidthOrDefault(transaction, IFSMRendering.RenderingLayer.SELECTION_DRIVER_AND_LOAD_FOREGROUND);
        styles.add((Object)STYLE_FACTORY.createSelectionDriverAndLoadLineWidth(lineWidth));
        edge.getData().add((Object)edgeRendering);
    }

    public static void renderLabel(KLabel label, IFSMBase elem) {
        KText labelRendering = FSMRenderingUtils.getLabelRenderingOrDefault();
        if (labelRendering == null) {
            return;
        }
        EList styles = labelRendering.getStyles();
        int size = FSMRenderingUtils.getFontSizeOrDefault(elem);
        styles.add((Object)STYLE_FACTORY.createFontSize(size));
        String fontName = FSMRenderingUtils.getFontNameOrDefault(elem);
        styles.add((Object)STYLE_FACTORY.createFontName(fontName));
        KFontBold fontBold = FSMRenderingUtils.getFontBoldOrDefault(elem);
        styles.add((Object)fontBold);
        KFontItalic fontItalic = FSMRenderingUtils.getFontItalicOrDefault(elem);
        styles.add((Object)fontItalic);
        KColor fgColor = FSMRenderingUtils.getColorOrDefault(elem, IFSMRendering.RenderingLayer.LABEL_FOREGROUND);
        int fgAlpha = FSMRenderingUtils.getAlphaOrDefault(elem, IFSMRendering.RenderingLayer.LABEL_FOREGROUND);
        styles.add((Object)STYLE_FACTORY.createForeground(fgColor, fgAlpha));
        fgColor = FSMRenderingUtils.getColorOrDefault(elem, IFSMRendering.RenderingLayer.SELECTION_LABEL_FOREGROUND);
        fgAlpha = FSMRenderingUtils.getAlphaOrDefault(elem, IFSMRendering.RenderingLayer.SELECTION_LABEL_FOREGROUND);
        styles.add((Object)STYLE_FACTORY.createSelectionForeground(fgColor, fgAlpha));
        label.getData().add((Object)labelRendering);
    }

    public static FontData getFontData(KLabel label) {
        if (label == null) {
            return null;
        }
        KRendering text = (KRendering)label.getData(KRendering.class);
        if (!(text instanceof KText)) {
            return null;
        }
        String fontName = null;
        int fontSize = 0;
        int fontStyle = 0;
        EList styles = text.getStyles();
        for (KStyle style : styles) {
            if (style instanceof KFontSize) {
                fontSize = ((KFontSize)style).getSize();
                continue;
            }
            if (style instanceof KFontName) {
                fontName = ((KFontName)style).getName();
                continue;
            }
            if (style instanceof KFontBold && ((KFontBold)style).isBold()) {
                fontStyle |= 1;
                continue;
            }
            if (!(style instanceof KFontItalic) || !((KFontItalic)style).isItalic()) continue;
            fontStyle |= 2;
        }
        return FontFactory.getInstance().getFontData(fontName, fontSize, fontStyle);
    }

    @NotNull
    public static KRendering getGateRenderingOrDefault(IFSMState state, FSMDiagramConfiguration bundle) {
        KRendering rendering = FSMRendering.getInstance().getGateRendering(state, bundle);
        if (rendering != null) {
            return rendering;
        }
        return FSMDefaultRendering.getInstance().getGateRendering(state, bundle);
    }

    @NotNull
    public static KRendering getDummyGateRenderingOrDefault() {
        KRendering rendering = FSMRendering.getInstance().getDummyGateRendering();
        if (rendering != null) {
            return rendering;
        }
        return FSMDefaultRendering.getInstance().getDummyGateRendering();
    }

    @NotNull
    public static KRendering getEdgeRenderingOrDefault(IFSMTransition trans, FSMDiagramConfiguration bundle) {
        KRendering rendering = FSMRendering.getInstance().getEdgeRendering(trans, bundle);
        if (rendering != null) {
            return rendering;
        }
        return FSMDefaultRendering.getInstance().getEdgeRendering(trans, bundle);
    }

    @NotNull
    public static KRendering getPortRenderingOrDefault() {
        KRendering rendering = FSMRendering.getInstance().getPortRendering();
        if (rendering != null) {
            return rendering;
        }
        return FSMDefaultRendering.getInstance().getPortRendering();
    }

    @NotNull
    public static KText getLabelRenderingOrDefault() {
        KText rendering = FSMRendering.getInstance().getLabelRendering();
        if (rendering != null) {
            return rendering;
        }
        return FSMDefaultRendering.getInstance().getLabelRendering();
    }

    @NotNull
    public static KColor getColorOrDefault(IFSMBase object, IFSMRendering.RenderingLayer layer) {
        KColor color = FSMRendering.getInstance().getColor(object, layer);
        if (color != null) {
            return color;
        }
        return FSMDefaultRendering.getInstance().getColor(object, layer);
    }

    @NotNull
    public static int getAlphaOrDefault(IFSMBase object, IFSMRendering.RenderingLayer layer) {
        int alpha = FSMRendering.getInstance().getAlpha(object, layer);
        if (alpha > -1) {
            return alpha;
        }
        return FSMDefaultRendering.getInstance().getAlpha(object, layer);
    }

    @NotNull
    public static int getFontSizeOrDefault(IFSMBase object) {
        int fontSize = FSMRendering.getInstance().getFontSize(object);
        if (fontSize > -1) {
            return fontSize;
        }
        return FSMDefaultRendering.getInstance().getFontSize(object);
    }

    @NotNull
    public static String getFontNameOrDefault(IFSMBase object) {
        String fontName = FSMRendering.getInstance().getFontName(object);
        if (fontName != null) {
            return fontName;
        }
        return FSMDefaultRendering.getInstance().getFontName(object);
    }

    @NotNull
    public static KFontBold getFontBoldOrDefault(IFSMBase object) {
        KFontBold fontBold = FSMRendering.getInstance().getFontBold(object);
        if (fontBold != null) {
            return fontBold;
        }
        return FSMDefaultRendering.getInstance().getFontBold(object);
    }

    @NotNull
    public static KFontItalic getFontItalicOrDefault(IFSMBase object) {
        KFontItalic fontItalic = FSMRendering.getInstance().getFontItalic(object);
        if (fontItalic != null) {
            return fontItalic;
        }
        return FSMDefaultRendering.getInstance().getFontItalic(object);
    }

    @NotNull
    public static float getLineWidthOrDefault(IFSMBase object, IFSMRendering.RenderingLayer layer) {
        float lineWidth = FSMRendering.getInstance().getLineWidth(object, layer);
        if (lineWidth > -1.0f) {
            return lineWidth;
        }
        return FSMDefaultRendering.getInstance().getLineWidth(object, layer);
    }

    @NotNull
    public static LineStyle getLineStyleOrDefault(IFSMBase object) {
        LineStyle lineStyle = FSMRendering.getInstance().getLineStyle(object);
        if (lineStyle != null) {
            return lineStyle;
        }
        return FSMDefaultRendering.getInstance().getLineStyle(object);
    }
}

