/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.fsm.rendering.gui;

import de.cau.cs.kieler.core.krendering.KColor;
import de.cau.cs.kieler.core.krendering.KFontBold;
import de.cau.cs.kieler.core.krendering.KFontItalic;
import de.cau.cs.kieler.core.krendering.KRendering;
import de.cau.cs.kieler.core.krendering.KRenderingFactory;
import de.cau.cs.kieler.core.krendering.KText;
import de.cau.cs.kieler.core.krendering.LineStyle;
import de.cau.cs.kieler.kiml.options.EdgeRouting;
import ro.amiq.dvt.diagrams.fsm.FSMDiagramConfiguration;
import ro.amiq.dvt.diagrams.fsm.rendering.FSMDefaultRendering;
import ro.amiq.dvt.diagrams.fsm.rendering.FSMDefaultRenderingConstants;
import ro.amiq.dvt.diagrams.fsm.rendering.IFSMRendering;
import ro.amiq.dvt.diagrams.klay.rendering.KLayStyleFactory;
import ro.amiq.dvt.fsm.model.IFSMBase;
import ro.amiq.dvt.fsm.model.IFSMCondition;
import ro.amiq.dvt.fsm.model.IFSMState;
import ro.amiq.dvt.fsm.model.IFSMTransition;
import ro.amiq.dvt.fsm.utils.FSMUtils;

public class FSMDefaultGUIRendering
extends FSMDefaultRendering {
    public static final KRenderingFactory FACTORY = KRenderingFactory.eINSTANCE;

    @Override
    public KRendering getGateRendering(IFSMState gate, FSMDiagramConfiguration config) {
        if (config.contains(FSMDiagramConfiguration.FSMDiagramConfigurationKey.SHOW_STATE_AS_CIRCLE)) {
            return FACTORY.createKEllipse();
        }
        return FACTORY.createKRoundedRectangle();
    }

    @Override
    public KRendering getDummyGateRendering() {
        return FACTORY.createKRectangle();
    }

    @Override
    public KRendering getEdgeRendering(IFSMTransition edge, FSMDiagramConfiguration bundle) {
        EdgeRouting edgeRouting = bundle.get(FSMDiagramConfiguration.FSMDiagramConfigurationKey.EDGE_ROUTING);
        if (edgeRouting == EdgeRouting.SPLINES) {
            return FACTORY.createKSpline();
        }
        return FACTORY.createKPolyline();
    }

    @Override
    public KRendering getPortRendering() {
        return FACTORY.createKRectangle();
    }

    @Override
    public KText getLabelRendering() {
        return FACTORY.createKText();
    }

    @Override
    public KColor getForegroundColor(IFSMBase object) {
        if (object instanceof IFSMState) {
            return KLayStyleFactory.createColorFromRGB(FSMDefaultRenderingConstants.FG_STATE_RGB);
        }
        if (object instanceof IFSMTransition) {
            return KLayStyleFactory.createColorFromRGB(FSMDefaultRenderingConstants.FG_TRANSITION_RGB);
        }
        return KLayStyleFactory.createColorFromRGB(FSMDefaultRenderingConstants.DEFAULT_FG_RGB);
    }

    @Override
    public KColor getSelectionForegroundColor(IFSMBase object, IFSMRendering.RenderingLayer layer) {
        if (object instanceof IFSMState) {
            switch (layer) {
                case SELECTION_DRIVER_FOREGROUND: {
                    return KLayStyleFactory.createColorFromRGB(FSMDefaultRenderingConstants.SEL_DRIVER_FG_STATE_RGB);
                }
                case SELECTION_LOAD_FOREGROUND: {
                    return KLayStyleFactory.createColorFromRGB(FSMDefaultRenderingConstants.SEL_LOAD_FG_STATE_RGB);
                }
                case SELECTION_DRIVER_AND_LOAD_FOREGROUND: {
                    return KLayStyleFactory.createColorFromRGB(FSMDefaultRenderingConstants.SEL_DRIVER_AND_LOAD_FG_STATE_RGB);
                }
            }
            return KLayStyleFactory.createColorFromRGB(FSMDefaultRenderingConstants.SEL_FG_STATE_RGB);
        }
        if (object instanceof IFSMTransition) {
            switch (layer) {
                case SELECTION_DRIVER_FOREGROUND: {
                    return KLayStyleFactory.createColorFromRGB(FSMDefaultRenderingConstants.SEL_DRIVER_FG_TRANSITION_RGB);
                }
                case SELECTION_LOAD_FOREGROUND: {
                    return KLayStyleFactory.createColorFromRGB(FSMDefaultRenderingConstants.SEL_LOAD_FG_TRANSITION_RGB);
                }
                case SELECTION_DRIVER_AND_LOAD_FOREGROUND: {
                    return KLayStyleFactory.createColorFromRGB(FSMDefaultRenderingConstants.SEL_DRIVER_AND_LOAD_FG_TRANSITION_RGB);
                }
            }
            return KLayStyleFactory.createColorFromRGB(FSMDefaultRenderingConstants.SEL_FG_TRANSITION_RGB);
        }
        return KLayStyleFactory.createColorFromRGB(FSMDefaultRenderingConstants.DEFAULT_SEL_RGB);
    }

    @Override
    public KColor getLabelForegroundColor(IFSMBase object) {
        return KLayStyleFactory.createColorFromRGB(FSMDefaultRenderingConstants.LABEL_FG_TRANSITION_RGB);
    }

    @Override
    public KColor getLabelSelectionForegroundColor(IFSMBase object) {
        return KLayStyleFactory.createColorFromRGB(FSMDefaultRenderingConstants.SEL_LABEL_FG_TRANSITION_RGB);
    }

    @Override
    public KColor getBackgroundColor(IFSMBase object) {
        if (object instanceof IFSMState) {
            if (FSMUtils.isStartState(object) || ((IFSMState)object).isDefault()) {
                return KLayStyleFactory.createColorFromRGB(FSMDefaultRenderingConstants.BG_START_STATE_RGB);
            }
            return KLayStyleFactory.createColorFromRGB(FSMDefaultRenderingConstants.BG_STATE_RGB);
        }
        return KLayStyleFactory.createColorFromRGB(FSMDefaultRenderingConstants.DEFAULT_BG_RGB);
    }

    @Override
    public KColor getSelectionBackgroundColor(IFSMBase object, IFSMRendering.RenderingLayer layer) {
        if (object instanceof IFSMState) {
            switch (layer) {
                case SELECTION_DRIVER_BACKGROUND: {
                    return KLayStyleFactory.createColorFromRGB(FSMDefaultRenderingConstants.SEL_DRIVER_BG_STATE_RGB);
                }
                case SELECTION_LOAD_BACKGROUND: {
                    return KLayStyleFactory.createColorFromRGB(FSMDefaultRenderingConstants.SEL_LOAD_BG_STATE_RGB);
                }
                case SELECTION_DRIVER_AND_LOAD_BACKGROUND: {
                    return KLayStyleFactory.createColorFromRGB(FSMDefaultRenderingConstants.SEL_DRIVER_AND_LOAD_BG_STATE_RGB);
                }
            }
            return KLayStyleFactory.createColorFromRGB(FSMDefaultRenderingConstants.SEL_BG_STATE_RGB);
        }
        return KLayStyleFactory.createColorFromRGB(FSMDefaultRenderingConstants.DEFAULT_SEL_RGB);
    }

    @Override
    public int getAlpha(IFSMBase object, IFSMRendering.RenderingLayer layer) {
        return 255;
    }

    @Override
    public int getFontSize(IFSMBase object) {
        if (object instanceof IFSMState) {
            return 20;
        }
        if (object instanceof IFSMCondition) {
            return 10;
        }
        if (object instanceof IFSMTransition) {
            return 25;
        }
        return 0;
    }

    @Override
    public String getFontName(IFSMBase object) {
        return "Ubuntu Mono";
    }

    @Override
    public KFontBold getFontBold(IFSMBase object) {
        KFontBold fontBold = FACTORY.createKFontBold();
        return fontBold;
    }

    @Override
    public KFontItalic getFontItalic(IFSMBase object) {
        KFontItalic fontItalic = FACTORY.createKFontItalic();
        fontItalic.setItalic(false);
        return fontItalic;
    }

    @Override
    public float getLineWidth(IFSMBase object, IFSMRendering.RenderingLayer layer) {
        switch (layer) {
            case SELECTION_FOREGROUND: {
                return 3.0f;
            }
            case SELECTION_DRIVER_FOREGROUND: {
                return 3.0f;
            }
            case SELECTION_LOAD_FOREGROUND: {
                return 3.0f;
            }
            case SELECTION_DRIVER_AND_LOAD_FOREGROUND: {
                return 3.0f;
            }
            case SELECTION_LABEL_FOREGROUND: {
                return 3.0f;
            }
        }
        return 1.0f;
    }

    @Override
    public LineStyle getLineStyle(IFSMBase object) {
        return FSMDefaultRenderingConstants.LINE_STYLE;
    }
}

