/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.fsm.utils;

import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KLabeledGraphElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.DProgressMonitor;
import ro.amiq.dvt.diagrams.exceptions.DCanceledException;
import ro.amiq.dvt.diagrams.fsm.FSMDiagramAdapter;
import ro.amiq.dvt.diagrams.fsm.FSMDiagramConfiguration;
import ro.amiq.dvt.diagrams.fsm.editor.actions.TransitionLabelType;
import ro.amiq.dvt.diagrams.fsm.model.FSMCondition;
import ro.amiq.dvt.diagrams.fsm.model.FSMFactory;
import ro.amiq.dvt.diagrams.fsm.model.FSMInput;
import ro.amiq.dvt.diagrams.fsm.model.FSMModel;
import ro.amiq.dvt.diagrams.fsm.model.FSMState;
import ro.amiq.dvt.diagrams.fsm.model.FSMTransition;
import ro.amiq.dvt.fsm.debug.FSMDebugUtils;
import ro.amiq.dvt.fsm.model.IFSMCondition;
import ro.amiq.dvt.fsm.model.IFSMInput;
import ro.amiq.dvt.fsm.model.IFSMState;
import ro.amiq.dvt.fsm.model.IFSMTransition;
import ro.amiq.dvt.fsm.utils.FSMExecutors;
import ro.amiq.dvt.fsm.utils.FSMFilterCommonExpressionsVisitor;
import ro.amiq.dvt.fsm.utils.FSMFilterNamesVisitor;
import ro.amiq.dvt.fsm.utils.FSMUtils;
import ro.amiq.dvt.fsm.utils.FSMVisitors;
import ro.amiq.dvt.logic.form.model.LFFormula;
import ro.amiq.dvt.logic.form.utils.LFUtils;
import ro.amiq.dvt.model.reflection.GoToInfo;

public class FSMDiagramProcessors {
    public static final void mergeDuplicateTransitions(FSMModel model, FSMDiagramConfiguration config, IProgressMonitor monitor) {
        if (model == null || !config.contains(FSMDiagramConfiguration.FSMDiagramConfigurationKey.MERGE_DUPLICATE_TRANSITIONS)) {
            return;
        }
        FSMExecutors.newBFS().setModel(model, false, monitor).addVisitor(new FSMVisitors.StateVisitor(){

            @Override
            public void visit(IFSMState state) {
                Collection<? extends IFSMTransition> transitions = state.getOutgoingTransitions();
                if (transitions == null || transitions.size() <= 1) {
                    return;
                }
                LinkedHashMap<IFSMState, ArrayList<IFSMTransition>> mapTransitions = new LinkedHashMap<IFSMState, ArrayList<IFSMTransition>>(transitions.size());
                for (IFSMTransition iFSMTransition : transitions) {
                    IFSMInput input = iFSMTransition.getSourceInput();
                    if (!(input instanceof FSMInput)) continue;
                    ArrayList<IFSMTransition> duplicates = (ArrayList<IFSMTransition>)mapTransitions.get(iFSMTransition.getDestination());
                    if (duplicates == null) {
                        duplicates = new ArrayList<IFSMTransition>(4);
                        mapTransitions.put(iFSMTransition.getDestination(), duplicates);
                    }
                    duplicates.add(iFSMTransition);
                }
                for (Map.Entry entry : mapTransitions.entrySet()) {
                    List duplicates = (List)entry.getValue();
                    if (duplicates == null || duplicates.size() <= 1) continue;
                    IFSMState dest = (IFSMState)entry.getKey();
                    ArrayList<IFSMCondition> conditions = new ArrayList<IFSMCondition>(mapTransitions.size());
                    ArrayList<GoToInfo> markers = new ArrayList<GoToInfo>(mapTransitions.size());
                    String nextStateVarName = null;
                    String stateVarName = null;
                    for (IFSMTransition duplicate : duplicates) {
                        conditions.addAll(((FSMInput)duplicate.getSourceInput()).getConditions());
                        if (!(duplicate instanceof FSMTransition)) continue;
                        FSMTransition duplicateTransition = (FSMTransition)duplicate;
                        markers.addAll(duplicateTransition.getMarkers());
                        nextStateVarName = duplicateTransition.getNextStateVarName();
                        stateVarName = duplicateTransition.getStateVarName();
                    }
                    boolean removedPrev = FSMFactory.removeTransitions(state, dest);
                    if (!removedPrev) {
                        FSMDebugUtils.debugLevelTwo("Could not remove transitions from '" + state + "' to '" + dest + "'", new Object[0]);
                        continue;
                    }
                    FSMDebugUtils.debugLevelTwo("Removed transitions from '" + state + "' to '" + dest + "'", new Object[0]);
                    FSMTransition newTrans = FSMFactory.createTransition(FSMFactory.createInput(conditions), state, dest, stateVarName, nextStateVarName);
                    if (newTrans != null) {
                        newTrans.setMarkers(markers);
                        FSMDebugUtils.debugLevelTwo("Created new merge transition from '" + state + "' to '" + dest + "' with formulas: " + ((Object)conditions).toString(), new Object[0]);
                        continue;
                    }
                    FSMDebugUtils.debugLevelTwo("Could not create new merge transition from '" + state + "' to '" + dest + "'", new Object[0]);
                }
            }
        }).start();
    }

    public static final void removeLoopBackTransitions(FSMModel model, FSMDiagramConfiguration config, DProgressMonitor monitor) {
        if (model == null || !config.contains(FSMDiagramConfiguration.FSMDiagramConfigurationKey.REMOVE_LOOPBACK_TRANSITIONS)) {
            return;
        }
        FSMExecutors.newBFS().setModel(model, false, (IProgressMonitor)monitor).addVisitor(new FSMVisitors.StateVisitor(){

            @Override
            public void visit(IFSMState state) {
                boolean hasRemoved = FSMFactory.removeTransitions(state, state);
                FSMDebugUtils.debugLevelTwo(hasRemoved, "Removed loopback of state '" + state + "'", new Object[0]);
            }
        }).start();
    }

    public static final void filterConditionsBySignalName(FSMModel model, FSMDiagramConfiguration config, DProgressMonitor monitor) {
        Set<String> filteredSignalNames = config.get(FSMDiagramConfiguration.FSMDiagramConfigurationKey.FILTER_NAMES_IN_CONDITIONS);
        if (model == null || filteredSignalNames == null || filteredSignalNames.isEmpty()) {
            return;
        }
        boolean isVhdl = model.getLanguageKind() == LanguageKind.VHDL;
        FSMExecutors.newBFS().setModel(model, false, (IProgressMonitor)monitor).addVisitor(new FSMFilterNamesVisitor(isVhdl, filteredSignalNames)).start();
    }

    public static void removeDefaultState(FSMModel model, FSMDiagramConfiguration config, DProgressMonitor monitor) throws DCanceledException {
        if (model == null) {
            return;
        }
        monitor.checkCanceled();
        if (!config.contains(FSMDiagramConfiguration.FSMDiagramConfigurationKey.SHOW_DEFAULT_STATE)) {
            Iterator<IFSMState> iter = model.getStates().iterator();
            while (iter.hasNext()) {
                IFSMState state = iter.next();
                if (!state.isDefault()) continue;
                iter.remove();
            }
        }
    }

    public static void setAndShowTransitionIndexes(FSMModel model, final FSMDiagramConfiguration config) {
        final int[] transitionIndex = new int[]{1};
        final FSMDiagramAdapter localAdapter = new FSMDiagramAdapter(config);
        FSMExecutors.newBFS().setModel(model, true, (IProgressMonitor)new NullProgressMonitor()).addVisitor(new FSMVisitors.TransitionVisitor(){

            @Override
            public void visit(IFSMTransition transitionRaw) {
                if (!(transitionRaw instanceof FSMTransition)) {
                    return;
                }
                FSMTransition transition = (FSMTransition)transitionRaw;
                if (transition.getSource() == FSMState.VOID) {
                    return;
                }
                int n = transitionIndex[0];
                transitionIndex[0] = n + 1;
                transition.setIndex(n);
                KEdge edge = transition.getEdge();
                if (edge == null) {
                    return;
                }
                if (TransitionLabelType.INDEX == config.get(FSMDiagramConfiguration.FSMDiagramConfigurationKey.SHOW_TRANSITION_LABELS)) {
                    EList labels = edge.getLabels();
                    if (labels != null && !labels.isEmpty()) {
                        labels.clear();
                    }
                    localAdapter.setKLabel(transition, String.valueOf(transition.getIndex()), (KLabeledGraphElement)edge);
                }
            }
        }).start();
    }

    public static final void filterCommonCondition(FSMModel model, FSMDiagramConfiguration config, DProgressMonitor monitor) {
        if (model == null || !config.contains(FSMDiagramConfiguration.FSMDiagramConfigurationKey.FILTER_COMMON_EXPRESSIONS_IN_CONDITIONS)) {
            return;
        }
        Set<String> commonExpressions = FSMDiagramProcessors.computeCommonExpressions(model, monitor);
        if (commonExpressions.isEmpty()) {
            return;
        }
        FSMExecutors.newBFS().setModel(model, false, (IProgressMonitor)monitor).addVisitor(new FSMFilterCommonExpressionsVisitor(commonExpressions)).start();
    }

    public static final Set<String> computeCommonExpressions(FSMModel model, DProgressMonitor monitor) {
        final HashSet<String> expressions = new HashSet<String>();
        final AtomicBoolean expressionsCollected = new AtomicBoolean(false);
        FSMExecutors.newBFS().setModel(model, false, (IProgressMonitor)monitor).addVisitor(new FSMVisitors.TransitionVisitor(){

            @Override
            public void visit(IFSMTransition transition) {
                if (FSMUtils.isStartTransition(transition)) {
                    return;
                }
                if (expressionsCollected.get() && expressions.isEmpty()) {
                    return;
                }
                IFSMInput sourceInput = transition.getSourceInput();
                if (!(sourceInput instanceof FSMInput)) {
                    return;
                }
                List<IFSMCondition> conditions = ((FSMInput)sourceInput).getConditions();
                HashSet commonExpressions = new HashSet();
                for (IFSMCondition condition : conditions) {
                    if (!(condition instanceof FSMCondition)) continue;
                    List<LFFormula> commonFormulas = LFUtils.flattenFormula(((FSMCondition)condition).getFormula(), formula -> {
                        if (LFUtils.isEmptyFormula(formula)) {
                            return false;
                        }
                        if (!expressionsCollected.get()) {
                            return true;
                        }
                        return expressions.contains(formula.toString());
                    });
                    commonExpressions.addAll(commonFormulas.stream().map(formula -> formula.toString()).collect(Collectors.toList()));
                }
                if (expressionsCollected.get()) {
                    expressions.removeIf(formula -> !commonExpressions.contains(formula));
                    return;
                }
                expressionsCollected.set(true);
                expressions.addAll(commonExpressions);
            }
        }).start();
        return expressions;
    }
}

