/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.klay;

import de.cau.cs.kieler.core.kgraph.KGraphPackage;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.kiml.klayoutdata.KLayoutDataPackage;
import de.cau.cs.kieler.kiml.util.KimlUtil;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import ro.amiq.dvt.diagrams.DDiagram;
import ro.amiq.dvt.draw.DExporter;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.wizards.specador.SpecadorSVGDiagramFactory;

public final class KLayDiagramDebug {
    public static final String DIAGRAMS_DIRECTORY = "/dvt_diagrams/";
    public static final String EL_DIAGRAMS_DIRECTORY = "/dvt_elaboration_diagrams/";
    public static final String DIAGRAMS_REFERENCE_DIRECTORY = "/dvt_diagrams_reference/";
    public static final String EL_DIAGRAMS_REFERENCE_DIRECTORY = "/dvt_elaboration_diagrams_reference/";
    public static final String DIAGRAMS_REFERENCE_DIRECTORY_JAVA_24 = "/dvt_diagrams_reference_java_24/";
    public static final String EL_DIAGRAMS_REFERENCE_DIRECTORY_24 = "/dvt_elaboration_diagrams_reference_java_24/";
    public static final String DIAGRAMS_REFERENCE_LOCATION_GUI = "dvt_diagrams_reference_gui/";
    private static final Pattern regexHomeProjects = Pattern.compile("/home/.*/projects/");
    private static final Pattern regexHomeGit = Pattern.compile("/home/.*/git/");
    private static final Pattern regexTmp = Pattern.compile("/tmp/.*/projects/");
    public static final EnumSet<DiagramDebugTag> ACCEPTED_TAGS = EnumSet.of(DiagramDebugTag.ERROR);
    public static final EnumSet<DebugRegion> ACCEPTED_REGIONS = EnumSet.of(DebugRegion.NL_MODEL_CONSTRUCTION, new DebugRegion[]{DebugRegion.FLOW_DIAGRAM_CONSTRUCTION, DebugRegion.TRACE_DIAGRAM_CONSTRUCTION, DebugRegion.NL_DIAGRAM_IMPORT, DebugRegion.NL_DIAGRAM_ADAPT, DebugRegion.LAYOUT_ENGINE, DebugRegion.STYLE_SET_UP, DebugRegion.NL_DIAGRAM_ACTION});

    private KLayDiagramDebug() {
    }

    public static final String getDiagramFilePath(String elementName, String directoryName, String prefixText, String diagramKind, String fileExtension) {
        new File(directoryName).mkdirs();
        StringBuilder filePath = new StringBuilder(directoryName);
        if (prefixText != null) {
            filePath.append(prefixText).append('_');
        }
        if (diagramKind != null) {
            filePath.append(diagramKind.toLowerCase()).append('_');
        }
        filePath.append(elementName).append(fileExtension);
        return filePath.toString();
    }

    public static final void saveToKgx(String filePath, KNode graph) {
        BufferedWriter kLayWriter;
        block8: {
            kLayWriter = null;
            if (graph != null) break block8;
            DVTUtilsCommon.INSTANCE.closeClosable(kLayWriter);
            return;
        }
        try {
            try {
                if (filePath != null) {
                    kLayWriter = new BufferedWriter(new FileWriter(filePath));
                }
                String diagramString = KLayDiagramDebug.serialize(graph);
                Matcher matcherHomeProjects = regexHomeProjects.matcher(diagramString);
                diagramString = matcherHomeProjects.replaceAll("/path/projects/");
                Matcher matcherHomeGit = regexHomeGit.matcher(diagramString);
                diagramString = matcherHomeGit.replaceAll("/path/git/");
                Matcher matcherTmp = regexTmp.matcher(diagramString);
                diagramString = matcherTmp.replaceAll("/path/projects/");
                int length = diagramString.length();
                int i = 0;
                while (i < length) {
                    if (i <= 5000000) {
                        String substring = diagramString.substring(i, Math.min(length, i += 1000));
                        if (kLayWriter == null) continue;
                        kLayWriter.write(substring);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception ex) {
                DVTLogger.INSTANCE.logError((Throwable)ex);
                DVTUtilsCommon.INSTANCE.closeClosable(kLayWriter);
            }
        }
        catch (Throwable throwable) {
            DVTUtilsCommon.INSTANCE.closeClosable(kLayWriter);
            throw throwable;
        }
        DVTUtilsCommon.INSTANCE.closeClosable(kLayWriter);
    }

    private static final String serialize(KNode graph) {
        if (graph == null) {
            return "";
        }
        KimlUtil.persistDataElements((KNode)graph);
        ByteArrayOutputStream target = new ByteArrayOutputStream();
        try {
            KLayDiagramDebug.serializeBinary(graph, target, Collections.emptyMap());
            String string = target.toString();
            return string;
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        finally {
            DVTUtilsCommon.INSTANCE.closeClosable(target);
        }
        return "";
    }

    private static final void serializeBinary(KNode graph, OutputStream target, Map<Object, Object> options) throws IOException {
        EcoreUtil.resolveAll((EObject)graph);
        URI uri = URI.createURI((String)"temp.kgx");
        ResourceSet resourceSet = KLayDiagramDebug.createResourceSet();
        Resource resource = resourceSet.createResource(uri);
        resource.getContents().add((Object)graph);
        resource.save(target, options == null ? Collections.emptyMap() : options);
    }

    private static final ResourceSet createResourceSet() {
        EPackage.Registry registry;
        Map extensionMap = Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap();
        if (!extensionMap.containsKey("kgx")) {
            extensionMap.put("kgx", new XMIResourceFactoryImpl());
        }
        if (!(registry = EPackage.Registry.INSTANCE).containsKey((Object)"http://kieler.cs.cau.de/KGraph")) {
            registry.put((Object)"http://kieler.cs.cau.de/KGraph", (Object)KGraphPackage.eINSTANCE);
        }
        if (!registry.containsKey((Object)"http://kieler.cs.cau.de/KLayoutData")) {
            registry.put((Object)"http://kieler.cs.cau.de/KLayoutData", (Object)KLayoutDataPackage.eINSTANCE);
        }
        return new ResourceSetImpl();
    }

    public static final void saveToSVG(DDiagram diagram, String diagramKind, String prefix, String elementName, String directoryName) {
        if (diagram == null || diagramKind == null || elementName == null) {
            return;
        }
        String filePath = KLayDiagramDebug.getDiagramFilePath(elementName, directoryName, prefix, diagramKind, ".svg");
        if (filePath == null) {
            return;
        }
        try {
            SpecadorSVGDiagramFactory.testExportDiagramToFile(filePath, diagram, filePath, DExporter.SVG);
        }
        catch (IOException iOException) {}
    }

    public static final void saveToKgx(DDiagram diagram, String diagramKind, String prefix, String elementName, String directoryName) {
        if (diagram == null || diagramKind == null || elementName == null) {
            return;
        }
        String filePath = KLayDiagramDebug.getDiagramFilePath(elementName, directoryName, prefix, diagramKind, ".kgx");
        if (filePath == null) {
            return;
        }
        try {
            SpecadorSVGDiagramFactory.testExportDiagramToFile(filePath, diagram, filePath, DExporter.KGX);
        }
        catch (IOException iOException) {}
    }

    public static final boolean isDebugMode() {
        return DVTLogger.INSTANCE.isDebugMode();
    }

    public static final void debugInfo(DebugRegion debugRegion, String message, Object ... objects) {
        KLayDiagramDebug.debug(DiagramDebugTag.INFO, debugRegion, message, objects);
    }

    public static final void debugError(DebugRegion debugRegion, String message, Object ... objects) {
        KLayDiagramDebug.debug(DiagramDebugTag.ERROR, debugRegion, message, objects);
    }

    private static final void debug(DiagramDebugTag tag, DebugRegion region, String firstMessage, Object ... objects) {
        if (!(KLayDiagramDebug.isDebugMode() && ACCEPTED_TAGS.contains((Object)tag) && ACCEPTED_REGIONS.contains((Object)region))) {
            return;
        }
        firstMessage = firstMessage != null ? firstMessage : "";
        boolean addStartingNewLine = firstMessage.startsWith("\n") || firstMessage.startsWith("\r");
        StringBuilder result = new StringBuilder(addStartingNewLine ? "\n" : "").append(tag.toString()).append((Object)region).append(" : ").append(firstMessage.replaceAll("\\r?\\n|\\r", " ").trim());
        if (objects == null || objects.length == 0) {
            DVTLogger.INSTANCE.logError(result.toString());
            return;
        }
        result.append(" ... ");
        StringBuilder resultObjects = new StringBuilder();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            resultObjects.append(object).append(" ");
            ++n2;
        }
        DVTLogger.INSTANCE.logError(result.append(resultObjects.toString().replaceAll("\\r?\\n|\\r", " ")).toString());
    }

    public static enum DebugRegion {
        NL_MODEL_CONSTRUCTION,
        FLOW_DIAGRAM_CONSTRUCTION,
        TRACE_DIAGRAM_CONSTRUCTION,
        NL_DIAGRAM_IMPORT,
        NL_DIAGRAM_ADAPT,
        LAYOUT_ENGINE,
        STYLE_SET_UP,
        NL_DIAGRAM_ACTION;

    }

    private static enum DiagramDebugTag {
        INFO(""),
        ERROR("!!! ");

        private String text;

        private DiagramDebugTag(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }
}

