/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.klay;

import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.kiml.IGraphLayoutEngine;
import de.cau.cs.kieler.kiml.LayoutMetaDataService;
import de.cau.cs.kieler.kiml.RecursiveGraphLayoutEngine;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.service.util.ProgressMonitorAdapter;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.diagrams.klay.KLayDiagramDebug;

public enum KLayDiagramLayout {
    INSTANCE;

    private final IGraphLayoutEngine KLAY_LAYOUT_ENGINE = new RecursiveGraphLayoutEngine();

    public void layout(KNode graph, int seed, IProgressMonitor monitor) {
        if (graph == null) {
            return;
        }
        try {
            ProgressMonitorAdapter progressMonitor = new ProgressMonitorAdapter(monitor);
            this.setSeed(graph, seed);
            this.KLAY_LAYOUT_ENGINE.layout(graph, (IKielerProgressMonitor)progressMonitor);
            KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.LAYOUT_ENGINE, "Total layout time ", progressMonitor.getExecutionTime(), "s");
        }
        catch (Throwable throwable) {
            LayoutMetaDataService.getInstance().getAlgorithmData().stream().forEach(algorithmData -> algorithmData.getInstancePool().clear());
            throw throwable;
        }
        LayoutMetaDataService.getInstance().getAlgorithmData().stream().forEach(algorithmData -> algorithmData.getInstancePool().clear());
    }

    private void setSeed(KNode graph, Integer seed) {
        if (graph == null) {
            return;
        }
        ((KShapeLayout)graph.getData(KShapeLayout.class)).setProperty(Properties.RANDOM_SEED, (Object)seed);
        for (KNode child : graph.getChildren()) {
            this.setSeed(child, seed);
        }
    }
}

