/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.klay.utils;

import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KGraphElement;
import de.cau.cs.kieler.core.kgraph.KLabel;
import de.cau.cs.kieler.core.kgraph.KLabeledGraphElement;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.kgraph.KPort;
import de.cau.cs.kieler.core.krendering.KBackground;
import de.cau.cs.kieler.core.krendering.KColor;
import de.cau.cs.kieler.core.krendering.KColoring;
import de.cau.cs.kieler.core.krendering.KFontBold;
import de.cau.cs.kieler.core.krendering.KFontItalic;
import de.cau.cs.kieler.core.krendering.KFontName;
import de.cau.cs.kieler.core.krendering.KFontSize;
import de.cau.cs.kieler.core.krendering.KForeground;
import de.cau.cs.kieler.core.krendering.KLineStyle;
import de.cau.cs.kieler.core.krendering.KLineWidth;
import de.cau.cs.kieler.core.krendering.KRectangle;
import de.cau.cs.kieler.core.krendering.KRendering;
import de.cau.cs.kieler.core.krendering.KRoundedRectangle;
import de.cau.cs.kieler.core.krendering.KStyle;
import de.cau.cs.kieler.core.krendering.KText;
import de.cau.cs.kieler.core.krendering.LineStyle;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.math.KVectorChain;
import de.cau.cs.kieler.kiml.klayoutdata.KEdgeLayout;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.options.EdgeType;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortSide;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import ro.amiq.dvt.diagrams.klay.rendering.styles.KSelectionBackground;
import ro.amiq.dvt.diagrams.klay.rendering.styles.KSelectionForeground;
import ro.amiq.dvt.diagrams.klay.rendering.styles.KSelectionLineWidth;
import ro.amiq.dvt.diagrams.klay.utils.KLayDrawUtils;
import ro.amiq.dvt.diagrams.netlist.model.NLAbstractBase;
import ro.amiq.dvt.diagrams.netlist.model.NLConnection;
import ro.amiq.dvt.diagrams.netlist.model.NLGate;
import ro.amiq.dvt.diagrams.netlist.model.NLGateKind;
import ro.amiq.dvt.diagrams.netlist.model.NLLogicStatement;
import ro.amiq.dvt.diagrams.netlist.model.NLPDSwitchGate;
import ro.amiq.dvt.diagrams.netlist.model.NLPort;
import ro.amiq.dvt.diagrams.netlist.model.NLPortGate;
import ro.amiq.dvt.diagrams.netlist.utils.NLUtils;
import ro.amiq.dvt.draw.obj.design.DDesignObject;
import ro.amiq.dvt.draw.obj.design.DDesignScene;
import ro.amiq.dvt.draw.obj.design.DEdge;
import ro.amiq.dvt.draw.obj.design.DLabel;
import ro.amiq.dvt.draw.obj.design.DModule;
import ro.amiq.dvt.draw.obj.design.DPort;
import ro.amiq.dvt.draw.obj.utils.DProperties;
import ro.amiq.dvt.draw.obj.utils.RGBV;
import ro.amiq.dvt.draw.utils.ColorFactory;
import ro.amiq.dvt.draw.utils.FRectangle;
import ro.amiq.dvt.draw.utils.FontFactory;
import ro.amiq.dvt.ui.trace.connections.model.TCStatement;

public class KLayDrawConverter {
    private static final DProperties.Key<FRectangle> FLOAT_LAYOUT = new DProperties.Key("KLayDrawConverter.FLOAT_LAYOUT");
    private static final DProperties.Key<List<DDesignObject>> CHILDREN = new DProperties.Key("KLayDrawConverter.CHILDREN");
    private final KNode kRoot;
    private Map<KGraphElement, DDesignObject> kdMap;

    private KLayDrawConverter(KNode kRoot) {
        this.kRoot = kRoot;
    }

    public static KLayDrawConverter use(KNode root) {
        return new KLayDrawConverter(root);
    }

    public DDesignScene createScene() {
        this.kdMap = new HashMap<KGraphElement, DDesignObject>();
        EList kChildren = this.kRoot.getChildren();
        this.convertKNodes((List<KNode>)kChildren, true);
        this.adjustDEdges();
        ArrayList<DDesignObject> dChildren = new ArrayList<DDesignObject>();
        for (KNode kChild : kChildren) {
            dChildren.add(this.kdMap.get(kChild));
        }
        this.createDDesignObjects(dChildren);
        KShapeLayout kLayout = (KShapeLayout)this.kRoot.getData(KShapeLayout.class);
        Rectangle bounds = new Rectangle(0, 0, Math.round(kLayout.getWidth()), Math.round(kLayout.getHeight()));
        return new DDesignScene(bounds, dChildren, this.kdMap, this.kRoot);
    }

    private void createDDesignObjects(List<DDesignObject> dDesignObjects) {
        for (DDesignObject dDesignObject : dDesignObjects) {
            dDesignObject.create();
            List<DDesignObject> dChildren = dDesignObject.getProperty(CHILDREN);
            dDesignObject.removeProperty(CHILDREN);
            dDesignObject.removeProperty(FLOAT_LAYOUT);
            if (dChildren == null) continue;
            dChildren.sort(DDesignObject.COMPARATOR);
            dDesignObject.addChildren(dChildren);
            this.createDDesignObjects(dChildren);
        }
    }

    private void convertKNodes(List<KNode> kNodes, boolean isFirst) {
        for (KNode kNode : kNodes) {
            Optional<DDesignObject> pdLabel;
            NLAbstractBase nlObject = KLayDrawUtils.getNLObject((KGraphElement)kNode);
            boolean isSelectable = !NLUtils.isInternalLogicGate(nlObject) && !NLUtils.isPDTopInstance(nlObject) && !NLUtils.isImplicitGate(nlObject);
            DModule dModule = this.registerDDesignObject(DModule.newInstance(isSelectable, isFirst), (KGraphElement)kNode, (KGraphElement)kNode.getParent());
            this.setLayoutProperties((KGraphElement)kNode, (KGraphElement)kNode.getParent(), dModule);
            this.setRenderingProperties((KGraphElement)kNode, dModule);
            this.convertKNodes((List<KNode>)kNode.getChildren(), false);
            this.convertKLabels((List<KLabel>)kNode.getLabels(), null);
            this.convertKEdges((List<KEdge>)kNode.getOutgoingEdges());
            this.convertKPorts((List<KPort>)kNode.getPorts());
            List<DDesignObject> children = dModule.getProperty(CHILDREN);
            if (children == null || !(pdLabel = children.stream().filter(child -> {
                if (child instanceof DLabel) {
                    String text = child.getProperty(DLabel.TEXT);
                    return text == null ? false : text.trim().startsWith("Ground: ");
                }
                return false;
            }).findAny()).isPresent() || pdLabel.get().getProperty(DDesignObject.FILL_COLOR) == null) continue;
            Rectangle layout = pdLabel.get().getProperty(DDesignObject.LAYOUT);
            dModule.setProperty(DModule.PD_LINE_Y, layout.y + layout.height);
            dModule.setProperty(DModule.PD_FILL_COLOR, pdLabel.get().getProperty(DDesignObject.FILL_COLOR));
        }
    }

    private void convertKPorts(List<KPort> kPorts) {
        for (KPort kPort : kPorts) {
            NLAbstractBase nlObject = KLayDrawUtils.getNLObject((KGraphElement)kPort);
            DPort dPort = this.registerDDesignObject(new DPort(NLUtils.isInternalLogicGatePort(nlObject)), (KGraphElement)kPort, (KGraphElement)kPort.getNode());
            this.setLayoutProperties((KGraphElement)kPort, (KGraphElement)kPort.getNode(), dPort);
            this.setRenderingProperties((KGraphElement)kPort, dPort);
            this.setPortDirection(kPort, dPort);
            this.convertKLabels((List<KLabel>)kPort.getLabels(), dPort);
        }
    }

    private void setPortDirection(KPort kPort, DPort dPort) {
        DPort.Type dPortType = DPort.Type.NONE;
        KShapeLayout kLayout = (KShapeLayout)kPort.getData(KShapeLayout.class);
        if (kLayout != null) {
            NLPort.NLPortDirection nlPortDirection = null;
            NLAbstractBase origin = KLayDrawUtils.getNLObject((KGraphElement)kPort);
            if (origin instanceof NLPort && !(origin.getEnclosingGate() instanceof NLPortGate)) {
                NLConnection.NLConnectionKind portKind = ((NLPort)origin).getKind();
                if (((NLPort)origin).isUnknownDesignPort()) {
                    dPortType = DPort.Type.CROSS;
                } else if (portKind == NLConnection.NLConnectionKind.COMMON_SIGNAL || portKind == NLConnection.NLConnectionKind.COMMON_EDGE) {
                    nlPortDirection = ((NLPort)origin).getDirection();
                    if (nlPortDirection == NLPort.NLPortDirection.DIR_INOUT) {
                        dPortType = DPort.Type.DIAMOND;
                    } else if (nlPortDirection == NLPort.NLPortDirection.DIR_IN || nlPortDirection == NLPort.NLPortDirection.DIR_OUT) {
                        PortSide portSide = (PortSide)kLayout.getProperty(LayoutOptions.PORT_SIDE);
                        if (nlPortDirection == NLPort.NLPortDirection.DIR_IN) {
                            portSide = portSide.opposed();
                        }
                        if (((NLPort)origin).isPortInBidirectionalConnection() && nlPortDirection == NLPort.NLPortDirection.DIR_OUT) {
                            portSide = portSide.opposed();
                        }
                        switch (portSide) {
                            case EAST: {
                                dPortType = DPort.Type.EAST;
                                break;
                            }
                            case WEST: {
                                dPortType = DPort.Type.WEST;
                                break;
                            }
                            case NORTH: {
                                dPortType = DPort.Type.NORTH;
                                break;
                            }
                            case SOUTH: {
                                dPortType = DPort.Type.SOUTH;
                                break;
                            }
                            default: {
                                dPortType = DPort.Type.NONE;
                                break;
                            }
                        }
                    }
                } else if (portKind == NLConnection.NLConnectionKind.BUNDLE_SIGNAL) {
                    dPortType = DPort.Type.BAR;
                }
            }
        }
        dPort.setProperty(DPort.TYPE, dPortType);
    }

    private void convertKEdges(List<KEdge> kEdges) {
        for (KEdge kEdge : kEdges) {
            NLAbstractBase nlObject = KLayDrawUtils.getNLObject((KGraphElement)kEdge);
            KNode kContainerParent = this.findEdgeContainerParent(kEdge.getSource(), kEdge.getTarget());
            DEdge dEdge = this.registerDDesignObject(NLUtils.isInternalLogicGateConnection(nlObject) ? new DEdge() : new DEdge.DSelectableEdge(), (KGraphElement)kEdge, (KGraphElement)kContainerParent);
            this.setRenderingProperties((KGraphElement)kEdge, dEdge);
            KNode kLayoutParent = this.findEdgeLayoutParent(kEdge.getSource(), kEdge.getTarget());
            DDesignObject dLayoutParent = this.kdMap.get(kLayoutParent);
            FRectangle floatLayout = dLayoutParent.getProperty(FLOAT_LAYOUT);
            this.setEdgeArrowRendering(kEdge, dEdge);
            KEdgeLayout kEdgeLayout = (KEdgeLayout)kEdge.getData(KEdgeLayout.class);
            ArrayList<Point> dBendingPoints = new ArrayList<Point>();
            KVectorChain kEdgePoints = kEdgeLayout.createVectorChain();
            for (KVector kPoint : kEdgePoints) {
                dBendingPoints.add(floatLayout.relativeRound((float)kPoint.x, (float)kPoint.y));
            }
            dEdge.setProperty(DEdge.BENDING_POINTS, dBendingPoints);
            ArrayList<Point> dJunctionPoints = new ArrayList<Point>();
            KVectorChain kJunctionPoints = (KVectorChain)kEdgeLayout.getProperty(LayoutOptions.JUNCTION_POINTS);
            for (KVector kPoint : kJunctionPoints) {
                dJunctionPoints.add(floatLayout.relativeRound((float)kPoint.x, (float)kPoint.y));
            }
            dEdge.setProperty(DEdge.JUNCTION_POINTS, dJunctionPoints);
            this.convertKLabels(kEdge, dEdge, kLayoutParent);
        }
    }

    private void setEdgeArrowRendering(KEdge kEdge, DDesignObject dDesignObject) {
        KEdgeLayout kEdgeLayout = (KEdgeLayout)kEdge.getData(KEdgeLayout.class);
        DEdge.Type dEdgeType = DEdge.Type.NONE;
        switch ((EdgeType)kEdgeLayout.getProperty(LayoutOptions.EDGE_TYPE)) {
            case DIRECTED: {
                dEdgeType = DEdge.Type.DIRECTED;
                dDesignObject.setProperty(DEdge.TARGET_ARROW_SIZE, Math.round(((KShapeLayout)kEdge.getTargetPort().getData(KShapeLayout.class)).getWidth()));
                break;
            }
            case UNDIRECTED: {
                dEdgeType = DEdge.Type.UNDIRECTED;
                dDesignObject.setProperty(DEdge.SOURCE_ARROW_SIZE, Math.round(((KShapeLayout)kEdge.getSourcePort().getData(KShapeLayout.class)).getWidth()));
                dDesignObject.setProperty(DEdge.TARGET_ARROW_SIZE, Math.round(((KShapeLayout)kEdge.getTargetPort().getData(KShapeLayout.class)).getWidth()));
                break;
            }
            default: {
                dEdgeType = DEdge.Type.NONE;
            }
        }
        dDesignObject.setProperty(DEdge.TYPE, dEdgeType);
    }

    private KNode findEdgeContainerParent(KNode kNode1, KNode kNode2) {
        if (kNode1 == null || kNode2 == null) {
            return null;
        }
        if (kNode1.equals(kNode2)) {
            return kNode1;
        }
        HashSet<KNode> parents = new HashSet<KNode>();
        do {
            parents.add(kNode1);
        } while ((kNode1 = kNode1.getParent()) != null);
        do {
            if (!parents.contains(kNode2)) continue;
            return kNode2;
        } while ((kNode2 = kNode2.getParent()) != null);
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private KNode findEdgeLayoutParent(KNode kNode1, KNode kNode2) {
        if (kNode1 == null || kNode2 == null) {
            return null;
        }
        if (!kNode1.equals(kNode2)) ** GOTO lbl7
        return kNode1.getParent();
lbl-1000:
        // 1 sources

        {
            if (!kNode1.equals(kNode2)) continue;
            return kNode1;
lbl7:
            // 2 sources

            ** while ((kNode2 = kNode2.getParent()) != null)
        }
lbl8:
        // 1 sources

        return kNode1.getParent();
    }

    private void convertKLabels(KEdge kEdge, DEdge dEdge, KNode kLayoutParent) {
        if (kEdge == null || dEdge == null || kLayoutParent == null) {
            return;
        }
        EList labels = kEdge.getLabels();
        if (labels == null) {
            return;
        }
        for (KLabel kLabel : labels) {
            DLabel.DSelectableLabel dSelectableLabel = new DLabel.DSelectableLabel(dEdge);
            dSelectableLabel = this.registerDDesignObject(dSelectableLabel, (KGraphElement)kLabel, (KGraphElement)kLayoutParent);
            this.setLayoutProperties((KGraphElement)kLabel, (KGraphElement)kLayoutParent, dSelectableLabel);
            dSelectableLabel.setProperty(DLabel.TYPE, DLabel.Type.TEXT);
            this.setTextProperties(kLabel, dSelectableLabel);
            dSelectableLabel.setProperty(DLabel.TEXT, kLabel.getText());
            dSelectableLabel.setProperty(DLabel.SELECTED_LINE_COLOR, (RGBV)dEdge.getProperty(DPort.SELECTED_LINE_COLOR));
            DDesignObject connectedDesignObject = dSelectableLabel.getConnectedDesignObject();
            if (!(connectedDesignObject instanceof DEdge.DSelectableEdge)) continue;
            ((DEdge.DSelectableEdge)connectedDesignObject).addLabel(dSelectableLabel);
        }
    }

    private void convertKLabels(List<KLabel> kLables, DPort port) {
        for (KLabel kLabel : kLables) {
            KLabeledGraphElement kParent = kLabel.getParent();
            String label = kLabel.getText().trim();
            DLabel dLabel = port != null && !port.isInnerGatePort() && !label.startsWith("(") && !label.endsWith(")") ? (DLabel)this.registerDDesignObject(new DLabel.DSelectableLabel(port), (KGraphElement)kLabel, (KGraphElement)kParent) : this.registerDDesignObject(new DLabel(), (KGraphElement)kLabel, (KGraphElement)kParent);
            this.setLayoutProperties((KGraphElement)kLabel, (KGraphElement)kLabel.getParent(), dLabel);
            NLAbstractBase origin = KLayDrawUtils.getNLObject((KGraphElement)kParent);
            if (origin instanceof NLGate && ((NLGate)origin).getKind() == NLGateKind.LOGIC) {
                NLLogicStatement logicStatement = ((NLGate)origin).getMapping(NLLogicStatement.class);
                if (logicStatement == null) continue;
                dLabel.setProperty(DLabel.TYPE, logicStatement.statement.kind == TCStatement.TCStatementKind.SEQUENTIAL_ALWAYS_BLOCK ? DLabel.Type.SEQUENTIAL : DLabel.Type.COMBINATIONAL);
            } else if (origin instanceof NLPDSwitchGate && ((NLPDSwitchGate)origin).getKind() == NLGateKind.POWER_SWITCH && kLabel.getText().trim().equals("PS :")) {
                dLabel.setProperty(DLabel.TYPE, DLabel.Type.POWER_SWITCH);
            } else {
                dLabel.setProperty(DLabel.TYPE, DLabel.Type.TEXT);
                this.setTextProperties(kLabel, dLabel);
                dLabel.setProperty(DLabel.TEXT, kLabel.getText());
            }
            if (port == null) continue;
            dLabel.setProperty(DLabel.SELECTED_LINE_COLOR, (RGBV)port.getProperty(DPort.SELECTED_LINE_COLOR));
        }
    }

    private void setTextProperties(KLabel kLabel, DLabel dLabel) {
        KText kText = (KText)kLabel.getData(KText.class);
        String fontName = null;
        int fontSize = 0;
        int fontStyle = 0;
        EList styles = kText.getStyles();
        for (KStyle kStyle : styles) {
            if (kStyle instanceof KFontName) {
                fontName = ((KFontName)kStyle).getName();
                continue;
            }
            if (kStyle instanceof KFontSize) {
                fontSize = ((KFontSize)kStyle).getSize();
                continue;
            }
            if (kStyle instanceof KFontBold && ((KFontBold)kStyle).isBold()) {
                fontStyle |= 1;
                continue;
            }
            if (kStyle instanceof KFontItalic && ((KFontItalic)kStyle).isItalic()) {
                fontStyle |= 2;
                continue;
            }
            if (kStyle instanceof KForeground) {
                dLabel.setProperty(DDesignObject.LINE_COLOR, this.convertKColoring((KColoring<?>)((KForeground)kStyle)));
                continue;
            }
            if (!(kStyle instanceof KBackground)) continue;
            dLabel.setProperty(DDesignObject.FILL_COLOR, this.convertKColoring((KColoring<?>)((KBackground)kStyle)));
        }
        dLabel.setProperty(DLabel.FONT, FontFactory.getInstance().getFontData(fontName, fontSize, fontStyle));
    }

    private <T extends DDesignObject> T registerDDesignObject(T dDesignObject, KGraphElement kElement, KGraphElement kParent) {
        ((DDesignObject)dDesignObject).setProperty(DDesignObject.KELEMENT, (KGraphElement)kElement);
        this.kdMap.put(kElement, (DDesignObject)dDesignObject);
        DDesignObject dParent = this.kdMap.get(kParent);
        if (dParent != null) {
            List<DDesignObject> children = dParent.getProperty(CHILDREN);
            if (children == null) {
                children = new ArrayList<DDesignObject>();
                dParent.setProperty(CHILDREN, children);
            }
            children.add((DDesignObject)dDesignObject);
        }
        return (T)dDesignObject;
    }

    private void setLayoutProperties(KGraphElement kElement, KGraphElement kParent, DDesignObject dDesignObject) {
        DDesignObject dParent = this.kdMap.get(kParent);
        FRectangle parentLayout = null;
        parentLayout = dParent == null ? new FRectangle(0.0f, 0.0f, 0.0f, 0.0f) : dParent.getProperty(FLOAT_LAYOUT);
        KShapeLayout kLayout = (KShapeLayout)kElement.getData(KShapeLayout.class);
        FRectangle currentLayout = parentLayout.relative(kLayout.getXpos(), kLayout.getYpos(), kLayout.getWidth(), kLayout.getHeight());
        dDesignObject.setProperty(FLOAT_LAYOUT, currentLayout);
        dDesignObject.setProperty(DDesignObject.LAYOUT, currentLayout.round());
    }

    private void setRenderingProperties(KGraphElement kElement, DDesignObject dDesignObject) {
        KRendering kRendering = (KRendering)kElement.getData(KRendering.class);
        if (kRendering instanceof KRectangle) {
            dDesignObject.setProperty(DModule.ROUNDED, false);
        } else if (kRendering instanceof KRoundedRectangle) {
            dDesignObject.setProperty(DModule.ROUNDED, true);
        }
        EList kStyles = kRendering.getStyles();
        for (KStyle kStyle : kStyles) {
            if (kStyle instanceof KSelectionBackground) {
                dDesignObject.setProperty(DDesignObject.SELECTED_FILL_COLOR, this.convertKColoring((KSelectionBackground)kStyle));
                continue;
            }
            if (kStyle instanceof KBackground) {
                dDesignObject.setProperty(DDesignObject.FILL_COLOR, this.convertKColoring((KColoring<?>)((KBackground)kStyle)));
                continue;
            }
            if (kStyle instanceof KSelectionForeground) {
                dDesignObject.setProperty(DDesignObject.SELECTED_LINE_COLOR, this.convertKColoring((KSelectionForeground)kStyle));
                continue;
            }
            if (kStyle instanceof KForeground) {
                dDesignObject.setProperty(DDesignObject.LINE_COLOR, this.convertKColoring((KColoring<?>)((KForeground)kStyle)));
                continue;
            }
            if (kStyle instanceof KSelectionLineWidth) {
                dDesignObject.setProperty(DDesignObject.SELECTED_LINE_WIDTH, Math.round(((KSelectionLineWidth)kStyle).getLineWidth()));
                continue;
            }
            if (kStyle instanceof KLineWidth) {
                dDesignObject.setProperty(DDesignObject.LINE_WIDTH, Math.round(((KLineWidth)kStyle).getLineWidth()));
                continue;
            }
            if (!(kStyle instanceof KLineStyle)) continue;
            dDesignObject.setProperty(DDesignObject.LINE_STYLE, this.convertKLineStyle(((KLineStyle)kStyle).getLineStyle()));
        }
    }

    private RGBV convertKColoring(KColoring<?> coloring) {
        KColor color = coloring.getColor();
        return ColorFactory.getInstance().getRGBV(color.getRed(), color.getGreen(), color.getBlue(), coloring.getAlpha() > 0);
    }

    private int convertKLineStyle(LineStyle style) {
        if (style == LineStyle.SOLID) {
            return 1;
        }
        if (style == LineStyle.DASH) {
            return 2;
        }
        if (style == LineStyle.DASHDOT) {
            return 4;
        }
        if (style == LineStyle.DASHDOTDOT) {
            return 5;
        }
        if (style == LineStyle.DOT) {
            return 3;
        }
        return 1;
    }

    private void adjustDEdges() {
        for (Map.Entry<KGraphElement, DDesignObject> entry : this.kdMap.entrySet()) {
            DDesignObject target;
            if (!(entry.getKey() instanceof KEdge)) continue;
            KEdge kEdge = (KEdge)entry.getKey();
            List<Point> dBendingPoints = entry.getValue().getProperty(DEdge.BENDING_POINTS);
            DEdge.Type type = entry.getValue().getProperty(DEdge.TYPE);
            DDesignObject source = this.kdMap.get(kEdge.getSourcePort());
            if (source != null) {
                this.trimEdgeEnd(dBendingPoints.get(0), dBendingPoints.get(1), source.getProperty(DDesignObject.LAYOUT), type == DEdge.Type.UNDIRECTED);
            }
            if ((target = this.kdMap.get(kEdge.getTargetPort())) == null) continue;
            this.trimEdgeEnd(dBendingPoints.get(dBendingPoints.size() - 1), dBendingPoints.get(dBendingPoints.size() - 2), target.getProperty(DDesignObject.LAYOUT), type == DEdge.Type.DIRECTED || type == DEdge.Type.UNDIRECTED);
        }
    }

    private void trimEdgeEnd(Point edgeP1, Point edgeP2, Rectangle portLayout, boolean hasArrow) {
        if (edgeP1.x >= portLayout.x && edgeP1.x <= portLayout.x + portLayout.width) {
            edgeP1.x = edgeP2.x > edgeP1.x ? portLayout.x + portLayout.width + 1 + (hasArrow ? 3 : 0) : portLayout.x - 1 - (hasArrow ? 3 : 0);
        }
    }
}

