/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.klay.utils;

import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KGraphElement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import ro.amiq.dvt.diagrams.klay.model.KLayWrapper;
import ro.amiq.dvt.diagrams.netlist.model.INLViewSelectable;
import ro.amiq.dvt.diagrams.netlist.model.INLViewSelectable2;
import ro.amiq.dvt.diagrams.netlist.model.INLViewSelectable3;
import ro.amiq.dvt.diagrams.netlist.model.NLAbstractBase;
import ro.amiq.dvt.diagrams.netlist.model.NLConnection;
import ro.amiq.dvt.diagrams.netlist.model.NLParameters;
import ro.amiq.dvt.diagrams.netlist.utils.NLUtils;
import ro.amiq.dvt.draw.obj.base.DObject;
import ro.amiq.dvt.draw.obj.design.DDesignObject;
import ro.amiq.dvt.draw.obj.design.DDesignScene;
import ro.amiq.dvt.draw.obj.design.DEdge;
import ro.amiq.dvt.draw.obj.design.DLabel;
import ro.amiq.dvt.draw.obj.design.DPort;
import ro.amiq.dvt.draw.obj.interaction.DSelectable;
import ro.amiq.dvt.model.reflection.GoToInfo;

public interface KLayDrawUtils {
    public static Set<DSelectable> getEdgeConnections(DDesignScene dScene, DEdge.DSelectableEdge dEdge) {
        NLAbstractBase nlObject;
        HashSet<DSelectable> result = new HashSet<DSelectable>();
        result.add(dEdge);
        if (dEdge.getLabels() != null) {
            for (DLabel.DSelectableLabel label : dEdge.getLabels()) {
                result.add(label);
            }
        }
        if (!((nlObject = KLayDrawUtils.getNLObject(dEdge)) instanceof NLConnection)) {
            return result;
        }
        Collection<KEdge> kRenderedEdges = ((NLConnection)nlObject).getCachedKEdges();
        for (KEdge kRenderedEdge : kRenderedEdges) {
            result.add((DSelectable)((Object)dScene.getDDesignObject((KGraphElement)kRenderedEdge)));
        }
        return result;
    }

    public static DSelectable getParent(DDesignScene dScene, DDesignObject dEdge) {
        if (dScene == null || dEdge == null) {
            return null;
        }
        KGraphElement kElement = dScene.getKElement(dEdge);
        if (kElement == null) {
            return null;
        }
        EObject eContainer = kElement.eContainer();
        if (eContainer == null) {
            return null;
        }
        EObject dEdgeParent = eContainer.eContainer();
        if (!(dEdgeParent instanceof KGraphElement)) {
            return null;
        }
        DDesignObject dDesignObject = dScene.getDDesignObject((KGraphElement)dEdgeParent);
        if (!(dDesignObject instanceof DSelectable)) {
            return null;
        }
        return (DSelectable)((Object)dDesignObject);
    }

    public static boolean isChildOfImplicitGate(DDesignObject connectedObject) {
        if (connectedObject == null) {
            return false;
        }
        NLAbstractBase nlObject = KLayDrawUtils.getNLObject(connectedObject);
        if (nlObject == null) {
            return false;
        }
        return NLUtils.isImplicitGate(nlObject.getEnclosingGate());
    }

    public static DObject[] getPreviousActionElements(Object object) {
        if (!(object instanceof DDesignScene)) {
            return null;
        }
        List<DObject> children = ((DDesignScene)object).getChildren();
        if (children == null || children.isEmpty()) {
            return null;
        }
        DObject root = children.get(0);
        if (!(root instanceof DDesignObject)) {
            return null;
        }
        HashSet<DObject> previousActionElements = new HashSet<DObject>();
        KLayDrawUtils.getPreviousActionElements((DDesignObject)root, previousActionElements);
        return !previousActionElements.isEmpty() ? previousActionElements.toArray(new DObject[previousActionElements.size()]) : null;
    }

    public static void getPreviousActionElements(DDesignObject element, Set<DObject> previousActionElements) {
        List<DObject> children;
        if (!(element instanceof DSelectable) && !(element instanceof DPort)) {
            return;
        }
        if (previousActionElements.contains(element)) {
            return;
        }
        NLAbstractBase nlElement = KLayDrawUtils.getNLObject(element instanceof DLabel.DSelectableLabel ? ((DLabel.DSelectableLabel)element).getConnectedDesignObject() : element);
        if (nlElement == null) {
            return;
        }
        if (nlElement.hasFlag(NLParameters.NLParametersFlag.IS_FOCUSED)) {
            previousActionElements.add(element);
        }
        if ((children = element.getChildren()) == null) {
            return;
        }
        for (DObject child : children) {
            if (!(child instanceof DDesignObject)) continue;
            KLayDrawUtils.getPreviousActionElements((DDesignObject)child, previousActionElements);
        }
    }

    public static NLAbstractBase getNLObject(KGraphElement kElement) {
        if (kElement == null) {
            return null;
        }
        KLayWrapper klayWrapper = (KLayWrapper)kElement.getData(KLayWrapper.class);
        if (klayWrapper == null) {
            return null;
        }
        return klayWrapper.getOrigin(NLAbstractBase.class);
    }

    public static NLAbstractBase getNLObject(DDesignObject designObject) {
        if (designObject == null) {
            return null;
        }
        return KLayDrawUtils.getNLObject(designObject.getProperty(DDesignObject.KELEMENT));
    }

    public static INLViewSelectable getNLViewSelectable(DSelectable sel) {
        return KLayDrawUtils.unwrapNLViewObject(sel, INLViewSelectable.class);
    }

    public static INLViewSelectable2 getNLViewSelectable2(DSelectable sel) {
        return KLayDrawUtils.unwrapNLViewObject(sel, INLViewSelectable2.class);
    }

    public static INLViewSelectable3 getNLViewSelectable3(DSelectable sel) {
        return KLayDrawUtils.unwrapNLViewObject(sel, INLViewSelectable3.class);
    }

    public static Set<GoToInfo> getUniqueGoToInfos(Set<DSelectable> selection) {
        if (selection == null || selection.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<GoToInfo> goTos = new LinkedHashSet<GoToInfo>();
        for (DSelectable sel : selection) {
            INLViewSelectable selectable = KLayDrawUtils.getNLViewSelectable(sel);
            if (selectable == null) continue;
            goTos.addAll(selectable.getGoToSource());
        }
        return goTos;
    }

    public static <T> T unwrapNLViewObject(DSelectable sel, Class<T> clazz) {
        if (!(sel instanceof DDesignObject)) {
            return null;
        }
        NLAbstractBase nlObject = KLayDrawUtils.getNLObject(sel instanceof DLabel.DSelectableLabel ? ((DLabel.DSelectableLabel)sel).getConnectedDesignObject() : (DDesignObject)((Object)sel));
        return (T)(clazz.isInstance(nlObject) ? nlObject : null);
    }

    public static String getNLObjectName(DDesignObject dObject) {
        NLAbstractBase nlElement = KLayDrawUtils.getNLObject(dObject);
        return nlElement != null ? nlElement.toString() : null;
    }
}

