/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.netlist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.model.DiagramInstanceWrapper;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.model.reflection.DummyInstance;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;

public class DMemoryAccessor {
    public static final DMemoryAccessor DUMMY_ACCESSOR = new DMemoryAccessor(null);
    private IELMemory memory;

    public DMemoryAccessor(IELMemory memory) {
        this.memory = memory;
    }

    public boolean hasELMemory() {
        return this.memory != null;
    }

    public DiagramInstanceWrapper createInstanceWrapper(ElementPath path) {
        if (this.memory == null) {
            return null;
        }
        ELInstance instance = this.getInstanceFor(path);
        if (instance == null) {
            return null;
        }
        return new DiagramInstanceWrapper(instance);
    }

    public List<DiagramInstanceWrapper> createChildInstanceWrappersFor(ElementPath parent, IRfNamedElement element) {
        if (this.memory == null) {
            return Collections.emptyList();
        }
        Map<ElementPath, ELInstance> subTree = this.memory.subtreeOf(parent, false);
        ArrayList<DiagramInstanceWrapper> childWrappersList = new ArrayList<DiagramInstanceWrapper>();
        for (ELInstance instance : subTree.values()) {
            if (instance.getBinding(false) != element) continue;
            childWrappersList.add(new DiagramInstanceWrapper(instance));
        }
        return childWrappersList;
    }

    public List<DiagramInstanceWrapper> createInstanceWrappersFor(IRfNamedElement element, int limit) {
        if (this.memory == null) {
            return Collections.emptyList();
        }
        List<ELInstance> instancesList = this.getInstancesFor(element, limit);
        ArrayList<DiagramInstanceWrapper> wrappersList = new ArrayList<DiagramInstanceWrapper>();
        for (ELInstance instance : instancesList) {
            wrappersList.add(new DiagramInstanceWrapper(instance));
            if (wrappersList.size() < limit) continue;
            return wrappersList;
        }
        return wrappersList;
    }

    public ELInstance getInstanceFor(ElementPath path) {
        if (this.memory == null) {
            return null;
        }
        return this.memory.instanceFor(path);
    }

    public List<ELInstance> getInstancesFor(IRfNamedElement element, int limit) {
        if (this.memory == null) {
            return null;
        }
        if (element instanceof IRfInstanceElement) {
            return this.memory.getInstancesFor((IRfInstanceElement)element, limit);
        }
        return this.memory.getInstancesFor(element, false, limit);
    }

    public List<ELInstance> getChildInstances(ElementPath parent, int limit) {
        return ELUtils.getChildInstances(this.memory, parent, limit);
    }

    public boolean isBlock(ElementPath path) {
        if (this.memory == null) {
            return false;
        }
        ELInstance instance = this.memory.instanceFor(path);
        if (instance == null) {
            return false;
        }
        IRfInstanceElement description = instance.getDescription();
        if (!(description instanceof DummyInstance)) {
            return false;
        }
        return ((DummyInstance)description).isGenerateInstance();
    }

    public IRfNamedElement getNamedElement(Object element) {
        if (element instanceof IRfNamedElement) {
            return (IRfNamedElement)element;
        }
        if (element instanceof DiagramInstanceWrapper) {
            IRfInstanceElement description = ((DiagramInstanceWrapper)element).getDescription();
            if (description instanceof DummyInstance) {
                return ((DummyInstance)description).design;
            }
            return description;
        }
        return null;
    }

    public IRfNamedElement getDesign(ElementPath elementPath, boolean stripToEntity) {
        IRfNamedElement design = this.memory.bindingFor(elementPath, stripToEntity);
        if (design == ELConstants.UNRESOLVED_INSTANCE_TYPE) {
            return null;
        }
        return design;
    }
}

