/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.netlist;

import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KLabel;
import de.cau.cs.kieler.core.kgraph.KLabeledGraphElement;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.kgraph.KPort;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.kiml.klayoutdata.KEdgeLayout;
import de.cau.cs.kieler.kiml.klayoutdata.KIdentifier;
import de.cau.cs.kieler.kiml.klayoutdata.KLayoutDataFactory;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.options.Direction;
import de.cau.cs.kieler.kiml.options.EdgeLabelPlacement;
import de.cau.cs.kieler.kiml.options.EdgeRouting;
import de.cau.cs.kieler.kiml.options.HierarchyHandling;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.NodeLabelPlacement;
import de.cau.cs.kieler.kiml.options.PortConstraints;
import de.cau.cs.kieler.kiml.options.PortLabelPlacement;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.kiml.options.SizeConstraint;
import de.cau.cs.kieler.kiml.options.SizeOptions;
import de.cau.cs.kieler.kiml.util.KimlUtil;
import de.cau.cs.kieler.kiml.util.nodespacing.Spacing;
import de.cau.cs.kieler.klay.layered.p3order.CrossingMinimizationStrategy;
import de.cau.cs.kieler.klay.layered.p4nodes.NodePlacementStrategy;
import de.cau.cs.kieler.klay.layered.properties.GreedySwitchType;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import de.cau.cs.kieler.klay.layered.properties.WideNodesStrategy;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import ro.amiq.dvt.diagrams.klay.KLayDiagramDebug;
import ro.amiq.dvt.diagrams.klay.model.KLaySize;
import ro.amiq.dvt.diagrams.klay.model.KLayWrapper;
import ro.amiq.dvt.diagrams.netlist.NLDiagramAdapterConstants;
import ro.amiq.dvt.diagrams.netlist.NLDiagramImporter;
import ro.amiq.dvt.diagrams.netlist.model.NLAbstractBase;
import ro.amiq.dvt.diagrams.netlist.model.NLBundleGate;
import ro.amiq.dvt.diagrams.netlist.model.NLConnection;
import ro.amiq.dvt.diagrams.netlist.model.NLGate;
import ro.amiq.dvt.diagrams.netlist.model.NLGateKind;
import ro.amiq.dvt.diagrams.netlist.model.NLInstanceGate;
import ro.amiq.dvt.diagrams.netlist.model.NLLogicGate;
import ro.amiq.dvt.diagrams.netlist.model.NLPDSwitchGate;
import ro.amiq.dvt.diagrams.netlist.model.NLParameters;
import ro.amiq.dvt.diagrams.netlist.model.NLPort;
import ro.amiq.dvt.diagrams.netlist.rendering.NLRenderingUtils;
import ro.amiq.dvt.diagrams.netlist.utils.NLConfiguration;
import ro.amiq.dvt.diagrams.netlist.utils.NLUtils;
import ro.amiq.dvt.draw.utils.FontFactory;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.power.format.DVTPFInfo;
import ro.amiq.dvt.power.format.DVTPFModel;
import ro.amiq.dvt.utils.Utils;

public class NLDiagramAdapter {
    private final Direction diagramDirection;
    private final EdgeRouting diagramEdgeRouting;
    private final String diagramLayoutAlgorithm;

    public NLDiagramAdapter(Direction direction, EdgeRouting diagramEdgeRouting) {
        this.diagramDirection = direction;
        this.diagramEdgeRouting = diagramEdgeRouting;
        this.diagramLayoutAlgorithm = "de.cau.cs.kieler.klay.layered";
    }

    public final void setKNodeInfo(KNode node, NLGate gate, NLDiagramImporter.Bundle bundle) {
        this.setKIdentifier((KLabeledGraphElement)node, gate);
        NLRenderingUtils.renderGate(node, gate, bundle);
        this.setKLabels((KLabeledGraphElement)node, gate, bundle);
        KShapeLayout nodeShapeLayout = (KShapeLayout)node.getData(KShapeLayout.class);
        EnumSet<NodeLabelPlacement> nodeLabelPlacement = this.getKNodeLabelPlacement(gate, bundle);
        this.setKNodeLayoutOptions(nodeShapeLayout, this.diagramEdgeRouting, this.diagramDirection, nodeLabelPlacement, this.getKNodePortLabelPlacement(gate), this.getKNodeSizeOptions(gate), this.getKNodeSizeConstraint(gate), this.getKNodePortConstrains(gate), this.getKNodeHierarchyHandling(gate));
        this.setLNodeLayeredOptions(nodeShapeLayout, this.getKNodeCrossingMinStrategy(gate, bundle));
    }

    private void setKIdentifier(KLabeledGraphElement kElement, NLAbstractBase nlElement) {
        if (nlElement == null || nlElement.getName() == null) {
            return;
        }
        KIdentifier identifier = (KIdentifier)kElement.getData(KIdentifier.class);
        if (identifier != null) {
            return;
        }
        identifier = KLayoutDataFactory.eINSTANCE.createKIdentifier();
        identifier.setId(nlElement.getName());
        kElement.getData().add((Object)identifier);
    }

    private EnumSet<SizeOptions> getKNodeSizeOptions(NLGate gate) {
        NLGateKind gateKind = NLUtils.getGateKind(gate);
        if (gateKind == NLGateKind.PORT) {
            return EnumSet.of(SizeOptions.DEFAULT_MINIMUM_SIZE);
        }
        return EnumSet.of(SizeOptions.DEFAULT_MINIMUM_SIZE, SizeOptions.COMPUTE_INSETS, SizeOptions.APPLY_ADDITIONAL_INSETS);
    }

    private EnumSet<SizeConstraint> getKNodeSizeConstraint(NLGate gate) {
        NLGateKind gateKind = NLUtils.getGateKind(gate);
        if (gateKind == NLGateKind.PORT) {
            return EnumSet.noneOf(SizeConstraint.class);
        }
        return EnumSet.of(SizeConstraint.MINIMUM_SIZE, SizeConstraint.PORTS, SizeConstraint.PORT_LABELS);
    }

    private EnumSet<NodeLabelPlacement> getKNodeLabelPlacement(NLGate gate, NLDiagramImporter.Bundle bundle) {
        if (gate == null) {
            return null;
        }
        NLGateKind kind = gate.getKind();
        switch (kind) {
            case INSTANCE: 
            case DESIGN: 
            case BLOCK: 
            case BUNDLE: 
            case POWER_DOMAIN: 
            case POWER_SWITCH: 
            case REFACTORING_OK: 
            case REFACTORING_SIDE_EFFECT: 
            case REFACTORING_SIDE_UNCONNECTED: {
                if (bundle.config.getFlags().contains((Object)NLConfiguration.INSTANCE_GATE_LABELS_INSIDE)) {
                    return NodeLabelPlacement.insideTopCenter();
                }
                return NodeLabelPlacement.outsideBottomCenter();
            }
            case LOGIC: {
                return NodeLabelPlacement.insideTopCenter();
            }
        }
        return NodeLabelPlacement.outsideBottomCenter();
    }

    private PortLabelPlacement getKNodePortLabelPlacement(NLGate gate) {
        return PortLabelPlacement.INSIDE;
    }

    private PortConstraints getKNodePortConstrains(NLGate gate) {
        if (gate != null && (gate.hasFlag(NLParameters.NLParametersFlag.IS_GATE_AS_BLOCK) || gate instanceof NLBundleGate)) {
            return PortConstraints.FIXED_ORDER;
        }
        return PortConstraints.FIXED_SIDE;
    }

    public final void setKEdgeInfo(KEdge edge, NLConnection conn, NLDiagramImporter.Bundle bundle) {
        this.setKIdentifier((KLabeledGraphElement)edge, conn);
        NLRenderingUtils.renderEdge(edge, conn, bundle);
        this.setKEdgeLayoutOptions((KEdgeLayout)edge.getData(KEdgeLayout.class), this.getKEdgeThickness(conn));
        this.setEdgeKLabel(edge, conn, bundle);
    }

    private void setEdgeKLabel(KEdge edge, NLConnection conn, NLDiagramImporter.Bundle bundle) {
        if (conn == null || !conn.isImplicitSignal()) {
            return;
        }
        KLabel label = this.setKLabel(conn.getLabel(), (KLabeledGraphElement)edge, conn, bundle);
        if (label == null) {
            return;
        }
        KShapeLayout labelShapeLayout = (KShapeLayout)label.getData(KShapeLayout.class);
        labelShapeLayout.setProperty(LayoutOptions.EDGE_LABEL_PLACEMENT, (Object)EdgeLabelPlacement.HEAD);
    }

    private float getKEdgeThickness(NLConnection conn) {
        if (conn == null) {
            return 0.0f;
        }
        return conn.isInterfaceConnection() ? 2.0f : 1.0f;
    }

    public final void setKPortInfo(KPort port, NLPort nlPort, NLDiagramImporter.Bundle bundle) {
        this.setKIdentifier((KLabeledGraphElement)port, nlPort);
        NLRenderingUtils.renderPort(port, nlPort, bundle);
        this.setKLabels((KLabeledGraphElement)port, nlPort, bundle);
        this.setKPortLayoutOptions((KShapeLayout)port.getData(KShapeLayout.class), this.getKPortSide(nlPort));
    }

    private PortSide getKPortSide(NLPort nlPort) {
        NLPort.NLPortDirection portDirection = NLUtils.getPortDirectionOfPort(nlPort);
        if (portDirection == null) {
            return PortSide.UNDEFINED;
        }
        switch (portDirection) {
            case DIR_OUT: {
                return PortSide.EAST;
            }
            case DIR_IN: {
                return PortSide.WEST;
            }
        }
        return PortSide.WEST;
    }

    private KVector getKPortAnchor(NLPort nlPort, PortSide portSide, KLaySize portSize) {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final void setKLabels(KLabeledGraphElement parent, NLAbstractBase object, NLDiagramImporter.Bundle bundle) {
        if (parent == null || object == null) {
            return;
        }
        String text = object.getLabel();
        if (text == null) {
            return;
        }
        if (object instanceof NLInstanceGate) {
            IRfDesignElement design = ((NLInstanceGate)object).getDesign();
            if (design != null && design.isShallowCompiled()) {
                text = "[S] " + text;
            } else if (design != null && design.isIncrementalShallowCompiled()) {
                text = "[iS] " + text;
            }
        }
        if (object instanceof NLPort && ((NLPort)object).isFlowSequentialPort()) {
            this.setKLabel("    ", parent, object, bundle);
            return;
        }
        String[] textLabels = new String[5];
        int indexNewLine = text.indexOf("\n");
        if (indexNewLine > -1) {
            DVTPFInfo pdInfo;
            textLabels[0] = text.substring(0, indexNewLine);
            textLabels[1] = text.substring(indexNewLine + 1, text.length());
            if (object instanceof NLInstanceGate && Utils.isDiagramsShowPDInfo() && (pfModel = NLUtils.getPFModel(object)) != null && (pdInfo = ((DVTPFModel)pfModel).getPDInfoForPDName(powerDomainName = ((DVTPFModel)pfModel).getPDNameForPath(NLUtils.getGatePathToTop((NLInstanceGate)object)))) != null) {
                powerSupply = pdInfo.getPrimaryPowerSupply();
                groundSupply = pdInfo.getPrimaryGroundSupply();
                textLabels[3] = textLabels[0];
                textLabels[4] = textLabels[1];
                textLabels[0] = "Domain: " + powerDomainName;
                if (powerSupply != null && groundSupply != null) {
                    textLabels[1] = "Power: " + powerSupply.getPortName();
                    textLabels[2] = "Ground: " + groundSupply.getPortName();
                }
            }
        } else {
            NLAbstractBase nLAbstractBase;
            DVTPFInfo pdInfo;
            textLabels[0] = text;
            if (object instanceof NLInstanceGate && Utils.isDiagramsShowPDInfo() && (pfModel = NLUtils.getPFModel(object)) != null && (pdInfo = ((DVTPFModel)pfModel).getPDInfoForPDName(powerDomainName = ((DVTPFModel)pfModel).getPDNameForPath(NLUtils.getGatePathToTop((NLInstanceGate)object)))) != null) {
                powerSupply = pdInfo.getPrimaryPowerSupply();
                groundSupply = pdInfo.getPrimaryGroundSupply();
                textLabels[3] = textLabels[0];
                textLabels[0] = "Domain: " + powerDomainName;
                if (powerSupply != null && groundSupply != null) {
                    textLabels[1] = "Power: " + powerSupply.getPortName();
                    textLabels[2] = "Ground: " + groundSupply.getPortName();
                }
            }
            if ((nLAbstractBase = object) instanceof NLPort && (pfModel = (NLPort)nLAbstractBase) == (NLPort)nLAbstractBase && object.getEnclosingGate() instanceof NLInstanceGate) {
                void port;
                int index = 1;
                if (NLUtils.isDiagramsShowPortFullyQualifiedName(object.getEnclosingGate()) && port.getQualifiedName() != null) {
                    textLabels[index++] = port.getQualifiedName();
                }
                if (Utils.isDiagramsShowPDInfo() && port.getPfInfo() != null) {
                    textLabels[index++] = port.getPfInfo();
                }
                if (port.getWaveformValue() != null) {
                    textLabels[index] = port.getWaveformValue();
                }
            }
        }
        if (object instanceof NLPDSwitchGate && ((NLPDSwitchGate)object).getKind() == NLGateKind.POWER_SWITCH) {
            String[] nextTextLabels = new String[]{"PS :", textLabels[0]};
            textLabels = nextTextLabels;
        }
        String[] stringArray = textLabels;
        int n = textLabels.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            this.setKLabel(line, parent, object, bundle);
            ++n2;
        }
    }

    private KLabel setKLabel(String text, KLabeledGraphElement parent, NLAbstractBase object, NLDiagramImporter.Bundle bundle) {
        if (text == null) {
            return null;
        }
        KLabel label = KimlUtil.createInitializedLabel((KLabeledGraphElement)parent);
        String padding = " ";
        label.setText(String.valueOf(padding) + text + padding);
        this.setKLabelInfo(label, object, bundle);
        return label;
    }

    private void setKLabelInfo(KLabel label, NLAbstractBase object, NLDiagramImporter.Bundle bundle) {
        NLRenderingUtils.renderLabel(label, object, bundle);
        this.setKLabelLayoutOptions((KShapeLayout)label.getData(KShapeLayout.class), this.getKLabelFixedSize(label, object));
    }

    private Point getKLabelFixedSize(KLabel label, NLAbstractBase object) {
        if (label == null || object == null) {
            return new Point(0, 0);
        }
        FontData fontData = NLRenderingUtils.getFontData(label);
        if (fontData == null) {
            return new Point(0, 0);
        }
        String text = label.getText();
        if (NLUtils.isLogicGate(object) || object instanceof NLPDSwitchGate && "PS :".equals(text.trim())) {
            Point emSize = FontFactory.getInstance().emSize(fontData);
            return new Point(4 * emSize.x, 2 * emSize.y);
        }
        return FontFactory.getInstance().stringExtent(text, fontData);
    }

    private void setKLabelLayoutOptions(KShapeLayout layout, Point size) {
        if (layout == null) {
            return;
        }
        layout.setSize((float)size.x, (float)size.y);
    }

    private void setKNodeLayoutOptions(KShapeLayout nodeLayout, EdgeRouting edgeRouting, Direction direction, EnumSet<NodeLabelPlacement> nodeLabelPlacement, PortLabelPlacement portLabelPlacement, EnumSet<SizeOptions> nodeSizeOptions, EnumSet<SizeConstraint> nodeSizeContraints, PortConstraints portConstraints, HierarchyHandling hierarchyHandling) {
        if (nodeLayout == null) {
            return;
        }
        nodeLayout.setProperty(LayoutOptions.EDGE_ROUTING, (Object)(edgeRouting != null ? edgeRouting : EdgeRouting.UNDEFINED));
        nodeLayout.setProperty(LayoutOptions.DIRECTION, (Object)(direction != null ? direction : Direction.UNDEFINED));
        nodeLayout.setProperty(LayoutOptions.NODE_LABEL_PLACEMENT, (Object)(nodeLabelPlacement != null ? nodeLabelPlacement : NodeLabelPlacement.outsideBottomCenter()));
        nodeLayout.setProperty(LayoutOptions.PORT_LABEL_PLACEMENT, (Object)(portLabelPlacement != null ? portLabelPlacement : PortLabelPlacement.INSIDE));
        nodeLayout.setProperty(LayoutOptions.SIZE_OPTIONS, nodeSizeOptions != null ? nodeSizeOptions : EnumSet.allOf(SizeOptions.class));
        nodeLayout.setProperty(LayoutOptions.SIZE_CONSTRAINT, nodeSizeContraints != null ? nodeSizeContraints : EnumSet.allOf(SizeConstraint.class));
        nodeLayout.setProperty(LayoutOptions.PORT_CONSTRAINTS, (Object)(portConstraints != null ? portConstraints : PortConstraints.FREE));
        nodeLayout.setProperty(LayoutOptions.HIERARCHY_HANDLING, (Object)(hierarchyHandling != null ? hierarchyHandling : HierarchyHandling.INHERIT));
        nodeLayout.setProperty(LayoutOptions.ALGORITHM, (Object)this.diagramLayoutAlgorithm);
    }

    private CrossingMinimizationStrategy getKNodeCrossingMinStrategy(NLGate gate, NLDiagramImporter.Bundle bundle) {
        return CrossingMinimizationStrategy.LAYER_SWEEP;
    }

    private void setLNodeLayeredOptions(KShapeLayout nodeLayout, CrossingMinimizationStrategy crossMinStrategy) {
        if (nodeLayout == null) {
            return;
        }
        nodeLayout.setProperty(Properties.CROSS_MIN, (Object)(crossMinStrategy != null ? crossMinStrategy : CrossingMinimizationStrategy.INTERACTIVE));
        nodeLayout.setProperty(Properties.LINEAR_SEGMENTS_DEFLECTION_DAMPENING, (Object)Float.valueOf(0.3f));
        nodeLayout.setProperty(Properties.NODE_PLACER, (Object)NodePlacementStrategy.BRANDES_KOEPF);
        nodeLayout.setProperty(Properties.GREEDY_SWITCH_TYPE, (Object)GreedySwitchType.TWO_SIDED);
        nodeLayout.setProperty(Properties.WIDE_NODES_ON_MULTIPLE_LAYERS, (Object)WideNodesStrategy.OFF);
        nodeLayout.setProperty(Properties.FEEDBACK_EDGES, (Object)false);
    }

    private void setKEdgeLayoutOptions(KEdgeLayout edgeLayout, float edgeThicknes) {
        if (edgeLayout == null) {
            return;
        }
        edgeLayout.setProperty(LayoutOptions.THICKNESS, (Object)Float.valueOf(Math.max(edgeThicknes, 1.0f)));
    }

    private void setKPortLayoutOptions(KShapeLayout portLayout, PortSide side) {
        if (portLayout == null) {
            return;
        }
        portLayout.setProperty(LayoutOptions.PORT_SIDE, (Object)(side != null ? side : PortSide.UNDEFINED));
    }

    public HierarchyHandling getKNodeHierarchyHandling(NLGate gate) {
        boolean isExpandedLogicGate = gate instanceof NLLogicGate && ((NLLogicGate)gate).hasSubGates();
        boolean isExpandedInstanceGate = !(gate instanceof NLLogicGate) && NLUtils.isExpanded(gate);
        return isExpandedLogicGate || isExpandedInstanceGate ? HierarchyHandling.INCLUDE_CHILDREN : HierarchyHandling.SEPARATE_CHILDREN;
    }

    public final void setKNodeSpacingInfo(KNode node) {
        if (node == null) {
            return;
        }
        KLayWrapper wrapper = (KLayWrapper)node.getData(KLayWrapper.class);
        if (wrapper == null) {
            return;
        }
        NLAbstractBase mapping = wrapper.getOrigin(NLAbstractBase.class);
        if (!(mapping instanceof NLGate)) {
            return;
        }
        KShapeLayout nodeLayout = (KShapeLayout)node.getData(KShapeLayout.class);
        if (nodeLayout == null) {
            return;
        }
        float labelSpacing = 0.0f;
        float nodeSpacing = 20.0f;
        nodeLayout.setProperty(LayoutOptions.LABEL_SPACING, (Object)Float.valueOf(labelSpacing));
        nodeLayout.setProperty(LayoutOptions.SPACING, (Object)Float.valueOf(nodeSpacing));
        NLGate gate = (NLGate)mapping;
        switch (gate.getKind()) {
            case INSTANCE: 
            case DESIGN: 
            case LOGIC: 
            case BUNDLE: 
            case POWER_DOMAIN: 
            case POWER_SWITCH: 
            case REFACTORING_OK: 
            case REFACTORING_SIDE_EFFECT: 
            case REFACTORING_SIDE_UNCONNECTED: {
                this.setKNodeSpacingInfo(gate, nodeLayout, (List<KNode>)node.getChildren(), (List<KPort>)node.getPorts(), (List<KLabel>)node.getLabels(), labelSpacing);
                break;
            }
            case BLOCK: 
            case PORT: {
                KLaySize nLSpace = this.computeSpaceForNodeLabels(nodeLayout, (List<KLabel>)node.getLabels(), labelSpacing);
                nodeLayout.setProperty(LayoutOptions.MIN_WIDTH, (Object)Float.valueOf(nLSpace.width));
            }
        }
    }

    private void setKNodeSpacingInfo(NLGate gate, KShapeLayout layout, List<KNode> children, List<KPort> ports, List<KLabel> labels, float labelSpacing) {
        float totalWidth = 0.0f;
        float totalHeight = 0.0f;
        boolean isCompoundNode = !children.isEmpty();
        boolean hasLabelsInside = layout.getProperty(LayoutOptions.PORT_LABEL_PLACEMENT) == PortLabelPlacement.INSIDE;
        KLayDiagramDebug.debugInfo(KLayDiagramDebug.DebugRegion.NL_DIAGRAM_ADAPT, "\nSpacing for node ", gate);
        boolean isFlowGate = gate.hasFlag(NLParameters.NLParametersFlag.IS_GATE_WITH_FLOW_CONNECTION);
        Spacing.Insets pLSpace = this.computeSpaceForPortsLabels(layout, isFlowGate, ports, isCompoundNode, hasLabelsInside, labelSpacing);
        totalWidth = (float)((double)totalWidth + (pLSpace.left + pLSpace.right));
        totalHeight = (float)Math.max((double)totalHeight, pLSpace.top + pLSpace.bottom);
        if (!NLUtils.isInternalLogicGate(gate)) {
            KLaySize nLSpace = this.computeSpaceForNodeLabels(layout, labels, labelSpacing);
            totalWidth = Math.max(totalWidth, nLSpace.width);
            totalHeight += nLSpace.height;
        }
        float fWidth = Math.max(totalWidth, layout.getWidth());
        float fHeight = Math.max(totalHeight, layout.getHeight());
        layout.setProperty(LayoutOptions.MIN_WIDTH, (Object)Float.valueOf(fWidth));
        layout.setProperty(LayoutOptions.MIN_HEIGHT, (Object)Float.valueOf(fHeight));
        KLayDiagramDebug.debugInfo(KLayDiagramDebug.DebugRegion.NL_DIAGRAM_ADAPT, "Total size ", Float.valueOf(fWidth), "x", Float.valueOf(fHeight));
    }

    private void setFixedSizeKNode(KNode node, KLaySize fixedSize) {
        if (node == null || fixedSize == null) {
            return;
        }
        KShapeLayout layout = (KShapeLayout)node.getData(KShapeLayout.class);
        if (layout == null) {
            return;
        }
        layout.setSize(fixedSize.width, fixedSize.height);
    }

    private Spacing.Insets computeSpaceForPortsLabels(KShapeLayout nodeLayout, boolean isFlowGate, List<KPort> ports, boolean isCompoundNode, boolean hasLabelsInside, float labelSpacing) {
        Spacing.Insets space = new Spacing.Insets();
        float maxBorderSpacing = 15.0f;
        float maxPortSpacing = isFlowGate ? NLDiagramAdapterConstants.DEFAULT_FLOW_PORT_SPACING : NLDiagramAdapterConstants.DEFAULT_PORT_SPACING;
        float maxPortHeight = isFlowGate ? NLDiagramAdapterConstants.DEFAULT_FLOW_PORT_SIZE.height : NLDiagramAdapterConstants.DEFAULT_PORT_SIZE.height;
        Point emSize = null;
        for (KPort port : ports) {
            EList labels = port.getLabels();
            if (labels == null || labels.isEmpty()) continue;
            KLabel label = (KLabel)labels.get(0);
            FontData fontData = NLRenderingUtils.getFontData(label);
            if (fontData != null) {
                emSize = FontFactory.getInstance().emSize(fontData);
                float roundedPortHeight = 0.65f * (float)emSize.y + labelSpacing;
                maxPortHeight = Math.max(maxPortHeight, roundedPortHeight - roundedPortHeight % 2.0f);
                maxPortSpacing = Math.max(maxPortSpacing, 2.6f * maxPortHeight * (float)labels.size());
            }
            if (!hasLabelsInside) continue;
            KShapeLayout labelLayout = (KShapeLayout)label.getData(KShapeLayout.class);
            float maxPortWidth = labelLayout.getWidth() + labelSpacing;
            if (labels.size() > 1) {
                for (KLabel labelWidthCandidate : labels) {
                    maxPortWidth = Math.max(maxPortWidth, ((KShapeLayout)labelWidthCandidate.getData(KShapeLayout.class)).getWidth());
                }
            }
            float lHeight = labelLayout.getHeight() + labelSpacing;
            PortSide portSide = (PortSide)((KShapeLayout)port.getData(KShapeLayout.class)).getProperty(LayoutOptions.PORT_SIDE);
            if (portSide == null) continue;
            switch (portSide) {
                case WEST: {
                    space.left = Math.max(space.left, (double)maxPortWidth);
                    space.top += (double)lHeight;
                    break;
                }
                case EAST: {
                    space.right = Math.max(space.right, (double)maxPortWidth);
                    space.bottom += (double)lHeight;
                    break;
                }
                case NORTH: {
                    space.top = Math.max(space.top, (double)lHeight);
                    space.left += (double)maxPortWidth;
                    break;
                }
                case SOUTH: {
                    space.bottom = Math.max(space.bottom, (double)lHeight);
                    space.right += (double)maxPortWidth;
                    break;
                }
            }
            if (!isCompoundNode) continue;
            maxBorderSpacing = this.diagramDirection == NLDiagramAdapterConstants.DIAGRAM_DIRECTION || this.diagramDirection == Direction.LEFT ? Math.max(maxBorderSpacing, maxPortWidth) : Math.max(maxBorderSpacing, lHeight);
        }
        nodeLayout.setProperty(LayoutOptions.BORDER_SPACING, (Object)Float.valueOf(maxBorderSpacing));
        KLayDiagramDebug.debugInfo(KLayDiagramDebug.DebugRegion.NL_DIAGRAM_ADAPT, "Border spacing ", Float.valueOf(maxBorderSpacing));
        nodeLayout.setProperty(LayoutOptions.PORT_SPACING, (Object)Float.valueOf(maxPortSpacing));
        KLayDiagramDebug.debugInfo(KLayDiagramDebug.DebugRegion.NL_DIAGRAM_ADAPT, "Port spacing ", Float.valueOf(maxPortSpacing));
        Spacing.Margins additionalPortSpacing = new Spacing.Margins((double)(0.2f * maxPortSpacing), 0.0, (double)(0.2f * maxPortSpacing), 0.0);
        nodeLayout.setProperty(LayoutOptions.ADDITIONAL_PORT_SPACE, (Object)additionalPortSpacing);
        KLayDiagramDebug.debugInfo(KLayDiagramDebug.DebugRegion.NL_DIAGRAM_ADAPT, "Margins spacing ", additionalPortSpacing);
        for (KPort port : ports) {
            KShapeLayout portLayout = (KShapeLayout)port.getData(KShapeLayout.class);
            portLayout.setSize(maxPortHeight, maxPortHeight);
            KLayDiagramDebug.debugInfo(KLayDiagramDebug.DebugRegion.NL_DIAGRAM_ADAPT, "Port size ", Float.valueOf(maxPortHeight), "x", Float.valueOf(maxPortHeight), "|", port);
        }
        return space;
    }

    private KLaySize computeSpaceForNodeLabels(KShapeLayout nodeLayout, List<KLabel> nodeLabels, float labelSpacing) {
        KLaySize size = KLaySize.of(0.0f, 0.0f);
        if (nodeLabels == null || nodeLabels.isEmpty()) {
            return size;
        }
        for (KLabel nodeLabel : nodeLabels) {
            KShapeLayout labelLayout = (KShapeLayout)nodeLabel.getData(KShapeLayout.class);
            float lWidth = labelLayout.getWidth() + labelSpacing;
            float lHeight = labelLayout.getHeight() + labelSpacing;
            if (size.width < lWidth) {
                size.width = lWidth;
            }
            size.height += lHeight;
        }
        Spacing.Margins additionalPortSpacing = (Spacing.Margins)nodeLayout.getProperty(LayoutOptions.ADDITIONAL_PORT_SPACE);
        if (additionalPortSpacing != null) {
            float topSpacing = 1.2f * size.height;
            additionalPortSpacing.top += (double)topSpacing;
            KLayDiagramDebug.debugInfo(KLayDiagramDebug.DebugRegion.NL_DIAGRAM_ADAPT, "Additional top spacing ", Float.valueOf(topSpacing));
        }
        return size;
    }

    private KLaySize computeSpaceForSubGates(List<KNode> children, float spacing) {
        KLaySize size = KLaySize.of(0.0f, 0.0f);
        if (children == null || children.isEmpty()) {
            return size;
        }
        for (KNode subNode : children) {
            if (this.diagramDirection != NLDiagramAdapterConstants.DIAGRAM_DIRECTION && this.diagramDirection != Direction.LEFT) continue;
            KShapeLayout childLayout = (KShapeLayout)subNode.getData(KShapeLayout.class);
            size.width += ((Float)childLayout.getProperty(LayoutOptions.MIN_WIDTH)).floatValue() + spacing;
            size.height = Math.max(size.height, ((Float)childLayout.getProperty(LayoutOptions.MIN_HEIGHT)).floatValue());
        }
        return size;
    }

    public void setKNodeDummyRootInfo(KNode dummyRoot) {
        if (dummyRoot == null) {
            return;
        }
        NLRenderingUtils.renderDummyGate(dummyRoot);
        KShapeLayout dummyRootLayout = (KShapeLayout)dummyRoot.getData(KShapeLayout.class);
        dummyRootLayout.setProperty(LayoutOptions.EXPAND_NODES, (Object)true);
        dummyRootLayout.setProperty(LayoutOptions.HIERARCHY_HANDLING, (Object)HierarchyHandling.INCLUDE_CHILDREN);
        dummyRootLayout.setProperty(LayoutOptions.EDGE_ROUTING, (Object)this.diagramEdgeRouting);
        dummyRootLayout.setProperty(LayoutOptions.DIRECTION, (Object)this.diagramDirection);
        dummyRootLayout.setProperty(LayoutOptions.ALGORITHM, (Object)this.diagramLayoutAlgorithm);
        dummyRootLayout.setProperty(LayoutOptions.LABEL_SPACING, (Object)Float.valueOf(0.0f));
    }

    public void updateKNodeInfo(KPort port, KNode enclosingNode) {
        if (port == null || enclosingNode == null) {
            return;
        }
        KShapeLayout portShapeLayout = (KShapeLayout)port.getData(KShapeLayout.class);
        KShapeLayout nodeShapeLayout = (KShapeLayout)enclosingNode.getData(KShapeLayout.class);
        if (portShapeLayout.getProperty(LayoutOptions.PORT_SIDE) == PortSide.UNDEFINED) {
            nodeShapeLayout.setProperty(LayoutOptions.PORT_CONSTRAINTS, (Object)PortConstraints.FREE);
        }
    }
}

