/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.netlist;

import de.cau.cs.kieler.core.kgraph.KNode;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.diagrams.DProgressMonitor;
import ro.amiq.dvt.diagrams.IDiagramEngine;
import ro.amiq.dvt.diagrams.design.DActionFlowDiagram;
import ro.amiq.dvt.diagrams.design.DActionOnPortSchematicDiagram;
import ro.amiq.dvt.diagrams.design.DActionSchematicDiagram;
import ro.amiq.dvt.diagrams.design.DRefactoringConnectDiagram;
import ro.amiq.dvt.diagrams.design.DRefactoringDiagram;
import ro.amiq.dvt.diagrams.exceptions.DCanceledException;
import ro.amiq.dvt.diagrams.klay.KLayDiagramKind;
import ro.amiq.dvt.diagrams.netlist.DMemoryAccessor;
import ro.amiq.dvt.diagrams.netlist.NLDiagramImporter;
import ro.amiq.dvt.diagrams.netlist.model.NLConnection;
import ro.amiq.dvt.diagrams.netlist.model.NLFactory;
import ro.amiq.dvt.diagrams.netlist.model.NLInstanceGate;
import ro.amiq.dvt.diagrams.netlist.model.NLParameters;
import ro.amiq.dvt.diagrams.netlist.utils.NLConfig;
import ro.amiq.dvt.diagrams.netlist.utils.NLConfiguration;
import ro.amiq.dvt.diagrams.netlist.utils.NLProcessors;
import ro.amiq.dvt.diagrams.netlist.utils.NLTCProcessors;
import ro.amiq.dvt.diagrams.netlist.utils.NLUtils;
import ro.amiq.dvt.elaboration.model.DiagramInstanceWrapper;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.power.format.DVTPFModel;
import ro.amiq.dvt.ui.trace.connections.model.TCEndSet;
import ro.amiq.dvt.ui.trace.connections.model.TCNode;
import ro.amiq.dvt.ui.trace.connections.model.TCPathChain;
import ro.amiq.dvt.ui.trace.connections.model.TCPathPoint;
import ro.amiq.dvt.ui.trace.connections.model.TCPathRedundance;
import ro.amiq.dvt.ui.trace.connections.utils.TCOperation;
import ro.amiq.dvt.ui.trace.connections.utils.TCUtils;

public enum NLDiagramEngine implements IDiagramEngine
{
    INSTANCE;


    public KNode makeFlowDiagram(IRfNamedElement topNamedElement, NLConfig nlConfig, ElementPath topPath, DMemoryAccessor memoryAccessor, DProgressMonitor monitor) throws DCanceledException {
        ElementPath elToSearch = topPath == null ? ElementPath.EMPTY_PATH : topPath;
        Object top = this.computeTopElement(topNamedElement, memoryAccessor, elToSearch);
        NLInstanceGate topInstance = NLFactory.createTopInstance(top, NLFactory.createParametersWithTopPath(elToSearch), memoryAccessor);
        nlConfig.setTopInstance(topInstance);
        NLProcessors.expandToDepth(topInstance, 1, new HashSet<Object>(), monitor);
        NLProcessors.reduceInterfaceBundles(topInstance, nlConfig, false, monitor);
        NLProcessors.adjustAlwaysBlockLogic(topInstance, nlConfig, monitor);
        NLProcessors.reduceEmptyGenerateBlocks(topInstance, nlConfig, monitor);
        NLProcessors.applyFilters(topInstance, nlConfig, monitor);
        NLProcessors.reduceUnconnectedPorts(topInstance, nlConfig, monitor);
        NLProcessors.transformToFlowDiagram(topInstance, nlConfig, monitor);
        NLProcessors.reduceUnconnectedGates(topInstance, nlConfig, true);
        KNode graph = NLDiagramImporter.getDefault().toKLay(topInstance, nlConfig, monitor);
        return graph;
    }

    public KNode makeSchematicDiagram(IRfNamedElement topNamedElement, int depth, NLConfig nlConfig, ElementPath topPath, DMemoryAccessor memoryAccessor, DProgressMonitor monitor) throws DCanceledException {
        ElementPath elToSearch = topPath == null ? ElementPath.EMPTY_PATH : topPath;
        Object top = this.computeTopElement(topNamedElement, memoryAccessor, elToSearch);
        if (top == null) {
            return null;
        }
        NLParameters parameters = NLFactory.createParametersWithTopPath(elToSearch);
        this.copyConfigFlagsToParameters(nlConfig, parameters);
        NLInstanceGate topInstance = NLFactory.createTopInstance(top, parameters, memoryAccessor);
        nlConfig.setTopInstance(topInstance);
        NLProcessors.expandToDepth(topInstance, depth, new HashSet<Object>(), monitor);
        NLProcessors.reduceInterfaceBundles(topInstance, nlConfig, true, monitor);
        NLProcessors.adjustAlwaysBlockLogic(topInstance, nlConfig, monitor);
        NLProcessors.reduceEmptyGenerateBlocks(topInstance, nlConfig, monitor);
        NLProcessors.applyFilters(topInstance, nlConfig, monitor);
        NLProcessors.hideLogicGates(topInstance, nlConfig, monitor);
        NLProcessors.reduceUnconnectedPorts(topInstance, nlConfig, monitor);
        NLProcessors.reduceUnconnectedGates(topInstance, nlConfig, false);
        NLProcessors.addWaveformInfo(topInstance, nlConfig);
        KNode graph = NLDiagramImporter.getDefault().toKLay(topInstance, nlConfig, monitor);
        return graph;
    }

    private Object computeTopElement(IRfNamedElement namedElement, DMemoryAccessor memoryAccessor, ElementPath elToSearch) {
        if (!memoryAccessor.hasELMemory()) {
            return NLUtils.adjustTopElement(namedElement);
        }
        DiagramInstanceWrapper instanceWrapper = memoryAccessor.createInstanceWrapper(elToSearch.toElaborationForm());
        if (instanceWrapper == null) {
            List<DiagramInstanceWrapper> wrappers = memoryAccessor.createInstanceWrappersFor(namedElement, 1);
            if (wrappers.isEmpty()) {
                return null;
            }
            return wrappers.get(0);
        }
        return instanceWrapper;
    }

    public KNode makeActionDiagram(DActionSchematicDiagram diagram, DProgressMonitor monitor) throws DCanceledException {
        DMemoryAccessor memoryAccessor = diagram.getMemoryAccessor(1, (IProgressMonitor)monitor);
        ElementPath elToSearch = diagram.getTopPath();
        NLConfig nlConfig = diagram.getConfig();
        Object adjustedTopElement = this.computeTopElement(diagram.getNamedElement(), memoryAccessor, elToSearch);
        NLInstanceGate topInstance = null;
        boolean hasCopyElements = diagram.getCopyElements() != null && !diagram.getCopyElements().isEmpty();
        NLParameters parameters = NLFactory.createParametersWithTopPath(elToSearch);
        this.copyConfigFlagsToParameters(nlConfig, parameters);
        if (diagram instanceof DActionOnPortSchematicDiagram && ((DActionOnPortSchematicDiagram)diagram).getPort() != null) {
            DActionOnPortSchematicDiagram portDiagram = (DActionOnPortSchematicDiagram)diagram;
            topInstance = NLFactory.createTopInstanceFromPort(adjustedTopElement, portDiagram.getPortParent(), portDiagram.getPort(), parameters, memoryAccessor, monitor);
            nlConfig.setTopInstance(topInstance);
            portDiagram.setPortAndParent(null, null);
        } else if (hasCopyElements && diagram.getCopyElements().get(0) instanceof NLInstanceGate) {
            topInstance = NLFactory.createTopInstance(adjustedTopElement, parameters, memoryAccessor);
            NLProcessors.copyGatesInTop(topInstance, diagram.getCopyElements(), nlConfig, monitor);
            diagram.setCopyElement(null);
        } else if (hasCopyElements && diagram.getCopyElements().get(0) instanceof NLConnection) {
            topInstance = NLFactory.createTopInstance(adjustedTopElement, parameters, memoryAccessor);
            NLProcessors.copyConnectionsInTop(topInstance, diagram.getCopyElements(), nlConfig, monitor);
            diagram.setCopyElement(null);
        } else {
            topInstance = nlConfig.getTopInstance();
            if (topInstance == null) {
                topInstance = NLFactory.createTopInstance(adjustedTopElement, parameters, memoryAccessor);
            }
        }
        NLProcessors.cleanModel(topInstance, nlConfig, monitor);
        NLProcessors.applyAction(topInstance, nlConfig, monitor, false);
        NLProcessors.reduceInterfaceBundles(topInstance, nlConfig, true, monitor);
        NLProcessors.showInternalLogicGates(topInstance, nlConfig, monitor);
        NLProcessors.adjustAlwaysBlockLogic(topInstance, nlConfig, monitor);
        NLProcessors.reduceEmptyGenerateBlocks(topInstance, nlConfig, monitor);
        NLProcessors.makeAllVisibleRelevant(topInstance, nlConfig, monitor);
        NLProcessors.applyFilters(topInstance, nlConfig, monitor);
        NLProcessors.reduceUnconnectedPorts(topInstance, nlConfig, monitor);
        NLProcessors.reduceUnconnectedGates(topInstance, nlConfig, false);
        NLProcessors.addWaveformInfo(topInstance, nlConfig);
        nlConfig.setActionKind(null);
        KNode graph = NLDiagramImporter.getDefault().toKLay(topInstance, nlConfig, monitor);
        return graph;
    }

    public KNode makeActionFlowDiagram(DActionFlowDiagram diagram, DProgressMonitor monitor) throws DCanceledException {
        boolean hasCopyElements;
        DMemoryAccessor memoryAccessor = diagram.getMemoryAccessor(1, (IProgressMonitor)monitor);
        ElementPath elToSearch = diagram.getTopPath();
        NLConfig nlConfig = diagram.getConfig();
        Object adjustedTopElement = this.computeTopElement(diagram.getNamedElement(), memoryAccessor, elToSearch);
        NLInstanceGate topInstance = null;
        boolean bl = hasCopyElements = diagram.getCopyElements() != null && !diagram.getCopyElements().isEmpty();
        if (hasCopyElements && diagram.getCopyElements().get(0) instanceof NLInstanceGate) {
            topInstance = NLFactory.createTopInstance(adjustedTopElement, NLFactory.createParametersWithTopPath(elToSearch), memoryAccessor);
            NLProcessors.copyGatesInTop(topInstance, diagram.getCopyElements(), nlConfig, monitor);
            diagram.setCopyElement(null);
        } else if (hasCopyElements && diagram.getCopyElements().get(0) instanceof NLConnection) {
            topInstance = NLFactory.createTopInstance(adjustedTopElement, NLFactory.createParametersWithTopPath(elToSearch), memoryAccessor);
            NLProcessors.copyConnectionsInTop(topInstance, diagram.getCopyElements(), nlConfig, monitor);
            diagram.setCopyElement(null);
        } else {
            topInstance = nlConfig.getTopInstance();
        }
        NLProcessors.cleanModel(topInstance, nlConfig, monitor);
        NLProcessors.applyAction(topInstance, nlConfig, monitor, true);
        NLProcessors.reduceInterfaceBundles(topInstance, nlConfig, false, monitor);
        NLProcessors.adjustAlwaysBlockLogic(topInstance, nlConfig, monitor);
        NLProcessors.reduceEmptyGenerateBlocks(topInstance, nlConfig, monitor);
        NLProcessors.makeAllVisibleRelevant(topInstance, nlConfig, monitor);
        NLProcessors.applyFilters(topInstance, nlConfig, monitor);
        NLProcessors.reduceUnconnectedPorts(topInstance, nlConfig, monitor);
        NLProcessors.transformToFlowDiagram(topInstance, nlConfig, monitor);
        NLProcessors.reduceUnconnectedGates(topInstance, nlConfig, false);
        nlConfig.setActionKind(null);
        KNode graph = NLDiagramImporter.getDefault().toKLay(topInstance, nlConfig, monitor);
        return graph;
    }

    private KNode makeHierarchicalSchematicDiagram(IRfNamedElement top, NLConfig nlConfig, ElementPath topPath, DMemoryAccessor memAccessor, DProgressMonitor monitor) throws DCanceledException {
        return this.makeSchematicDiagram(top, Integer.MAX_VALUE, nlConfig, topPath, memAccessor, monitor);
    }

    public KNode makeBlockDiagram(IRfNamedElement top, NLConfig nlConfig, ElementPath topPath, DProgressMonitor monitor) throws DCanceledException {
        NLParameters parameters = NLFactory.createParametersWithTopPath(topPath);
        parameters.addFlag(NLParameters.NLParametersFlag.IS_GATE_AS_BLOCK);
        this.copyConfigFlagsToParameters(nlConfig, parameters);
        NLInstanceGate topInstance = NLFactory.createTopInstance(DesignUtils.getDesign(DesignUtils.DesignRequest.of(top)), parameters, null);
        NLProcessors.orderBlockDiagramPorts(topInstance, nlConfig.getFlags(), monitor);
        KNode graph = NLDiagramImporter.getDefault().toKLay(topInstance, nlConfig, monitor);
        return graph;
    }

    public KNode makeTraceAllDiagram(TCNode topNode, TCPathPoint startPoint, TCEndSet sources, TCPathChain driveCausedBy, TCPathRedundance driveRedundance, TCEndSet destinations, TCPathChain loadCausedBy, TCPathRedundance loadRedundance, TCOperation operation, NLConfig nlConfig, DProgressMonitor monitor) throws DCanceledException {
        if (sources == null && destinations == null || driveCausedBy == null && loadCausedBy == null) {
            return null;
        }
        NLInstanceGate topInstance = NLFactory.createTopInstance(topNode, NLFactory.createTCParameters(), new DMemoryAccessor(TCUtils.getELMemory(topNode)));
        topInstance = NLTCProcessors.transformToTraceAllDiagram(topInstance, topNode, startPoint, sources, driveCausedBy, driveRedundance, destinations, loadCausedBy, loadRedundance, monitor);
        NLProcessors.reduceInterfaceBundles(topInstance, nlConfig, false, monitor);
        NLProcessors.adjustAlwaysBlockLogic(topInstance, nlConfig, monitor);
        NLProcessors.reduceEmptyGenerateBlocks(topInstance, nlConfig, monitor);
        NLTCProcessors.handleOutputPortsForDriveOperation(topInstance, operation, monitor);
        NLProcessors.applyFilters(topInstance, nlConfig, monitor);
        NLProcessors.reduceUnconnectedPorts(topInstance, nlConfig, monitor);
        NLProcessors.reduceUnconnectedGates(topInstance, nlConfig, false);
        KNode graph = NLDiagramImporter.getDefault().toKLay(topInstance, nlConfig, monitor);
        return graph;
    }

    public KNode makeTracePathDiagram(TCNode topNode, TCPathPoint point, TCEndSet sources, TCPathChain driveCausedBy, TCEndSet destinations, TCPathChain loadCausedBy, TCPathPoint startPoint, TCOperation operation, NLConfig nlConfig, DProgressMonitor monitor) throws DCanceledException {
        if (point == null || driveCausedBy == null && loadCausedBy == null) {
            return null;
        }
        NLInstanceGate topInstance = NLFactory.createTopInstance(topNode, NLFactory.createTCParameters(), new DMemoryAccessor(TCUtils.getELMemory(topNode)));
        topInstance = NLTCProcessors.transformToTracePathDiagram(topInstance, point, sources, driveCausedBy, destinations, loadCausedBy, startPoint, operation, monitor);
        NLProcessors.reduceInterfaceBundles(topInstance, nlConfig, false, monitor);
        NLProcessors.adjustAlwaysBlockLogic(topInstance, nlConfig, monitor);
        NLProcessors.reduceEmptyGenerateBlocks(topInstance, nlConfig, monitor);
        NLTCProcessors.handleOutputPortsForDriveOperation(topInstance, operation, monitor);
        NLProcessors.applyFilters(topInstance, nlConfig, monitor);
        NLProcessors.reduceUnconnectedPorts(topInstance, nlConfig, monitor);
        NLProcessors.reduceUnconnectedGates(topInstance, nlConfig, false);
        KNode graph = NLDiagramImporter.getDefault().toKLay(topInstance, nlConfig, monitor);
        return graph;
    }

    public KNode makePFDiagram(DVTPFModel pfModel, NLConfig nlConfig, Set<String> selectedPDs, DProgressMonitor monitor) throws DCanceledException {
        if (pfModel == null) {
            return null;
        }
        NLInstanceGate topInstance = NLFactory.createPFGates(pfModel, selectedPDs);
        KNode graph = NLDiagramImporter.getDefault().toKLay(topInstance, nlConfig, monitor);
        return graph;
    }

    public KNode makeRefactoringDiagram(DRefactoringDiagram input, DProgressMonitor monitor) throws DCanceledException {
        input.addSideEffects();
        input.computeTopElement();
        NLInstanceGate topInstance = NLFactory.createRefactoringGates(input);
        KNode graph = NLDiagramImporter.getDefault().toKLay(topInstance, input.getConfig(), monitor);
        return graph;
    }

    public KNode makeRefactoringConnectDiagram(DRefactoringConnectDiagram input, DProgressMonitor monitor) throws DCanceledException {
        input.addSideEffects();
        input.computeTopElement();
        NLInstanceGate topInstance = NLFactory.createRefactoringConnectGates(input);
        KNode graph = NLDiagramImporter.getDefault().toKLay(topInstance, input.getConfig(), monitor);
        return graph;
    }

    private void copyConfigFlagsToParameters(NLConfig nlConfig, NLParameters parameters) {
        if (nlConfig.getFlags().contains((Object)NLConfiguration.SCHEMATIC_SHOW_CONSTANTS)) {
            parameters.addFlag(NLParameters.NLParametersFlag.SCHEMATIC_SHOW_CONSTANTS);
        }
        parameters.setFlag(NLParameters.NLParametersFlag.DIAGRAM_SHOW_PORT_WIDTH, nlConfig.getDiagramShowPortWidth());
        parameters.setFlag(NLParameters.NLParametersFlag.DIAGRAM_SHOW_PORT_FULLY_QUALIFIED_NAME, nlConfig.getDiagramShowPortFullyQualifiedType());
    }

    public KNode testMakeDiagram(String kind, String title, IRfNamedElement top, NLConfig nlConfig, ElementPath topPath, DProgressMonitor monitor) throws DCanceledException {
        if (KLayDiagramKind.FLOW.getName().equals(kind)) {
            return this.makeFlowDiagram(top, nlConfig, topPath, DMemoryAccessor.DUMMY_ACCESSOR, monitor);
        }
        if (KLayDiagramKind.SCHEMATIC.getName().equals(kind)) {
            return this.makeSchematicDiagram(top, 1, nlConfig, topPath, null, monitor);
        }
        if (KLayDiagramKind.HIERARCHICAL_SCHEMATIC.getName().equals(kind)) {
            return this.makeHierarchicalSchematicDiagram(top, nlConfig, topPath, DMemoryAccessor.DUMMY_ACCESSOR, monitor);
        }
        return null;
    }

    public Map<IRfNamedElement, KNode> testMakeDiagram(String diagramKind, IRfNamedElement top, NLConfig nlConfig, ElementPath topPath, DProgressMonitor monitor) throws DCanceledException {
        IRfDesignElement design = DesignUtils.getDesign(DesignUtils.DesignRequest.of(top, true));
        String title = NLUtils.getDesignNLLabel(design, NLUtils.getNLDesign(design), topPath);
        KNode nlGraph = this.testMakeDiagram(diagramKind, title, design, nlConfig, topPath, monitor);
        if (nlGraph == null) {
            return Collections.emptyMap();
        }
        return Collections.singletonMap(top, nlGraph);
    }
}

