/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.netlist;

import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.kgraph.KPort;
import de.cau.cs.kieler.kiml.options.Direction;
import de.cau.cs.kieler.kiml.options.EdgeRouting;
import de.cau.cs.kieler.kiml.util.KimlUtil;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Consumer;
import ro.amiq.dvt.diagrams.DProgressMonitor;
import ro.amiq.dvt.diagrams.exceptions.DCanceledException;
import ro.amiq.dvt.diagrams.klay.KLayDiagramDebug;
import ro.amiq.dvt.diagrams.klay.model.KLayWrapper;
import ro.amiq.dvt.diagrams.netlist.NLDiagramAdapter;
import ro.amiq.dvt.diagrams.netlist.model.NLConnection;
import ro.amiq.dvt.diagrams.netlist.model.NLGate;
import ro.amiq.dvt.diagrams.netlist.model.NLGateKind;
import ro.amiq.dvt.diagrams.netlist.model.NLInstanceGate;
import ro.amiq.dvt.diagrams.netlist.model.NLParameters;
import ro.amiq.dvt.diagrams.netlist.model.NLPort;
import ro.amiq.dvt.diagrams.netlist.utils.NLConfig;
import ro.amiq.dvt.diagrams.netlist.utils.NLUtils;

public class NLDiagramImporter {
    public final NLDiagramAdapter adapter;

    private NLDiagramImporter(NLDiagramAdapter adapter) {
        this.adapter = adapter;
    }

    public static final NLDiagramImporter getDefault() {
        return new NLDiagramImporter(new NLDiagramAdapter(Direction.RIGHT, EdgeRouting.ORTHOGONAL));
    }

    public KNode toKLay(NLInstanceGate topInstance, NLConfig nlConfig, DProgressMonitor monitor) throws DCanceledException {
        if (topInstance == null) {
            return null;
        }
        int hDepth = NLUtils.getHDepth(topInstance);
        Bundle bundle = Bundle.of(hDepth, nlConfig, new IdentityHashMap<NLGate, KNode>(), monitor);
        KNode graph = this.topDownToKlay(topInstance, bundle);
        KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.NL_DIAGRAM_IMPORT, "Total number of KNodes = " + bundle.nofKNodes, new Object[0]);
        KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.NL_DIAGRAM_IMPORT, "Total number of KPorts = " + bundle.nofKPorts, new Object[0]);
        KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.NL_DIAGRAM_IMPORT, "Total number of KEdges = " + bundle.nofKEdges, new Object[0]);
        monitor.setDebugTimeoutInfo("Nodes: " + bundle.nofKNodes + "\nEdges: " + bundle.nofKEdges);
        this.recursiveSetKNodeSpacingInfo(graph);
        KNode dummyRoot = this.createDummyRoot(graph);
        return dummyRoot;
    }

    private KNode topDownToKlay(NLGate instance, Bundle bundle) throws DCanceledException {
        this.topDownToKLayGeneric(instance, i -> {
            KNode kNode = this.createOrGetKNode((NLGate)i, bundle);
        }, bundle);
        this.topDownToKLayGeneric(instance, i -> {
            KNode kNode = this.createKEdges((NLGate)i, bundle);
        }, bundle);
        return bundle.kNodes.get(instance);
    }

    private void topDownToKLayGeneric(NLGate instance, Consumer<NLGate> method, Bundle bundle) throws DCanceledException {
        bundle.monitor.checkCanceled();
        method.accept(instance);
        if (!(instance instanceof NLInstanceGate)) {
            return;
        }
        for (NLGate nLGate : ((NLInstanceGate)instance).getSubGates()) {
            this.topDownToKLayGeneric(nLGate, method, bundle);
        }
    }

    private KNode createKEdges(NLGate enclosingGate, Bundle bundle) {
        if (!NLUtils.isExpanded(enclosingGate)) {
            return null;
        }
        for (NLConnection connection : ((NLInstanceGate)enclosingGate).getSignals()) {
            this.createKEdge(connection, bundle);
        }
        return null;
    }

    private void createKEdge(NLConnection connection, Bundle bundle) {
        if (!NLUtils.isVisible(connection)) {
            return;
        }
        Collection<NLPort> targets = connection.getTargets();
        if (targets == null || targets.isEmpty()) {
            return;
        }
        NLGate enclosingGate = connection.getEnclosingGate();
        if (enclosingGate == null) {
            return;
        }
        NLPort source = this.getSafeStartForKEdge(targets, enclosingGate, connection);
        if (source == null) {
            KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.NL_DIAGRAM_IMPORT, "Connection has no safe start port", connection);
            return;
        }
        KNode sourceNode = bundle.kNodes.get(source.getEnclosingGate());
        if (sourceNode == null) {
            return;
        }
        KPort sourcePort = null;
        for (NLPort other : targets) {
            KPort otherPort;
            KNode otherNode;
            if (other == source) continue;
            NLGate otherEnclosingGate = other.getEnclosingGate();
            if (connection.isSignal() && (otherEnclosingGate.equals(enclosingGate) && !other.hasFlag(NLParameters.NLParametersFlag.INNER_VISIBLE) || !otherEnclosingGate.equals(enclosingGate) && !other.hasFlag(NLParameters.NLParametersFlag.OUTER_VISIBLE)) || (otherNode = bundle.kNodes.get(otherEnclosingGate)) == null || (otherPort = this.createOrGetKPort(other, otherNode, bundle)) == null) continue;
            KPort kPort = sourcePort = sourcePort != null ? sourcePort : this.createOrGetKPort(source, sourceNode, bundle);
            if (sourcePort == null) {
                return;
            }
            this.createOrGetKEdgeWithKPorts(sourcePort, sourceNode, otherPort, otherNode, connection, bundle);
        }
        KLayDiagramDebug.debugInfo(KLayDiagramDebug.DebugRegion.NL_DIAGRAM_IMPORT, "Imported connection", connection);
    }

    private NLPort getSafeStartForKEdge(Collection<NLPort> targets, NLGate enclosingGate, NLConnection connection) {
        if (targets == null || targets.isEmpty() || enclosingGate == null) {
            return null;
        }
        NLPort target = null;
        boolean isInterfaceConnection = connection.isInterfaceConnection();
        boolean isSingleTargetPort = targets.size() == 1;
        for (NLPort portRef : targets) {
            boolean checkForInterfaceConnection;
            if (!NLUtils.isVisible(portRef)) continue;
            NLGate portRefEnclosingGate = portRef.getEnclosingGate();
            if (connection.isSignal() && (portRefEnclosingGate.equals(enclosingGate) && !portRef.hasFlag(NLParameters.NLParametersFlag.INNER_VISIBLE) || !portRefEnclosingGate.equals(enclosingGate) && !portRef.hasFlag(NLParameters.NLParametersFlag.OUTER_VISIBLE))) continue;
            NLGate portEnclosingGate = portRefEnclosingGate;
            if (!NLUtils.isVisible(portEnclosingGate) || portEnclosingGate == enclosingGate && !isSingleTargetPort) continue;
            boolean checkForSourcePort = NLUtils.isSourcePort(portRef);
            boolean bl = checkForInterfaceConnection = !isInterfaceConnection || portEnclosingGate.getKind() == NLGateKind.BUNDLE || portRef.isInterfacePort();
            if (checkForSourcePort && checkForInterfaceConnection) {
                return portRef;
            }
            target = portRef;
        }
        return target;
    }

    private NLPort getUnsafeStartForKEdge(Collection<NLPort> targets, NLGate enclosingGate) {
        if (targets == null || targets.isEmpty() || enclosingGate == null) {
            return null;
        }
        NLPort target = null;
        for (NLPort portRef : targets) {
            if (!NLUtils.isVisible(portRef)) continue;
            if (portRef.getEnclosingGate() != enclosingGate ? NLUtils.isSourcePort(portRef) : NLUtils.isDestinationPort(portRef)) {
                return portRef;
            }
            target = portRef;
        }
        return target;
    }

    private void recursiveSetKNodeSpacingInfo(KNode node) {
        if (node == null) {
            return;
        }
        for (KNode subNode : node.getChildren()) {
            this.recursiveSetKNodeSpacingInfo(subNode);
        }
        this.adapter.setKNodeSpacingInfo(node);
    }

    private KNode createOrGetKNode(NLGate gate, Bundle bundle) {
        if (!NLUtils.isVisible(gate)) {
            return null;
        }
        if (bundle.kNodes.containsKey(gate)) {
            return bundle.kNodes.get(gate);
        }
        KNode node = KimlUtil.createInitializedNode();
        bundle.kNodes.put(gate, node);
        ++bundle.nofKNodes;
        node.getData().add((Object)KLayWrapper.of(gate));
        NLInstanceGate parentGate = gate.getEnclosingGate();
        KNode parentNode = this.createOrGetKNode(parentGate, bundle);
        if (parentNode != null) {
            parentNode.getChildren().add((Object)node);
        }
        this.adapter.setKNodeInfo(node, gate, bundle);
        if (gate.getKind() != NLGateKind.PORT && !gate.hasFlag(NLParameters.NLParametersFlag.IS_GATE_WITH_FLOW_CONNECTION)) {
            for (NLPort port : gate.getPorts()) {
                this.createOrGetKPort(port, node, bundle);
            }
        }
        KLayDiagramDebug.debugInfo(KLayDiagramDebug.DebugRegion.NL_DIAGRAM_IMPORT, "Imported gate", gate);
        return node;
    }

    private KPort createOrGetKPort(NLPort nlPort, KNode enclosingNode, Bundle bundle) {
        if (!NLUtils.isVisible(nlPort) || enclosingNode == null) {
            return null;
        }
        KPort existingKPort = nlPort.getCachedKPort();
        if (existingKPort != null) {
            return existingKPort;
        }
        KPort port = KimlUtil.createInitializedPort();
        ++bundle.nofKPorts;
        nlPort.setCachedKPort(port);
        port.getData().add((Object)KLayWrapper.of(nlPort));
        enclosingNode.getPorts().add((Object)port);
        this.adapter.setKPortInfo(port, nlPort, bundle);
        this.adapter.updateKNodeInfo(port, enclosingNode);
        KLayDiagramDebug.debugInfo(KLayDiagramDebug.DebugRegion.NL_DIAGRAM_IMPORT, "Imported port", nlPort);
        return port;
    }

    private KEdge createOrGetKEdgeWithKPorts(KPort sourcePort, KNode sourceNode, KPort destinationPort, KNode destinationNode, NLConnection connection, Bundle bundle) {
        if (sourceNode == null || sourcePort == null || destinationNode == null || destinationPort == null || connection == null) {
            return null;
        }
        boolean isBidir = connection.isBidirectional();
        if (isBidir) {
            for (KEdge existingEdge : destinationPort.getEdges()) {
                if (existingEdge.getTargetPort() != sourcePort) continue;
                return existingEdge;
            }
        }
        KEdge edge = KimlUtil.createInitializedEdge();
        ++bundle.nofKEdges;
        edge.getData().add((Object)KLayWrapper.of(connection));
        connection.addToCacheKEdges(edge);
        edge.setSource(sourceNode);
        edge.setSourcePort(sourcePort);
        edge.setTarget(destinationNode);
        edge.setTargetPort(destinationPort);
        this.adapter.setKEdgeInfo(edge, connection, bundle);
        KLayDiagramDebug.debugInfo(KLayDiagramDebug.DebugRegion.NL_DIAGRAM_IMPORT, "Imported connection between ", sourceNode, sourcePort, destinationNode, destinationPort);
        return edge;
    }

    public KNode createDummyRoot(KNode graph) {
        KNode dummyRoot = KimlUtil.createInitializedNode();
        if (graph != null) {
            dummyRoot.getChildren().add((Object)graph);
        }
        this.adapter.setKNodeDummyRootInfo(dummyRoot);
        return dummyRoot;
    }

    public static class Bundle {
        public final int maxHDepth;
        public final NLConfig config;
        public final DProgressMonitor monitor;
        public final Map<NLGate, KNode> kNodes;
        public int nofKNodes;
        public int nofKPorts;
        public int nofKEdges;

        private Bundle(int maxHierarchyDepth, NLConfig config, Map<NLGate, KNode> kNodes, DProgressMonitor monitor) {
            this.maxHDepth = maxHierarchyDepth;
            this.config = config;
            this.monitor = monitor;
            this.kNodes = kNodes;
        }

        public static Bundle of(int maxHierarchyDepth, NLConfig config, Map<NLGate, KNode> kNodes, DProgressMonitor monitor) {
            return new Bundle(maxHierarchyDepth, config, kNodes, monitor);
        }
    }
}

