/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.netlist.model;

import ro.amiq.dvt.diagrams.netlist.model.INLViewLabeled;
import ro.amiq.dvt.diagrams.netlist.model.NLGate;
import ro.amiq.dvt.diagrams.netlist.model.NLGateKind;
import ro.amiq.dvt.diagrams.netlist.model.NLParameters;

public abstract class NLAbstractBase
implements INLViewLabeled {
    private String name;
    private NLGate enclosingGate;
    private NLParameters parameters;
    protected String label;

    protected NLAbstractBase(String name, NLGate enclosingGate) {
        this.name = name;
        this.enclosingGate = enclosingGate;
    }

    public NLGate getEnclosingGate() {
        return this.enclosingGate;
    }

    public NLGate getEnclosingGateExcludingGenerateBlocks() {
        NLGate currentEnclosingGate = this.enclosingGate;
        while (currentEnclosingGate != null && currentEnclosingGate.getKind() == NLGateKind.BLOCK) {
            currentEnclosingGate = currentEnclosingGate.getEnclosingGate();
        }
        return currentEnclosingGate;
    }

    public void setEnclosingGate(NLGate enclosingGate) {
        this.enclosingGate = enclosingGate;
    }

    public NLGate getTopGate() {
        NLGate parent = this.getEnclosingGate();
        while (parent != null && !parent.isTopGate()) {
            parent = parent.getEnclosingGate();
        }
        return parent;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLastSegmentName() {
        return this.name;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    public NLParameters getParameters() {
        return this.parameters;
    }

    public void setParameters(NLParameters parameters) {
        this.parameters = parameters;
    }

    public void addFlag(NLParameters.NLParametersFlag flag) {
        if (this.parameters != null) {
            this.parameters.addFlag(flag);
        }
    }

    public void removeFlag(NLParameters.NLParametersFlag flag) {
        if (this.parameters != null) {
            this.parameters.removeFlag(flag);
        }
    }

    public void removeAllFlags() {
        if (this.parameters != null) {
            this.parameters.removeAllFlags();
        }
    }

    public boolean hasFlag(NLParameters.NLParametersFlag flag) {
        if (this.parameters != null) {
            return this.parameters.hasFlag(flag);
        }
        return false;
    }

    public boolean hasFlags(long flagValues) {
        if (this.parameters != null) {
            return this.parameters.hasFlags(flagValues);
        }
        return false;
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NLAbstractBase other = (NLAbstractBase)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    protected void dispose() {
        this.name = null;
        this.enclosingGate = null;
        this.parameters = null;
    }
}

