/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.netlist.model;

import java.util.ArrayList;
import java.util.Collection;
import ro.amiq.dvt.diagrams.netlist.model.NLConnection;
import ro.amiq.dvt.diagrams.netlist.model.NLGate;
import ro.amiq.dvt.diagrams.netlist.model.NLGateKind;
import ro.amiq.dvt.diagrams.netlist.model.NLInstanceGate;
import ro.amiq.dvt.diagrams.netlist.model.NLParameters;
import ro.amiq.dvt.diagrams.netlist.model.NLPort;
import ro.amiq.dvt.diagrams.netlist.model.NLPortLabelOptions;
import ro.amiq.dvt.diagrams.netlist.utils.NLBusUtils;
import ro.amiq.dvt.diagrams.netlist.utils.NLUtils;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.util.DesignUtils;

public class NLBundleGate
extends NLInstanceGate {
    private String busWidthLabel;
    private boolean isGateAdjusted;

    protected NLBundleGate(String name, NLInstanceGate enclosingGate) {
        super(name, enclosingGate);
    }

    @Override
    protected NLBundleGate init(Object source) {
        if (this.isInit()) {
            return this;
        }
        boolean isInterfaceInstance = DesignUtils.isInterfaceInstance(source);
        boolean isInterfacePort = DesignUtils.isInterfacePort(source);
        boolean isCompositeSignal = DesignUtils.isCompositeSignal(source);
        if (!(isInterfaceInstance || isInterfacePort || isCompositeSignal)) {
            return null;
        }
        this.setKind(NLGateKind.BUNDLE);
        this.setMapping(source);
        return isInterfaceInstance ? this.initAsInstance(source) : this.initAsSimple(source);
    }

    @Override
    protected NLBundleGate initAsInstance(Object instance) {
        if (!(instance instanceof IRfInstanceElement)) {
            return this;
        }
        super.initAsInstance(instance);
        if (this.hasFlag(NLParameters.NLParametersFlag.IS_GATE_AS_BLOCK)) {
            return this;
        }
        this.addSameNamedSignalAndPort(NLConnection.NLConnectionKind.BUNDLE_SIGNAL);
        return this;
    }

    private NLBundleGate initAsSimple(Object source) {
        this.addSameNamedSignalAndPort(NLConnection.NLConnectionKind.BUNDLE_SIGNAL);
        if (this.isBusGate()) {
            this.computeSameNamedPortLabel(source);
            this.computeBusWidth(source);
        }
        return this;
    }

    @Override
    public IRfDesignElement getDesign() {
        if (this.design != null) {
            return this.design;
        }
        this.design = DesignUtils.getDesign(DesignUtils.DesignRequest.of(this.getMapping(IRfInstanceElement.class)));
        return this.design;
    }

    @Override
    protected void addInternalSignalConnections(Collection<NLPort> ports) {
        ArrayList<NLPort> actualPorts = new ArrayList<NLPort>(ports);
        actualPorts.remove(this.getSameNamedPort());
        super.addInternalSignalConnections(actualPorts);
    }

    @Override
    public NLGate getCopy(NLInstanceGate enclosingGate) {
        NLBundleGate copy = new NLBundleGate(this.getName(), enclosingGate);
        copy.setParameters(this.getParameters().getCopy());
        copy.setLabel(this.getLabel());
        copy.setKind(this.getKind());
        ((NLGate)copy).setMapping(this.getMapping());
        copy.setGateAdjusted(this.isGateAdjusted());
        return copy;
    }

    public boolean isBusGate() {
        return DesignUtils.isCompositeSignal(this.getMapping());
    }

    public NLPort getOutputSameNamedPort() {
        if (this.ports == null || this.ports.isEmpty()) {
            return null;
        }
        return (NLPort)this.ports.get(NLBusUtils.getOutputPortOrConnectionName(NLUtils.getSameNamedPortName(this.getName())));
    }

    private void computeSameNamedPortLabel(Object source) {
        NLPortLabelOptions portLabelOptions = NLPortLabelOptions.getFromParameters(this.getParameters());
        NLPort sameNamedPort = this.getSameNamedPort();
        sameNamedPort.setLabel(NLUtils.getNLLabel(source, null, portLabelOptions));
    }

    private void computeBusWidth(Object source) {
        String busLabel = NLUtils.getNLLabel(source, null, NLPortLabelOptions.of(NLPortLabelOptions.NLPortLabelOptionsFlag.DIAGRAM_SHOW_PORT_WIDTH));
        String[] splitPortLabel = busLabel.split(":");
        if (splitPortLabel.length < 2) {
            return;
        }
        this.setBusWidthLabel(splitPortLabel[1].trim());
    }

    public String getBusWidthLabel() {
        return this.busWidthLabel;
    }

    public void setBusWidthLabel(String portWidthLabel) {
        this.busWidthLabel = portWidthLabel;
    }

    public boolean isGateAdjusted() {
        return this.isGateAdjusted;
    }

    public void setGateAdjusted(boolean isGateAdjusted) {
        this.isGateAdjusted = isGateAdjusted;
    }
}

