/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.netlist.model;

import de.cau.cs.kieler.core.kgraph.KEdge;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.diagrams.klay.KLayDiagramDebug;
import ro.amiq.dvt.diagrams.netlist.model.INLViewSelectable;
import ro.amiq.dvt.diagrams.netlist.model.INLViewSelectable3;
import ro.amiq.dvt.diagrams.netlist.model.NLAbstractBase;
import ro.amiq.dvt.diagrams.netlist.model.NLGate;
import ro.amiq.dvt.diagrams.netlist.model.NLInstanceGate;
import ro.amiq.dvt.diagrams.netlist.model.NLParameters;
import ro.amiq.dvt.diagrams.netlist.model.NLPort;
import ro.amiq.dvt.diagrams.netlist.utils.NLUtils;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.ui.trace.connections.utils.TCOperation;
import ro.amiq.dvt.ui.trace.connections.utils.TCViewUtils;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.utils.OptimizedUtils;

public class NLConnection
extends NLAbstractBase
implements INLViewSelectable,
INLViewSelectable3 {
    private NLConnectionKind kind;
    private Map<NLPort, NLPort> targets;
    private List<KEdge> cachedKEdges = Collections.emptyList();
    private List<NLConnection> cachedFlowSignals = null;
    private Collection<GoToInfo> goToSource;

    protected NLConnection(String name, NLGate enclosingGate, NLConnectionKind kind) {
        super(name, enclosingGate);
        this.kind = kind;
    }

    public NLConnectionKind getKind() {
        return this.kind;
    }

    public void setKind(NLConnectionKind kind) {
        this.kind = kind;
    }

    @NotNull
    public Collection<NLPort> getTargets() {
        if (this.targets == null) {
            return Collections.emptySet();
        }
        return this.targets.values();
    }

    public boolean hasTargets() {
        return this.targets != null && !this.targets.isEmpty();
    }

    public void addTarget(NLPort port) {
        if (this.targets == null) {
            this.targets = new LinkedHashMap<NLPort, NLPort>();
        }
        this.targets.put(port, port);
    }

    public boolean removeTarget(NLPort port) {
        if (this.targets == null) {
            return false;
        }
        return this.targets.remove(port) != null;
    }

    public boolean hasTarget(NLPort port) {
        if (this.targets == null) {
            return false;
        }
        return this.targets.get(port) != null;
    }

    @NotNull
    public List<NLPort> getSourcePorts() {
        ArrayList<NLPort> sourcePorts = new ArrayList<NLPort>();
        NLGate enclosingGate = this.getEnclosingGate();
        for (NLPort connectedPort : this.getTargets()) {
            if (!(connectedPort.getEnclosingGate() != enclosingGate ? NLUtils.isSourcePort(connectedPort) : NLUtils.isDestinationPort(connectedPort))) continue;
            sourcePorts.add(connectedPort);
        }
        return sourcePorts;
    }

    @NotNull
    public List<NLPort> getDestinationPorts() {
        ArrayList<NLPort> destinationPorts = new ArrayList<NLPort>();
        NLGate enclosingGate = this.getEnclosingGate();
        for (NLPort connectedPort : this.getTargets()) {
            if (!(connectedPort.getEnclosingGate() != enclosingGate ? NLUtils.isDestinationPort(connectedPort) : NLUtils.isSourcePort(connectedPort))) continue;
            destinationPorts.add(connectedPort);
        }
        return destinationPorts;
    }

    @NotNull
    public List<NLGate> getSourceGates() {
        ArrayList<NLGate> sourceGates = new ArrayList<NLGate>();
        for (NLPort sourcePort : this.getSourcePorts()) {
            sourceGates.add(sourcePort.getEnclosingGate());
        }
        return sourceGates;
    }

    @NotNull
    public List<NLGate> getDestinationGates() {
        ArrayList<NLGate> destinationGates = new ArrayList<NLGate>();
        for (NLPort destinationPort : this.getDestinationPorts()) {
            destinationGates.add(destinationPort.getEnclosingGate());
        }
        return destinationGates;
    }

    public boolean isEdge() {
        return this.kind == NLConnectionKind.COMMON_EDGE || this.kind == NLConnectionKind.BUNDLE_EDGE;
    }

    public boolean isSignal() {
        return this.kind == NLConnectionKind.COMMON_SIGNAL || this.kind == NLConnectionKind.BUNDLE_SIGNAL;
    }

    public boolean isInterfaceConnection() {
        return this.kind == NLConnectionKind.BUNDLE_SIGNAL || this.kind == NLConnectionKind.BUNDLE_EDGE;
    }

    public boolean isImplicitSignal() {
        return this.kind == NLConnectionKind.IMPLICIT_SIGNAL;
    }

    public boolean isBidirectional() {
        return this.isSignal() || this.hasFlag(NLParameters.NLParametersFlag.IS_BIDIRECTIONAL_EDGE);
    }

    @Override
    public boolean hasGoToSource() {
        Collection<GoToInfo> goToInfo = this.getGoToSource();
        if (goToInfo == null || goToInfo.isEmpty()) {
            KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.NL_DIAGRAM_ACTION, "Go to source null for", this);
            return false;
        }
        return true;
    }

    public void setGoToInfo(Collection<GoToInfo> sourceInfo) {
        this.goToSource = sourceInfo;
    }

    @Override
    @NotNull
    public Collection<GoToInfo> getGoToSource() {
        return this.isEdge() ? this.getCachedFlowGoToInfos() : (this.goToSource != null ? this.goToSource : Collections.emptyList());
    }

    @Override
    public boolean canTraceConnection() {
        NLGate enclosingGate = this.getEnclosingGate();
        if (NLUtils.isLogicGate(enclosingGate)) {
            enclosingGate = enclosingGate.getEnclosingGate();
        }
        if (!(enclosingGate instanceof NLInstanceGate)) {
            KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.NL_DIAGRAM_ACTION, "Trace Connections: Signal doesn't have a viable enclosing gate", this);
            return false;
        }
        IRfDesignElement design = ((NLInstanceGate)enclosingGate).getDesign();
        if (design == null) {
            KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.NL_DIAGRAM_ACTION, "Trace Connections: No design element found for gate", this);
            return false;
        }
        IRfNamedElement signal = design.getSignalWithPrefix(this.getLabel(), 1);
        if (signal == null) {
            KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.NL_DIAGRAM_ACTION, "Trace Connections: Could not find signal", this);
            return false;
        }
        IProject project = DVTUtilsCommon.INSTANCE.getProject(signal);
        return project != null;
    }

    @Override
    public void traceConnection(TCOperation operation) {
        ElementPath partialInstancePath;
        NLGate enclosingGate = this.getEnclosingGate();
        if (NLUtils.isLogicGate(enclosingGate)) {
            enclosingGate = enclosingGate.getEnclosingGate();
        }
        if ((partialInstancePath = TCViewUtils.getCurrentBreadcrumb(true)) == null) {
            NLUtils.getPath(enclosingGate, gate -> {
                IRfNamedElement mapping = gate.getMapping(IRfNamedElement.class);
                if (mapping == null) {
                    return "";
                }
                return mapping.getName();
            });
        }
        IRfDesignElement design = ((NLInstanceGate)enclosingGate).getDesign();
        IRfNamedElement signal = design.getSignalWithPrefix(this.getLabel(), 1);
        IProject project = DVTUtilsCommon.INSTANCE.getProject(signal);
        TCViewUtils.startTCJobWithChecks(signal, partialInstancePath, false, true, project, operation);
    }

    public void addToCacheKEdges(KEdge kEdge) {
        this.cachedKEdges = OptimizedUtils.listAdd(this.cachedKEdges, kEdge);
    }

    @NotNull
    public Collection<KEdge> getCachedKEdges() {
        return this.cachedKEdges != null ? this.cachedKEdges : Collections.emptyList();
    }

    public void setCachedKEdges(List<KEdge> list) {
        this.cachedKEdges = list;
    }

    public void addFlowSignal(NLConnection connection) {
        if (this.cachedFlowSignals == null) {
            this.cachedFlowSignals = new ArrayList<NLConnection>();
        }
        if (connection != null) {
            this.cachedFlowSignals.add(connection);
        }
    }

    public List<NLConnection> getCachedFlowSignals() {
        return this.cachedFlowSignals;
    }

    @NotNull
    public Collection<GoToInfo> getCachedFlowGoToInfos() {
        if (this.cachedFlowSignals == null) {
            return Collections.emptyList();
        }
        if (this.goToSource != null) {
            return this.goToSource;
        }
        this.goToSource = new LinkedHashSet<GoToInfo>();
        for (NLConnection connection : this.cachedFlowSignals) {
            this.goToSource.addAll(connection.getGoToSource());
        }
        return this.goToSource;
    }

    public NLConnection getCopy(NLInstanceGate enclosingGate) {
        NLConnection copy = new NLConnection(this.getName(), enclosingGate, this.getKind());
        copy.setParameters(this.getParameters().getCopy());
        copy.setGoToInfo(this.getGoToSource());
        copy.setLabel(this.getLabel());
        copy.cachedFlowSignals = this.cachedFlowSignals;
        return copy;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.kind == null ? 0 : this.kind.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        NLConnection other = (NLConnection)obj;
        if (this.kind != other.kind) {
            return false;
        }
        NLGate enclosingGate = this.getEnclosingGate();
        NLGate otherEnclosingGate = other.getEnclosingGate();
        return !(enclosingGate == null ? otherEnclosingGate != null : !enclosingGate.equals(otherEnclosingGate));
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    protected void dispose() {
        super.dispose();
        this.targets = null;
        this.goToSource = null;
        this.cachedKEdges = null;
        this.cachedFlowSignals = null;
    }

    public static enum NLConnectionKind {
        COMMON_SIGNAL,
        BUNDLE_SIGNAL,
        COMMON_EDGE,
        BUNDLE_EDGE,
        IMPLICIT_SIGNAL;

    }
}

