/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.netlist.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.diagrams.klay.KLayDiagramDebug;
import ro.amiq.dvt.diagrams.netlist.DMemoryAccessor;
import ro.amiq.dvt.diagrams.netlist.model.NLCache;
import ro.amiq.dvt.diagrams.netlist.model.NLFactory;
import ro.amiq.dvt.diagrams.netlist.model.NLGate;
import ro.amiq.dvt.diagrams.netlist.model.NLGateKind;
import ro.amiq.dvt.diagrams.netlist.model.NLInstanceGate;
import ro.amiq.dvt.diagrams.netlist.model.NLInstanceGateExpandState;
import ro.amiq.dvt.diagrams.netlist.model.NLParameters;
import ro.amiq.dvt.diagrams.netlist.utils.NLUtils;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.model.DiagramInstanceWrapper;
import ro.amiq.dvt.model.reflection.DummyInstance;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.IRfBlockElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.trace.connections.model.TCConnSignal;

public class NLELInstanceGate
extends NLInstanceGate {
    private DMemoryAccessor memoryAccessor;

    protected NLELInstanceGate(String name, NLInstanceGate enclosingGate, DMemoryAccessor memoryAccessor) {
        super(name, enclosingGate);
        this.memoryAccessor = memoryAccessor;
    }

    @Override
    protected NLGateKind translateToValidInstanceGate(Object element) {
        if (!(element instanceof DiagramInstanceWrapper)) {
            return null;
        }
        IRfInstanceElement description = ((DiagramInstanceWrapper)element).getDescription();
        if (description == null) {
            return null;
        }
        if (!(description instanceof DummyInstance)) {
            return NLGateKind.INSTANCE;
        }
        if (((DummyInstance)description).isGenerateInstance()) {
            return NLGateKind.BLOCK;
        }
        return NLGateKind.DESIGN;
    }

    @Override
    protected NLInstanceGate initAsInstance(Object elem) {
        if (!(elem instanceof DiagramInstanceWrapper)) {
            return this;
        }
        DiagramInstanceWrapper instanceWrapper = (DiagramInstanceWrapper)elem;
        IRfInstanceElement description = instanceWrapper.getDescription();
        ElementPath instancePath = instanceWrapper.getHierarchyPath();
        this.addPorts(description, NLParameters.NLParametersFlag.OUTER_VISIBLE, instancePath);
        this.addInstanceParameters();
        return this;
    }

    @Override
    public IRfDesignElement getDesign() {
        if (this.design != null && !this.design.hasNoDefs(false)) {
            return this.design;
        }
        DiagramInstanceWrapper mapping2 = this.getMapping(DiagramInstanceWrapper.class);
        if (mapping2 == null) {
            return null;
        }
        IRfNamedElement binding = mapping2.getBinding(false);
        if (!(binding instanceof IRfDesignElement)) {
            return null;
        }
        this.design = (IRfDesignElement)binding;
        return this.design;
    }

    @Override
    protected NLInstanceGate initAsDesign(Object elem) {
        if (!(elem instanceof DiagramInstanceWrapper)) {
            return this;
        }
        DiagramInstanceWrapper instance = (DiagramInstanceWrapper)elem;
        IRfNamedElement binding = instance.getBinding(false);
        if (!(binding instanceof IRfDesignElement)) {
            return this;
        }
        IRfDesignElement design = (IRfDesignElement)binding;
        ElementPath instancePath = instance.getHierarchyPath();
        this.addPorts(design, NLParameters.NLParametersFlag.INNER_VISIBLE, instancePath);
        if (this.hasFlag(NLParameters.NLParametersFlag.IS_GATE_AS_BLOCK)) {
            return this;
        }
        this.addSignals(design, instancePath);
        this.addInternalSignalConnections(this.getPorts());
        List<Object> instancesFor = new LinkedList<DiagramInstanceWrapper>();
        if (instance.getDescription() instanceof DummyInstance && ((DummyInstance)instance.getDescription()).isGenerateInstance()) {
            instancesFor = this.getResolvedLocalGenerates(instance);
        } else {
            instancesFor.add(instance);
        }
        LinkedHashMap<IRfNamedElement, ELInstance> genBlocksToAdd = new LinkedHashMap<IRfNamedElement, ELInstance>();
        for (DiagramInstanceWrapper diagramInstanceWrapper : instancesFor) {
            ElementPath hierarchyPath = diagramInstanceWrapper.getHierarchyPath();
            this.addELInstancesGates(hierarchyPath, genBlocksToAdd, this);
        }
        for (NLGate nLGate : new ArrayList<NLGate>(this.getSubGates())) {
            if (!(nLGate instanceof NLELInstanceGate)) continue;
            ((NLELInstanceGate)nLGate).addInstancePortConnections();
        }
        this.addLogicGates(design);
        this.addELBlockGates(genBlocksToAdd, this);
        return this;
    }

    @Override
    protected void addInstancePortConnections() {
        DiagramInstanceWrapper instanceWrapper = this.getMapping(DiagramInstanceWrapper.class);
        if (instanceWrapper == null) {
            return;
        }
        if (this.hasFlag(NLParameters.NLParametersFlag.IS_GATE_AS_BLOCK)) {
            return;
        }
        IRfInstanceElement instance = instanceWrapper.getDescription();
        ElementPath instancePath = instanceWrapper.getHierarchyPath();
        NLInstanceGate enclosingGate = this.getEnclosingGate();
        if (enclosingGate == null) {
            return;
        }
        IRfNamedElement enclosingDesignOrInstance = this.getEnclosingDesignOrInstance(enclosingGate);
        ElementPath path = instancePath != null ? instancePath.removeLastSegment() : null;
        ELInstance closestAncestorInstance = this.memoryAccessor.getInstanceFor(path);
        Map<IRfPortElement, Set<TCConnSignal>> connections = DesignUtils.mapInstancePortConnections(DesignUtils.DesignRequest.of(instance, instancePath, null, true, this.getMemoryAccessor()), NLCache.INSTANCE.getDummyPortMap(), NLUtils.isDiagramsShowConstants(enclosingGate) ? HidFlatteningOption.IMPLICITS_IN_SELECTS_AND_ARGS_EXCLUDED : DesignUtils.PORT_CONNECTION_HID_FLATTENING);
        for (Map.Entry<IRfPortElement, Set<TCConnSignal>> pcEntry : connections.entrySet()) {
            this.addInstancePortConnection(pcEntry.getKey(), pcEntry.getValue(), enclosingGate, enclosingDesignOrInstance, path, closestAncestorInstance);
        }
    }

    private List<DiagramInstanceWrapper> getResolvedLocalGenerates(DiagramInstanceWrapper instance) {
        IRfNamedElement generateBinding = instance.getBinding(false);
        if (!(generateBinding instanceof IRfBlockElement)) {
            return Collections.emptyList();
        }
        ElementPath parentPath = this.getParentPathExcludingGenerates(instance.getHierarchyPath());
        if (parentPath.isEmpty()) {
            return Collections.emptyList();
        }
        return this.memoryAccessor.createChildInstanceWrappersFor(parentPath, generateBinding);
    }

    private ElementPath getParentPathExcludingGenerates(ElementPath path) {
        ElementPath parentPath = path.removeLastSegment();
        while (this.memoryAccessor.isBlock(parentPath)) {
            parentPath = parentPath.removeLastSegment();
        }
        return parentPath;
    }

    private void addELInstancesGates(ElementPath parentPath, Map<IRfNamedElement, ELInstance> genBlocksToAdd, NLGate enclosingGate) {
        boolean isBlockParent = this.memoryAccessor.isBlock(parentPath);
        List<ELInstance> childInstanceList = this.memoryAccessor.getChildInstances(parentPath, Integer.MAX_VALUE);
        String parentPathPrefix = isBlockParent && !childInstanceList.isEmpty() ? this.getInstanceGenblockPrefix(parentPath) : "";
        for (ELInstance childInstance : childInstanceList) {
            IRfNamedElement binding = childInstance.getBinding(false);
            if (!(binding instanceof IRfDesignElement)) continue;
            DiagramInstanceWrapper childWrapper = new DiagramInstanceWrapper(childInstance);
            if (IRfNamedElement.ElementKind.VLOG_INTERFACE == ((IRfDesignElement)binding).getKind() && this.subGates != null && this.subGates.containsKey(NLUtils.getNLName(childWrapper))) continue;
            IRfInstanceElement description = childInstance.getDescription();
            if (description instanceof DummyInstance && ((DummyInstance)description).isGenerateInstance()) {
                genBlocksToAdd.putIfAbsent(childInstance.getBinding(false), childInstance);
                continue;
            }
            if (isBlockParent) {
                childWrapper.setGenblockPrefixPrefixForDiagram(parentPathPrefix);
            }
            this.addSubGate(NLFactory.createGate(childWrapper, enclosingGate, this.memoryAccessor));
        }
    }

    private String getInstanceGenblockPrefix(ElementPath parentPath) {
        ELInstance parentInstance = this.memoryAccessor.getInstanceFor(parentPath);
        if (parentInstance == null) {
            return "";
        }
        ArrayList<String> prefixes = new ArrayList<String>();
        IRfInstanceElement parentDescription = parentInstance.getDescription();
        while (parentDescription instanceof DummyInstance && ((DummyInstance)parentDescription).isGenerateInstance()) {
            String blockNameForDiagram;
            DummyInstance blockDescription = (DummyInstance)parentDescription;
            String descrName = blockDescription.getName();
            String prefix = descrName.equals(blockNameForDiagram = blockDescription.design.getNameForDiagram()) ? blockDescription.design.getName() : descrName;
            prefixes.add(prefix);
            parentPath = parentPath.removeLastSegment();
            parentInstance = this.memoryAccessor.getInstanceFor(parentPath);
            if (parentInstance == null) break;
            parentDescription = parentInstance.getDescription();
        }
        if (prefixes.isEmpty()) {
            return "";
        }
        StringBuilder prefix = new StringBuilder();
        int i = prefixes.size() - 1;
        while (i >= 0) {
            prefix.append((String)prefixes.get(i)).append(".");
            --i;
        }
        return prefix.toString();
    }

    private void addELBlockGates(Map<IRfNamedElement, ELInstance> genBlocksToAdd, NLELInstanceGate enclosingGate) {
        for (Map.Entry<IRfNamedElement, ELInstance> genEntry : genBlocksToAdd.entrySet()) {
            this.addSubGate(NLFactory.createGate(new DiagramInstanceWrapper(genEntry.getValue()), enclosingGate, this.memoryAccessor));
        }
    }

    @Override
    protected IRfNamedElement getEnclosingDesignOrInstance(NLInstanceGate enclosingGate) {
        DiagramInstanceWrapper mapping2 = enclosingGate.getMapping(DiagramInstanceWrapper.class);
        if (mapping2 == null) {
            return null;
        }
        IRfInstanceElement description = mapping2.getDescription();
        if (!(description instanceof DummyInstance)) {
            return description;
        }
        return ((DummyInstance)description).design;
    }

    @Override
    protected DMemoryAccessor getMemoryAccessor() {
        return this.memoryAccessor;
    }

    @Override
    public NLInstanceGate expand(Set<Object> visited) {
        if (this.getExpandState() == NLInstanceGateExpandState.EXPANDED) {
            return this;
        }
        if (this.getKind() != NLGateKind.INSTANCE && this.getKind() != NLGateKind.BUNDLE && this.getKind() != NLGateKind.BLOCK && this.getKind() != NLGateKind.DESIGN) {
            return this;
        }
        DiagramInstanceWrapper mapping = this.getMapping(DiagramInstanceWrapper.class);
        if (mapping == null) {
            return this;
        }
        if (visited != null && visited.contains(mapping)) {
            return this;
        }
        this.initAsDesign(mapping);
        return this;
    }

    @Override
    public NLGate getCopy(NLInstanceGate enclosingGate) {
        NLELInstanceGate copy = new NLELInstanceGate(this.getName(), enclosingGate, this.memoryAccessor);
        copy.setParameters(this.getParameters().getCopy());
        copy.setLabel(this.getLabel());
        copy.setKind(this.getKind());
        ((NLGate)copy).setMapping(this.getMapping());
        return copy;
    }

    @Override
    public void goToDeclaration(IProject project, boolean activateEditor) {
        DiagramInstanceWrapper mapping2 = this.getMapping(DiagramInstanceWrapper.class);
        if (mapping2 == null) {
            return;
        }
        Collection<GoToInfo> goToDeclaration = NLFactory.createGoTo(this.getDesign(), mapping2.getHierarchyPath());
        if (goToDeclaration != null && !goToDeclaration.isEmpty()) {
            for (GoToInfo marker : goToDeclaration) {
                marker.open(project, activateEditor);
            }
        } else {
            KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.NL_DIAGRAM_ACTION, "Go to declaration null for", this);
        }
    }

    @Override
    public IRfSingleLangProject getRfProject() {
        DiagramInstanceWrapper mapping2 = this.getMapping(DiagramInstanceWrapper.class);
        if (mapping2 == null) {
            return null;
        }
        IRfNamedElement binding = mapping2.getBinding(false);
        if (binding == null) {
            return null;
        }
        return binding.getRfProject();
    }

    @Override
    public String getLastSegmentName() {
        try {
            String fullName = super.getName();
            DiagramInstanceWrapper mapping2 = this.getMapping(DiagramInstanceWrapper.class);
            if (mapping2 == null) {
                return fullName;
            }
            String[] split = fullName.split("\\.");
            if (split.length == 0) {
                return fullName;
            }
            return split[split.length - 1];
        }
        catch (PatternSyntaxException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return super.getName();
        }
    }

    @Override
    public DMemoryAccessor getMemAccessor() {
        return this.memoryAccessor;
    }
}

