/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.netlist.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import ro.amiq.dvt.DVTRefactorConnectWizardInput;
import ro.amiq.dvt.diagrams.DProgressMonitor;
import ro.amiq.dvt.diagrams.design.DRefactoringConnectDiagram;
import ro.amiq.dvt.diagrams.design.DRefactoringDiagram;
import ro.amiq.dvt.diagrams.exceptions.DCanceledException;
import ro.amiq.dvt.diagrams.klay.KLayDiagramDebug;
import ro.amiq.dvt.diagrams.netlist.DMemoryAccessor;
import ro.amiq.dvt.diagrams.netlist.model.NLAbstractBase;
import ro.amiq.dvt.diagrams.netlist.model.NLBundleGate;
import ro.amiq.dvt.diagrams.netlist.model.NLConnection;
import ro.amiq.dvt.diagrams.netlist.model.NLELBundleGate;
import ro.amiq.dvt.diagrams.netlist.model.NLELInstanceGate;
import ro.amiq.dvt.diagrams.netlist.model.NLFlowSequentialLogicGate;
import ro.amiq.dvt.diagrams.netlist.model.NLGate;
import ro.amiq.dvt.diagrams.netlist.model.NLGateKind;
import ro.amiq.dvt.diagrams.netlist.model.NLImplicitGate;
import ro.amiq.dvt.diagrams.netlist.model.NLInstanceGate;
import ro.amiq.dvt.diagrams.netlist.model.NLLogicGate;
import ro.amiq.dvt.diagrams.netlist.model.NLLogicStatement;
import ro.amiq.dvt.diagrams.netlist.model.NLPDInstanceGate;
import ro.amiq.dvt.diagrams.netlist.model.NLPDSwitchGate;
import ro.amiq.dvt.diagrams.netlist.model.NLParameters;
import ro.amiq.dvt.diagrams.netlist.model.NLPort;
import ro.amiq.dvt.diagrams.netlist.model.NLPortGate;
import ro.amiq.dvt.diagrams.netlist.model.NLPortLabelOptions;
import ro.amiq.dvt.diagrams.netlist.model.NLRefactoringGate;
import ro.amiq.dvt.diagrams.netlist.model.NLRefactoringPort;
import ro.amiq.dvt.diagrams.netlist.model.NLTCBundleGate;
import ro.amiq.dvt.diagrams.netlist.model.NLTCInstanceGate;
import ro.amiq.dvt.diagrams.netlist.utils.NLBusUtils;
import ro.amiq.dvt.diagrams.netlist.utils.NLFiltersProcessors;
import ro.amiq.dvt.diagrams.netlist.utils.NLProcessors;
import ro.amiq.dvt.diagrams.netlist.utils.NLUtils;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.model.DiagramInstanceWrapper;
import ro.amiq.dvt.logic.form.LogicForm;
import ro.amiq.dvt.logic.form.model.LFFanIn;
import ro.amiq.dvt.logic.form.model.LFProgram;
import ro.amiq.dvt.logic.form.model.LFResolvedFanIn;
import ro.amiq.dvt.model.reflection.DummyInstance;
import ro.amiq.dvt.model.reflection.DummyPort;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.GoToInfoWithBreadcrumbElement;
import ro.amiq.dvt.model.reflection.HierarchicalElement;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfListType;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.RfDummyElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.model.reflection.util.PortConnectionUtils;
import ro.amiq.dvt.power.format.DVTPFInfo;
import ro.amiq.dvt.power.format.DVTPFIsolationStrategyInfo;
import ro.amiq.dvt.power.format.DVTPFModel;
import ro.amiq.dvt.power.format.DVTPFSupplyNetInfo;
import ro.amiq.dvt.power.format.DVTPFSupplyPortInfo;
import ro.amiq.dvt.power.format.upf.DVTUPFPowerSwitchInfo;
import ro.amiq.dvt.power.format.upf.DVTUPFSupplyPortInfo;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.refactor.connect.RefactorInputWrapper;
import ro.amiq.dvt.ui.refactor.designelement.DVTRefactorDesignElementUtils;
import ro.amiq.dvt.ui.refactor.rename.PreviewDiagramInstanceInfo;
import ro.amiq.dvt.ui.refactor.rename.RenameConflictType;
import ro.amiq.dvt.ui.trace.connections.model.TCConnSignal;
import ro.amiq.dvt.ui.trace.connections.model.TCNode;
import ro.amiq.dvt.ui.trace.connections.model.TCStatement;
import ro.amiq.dvt.ui.trace.connections.utils.TCUtils;

public class NLFactory {
    private static final String CONSTANTS_OF = "CONSTANTS_OF_";

    public static NLParameters createParameters() {
        return NLParameters.getDefault();
    }

    public static NLParameters createParameters(Set<NLParameters.NLParametersFlag> initialParameters) {
        NLParameters parameters = NLParameters.getDefault();
        if (initialParameters == null) {
            return parameters;
        }
        for (NLParameters.NLParametersFlag flag : initialParameters) {
            parameters.addFlag(flag);
        }
        return parameters;
    }

    public static NLParameters createParametersWithTopPath(ElementPath topPath) {
        return NLParameters.getDefault().addTopPath(topPath);
    }

    public static NLParameters createTCParameters() {
        return NLParameters.getDefault().removeFlag(NLParameters.NLParametersFlag.IS_VISIBLE);
    }

    public static NLInstanceGate createTopInstance(Object element, NLParameters parameters, DMemoryAccessor memoryAccessor) {
        String elementName = NLUtils.getNLName(element);
        if (elementName == null) {
            return null;
        }
        NLInstanceGate topInstance = null;
        if (element instanceof TCNode) {
            topInstance = new NLTCInstanceGate(elementName, null, memoryAccessor);
        } else if (element instanceof IRfNamedElement) {
            topInstance = NLFactory.isBundleGate(element) ? new NLBundleGate(elementName, null) : new NLInstanceGate(elementName, null);
        } else if (element instanceof DiagramInstanceWrapper) {
            NLInstanceGate nLInstanceGate = topInstance = NLFactory.isBundleGate(element) ? new NLELBundleGate(elementName, null, memoryAccessor) : new NLELInstanceGate(elementName, null, memoryAccessor);
        }
        if (topInstance == null) {
            return null;
        }
        if (NLFactory.initGateInParameters(topInstance, element, parameters != null ? parameters : NLFactory.createParameters()) == null) {
            KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.NL_MODEL_CONSTRUCTION, "Could not init top gate", new Object[0]);
            return null;
        }
        return topInstance;
    }

    private static boolean isBundleGate(Object element) {
        if (element instanceof DiagramInstanceWrapper) {
            return DesignUtils.isInterfaceInstance(element);
        }
        if (element instanceof IRfNamedElement) {
            return DesignUtils.isInterfacePort(element) || DesignUtils.isInterfaceInstance(element) || DesignUtils.isCompositeSignal(element);
        }
        return false;
    }

    public static NLInstanceGate createPFGates(DVTPFModel pfModel, Set<String> selectedPFGateNames) {
        Collection<DVTPFInfo> allPDInfo = pfModel.getAllPDInfo();
        if (allPDInfo == null || allPDInfo.isEmpty()) {
            return null;
        }
        NLInstanceGate topInstance = NLFactory.createTopPFGate(pfModel);
        NLFactory.addPFSubGates(selectedPFGateNames, allPDInfo, topInstance);
        NLFactory.addPFSwitches(pfModel, topInstance);
        NLFactory.addPFConnections(pfModel, topInstance);
        NLFactory.removeUnconnectedPorts(topInstance);
        return topInstance;
    }

    private static void removeUnconnectedPorts(NLInstanceGate topInstance) {
        Collection<NLPort> ports = topInstance.getPorts();
        if (ports == null) {
            return;
        }
        Iterator<NLPort> iterator = ports.iterator();
        while (iterator.hasNext()) {
            NLPort port = iterator.next();
            Collection<NLConnection> connections = port.getConnections();
            if (connections != null && !connections.isEmpty()) continue;
            iterator.remove();
        }
    }

    private static void addPFConnections(DVTPFModel pfModel, NLInstanceGate topInstance) {
        for (DVTPFSupplyNetInfo net : pfModel.getAllSupplyNetInfo()) {
            NLConnection connection = NLFactory.createConnection(net.getName(), net.getName(), topInstance, NLConnection.NLConnectionKind.COMMON_SIGNAL, net.getGotoInfos());
            for (DVTPFSupplyPortInfo port : net.getConnectedPorts()) {
                NLGate domainGate;
                String domainName;
                if (port == null || (domainName = port.getDomainName()) == null || (domainGate = topInstance.getSubGate(domainName)) == null) continue;
                NLPort nlPort = domainGate.getPort(port.getNetName());
                if (nlPort == null) {
                    nlPort = new NLPort(port.getNetName(), domainGate, "out".equals(port.getDirection()) ? NLPort.NLPortDirection.DIR_OUT : NLPort.NLPortDirection.DIR_IN, NLConnection.NLConnectionKind.COMMON_SIGNAL);
                    nlPort.setParameters(NLFactory.createParameters());
                    nlPort.setLabel(port.getLabel());
                    nlPort.setGoToInfo(port.getGotoInfos());
                    nlPort.addFlag(NLParameters.NLParametersFlag.OUTER_VISIBLE);
                    domainGate.addPort(nlPort);
                }
                if (domainGate.hasFlag(NLParameters.NLParametersFlag.IS_FOCUSED)) {
                    connection.addFlag(NLParameters.NLParametersFlag.IS_FOCUSED);
                }
                connection.addTarget(nlPort);
                nlPort.addConnection(connection);
                NLPort topInstancePort = topInstance.getPort(port.getPortName());
                if (topInstancePort == null) continue;
                topInstancePort.addConnection(connection);
                connection.addTarget(topInstancePort);
            }
            topInstance.addSignal(connection);
        }
    }

    private static void addPFSwitches(DVTPFModel pfModel, NLInstanceGate topInstance) {
        for (DVTUPFPowerSwitchInfo powerSwitchInfo : pfModel.getPowerSwitchInfos()) {
            String switchName = powerSwitchInfo.getName();
            NLPDSwitchGate switchGate = new NLPDSwitchGate(switchName, topInstance);
            switchGate.init(powerSwitchInfo);
            switchGate.setLabel(switchName);
            DVTUPFSupplyPortInfo controlPort = powerSwitchInfo.getControlPort();
            if (controlPort != null) {
                NLPort nlPort = new NLPort(controlPort.getNetName(), switchGate, NLPort.NLPortDirection.DIR_NONE, NLConnection.NLConnectionKind.COMMON_SIGNAL);
                nlPort.setParameters(NLFactory.createParameters());
                nlPort.setLabel(controlPort.getLabel());
                nlPort.setGoToInfo(controlPort.getGotoInfos());
                nlPort.addFlag(NLParameters.NLParametersFlag.INNER_VISIBLE);
                switchGate.addPort(nlPort);
            }
            topInstance.addSubGate(switchGate);
        }
    }

    private static void addPFSubGates(Set<String> selectedPDs, Collection<DVTPFInfo> allPDInfo, NLInstanceGate topInstance) {
        for (DVTPFInfo pdInfo : allPDInfo) {
            String powerDomainName = pdInfo.getPowerDomainName();
            NLPDInstanceGate subGate = new NLPDInstanceGate(powerDomainName, topInstance);
            ((NLInstanceGate)subGate).init(pdInfo);
            String label = powerDomainName;
            if (pdInfo.hasMappedDomains()) {
                label = pdInfo.getFullLabel();
            }
            if (pdInfo.hasCpfShutoffCondition()) {
                DVTPFSupplyPortInfo cpfShutoffPort = pdInfo.getCpfShutoffPort();
                NLPort nlPort = new NLPort(cpfShutoffPort.getLabel(), subGate, NLPort.NLPortDirection.DIR_NONE, NLConnection.NLConnectionKind.COMMON_SIGNAL);
                nlPort.setParameters(NLFactory.createParameters());
                nlPort.setLabel(cpfShutoffPort.getLabel());
                nlPort.setGoToInfo(cpfShutoffPort.getGotoInfos());
                nlPort.addFlag(NLParameters.NLParametersFlag.INNER_VISIBLE);
                subGate.addPort(nlPort);
            }
            subGate.setLabel(label);
            if (selectedPDs != null && selectedPDs.contains(powerDomainName)) {
                subGate.addFlag(NLParameters.NLParametersFlag.IS_FOCUSED);
            }
            topInstance.addSubGate(subGate);
        }
    }

    private static NLInstanceGate createTopPFGate(DVTPFModel pfModel) {
        IRfDesignElement topDesign = pfModel.getTopDesign();
        String name = topDesign == null ? "" : topDesign.getName();
        NLPDInstanceGate topInstance = new NLPDInstanceGate(name, null);
        ((NLInstanceGate)topInstance).init(null);
        topInstance.setLabel(name);
        for (DVTPFSupplyPortInfo portInfo : pfModel.getAllExplicitlyDeclaredPorts()) {
            NLPort topInstancePort = new NLPort(portInfo.getNetName(), topInstance, portInfo.getDirection().equals("out") ? NLPort.NLPortDirection.DIR_OUT : NLPort.NLPortDirection.DIR_IN, NLConnection.NLConnectionKind.COMMON_SIGNAL);
            topInstancePort.setParameters(NLFactory.createParameters());
            topInstancePort.setLabel(portInfo.getPortName());
            topInstancePort.setGoToInfo(portInfo.getGotoInfos());
            topInstancePort.addFlag(NLParameters.NLParametersFlag.INNER_VISIBLE);
            topInstance.addPort(topInstancePort);
        }
        return topInstance;
    }

    public static NLInstanceGate createRefactoringGates(DRefactoringDiagram input) {
        try {
            NLRefactoringGate topInstance = NLFactory.createTopRefactoringGate(input);
            NLFactory.addRefactoringSubGates(input, topInstance);
            NLFactory.addRefactoringConnections(topInstance);
            NLFactory.addSideEffectsRecursively(topInstance, false);
            NLFactory.removeConflictSubGates(topInstance);
            if (topInstance.getMapping() == input.getRootElement()) {
                topInstance.setKind(NLGateKind.REFACTORING_INVISIBLE_GATE);
            }
            return topInstance;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return new NLInstanceGate("", null);
        }
    }

    public static NLInstanceGate createRefactoringConnectGates(DRefactoringConnectDiagram input) {
        try {
            NLRefactoringGate topInstance = NLFactory.createTopRefactoringConnectGate(input);
            if (topInstance == null) {
                return new NLInstanceGate("", null);
            }
            NLFactory.createRefactoringConnectSubGates(input, topInstance);
            NLFactory.addConnectionsBetweenRefactoringConnectOKGates(topInstance);
            NLFactory.addConnectionsBetweenRefactoringConnectSideEffects(topInstance);
            NLFactory.addRefactoringConnectConnections(topInstance);
            return topInstance;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return new NLInstanceGate("", null);
        }
    }

    private static void addConnectionsBetweenRefactoringConnectSideEffects(NLRefactoringGate topIntance) {
        Collection<? extends NLGate> subGates = topIntance.getSubGates();
        if (subGates == null || subGates.isEmpty()) {
            return;
        }
        NLAbstractBase firstGate = null;
        NLAbstractBase secondGate = null;
        for (NLGate nLGate : subGates) {
            if (!(nLGate instanceof NLRefactoringGate)) continue;
            NLRefactoringGate refactoringGate = (NLRefactoringGate)nLGate;
            Collection<NLPort> ports = refactoringGate.getPorts();
            if (refactoringGate.getKind() != NLGateKind.REFACTORING_SIDE_EFFECT || ports == null || ports.isEmpty()) continue;
            NLPort.NLPortDirection direction = ports.iterator().next().getDirection();
            if (direction == NLPort.NLPortDirection.DIR_IN) {
                firstGate = refactoringGate;
                continue;
            }
            if (direction != NLPort.NLPortDirection.DIR_OUT) continue;
            secondGate = refactoringGate;
        }
        if (firstGate != null && secondGate != null) {
            NLConnection nLConnection = NLFactory.createConnection(String.valueOf(firstGate.getName()) + "_" + secondGate.getName() + "_side_effect", "", topIntance, NLConnection.NLConnectionKind.COMMON_SIGNAL, null);
            nLConnection.setParameters(NLFactory.createParameters());
            Collection<NLPort> firstGatePorts = ((NLGate)firstGate).getPorts();
            if (firstGatePorts == null || firstGatePorts.isEmpty()) {
                return;
            }
            Collection<NLPort> secondGatePorts = ((NLGate)secondGate).getPorts();
            if (secondGatePorts == null || secondGatePorts.isEmpty()) {
                return;
            }
            NLPort secondGatePort = secondGatePorts.iterator().next();
            nLConnection.addTarget(secondGatePort);
            secondGatePort.addConnection(nLConnection);
            NLPort firstGatePort = firstGatePorts.iterator().next();
            nLConnection.addTarget(firstGatePort);
            firstGatePort.addConnection(nLConnection);
            topIntance.addSignal(nLConnection);
            return;
        }
        for (NLGate nLGate : subGates) {
            if (!(nLGate instanceof NLRefactoringGate)) continue;
            NLFactory.addConnectionsBetweenRefactoringConnectSideEffects((NLRefactoringGate)nLGate);
        }
    }

    private static void addConnectionsBetweenRefactoringConnectOKGates(NLRefactoringGate topIntance) {
        Collection<? extends NLGate> subGates = topIntance.getSubGates();
        if (subGates == null || subGates.isEmpty()) {
            return;
        }
        NLAbstractBase firstGate = null;
        NLAbstractBase secondGate = null;
        for (NLGate nLGate : subGates) {
            NLRefactoringGate refactoringGate;
            if (!(nLGate instanceof NLRefactoringGate) || (refactoringGate = (NLRefactoringGate)nLGate).getKind() != NLGateKind.REFACTORING_OK) continue;
            if (firstGate == null) {
                firstGate = refactoringGate;
                continue;
            }
            if (secondGate != null) continue;
            secondGate = refactoringGate;
        }
        if (firstGate != null && secondGate != null) {
            NLConnection nLConnection = NLFactory.createConnection(String.valueOf(firstGate.getName()) + "_" + secondGate.getName() + "_normal", "", topIntance, NLConnection.NLConnectionKind.COMMON_SIGNAL, null);
            nLConnection.setParameters(NLFactory.createParameters());
            Collection<NLPort> firstGatePorts = ((NLGate)firstGate).getPorts();
            if (firstGatePorts == null || firstGatePorts.isEmpty()) {
                return;
            }
            Collection<NLPort> secondGatePorts = ((NLGate)secondGate).getPorts();
            if (secondGatePorts == null || secondGatePorts.isEmpty()) {
                return;
            }
            NLPort firstGatePort = firstGatePorts.iterator().next();
            nLConnection.addTarget(firstGatePort);
            firstGatePort.addConnection(nLConnection);
            NLPort secondGatePort = secondGatePorts.iterator().next();
            nLConnection.addTarget(secondGatePort);
            secondGatePort.addConnection(nLConnection);
            topIntance.addSignal(nLConnection);
            return;
        }
        if (firstGate == null) {
            return;
        }
        NLFactory.addConnectionsBetweenRefactoringConnectOKGates(firstGate);
    }

    private static void createRefactoringConnectSubGates(DRefactoringConnectDiagram input, NLRefactoringGate topInstance) {
        DVTRefactorConnectWizardInput info = input.getInfo();
        if (info == null) {
            return;
        }
        Set<RefactorInputWrapper> wrappers = input.getResult();
        if (wrappers == null || wrappers.isEmpty()) {
            return;
        }
        for (RefactorInputWrapper refactorInputWrapper : wrappers) {
            NLRefactoringGate workingInstance = topInstance;
            String[] p = refactorInputWrapper.getPath();
            int i = input.getTopIndex();
            while (i < p.length) {
                String[] currentPathWithDummyNode = Arrays.copyOfRange(p, 0, i + 1);
                Object[] currentPath = Arrays.copyOfRange(currentPathWithDummyNode, 1, currentPathWithDummyNode.length);
                IRfNamedElement elementFromPath = DVTRefactorDesignElementUtils.getElementFromSegments((String[])currentPath, input.getProject());
                if (elementFromPath instanceof DummyInstance) {
                    elementFromPath = ((DummyInstance)elementFromPath).design;
                }
                if (elementFromPath != null) {
                    String name = elementFromPath.getName();
                    if (workingInstance.getSubGate(name) != null) {
                        workingInstance = (NLRefactoringGate)workingInstance.getSubGate(name);
                    } else {
                        boolean noPortNeeded;
                        NLRefactoringGate subGate = new NLRefactoringGate(name, workingInstance, NLGateKind.INSTANCE, elementFromPath);
                        if (Arrays.equals(input.getDstPath(), currentPath) || Arrays.equals(input.getSrcPath(), currentPath)) {
                            subGate.setRefactoringStart(true);
                        }
                        String fullName = subGate.getLabel();
                        if (elementFromPath != null) {
                            IRfScopeElement enclosingScope = elementFromPath.getEnclosingScope();
                            while (DesignUtils.isBlock(enclosingScope)) {
                                fullName = enclosingScope.getName() + "." + fullName;
                                enclosingScope = enclosingScope.getEnclosingScope();
                            }
                        }
                        subGate.setLabel(fullName);
                        subGate.setKind(refactorInputWrapper.isSideEffect() ? NLGateKind.REFACTORING_SIDE_EFFECT : NLGateKind.REFACTORING_OK);
                        workingInstance.addSubGate(subGate);
                        Object[] rootPath = input.getRootPath();
                        boolean samePartialPathAsRootPath = Arrays.equals(rootPath, currentPath) || DVTRefactorDesignElementUtils.isSamePartialPath((String[])rootPath, (String[])currentPath);
                        boolean isLeafSideEffectGate = refactorInputWrapper.isSideEffect() && i == p.length - 1;
                        boolean bl = noPortNeeded = samePartialPathAsRootPath && !isLeafSideEffectGate;
                        if (noPortNeeded) {
                            workingInstance = subGate;
                        } else {
                            if (isLeafSideEffectGate && refactorInputWrapper.getConnectionExpression() != null && refactorInputWrapper.getConnectionExpression().contains("FIXME")) {
                                subGate.setKind(NLGateKind.REFACTORING_SIDE_UNCONNECTED);
                            }
                            String portName = refactorInputWrapper.isOutput() ? info.getVlogOutputPortName() : info.getVlogInputPortName();
                            NLRefactoringPort nlPort = new NLRefactoringPort(portName, subGate, refactorInputWrapper.isOutput() ? NLPort.NLPortDirection.DIR_OUT : NLPort.NLPortDirection.DIR_IN, NLConnection.NLConnectionKind.COMMON_EDGE, false);
                            nlPort.setParameters(NLFactory.createParameters());
                            nlPort.addFlag(NLParameters.NLParametersFlag.INNER_VISIBLE);
                            nlPort.addFlag(NLParameters.NLParametersFlag.OUTER_VISIBLE);
                            nlPort.setLabel(portName);
                            subGate.addPort(nlPort);
                            NLFactory.checkHasConflictingPorts(input, info, refactorInputWrapper, (String[])currentPath, elementFromPath, subGate, portName);
                            workingInstance = subGate;
                        }
                    }
                }
                ++i;
            }
        }
    }

    private static void checkHasConflictingPorts(DRefactoringConnectDiagram input, DVTRefactorConnectWizardInput info, RefactorInputWrapper refactorInputWrapper, String[] currentPath, IRfNamedElement elementFromPath, NLRefactoringGate subGate, String portName) {
        if (!(elementFromPath instanceof IRfInstanceElement)) {
            return;
        }
        IRfNamedElement associatedType = ((IRfInstanceElement)elementFromPath).getSpecializedDesign(ElementPath.create(currentPath));
        if (!(associatedType instanceof IRfDesignElement)) {
            return;
        }
        String searchedPort = refactorInputWrapper.isOutput() ? info.getVlogOutputPortName() : info.getVlogInputPortName();
        IRfNamedElement member = associatedType.getMember(searchedPort, null, null, false, false, false, false, false);
        if (member != null && !member.equals(input.getDstPort()) && !member.equals(input.getSrcPort())) {
            NLRefactoringPort conflictingPort = new NLRefactoringPort("+" + portName, subGate, refactorInputWrapper.isOutput() ? NLPort.NLPortDirection.DIR_OUT : NLPort.NLPortDirection.DIR_IN, NLConnection.NLConnectionKind.COMMON_EDGE, true);
            conflictingPort.setParameters(NLFactory.createParameters());
            conflictingPort.addFlag(NLParameters.NLParametersFlag.INNER_VISIBLE);
            conflictingPort.addFlag(NLParameters.NLParametersFlag.OUTER_VISIBLE);
            conflictingPort.setLabel("+" + portName + " [Conflict]");
            subGate.addFlag(NLParameters.NLParametersFlag.IS_REFACTORING_CONFLICT);
            subGate.addPort(conflictingPort);
        }
    }

    private static NLRefactoringGate createTopRefactoringGate(DRefactoringDiagram input) {
        PreviewDiagramInstanceInfo topElement = input.getTopElement();
        if (topElement == null) {
            return new NLRefactoringGate("", null);
        }
        List<IRfNamedElement> instancePath = topElement.getInstancePath();
        if (instancePath == null || instancePath.isEmpty()) {
            return new NLRefactoringGate("", null);
        }
        IRfBreadcrumbElement designElement = instancePath.get(instancePath.size() - 1);
        String name = designElement == null ? "" : designElement.getName();
        NLRefactoringGate topInstance = new NLRefactoringGate(name, null, NLGateKind.DESIGN, designElement);
        NLFactory.addPortsAndFlagsToGate(topElement, topInstance, input.getNewName());
        return topInstance;
    }

    private static NLRefactoringGate createTopRefactoringConnectGate(DRefactoringConnectDiagram input) {
        RefactorInputWrapper topWrapper = input.getTopWrapper();
        if (topWrapper == null) {
            return null;
        }
        String[] topPathWithDummyNode = topWrapper.getPath();
        String[] topPath = Arrays.copyOfRange(topPathWithDummyNode, 1, topPathWithDummyNode.length);
        IRfNamedElement topInstance = DVTRefactorDesignElementUtils.getElementFromSegments(topPath, input.getProject());
        if (topInstance == null) {
            NLRefactoringGate nlRefactoringGate = new NLRefactoringGate("root", null, NLGateKind.REFACTORING_INVISIBLE_GATE, new RfDummyElement("root"));
            return nlRefactoringGate;
        }
        NLGateKind kind = topInstance instanceof IRfInstanceElement ? NLGateKind.INSTANCE : NLGateKind.DESIGN;
        NLRefactoringGate nlRefactoringGate = new NLRefactoringGate(topInstance.getName(), null, kind, topInstance);
        if (topWrapper.isInitialGate()) {
            nlRefactoringGate.setRefactoringStart(true);
        }
        return nlRefactoringGate;
    }

    private static void addRefactoringSubGates(DRefactoringDiagram input, NLRefactoringGate topInstance) {
        List<PreviewDiagramInstanceInfo> previewDiagramInstanceInfos = input.getFullDiagramInfo();
        if (previewDiagramInstanceInfos == null) {
            return;
        }
        for (PreviewDiagramInstanceInfo previewDiagramInstanceInfo : previewDiagramInstanceInfos) {
            NLInstanceGate workingInstance = topInstance;
            List<IRfNamedElement> currentInstancePath = previewDiagramInstanceInfo.getInstancePath();
            if (currentInstancePath == null || currentInstancePath.isEmpty()) continue;
            int j = input.getBreadcrumbStartIndex();
            while (j < currentInstancePath.size()) {
                String name;
                IRfBreadcrumbElement breadcrumbElement = currentInstancePath.get(j);
                if (breadcrumbElement instanceof DummyInstance) {
                    breadcrumbElement = ((DummyInstance)breadcrumbElement).design;
                }
                String string = name = breadcrumbElement == null ? "" : breadcrumbElement.getName();
                if (workingInstance.getSubGate(name) != null) {
                    workingInstance = (NLInstanceGate)workingInstance.getSubGate(name);
                } else {
                    NLRefactoringGate subGate = new NLRefactoringGate(name, workingInstance, NLGateKind.INSTANCE, breadcrumbElement);
                    String fullName = subGate.getLabel();
                    if (breadcrumbElement != null) {
                        IRfScopeElement enclosingScope = breadcrumbElement.getEnclosingScope();
                        while (DesignUtils.isBlock(enclosingScope)) {
                            fullName = String.valueOf(enclosingScope.getName()) + "." + fullName;
                            enclosingScope = enclosingScope.getEnclosingScope();
                        }
                    }
                    subGate.setLabel(fullName);
                    workingInstance.addSubGate(subGate);
                    workingInstance = subGate;
                }
                ++j;
            }
            if (workingInstance.isTopGate()) continue;
            NLFactory.addPortsAndFlagsToGate(previewDiagramInstanceInfo, workingInstance, input.getNewName());
        }
    }

    private static void addPortsAndFlagsToGate(PreviewDiagramInstanceInfo refactoringElement, NLGate workingInstance, String newName) {
        ((NLRefactoringGate)workingInstance).setPortConnections(refactoringElement.getPortConnections());
        ((NLRefactoringGate)workingInstance).setRefactoringStart(refactoringElement.isInitialElement());
        if (refactoringElement.isSideEffect()) {
            workingInstance.setKind(NLGateKind.REFACTORING_SIDE_EFFECT);
        } else {
            workingInstance.setKind(NLGateKind.REFACTORING_OK);
        }
        if (refactoringElement.getRenameConflict() != RenameConflictType.NO_CONFLICT) {
            workingInstance.addFlag(NLParameters.NLParametersFlag.IS_REFACTORING_CONFLICT);
        }
        if (refactoringElement.getModifiedInstancePorts() != null) {
            NLRefactoringPort topInstancePort;
            Map<IRfNamedElement, Boolean> ports;
            if (TestHelper.isTestMode()) {
                ports = new TreeMap<IRfNamedElement, Boolean>((o1, o2) -> {
                    if (o1 == null) {
                        return 1;
                    }
                    if (o2 == null) {
                        return -1;
                    }
                    if (o1.getName() == null) {
                        return 1;
                    }
                    if (o2.getName() == null) {
                        return -1;
                    }
                    return o1.getName().compareTo(o2.getName());
                });
                ports.putAll(refactoringElement.getModifiedInstancePorts());
            } else {
                ports = refactoringElement.getModifiedInstancePorts();
            }
            if (refactoringElement.getRenameConflict() == RenameConflictType.AMBIGUITY_CONFLICT) {
                for (Map.Entry<IRfNamedElement, Boolean> portEntry : ports.entrySet()) {
                    NLRefactoringPort nlPort;
                    IRfNamedElement port = portEntry.getKey();
                    if (!(port instanceof IRfPortElement)) continue;
                    String portName = port.getName();
                    if (workingInstance.getPort(portName) != null) {
                        nlPort = (NLRefactoringPort)workingInstance.getPort(portName);
                    } else {
                        nlPort = new NLRefactoringPort(port.getName(), workingInstance, ((IRfPortElement)port).getDirectionString().equalsIgnoreCase("out") ? NLPort.NLPortDirection.DIR_OUT : NLPort.NLPortDirection.DIR_IN, NLConnection.NLConnectionKind.COMMON_SIGNAL, true);
                        nlPort.setParameters(NLFactory.createParameters());
                        nlPort.setLabel(String.valueOf(portName) + " ->X " + newName + " [CONFLICT]");
                        nlPort.setMapping(port);
                        workingInstance.addPort(nlPort);
                    }
                    if (portEntry.getValue().booleanValue()) {
                        nlPort.doNotAllowParentConnections();
                    }
                    nlPort.addFlag(NLParameters.NLParametersFlag.INNER_VISIBLE);
                    nlPort.addFlag(NLParameters.NLParametersFlag.OUTER_VISIBLE);
                }
                return;
            }
            if (ports.size() != 1) {
                return;
            }
            IRfNamedElement port = ports.keySet().iterator().next();
            String portName = port.getName();
            NLPort.NLPortDirection portDirection = NLPort.NLPortDirection.DIR_IN;
            if (port instanceof IRfPortElement) {
                portDirection = ((IRfPortElement)port).getDirectionString().equalsIgnoreCase("out") ? NLPort.NLPortDirection.DIR_OUT : NLPort.NLPortDirection.DIR_IN;
            } else if (port instanceof IRfFieldElement) {
                NLPort.NLPortDirection nLPortDirection = portDirection = ((IRfFieldElement)port).isOutput() ? NLPort.NLPortDirection.DIR_OUT : NLPort.NLPortDirection.DIR_IN;
            }
            if (refactoringElement.getRenameConflict() == RenameConflictType.DUPLICATE_CONFLICT) {
                NLRefactoringPort nlPort = workingInstance.getPort(portName) != null ? (NLRefactoringPort)workingInstance.getPort(portName) : new NLRefactoringPort(port.getName(), workingInstance, portDirection, port instanceof IRfPortElement ? NLConnection.NLConnectionKind.COMMON_SIGNAL : NLConnection.NLConnectionKind.BUNDLE_EDGE, true);
                nlPort.setParameters(NLFactory.createParameters());
                nlPort.setLabel(String.valueOf(portName) + " ->X " + newName + " [CONFLICT]");
                nlPort.setMapping(port);
                workingInstance.addPort(nlPort);
                nlPort.addFlag(NLParameters.NLParametersFlag.INNER_VISIBLE);
                nlPort.addFlag(NLParameters.NLParametersFlag.OUTER_VISIBLE);
                Object mapping = workingInstance.getMapping();
                if (mapping instanceof IRfNamedElement) {
                    IRfNamedElement assocType;
                    IRfNamedElement namedElement = (IRfNamedElement)mapping;
                    IRfNamedElement conflictingPort = null;
                    conflictingPort = namedElement instanceof IRfInstanceElement ? ((assocType = ((IRfInstanceElement)namedElement).getAssociatedType()) instanceof IRfDesignElement ? assocType.getLocalMember(null, newName, null) : namedElement.getLocalMember(null, newName, null)) : namedElement.getLocalMember(null, newName, null);
                    NLPort.NLPortDirection conflictingPortDirection = NLPort.NLPortDirection.DIR_IN;
                    if (conflictingPort instanceof IRfPortElement) {
                        conflictingPortDirection = ((IRfPortElement)conflictingPort).getDirectionString().equalsIgnoreCase("out") ? NLPort.NLPortDirection.DIR_OUT : NLPort.NLPortDirection.DIR_IN;
                    } else if (conflictingPort instanceof IRfFieldElement) {
                        conflictingPortDirection = ((IRfFieldElement)conflictingPort).isOutput() ? NLPort.NLPortDirection.DIR_OUT : NLPort.NLPortDirection.DIR_IN;
                    }
                    NLRefactoringPort conflictingNLPort = new NLRefactoringPort(newName, workingInstance, conflictingPortDirection, conflictingPort instanceof IRfPortElement ? NLConnection.NLConnectionKind.COMMON_SIGNAL : NLConnection.NLConnectionKind.BUNDLE_EDGE, false);
                    conflictingNLPort.setParameters(NLFactory.createParameters());
                    conflictingNLPort.setLabel(newName);
                    workingInstance.addPort(conflictingNLPort);
                    if (conflictingPort != null) {
                        conflictingNLPort.setMapping(conflictingPort);
                    }
                    conflictingNLPort.addFlag(NLParameters.NLParametersFlag.INNER_VISIBLE);
                    conflictingNLPort.addFlag(NLParameters.NLParametersFlag.OUTER_VISIBLE);
                }
            }
            if (workingInstance.getPort(portName) != null) {
                topInstancePort = (NLRefactoringPort)workingInstance.getPort(portName);
            } else {
                topInstancePort = new NLRefactoringPort(port.getName(), workingInstance, portDirection, port instanceof IRfPortElement ? NLConnection.NLConnectionKind.COMMON_SIGNAL : NLConnection.NLConnectionKind.BUNDLE_EDGE, false);
                topInstancePort.setParameters(NLFactory.createParameters());
                topInstancePort.setLabel(refactoringElement.shouldBeRenamed() ? String.valueOf(port.getName()) + " -> " + newName : port.getName());
                topInstancePort.setMapping(port);
                workingInstance.addPort(topInstancePort);
            }
            topInstancePort.addFlag(NLParameters.NLParametersFlag.INNER_VISIBLE);
            topInstancePort.addFlag(NLParameters.NLParametersFlag.OUTER_VISIBLE);
        }
    }

    private static void addSideEffectsRecursively(NLRefactoringGate topInstance, boolean bellowStart) {
        if (!topInstance.isTopGate()) {
            NLGateKind nLGateKind = topInstance.getEnclosingGate().getKind();
            if (bellowStart && topInstance.getKind() == NLGateKind.REFACTORING_OK && !topInstance.getName().isEmpty() && topInstance.getSourceGates().isEmpty()) {
                topInstance.setKind(NLGateKind.REFACTORING_SIDE_EFFECT);
            }
            if (nLGateKind == NLGateKind.REFACTORING_SIDE_EFFECT && !topInstance.refactoringStart) {
                topInstance.setKind(NLGateKind.REFACTORING_SIDE_EFFECT);
            }
            if (topInstance.getKind() == NLGateKind.INSTANCE && topInstance.getEnclosingGate().getName().isEmpty()) {
                topInstance.setKind(NLGateKind.REFACTORING_SIDE_EFFECT);
            }
        }
        for (NLGate nLGate : topInstance.getSubGates()) {
            if (!(nLGate instanceof NLRefactoringGate)) continue;
            NLFactory.addSideEffectsRecursively((NLRefactoringGate)nLGate, bellowStart || topInstance.isRefactoringStart());
        }
    }

    private static void removeConflictSubGates(NLRefactoringGate topInstance) {
        if (topInstance.hasFlag(NLParameters.NLParametersFlag.IS_REFACTORING_CONFLICT)) {
            topInstance.setSubGates(null);
            topInstance.setSignals(null);
        }
        for (NLGate nLGate : topInstance.getSubGates()) {
            NLFactory.removeConflictSubGates((NLRefactoringGate)nLGate);
        }
    }

    private static void addRefactoringConnections(NLRefactoringGate topInstance) {
        Collection<NLPort> ports = topInstance.getPorts();
        if (ports != null) {
            NLConnection connection = NLFactory.createConnection("", "", topInstance, NLConnection.NLConnectionKind.COMMON_SIGNAL, null);
            for (NLPort nLPort : ports) {
                if (!(nLPort instanceof NLRefactoringPort)) continue;
                connection.setParameters(NLFactory.createParameters());
                connection.addTarget(nLPort);
                nLPort.addConnection(connection);
                for (NLGate nLGate : topInstance.getSubGates()) {
                    if (!(nLGate instanceof NLRefactoringGate)) continue;
                    for (NLPort subGatePort : nLGate.getPorts()) {
                        if (!(subGatePort instanceof NLRefactoringPort)) continue;
                        NLRefactoringPort subGateRefactoringPort = (NLRefactoringPort)subGatePort;
                        if (subGateRefactoringPort.isConflictPort()) {
                            if (!subGateRefactoringPort.allowParentConnection()) continue;
                            connection.addTarget(subGateRefactoringPort);
                            subGateRefactoringPort.addConnection(connection);
                            continue;
                        }
                        List<HidOperator> portConnections = ((NLRefactoringGate)nLGate).getPortConnections();
                        if (portConnections == null || portConnections.isEmpty()) continue;
                        for (IHidOperator iHidOperator : portConnections) {
                            if (iHidOperator == null) continue;
                            if (PortConnectionUtils.isDotStarConnected(iHidOperator) || PortConnectionUtils.isImplicitNamedConnected(iHidOperator)) {
                                connection.addTarget(subGateRefactoringPort);
                                subGateRefactoringPort.addConnection(connection);
                                continue;
                            }
                            Set<IHid> lhHids = iHidOperator.getLHHids(HidFlatteningOption.NONE_EXCLUDED);
                            if (lhHids == null || lhHids.isEmpty()) continue;
                            for (IHid lhHid : lhHids) {
                                Set<IHid> rhHids;
                                IRfNamedElement hidElement = lhHid.getElement();
                                if (hidElement == null || !hidElement.equals(subGateRefactoringPort.getMapping()) || (rhHids = iHidOperator.getRHHids(HidFlatteningOption.NONE_EXCLUDED)) == null || rhHids.isEmpty()) continue;
                                for (IHid rhHid : rhHids) {
                                    IRfNamedElement rhHidElement = rhHid.getElement();
                                    if (rhHidElement == null || !rhHidElement.checkEquals(((NLRefactoringPort)nLPort).getMapping())) continue;
                                    connection.addTarget(subGatePort);
                                    subGatePort.addConnection(connection);
                                }
                            }
                        }
                    }
                }
                topInstance.addSignal(connection);
            }
        }
        Collection<? extends NLGate> subGates = topInstance.getSubGates();
        for (NLGate nLGate : subGates) {
            if (!(nLGate instanceof NLRefactoringGate)) continue;
            NLFactory.addRefactoringConnections((NLRefactoringGate)nLGate);
        }
    }

    private static void addRefactoringConnectConnections(NLRefactoringGate topInstance) {
        boolean isTop;
        Collection<NLPort> ports = topInstance.getPorts();
        boolean bl = isTop = topInstance.getEnclosingGate() != null && topInstance.getEnclosingGate().getKind() == NLGateKind.REFACTORING_INVISIBLE_GATE;
        if (!isTop && ports != null) {
            NLConnection connection = NLFactory.createConnection("", "", topInstance, NLConnection.NLConnectionKind.COMMON_SIGNAL, null);
            for (NLPort nLPort : ports) {
                if (!(nLPort instanceof NLRefactoringPort)) continue;
                connection.setParameters(NLFactory.createParameters());
                connection.addTarget(nLPort);
                nLPort.addConnection(connection);
                for (NLGate nLGate : topInstance.getSubGates()) {
                    if (!(nLGate instanceof NLRefactoringGate)) continue;
                    for (NLPort subGatePort : nLGate.getPorts()) {
                        NLRefactoringPort subGateRefactoringPort;
                        if (!(subGatePort instanceof NLRefactoringPort) || (subGateRefactoringPort = (NLRefactoringPort)subGatePort).isConflictPort()) continue;
                        connection.addTarget(subGateRefactoringPort);
                        subGateRefactoringPort.addConnection(connection);
                    }
                }
                topInstance.addSignal(connection);
            }
        }
        Collection<? extends NLGate> subGates = topInstance.getSubGates();
        for (NLGate nLGate : subGates) {
            if (!(nLGate instanceof NLRefactoringGate)) continue;
            NLFactory.addRefactoringConnectConnections((NLRefactoringGate)nLGate);
        }
    }

    private static NLInstanceGate createInstanceGate(Object element, String elementName, NLGate enclosingGate, DMemoryAccessor memoryAccessor) {
        NLInstanceGate instanceGate = null;
        instanceGate = element instanceof DiagramInstanceWrapper ? new NLELInstanceGate(elementName, (NLInstanceGate)enclosingGate, memoryAccessor) : new NLInstanceGate(elementName, (NLInstanceGate)enclosingGate);
        NLParameters parameters = NLUtils.isDiagramsShowConstants(enclosingGate) ? NLFactory.createParameters(Collections.singleton(NLParameters.NLParametersFlag.SCHEMATIC_SHOW_CONSTANTS)) : NLFactory.createParameters();
        return (NLInstanceGate)NLFactory.initGateInParameters(instanceGate, element, parameters);
    }

    private static NLTCInstanceGate createTCInstanceGate(Object element, String elementName, NLGate enclosingGate, DMemoryAccessor memAccessor) {
        NLTCInstanceGate instanceGate = new NLTCInstanceGate(elementName, (NLInstanceGate)enclosingGate, memAccessor);
        return (NLTCInstanceGate)NLFactory.initGateInParameters(instanceGate, element, NLFactory.createTCParameters());
    }

    private static NLTCBundleGate createTCBundleGate(Object element, String elementName, NLGate enclosingGate, DMemoryAccessor memAccessor) {
        NLTCBundleGate instanceGate = new NLTCBundleGate(elementName, (NLInstanceGate)enclosingGate, memAccessor);
        return (NLTCBundleGate)NLFactory.initGateInParameters(instanceGate, element, NLFactory.createTCParameters());
    }

    private static NLPortGate createPortGate(Object element, String elementName, NLGate enclosingGate) {
        NLPortGate portGate = new NLPortGate(elementName, (NLInstanceGate)enclosingGate);
        return (NLPortGate)NLFactory.initGateInParameters(portGate, element, NLFactory.createParameters());
    }

    private static NLFlowSequentialLogicGate createSequentialLogicGate(Object element, NLGate enclosingGate) {
        NLFlowSequentialLogicGate flowLogicGate = new NLFlowSequentialLogicGate(NLUtils.getSeqNLName(enclosingGate), (NLInstanceGate)enclosingGate);
        return (NLFlowSequentialLogicGate)NLFactory.initGateInParameters(flowLogicGate, element, NLFactory.createParameters());
    }

    private static NLLogicGate createLogicGate(Object element, String elementName, NLGate enclosingGate) {
        NLLogicGate logicGate = new NLLogicGate(elementName, (NLInstanceGate)enclosingGate);
        return (NLLogicGate)NLFactory.initGateInParameters(logicGate, element, NLFactory.createParameters());
    }

    private static NLLogicGate.NLInternalLogicGate createInternalLogicGate(Object element, String elementName, NLGate enclosingGate) {
        NLLogicGate.NLInternalLogicGate logicGate = new NLLogicGate.NLInternalLogicGate(elementName, (NLLogicGate)enclosingGate);
        return (NLLogicGate.NLInternalLogicGate)NLFactory.initGateInParameters(logicGate, element, NLFactory.createParameters());
    }

    private static NLGate createBundleGate(Object element, String elementName, NLGate enclosingGate, DMemoryAccessor memoryAccessor) {
        NLInstanceGate bundleGate = null;
        bundleGate = element instanceof DiagramInstanceWrapper ? new NLELBundleGate(elementName, (NLInstanceGate)enclosingGate, memoryAccessor) : new NLBundleGate(elementName, (NLInstanceGate)enclosingGate);
        return NLFactory.initGateInParameters(bundleGate, element, NLFactory.createParameters());
    }

    protected static void createImplicitGateAndConnection(NLPort connectedPort, NLInstanceGate enclosingGate, TCConnSignal conn) {
        if (enclosingGate == null || connectedPort == null || conn == null) {
            return;
        }
        NLGate connectedGate = connectedPort.getEnclosingGate();
        if (!(connectedGate instanceof NLInstanceGate)) {
            return;
        }
        if (!NLUtils.isDiagramsShowConstants(enclosingGate)) {
            return;
        }
        NLImplicitGate implicitGate = ((NLInstanceGate)connectedGate).getConnectedImplicitGate();
        if (implicitGate == null) {
            implicitGate = (NLImplicitGate)NLFactory.createGate(conn, enclosingGate);
            if (implicitGate == null) {
                return;
            }
            implicitGate.setConnectedGate(connectedGate);
            implicitGate.setName(CONSTANTS_OF + connectedGate);
        }
        String portAndConnectionName = implicitGate.getName() + "." + connectedPort.getName() + "." + NLUtils.getNLName(conn);
        NLPort implicitPort = NLFactory.createPort(portAndConnectionName, "", implicitGate, NLPort.NLPortDirection.DIR_OUT, NLConnection.NLConnectionKind.IMPLICIT_SIGNAL, false, null, NLParameters.NLParametersFlag.OUTER_VISIBLE);
        implicitGate.addPort(implicitPort);
        List<GoToInfo> goToInfo = conn.statement != null ? Collections.singletonList(conn.statement.goToInfo) : null;
        NLConnection connection = NLFactory.createConnection(portAndConnectionName, NLUtils.getNLName(conn), enclosingGate, NLConnection.NLConnectionKind.IMPLICIT_SIGNAL, goToInfo);
        NLFactory.createCommonSignalToPortConnection(implicitPort, connection);
        NLFactory.createCommonSignalToPortConnection(connectedPort, connection);
        enclosingGate.addSignal(connection);
        enclosingGate.addSubGate(implicitGate);
    }

    protected static void createImplicitGateAndConnection(NLPort connectedPort, NLInstanceGate enclosingGate, HidImplicit hidImplicit, TCStatement statement) {
        TCConnSignal conn = TCConnSignal.of(hidImplicit, null, statement, null, null);
        NLFactory.createImplicitGateAndConnection(connectedPort, enclosingGate, conn);
    }

    private static NLGate createImplicitGate(TCConnSignal connSignal, String elementName, NLGate enclosingGate) {
        if (connSignal == null || !(connSignal.signal instanceof HidImplicit)) {
            return null;
        }
        return new NLImplicitGate(elementName, (NLInstanceGate)enclosingGate);
    }

    public static NLGate createGate(Object element, NLGate enclosingGate) {
        return NLFactory.createGate(element, enclosingGate, null);
    }

    public static NLGate createGate(Object element, NLGate enclosingGate, DMemoryAccessor memoryAccessor) {
        String elementName = NLUtils.getNLName(element);
        if (elementName == null || !(enclosingGate instanceof NLInstanceGate)) {
            return null;
        }
        if (element instanceof NLLogicStatement) {
            return NLLogicStatement.FLOW_SEQ.equals(element) ? NLFactory.createSequentialLogicGate(element, enclosingGate) : NLFactory.createLogicGate(element, elementName, enclosingGate);
        }
        if (element instanceof LFResolvedFanIn) {
            return NLFactory.createInternalLogicGate(element, elementName, enclosingGate);
        }
        if (element instanceof TCNode) {
            return DesignUtils.isInterfaceInstance(((TCNode)element).namedElement) ? NLFactory.createTCBundleGate(element, elementName, enclosingGate, memoryAccessor) : NLFactory.createTCInstanceGate(element, elementName, enclosingGate, memoryAccessor);
        }
        if (NLFactory.isBundleGate(element)) {
            return NLFactory.createBundleGate(element, elementName, enclosingGate, memoryAccessor);
        }
        if (element instanceof IRfPortElement) {
            return NLFactory.createPortGate(element, elementName, enclosingGate);
        }
        if (element instanceof IRfNamedElement || element instanceof DiagramInstanceWrapper) {
            return NLFactory.createInstanceGate(element, elementName, enclosingGate, memoryAccessor);
        }
        if (element instanceof TCConnSignal && ((TCConnSignal)element).signal instanceof HidImplicit) {
            return NLFactory.createImplicitGate((TCConnSignal)element, elementName, enclosingGate);
        }
        return null;
    }

    private static NLGate initGateInParameters(NLGate gate, Object element, NLParameters parameters) {
        gate.setParameters(parameters);
        KLayDiagramDebug.debugInfo(KLayDiagramDebug.DebugRegion.NL_MODEL_CONSTRUCTION, "\nInit gate for source ", element);
        if (gate.init(element) == null) {
            gate.dispose();
            KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.NL_MODEL_CONSTRUCTION, "Could not init gate", element);
            return null;
        }
        IRfNamedElement design = NLUtils.getNLDesign(element);
        gate.setLabel(NLFactory.createLabel(element, design, gate));
        return gate;
    }

    public static NLPort createPort(String name, String label, NLGate enclosingGate, NLPort.NLPortDirection direction, NLConnection.NLConnectionKind kind, boolean isUnknownDesignPort, Collection<GoToInfo> sourceInfo, NLParameters.NLParametersFlag ... additionalFlags) {
        if (name == null || enclosingGate == null) {
            return null;
        }
        NLPort port = new NLPort(name, enclosingGate, direction != null ? direction : NLPort.NLPortDirection.DIR_NONE, kind != null ? kind : NLConnection.NLConnectionKind.COMMON_SIGNAL);
        NLParameters parameters = enclosingGate instanceof NLTCInstanceGate ? NLFactory.createTCParameters() : NLFactory.createParameters();
        parameters.setFlag(NLParameters.NLParametersFlag.IS_UNKNOWN_DESIGN_PORT, isUnknownDesignPort);
        if (additionalFlags != null) {
            NLParameters.NLParametersFlag[] nLParametersFlagArray = additionalFlags;
            int n = additionalFlags.length;
            int n2 = 0;
            while (n2 < n) {
                NLParameters.NLParametersFlag nlParametersFlag = nLParametersFlagArray[n2];
                parameters.addFlag(nlParametersFlag);
                ++n2;
            }
        }
        port.setParameters(parameters);
        port.setGoToInfo(sourceInfo);
        port.setLabel(label);
        NLFactory.addPfInfo(name, enclosingGate, port);
        return port;
    }

    private static void addPfInfo(String name, NLGate enclosingGate, NLPort port) {
        DVTPFIsolationStrategyInfo isolationStrategy;
        if (!(enclosingGate instanceof NLInstanceGate)) {
            return;
        }
        NLInstanceGate enclosingInstance = (NLInstanceGate)enclosingGate;
        DVTPFModel pfModel = NLUtils.getPFModel(enclosingInstance);
        if (pfModel == null) {
            return;
        }
        ElementPath gatePath = NLUtils.getGatePathToTop(enclosingInstance);
        String powerDomainName = pfModel.getPDNameForPath(gatePath);
        if (powerDomainName == null) {
            return;
        }
        DVTPFInfo pdInfo = pfModel.getPDInfoForPDName(powerDomainName);
        if (pdInfo == null) {
            return;
        }
        ElementPath portPath = ElementPath.join(gatePath, name);
        String isolationStrategyName = pdInfo.getIsolationStrategyByElement(portPath);
        DVTPFIsolationStrategyInfo dVTPFIsolationStrategyInfo = isolationStrategy = isolationStrategyName != null ? pdInfo.getIsolationStrategyByName(isolationStrategyName) : null;
        if (isolationStrategy != null) {
            port.setPfInfo("[" + isolationStrategyName + ":" + isolationStrategy.getClampValue() + "]");
        }
    }

    public static NLConnection createConnection(String name, String label, NLGate enclosingGate, NLConnection.NLConnectionKind kind, Collection<GoToInfo> sourceInfo) {
        if (name == null || enclosingGate == null) {
            return null;
        }
        NLConnection conn = new NLConnection(name, enclosingGate, kind != null ? kind : NLConnection.NLConnectionKind.COMMON_SIGNAL);
        NLParameters parameters = enclosingGate instanceof NLTCInstanceGate ? NLFactory.createTCParameters() : NLFactory.createParameters();
        conn.setParameters(parameters);
        conn.setGoToInfo(sourceInfo);
        conn.setLabel(label);
        return conn;
    }

    public static boolean createSignalToPortConnection(NLPort ownPort, NLInstanceGate targetGate, IRfNamedElement targetSignal) {
        if (ownPort == null || targetGate == null || targetSignal == null) {
            return false;
        }
        if (targetSignal instanceof HierarchicalElement var3_4) {
            if (targetGate instanceof NLLogicGate) {
                return NLFactory.createInternalInterfaceSignalToPortConnection(ownPort, targetGate, (HierarchicalElement)hierarchicalSignal);
            }
            return NLFactory.createInterfaceSignalToPortConnection(ownPort, targetGate, (HierarchicalElement)hierarchicalSignal);
        }
        return NLFactory.createCommonSignalToPortConnection(ownPort, targetGate.getSignal(targetSignal));
    }

    public static boolean createCommonSignalToPortConnection(NLPort port, NLConnection signal) {
        if (port == null || signal == null) {
            return false;
        }
        if (signal.hasTarget(port)) {
            KLayDiagramDebug.debugInfo(KLayDiagramDebug.DebugRegion.NL_MODEL_CONSTRUCTION, "Signal is already connected to port", signal, port);
            return true;
        }
        signal.addTarget(port);
        port.addConnection(signal);
        return true;
    }

    private static final boolean createInternalInterfaceSignalToPortConnection(NLPort startPort, NLInstanceGate targetGate, HierarchicalElement targetSignal) {
        if (startPort == null || targetGate == null || targetSignal == null) {
            return false;
        }
        NLConnection hierarchicalSignal = NLFactory.getOrCreateHierarchicalSignal(targetGate, targetSignal);
        if (!NLFactory.createCommonSignalToPortConnection(startPort, hierarchicalSignal)) {
            return false;
        }
        boolean success = NLFactory.createBundleGateAndPortConnection(targetGate, targetSignal, hierarchicalSignal);
        if (targetSignal.hasHiddenSegments() && targetGate instanceof NLLogicGate) {
            success &= NLFactory.createConnectionForVisibleSegments(targetGate, targetSignal);
        }
        return success;
    }

    private static final boolean createInterfaceSignalToPortConnection(NLPort startPort, NLInstanceGate targetGate, HierarchicalElement targetSignal) {
        if (startPort == null || targetGate == null || targetSignal == null) {
            return false;
        }
        HierarchicalElement signalToUse = targetSignal;
        if (targetSignal.hasHiddenSegments()) {
            IRfNamedElement segmentsWithoutHidden = targetSignal.getSegmentsWithoutHidden();
            if (!(segmentsWithoutHidden instanceof HierarchicalElement var5_6)) {
                return NLFactory.createCommonSignalToPortConnection(startPort, targetGate.getSignal(segmentsWithoutHidden));
            }
            signalToUse = hierarchicalWithoutHidden;
        }
        if (!NLFactory.createCommonSignalToPortConnection(startPort, hierarchicalSignal = NLFactory.getOrCreateHierarchicalSignal(targetGate, signalToUse))) {
            return false;
        }
        return NLFactory.createBundleGateAndPortConnection(targetGate, signalToUse, hierarchicalSignal);
    }

    private static NLConnection getOrCreateHierarchicalSignal(NLInstanceGate targetGate, HierarchicalElement targetSignal) {
        NLConnection hierarchicalSignal = targetGate.getSignal(targetSignal);
        if (hierarchicalSignal == null) {
            hierarchicalSignal = targetGate.addSignal(NLFactory.createConnection(NLUtils.getNLName(targetSignal), NLUtils.getNLLabel(targetSignal), targetGate, NLConnection.NLConnectionKind.COMMON_SIGNAL, NLFactory.createGoTo(targetSignal, null)));
        }
        return hierarchicalSignal;
    }

    private static final boolean createBundleGateAndPortConnection(NLInstanceGate targetGate, HierarchicalElement targetSignal, NLConnection hierarchicalSignal) {
        Object interfaceParticular = NLFactory.getInterfaceParticular(targetGate, targetSignal);
        NLGate bundleGate = targetGate.getSubGate(interfaceParticular);
        if (bundleGate == null) {
            bundleGate = targetGate.addSubGate(NLFactory.createGate(interfaceParticular, targetGate, targetGate.getMemAccessor()));
        }
        if (bundleGate == null) {
            return false;
        }
        IRfNamedElement signalAccess = targetSignal.getSubPart(1, targetSignal.length());
        NLPort bundleGatePort = bundleGate.getPort(NLUtils.getNLName(signalAccess));
        if (bundleGatePort == null) {
            NLPortLabelOptions portLabelOptions = NLPortLabelOptions.getFromParameters(targetGate.getParameters());
            NLPort port = NLFactory.createPort(NLUtils.getNLName(signalAccess), NLUtils.getNLLabel(signalAccess, portLabelOptions), bundleGate, NLPort.NLPortDirection.DIR_INOUT, NLConnection.NLConnectionKind.COMMON_SIGNAL, false, NLFactory.createGoTo(signalAccess, null), NLParameters.NLParametersFlag.OUTER_VISIBLE);
            if (port != null && portLabelOptions.hasFlag(NLPortLabelOptions.NLPortLabelOptionsFlag.DIAGRAM_SHOW_PORT_FULLY_QUALIFIED_TYPE) && signalAccess instanceof IRfFieldElement var9_10) {
                port.setQualifiedName(fieldElement.getQualifiedNameForDiagram(null));
            }
            bundleGatePort = bundleGate.addPort(port);
        }
        return NLFactory.createCommonSignalToPortConnection(bundleGatePort, hierarchicalSignal);
    }

    private static final boolean createConnectionForVisibleSegments(NLInstanceGate targetGate, HierarchicalElement targetSignal) {
        NLConnection signal;
        NLPort bundlePort;
        IRfNamedElement segmentsWithoutHidden = targetSignal.getSegmentsWithoutHidden();
        Object interfaceParticular = NLFactory.getInterfaceParticular(targetGate, targetSignal);
        NLGate bundleGate = targetGate.getSubGate(interfaceParticular);
        NLPort nLPort = bundlePort = segmentsWithoutHidden == interfaceParticular ? bundleGate.getSameNamedPort() : bundleGate.getPort(segmentsWithoutHidden);
        if (bundlePort == null) {
            NLPortLabelOptions portLabelOptions = NLPortLabelOptions.getFromParameters(targetGate.getParameters());
            bundlePort = NLFactory.createPort(NLUtils.getNLName(segmentsWithoutHidden), NLUtils.getNLLabel(segmentsWithoutHidden, portLabelOptions), bundleGate, NLPort.NLPortDirection.DIR_INOUT, NLConnection.NLConnectionKind.COMMON_SIGNAL, false, NLFactory.createGoTo(segmentsWithoutHidden, null), NLParameters.NLParametersFlag.OUTER_VISIBLE);
            bundleGate.addPort(bundlePort);
        }
        if ((signal = targetGate.getSignal(segmentsWithoutHidden)) == null) {
            signal = targetGate.addSignal(NLFactory.createConnection(NLUtils.getNLName(segmentsWithoutHidden), NLUtils.getNLLabel(segmentsWithoutHidden), targetGate, NLConnection.NLConnectionKind.COMMON_SIGNAL, NLFactory.createGoTo(segmentsWithoutHidden, null)));
        }
        return NLFactory.createCommonSignalToPortConnection(bundlePort, signal);
    }

    private static Object getInterfaceParticular(NLInstanceGate targetGate, HierarchicalElement targetSignal) {
        IRfNamedElement firstSegment = targetSignal.getFirstSegment();
        if (!(targetGate instanceof NLELInstanceGate)) {
            return firstSegment;
        }
        DMemoryAccessor memAccessor = ((NLELInstanceGate)targetGate).getMemAccessor();
        if (memAccessor == null) {
            return firstSegment;
        }
        Object mapping = targetGate.getMapping();
        if (!(mapping instanceof DiagramInstanceWrapper)) {
            return firstSegment;
        }
        DiagramInstanceWrapper wrapper = (DiagramInstanceWrapper)mapping;
        ElementPath hierarchyPath = wrapper.getHierarchyPath();
        if (hierarchyPath == null || hierarchyPath.isEmpty()) {
            return firstSegment;
        }
        ElementPath interfacePath = ElementPath.join(hierarchyPath, firstSegment.getName());
        ELInstance instance = memAccessor.getInstanceFor(interfacePath);
        if (instance == null) {
            return firstSegment;
        }
        return new DiagramInstanceWrapper(instance);
    }

    public static NLConnection createSignalExpressionSignal(LogicForm signalExpression, TCStatement statement, NLInstanceGate enclosingGate, boolean fromOutputPort) {
        if (signalExpression == null || statement == null || enclosingGate == null) {
            return null;
        }
        LFProgram firstProg = signalExpression.content.get(0);
        if (!(firstProg instanceof LFProgram.LFAtomicProgram)) {
            return null;
        }
        LFFanIn fanIn = ((LFProgram.LFAtomicProgram)firstProg).fan;
        IHid signalExprHid = fromOutputPort ? fanIn.getBorder().get(0) : fanIn.getCenter();
        IRfNamedElement loadSignal = NLUtils.resolveSignal(signalExprHid, null, null, false, null);
        if (!(loadSignal instanceof DummyPort)) {
            return null;
        }
        DummyPort dummy = (DummyPort)loadSignal;
        NLConnection dummySignal = enclosingGate.getSignal(dummy);
        if (dummySignal == null) {
            dummySignal = enclosingGate.addSignal(NLFactory.createConnection(NLUtils.getNLName(dummy), NLUtils.getNLLabel(dummy), enclosingGate, NLConnection.NLConnectionKind.COMMON_SIGNAL, Collections.singleton(statement.goToInfo)));
        }
        return dummySignal;
    }

    public static boolean removeSignalToPortConnection(NLPort portBit, NLConnection signal) {
        if (portBit == null || signal == null) {
            return false;
        }
        return signal.removeTarget(portBit) && portBit.removeConnection(signal);
    }

    public static Collection<GoToInfo> createGoTo(Object element, IRfBreadcrumbElement bcElement) {
        if (element instanceof NLLogicStatement) {
            return Collections.singleton(((NLLogicStatement)element).statement.goToInfo);
        }
        if (element instanceof TCNode) {
            element = ((TCNode)element).namedElement;
        }
        if (element instanceof LFResolvedFanIn) {
            element = ((LFResolvedFanIn)element).getMarker();
        }
        if (element instanceof IRfNamedElement) {
            return Collections.singleton(GoToInfoWithBreadcrumbElement.sourceOf((IRfNamedElement)element, bcElement));
        }
        if (element instanceof DiagramInstanceWrapper) {
            return Collections.singleton(GoToInfoWithBreadcrumbElement.sourceOf(((DiagramInstanceWrapper)element).getDescription(), bcElement));
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static String createLabel(Object ... elements) {
        void var3_3;
        Object object;
        Object node;
        if (elements == null) {
            return "";
        }
        if (elements.length == 1) {
            return NLUtils.getNLLabel(elements[0]);
        }
        String prefix = "";
        if (elements[0] instanceof TCNode) {
            node = (TCNode)elements[0];
            if (TCUtils.getELMemory((TCNode)node) != null) {
                if (((TCNode)node).genBlockPrefixForDiagram != null) {
                    prefix = ((TCNode)node).genBlockPrefixForDiagram;
                }
                if (((TCNode)node).namedElement instanceof IRfInstanceElement && ((IRfInstanceElement)((TCNode)node).namedElement).isArray()) {
                    return String.valueOf(prefix) + NLUtils.getDesignNLInstanceLabel(((TCNode)node).getLabel(), (IRfInstanceElement)((TCNode)node).namedElement, (IRfNamedElement)elements[1], ((TCNode)node).getElementPath());
                }
            }
            elements[0] = ((TCNode)node).namedElement;
        }
        if (elements.length >= 3 && (object = elements[2]) instanceof NLBundleGate && (node = (NLBundleGate)object) == (NLBundleGate)var3_3) {
            void field;
            IRfNamedElement type;
            void bundleGate;
            StringBuilder gateLabel = new StringBuilder().append(NLUtils.getDesignNLLabel((IRfNamedElement)elements[0], (IRfNamedElement)elements[1], null));
            IRfNamedElement mapping = bundleGate.getMapping(IRfNamedElement.class);
            if (bundleGate.isBusGate() && ( instanceOfPatternExpressionValue = mapping) instanceof IRfFieldElement var6_7 && (type = field.getAssociatedType()) instanceof IRfListType) {
                gateLabel.append("[]");
            }
            NLBusUtils.appendBusLabel((NLBundleGate)bundleGate, gateLabel);
            return String.valueOf(prefix) + gateLabel;
        }
        if (elements[0] instanceof IRfNamedElement && (elements[1] == null || elements[1] instanceof IRfNamedElement)) {
            return String.valueOf(prefix) + NLUtils.getDesignNLLabel((IRfNamedElement)elements[0], (IRfNamedElement)elements[1], null);
        }
        if (elements[0] instanceof DiagramInstanceWrapper && (elements[1] == null || elements[1] instanceof IRfNamedElement)) {
            return NLUtils.getDesignNLLabel((DiagramInstanceWrapper)elements[0], (IRfNamedElement)elements[1]);
        }
        return "";
    }

    public static NLInstanceGate createTopInstanceFromPort(Object element, IRfNamedElement portParent, IRfPortElement port, NLParameters parameters, DMemoryAccessor memoryAccessor, DProgressMonitor monitor) throws DCanceledException {
        NLInstanceGate topInstance = NLFactory.createTopInstance(element, parameters, memoryAccessor);
        if (topInstance == null) {
            return null;
        }
        if (portParent != memoryAccessor.getNamedElement(element)) {
            NLProcessors.expandToDepth(topInstance, 1, new HashSet<Object>(), monitor);
            NLFiltersProcessors.hideEverything(topInstance, monitor);
            for (NLGate nLGate : topInstance.getSubGates()) {
                if (!nLGate.getLastSegmentName().equals(portParent.getName())) continue;
                for (NLPort nlPort : nLGate.getPorts()) {
                    if (!nlPort.getName().equals(port.getNameForDiagram())) continue;
                    nlPort.addFlag(NLParameters.NLParametersFlag.IS_ACTION_SELECTED);
                }
            }
        } else {
            for (NLPort nLPort : topInstance.getPorts()) {
                if (!nLPort.getName().equals(port.getNameForDiagram())) continue;
                nLPort.addFlag(NLParameters.NLParametersFlag.IS_ACTION_SELECTED);
            }
        }
        return topInstance;
    }
}

