/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.netlist.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.diagrams.klay.KLayDiagramDebug;
import ro.amiq.dvt.diagrams.netlist.model.INLViewLabeled;
import ro.amiq.dvt.diagrams.netlist.model.INLViewSelectable;
import ro.amiq.dvt.diagrams.netlist.model.NLAbstractBase;
import ro.amiq.dvt.diagrams.netlist.model.NLConnection;
import ro.amiq.dvt.diagrams.netlist.model.NLFactory;
import ro.amiq.dvt.diagrams.netlist.model.NLGateKind;
import ro.amiq.dvt.diagrams.netlist.model.NLInstanceGate;
import ro.amiq.dvt.diagrams.netlist.model.NLParameters;
import ro.amiq.dvt.diagrams.netlist.model.NLPort;
import ro.amiq.dvt.diagrams.netlist.utils.NLConfiguration;
import ro.amiq.dvt.diagrams.netlist.utils.NLUtils;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.NotNull;

public abstract class NLGate
extends NLAbstractBase
implements INLViewSelectable,
INLViewLabeled,
Comparable<NLGate> {
    protected Object mapping;
    protected Map<String, NLPort> ports;
    protected NLGateKind kind;

    protected NLGate(String name, NLGate enclosingGate) {
        super(name, enclosingGate);
        this.copyParametersFromEnclosing(enclosingGate);
    }

    private void copyParametersFromEnclosing(NLGate enclosingGate) {
        if (enclosingGate == null) {
            return;
        }
        NLParameters enclosingGateParameters = enclosingGate.getParameters();
        if (enclosingGateParameters == null) {
            return;
        }
        this.setParameters(NLParameters.getDefault());
        this.getParameters().setFlag(NLParameters.NLParametersFlag.DIAGRAM_SHOW_PORT_WIDTH, enclosingGateParameters.hasSchematicShowPortWidth());
        this.getParameters().setFlag(NLParameters.NLParametersFlag.DIAGRAM_SHOW_PORT_FULLY_QUALIFIED_NAME, enclosingGateParameters.hasSchematicShowPortFullyQualifiedType());
    }

    protected abstract NLGate init(Object var1);

    protected boolean isInit() {
        return this.kind != null;
    }

    public abstract NLGate getCopy(NLInstanceGate var1);

    protected void setMapping(Object mapping) {
        this.mapping = mapping;
    }

    public Object getMapping() {
        return this.mapping;
    }

    public <T> T getMapping(Class<T> type) {
        if (type == null) {
            return null;
        }
        Object mapping = this.getMapping();
        if (!type.isInstance(mapping)) {
            return null;
        }
        return type.cast(mapping);
    }

    public boolean isTopGate() {
        return this.getEnclosingGate() == null;
    }

    public boolean isUnconnectedGate() {
        if (!this.hasPorts()) {
            return true;
        }
        for (NLPort port : this.getPorts()) {
            if (!port.hasConnections()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(NLGate o) {
        return this.getName().compareTo(o.getName());
    }

    @Override
    public NLInstanceGate getEnclosingGate() {
        return (NLInstanceGate)super.getEnclosingGate();
    }

    @Override
    public NLInstanceGate getEnclosingGateExcludingGenerateBlocks() {
        NLGate enclosingGate = super.getEnclosingGateExcludingGenerateBlocks();
        if (enclosingGate instanceof NLInstanceGate) {
            return (NLInstanceGate)enclosingGate;
        }
        return null;
    }

    public boolean hasPorts() {
        return this.ports != null && !this.ports.isEmpty();
    }

    public boolean hasPorts(NLPort.NLPortDirection direction) {
        return this.ports != null && !this.ports.isEmpty() && this.ports.values().stream().filter(port -> port != null && port.getDirection() == direction).findAny().isPresent();
    }

    public NLPort getPort(String name) {
        if (name == null) {
            return null;
        }
        return this.ports != null ? this.ports.get(name) : null;
    }

    public NLPort getPort(IRfNamedElement port) {
        return this.getPort(NLUtils.getNLName(port));
    }

    @NotNull
    public Collection<NLPort> getPorts() {
        if (this.ports == null) {
            return Collections.emptySet();
        }
        return this.ports.values();
    }

    public NLPort addPort(NLPort port) {
        if (port == null) {
            return null;
        }
        if (this.ports == null) {
            this.ports = new LinkedHashMap<String, NLPort>();
        }
        this.ports.put(port.getName(), port);
        return port;
    }

    protected void addSameNamedSignalAndPort(NLConnection.NLConnectionKind signalKind) {
        NLConnection sameNamedSignal;
        String name = this.getName();
        NLPort newPort = this.addPort(NLFactory.createPort(NLUtils.getSameNamedPortName(name), "", this, NLPort.INTERNAL_SAME_NAMED_PORT_DIRECTION, signalKind, false, this.getGoToSource(), NLParameters.NLParametersFlag.OUTER_VISIBLE));
        if (newPort == null) {
            return;
        }
        NLInstanceGate enclosingGate = this.getEnclosingGate();
        if (enclosingGate == null) {
            return;
        }
        int index = name.indexOf("[");
        if (index > 0) {
            name = name.substring(0, index);
        }
        if ((sameNamedSignal = enclosingGate.getSignal(name)) == null) {
            sameNamedSignal = enclosingGate.addSignal(NLFactory.createConnection(name, NLUtils.getNLLabel(name), enclosingGate, signalKind, this.getGoToSource()));
        } else {
            sameNamedSignal.setKind(signalKind);
        }
        NLFactory.createCommonSignalToPortConnection(newPort, sameNamedSignal);
        KLayDiagramDebug.debugInfo(KLayDiagramDebug.DebugRegion.NL_MODEL_CONSTRUCTION, "Added same named signal and port", name);
    }

    public NLPort getSameNamedPort() {
        if (this.ports == null || this.ports.isEmpty()) {
            return null;
        }
        return this.ports.get(NLUtils.getSameNamedPortName(this.getName()));
    }

    public boolean makeConnection(NLPort ownPort, NLInstanceGate targetGate, IRfNamedElement targetSignal) {
        return NLFactory.createSignalToPortConnection(ownPort, targetGate, targetSignal);
    }

    public void makeFlowEdgeConnection(Collection<NLGate> destinationGates, Set<NLConfiguration> config, NLConnection signal, boolean forceIsBidir, NLInstanceGate topGate) {
        String reverseEdgeName;
        boolean destinationIsTop;
        if (destinationGates == null || destinationGates.isEmpty()) {
            return;
        }
        ArrayList<NLGate> destinations = new ArrayList<NLGate>(destinationGates);
        Collections.sort(destinations);
        NLInstanceGate enclosingGate = this.getEnclosingGate();
        if (enclosingGate == null && topGate == null) {
            return;
        }
        if (topGate != null) {
            enclosingGate = topGate;
        }
        if (enclosingGate == null) {
            return;
        }
        NLGate sourceGate = this;
        sourceGate.addFlag(NLParameters.NLParametersFlag.IS_GATE_WITH_FLOW_CONNECTION);
        List<NLGate> sourceGates = Arrays.asList(sourceGate);
        boolean sourceIsTop = topGate != null && sourceGate.equals(topGate);
        boolean bl = destinationIsTop = topGate != null && !sourceGate.equals(topGate);
        String newEdgeName = NLUtils.getFlowEdgeName(sourceGates, destinations, sourceIsTop ? NLPort.NLPortDirection.DIR_IN : (destinationIsTop ? NLPort.NLPortDirection.DIR_OUT : NLPort.NLPortDirection.DIR_NONE));
        NLConnection newEdge = enclosingGate.getSignal(newEdgeName);
        if (newEdge != null) {
            newEdge.addFlowSignal(signal);
            return;
        }
        if (config.contains((Object)NLConfiguration.FLOW_COLLAPSE_BIDIRECTIONAL_EDGES) && (newEdge = enclosingGate.getSignal(reverseEdgeName = NLUtils.getFlowEdgeName(destinations, sourceGates, sourceIsTop ? NLPort.NLPortDirection.DIR_IN : (destinationIsTop ? NLPort.NLPortDirection.DIR_OUT : NLPort.NLPortDirection.DIR_NONE)))) != null) {
            newEdge.addFlowSignal(signal);
            newEdge.addFlag(NLParameters.NLParametersFlag.IS_BIDIRECTIONAL_EDGE);
            KLayDiagramDebug.debugInfo(KLayDiagramDebug.DebugRegion.FLOW_DIAGRAM_CONSTRUCTION, "Flow edge is bidirectional", newEdge);
            return;
        }
        NLConnection.NLConnectionKind edgeKind = NLConnection.NLConnectionKind.COMMON_EDGE;
        newEdge = enclosingGate.addSignal(NLFactory.createConnection(newEdgeName, newEdgeName, enclosingGate, edgeKind, null));
        newEdge.addFlowSignal(signal);
        NLPort edgeSourcePort = sourceGate.getPort(newEdgeName);
        if (edgeSourcePort == null) {
            edgeSourcePort = sourceGate.addPort(NLFactory.createPort(newEdgeName, "", this, sourceIsTop ? NLPort.NLPortDirection.DIR_IN : NLPort.NLPortDirection.DIR_OUT, edgeKind, false, null, sourceIsTop ? NLParameters.NLParametersFlag.INNER_VISIBLE : NLParameters.NLParametersFlag.OUTER_VISIBLE));
        }
        NLFactory.createCommonSignalToPortConnection(edgeSourcePort, newEdge);
        for (NLGate destinationGate : destinations) {
            String selfLoopPortName;
            destinationGate.addFlag(NLParameters.NLParametersFlag.IS_GATE_WITH_FLOW_CONNECTION);
            NLPort edgeDestinationPort = destinationGate.getPort(newEdgeName);
            if (edgeDestinationPort == null) {
                edgeDestinationPort = destinationGate.addPort(NLFactory.createPort(newEdgeName, "", destinationGate, destinationIsTop ? NLPort.NLPortDirection.DIR_OUT : NLPort.NLPortDirection.DIR_IN, edgeKind, false, null, destinationIsTop ? NLParameters.NLParametersFlag.INNER_VISIBLE : NLParameters.NLParametersFlag.OUTER_VISIBLE));
            }
            if (edgeDestinationPort == edgeSourcePort && (edgeDestinationPort = destinationGate.getPort(selfLoopPortName = NLUtils.getSelfLoopPortName(newEdgeName))) == null) {
                edgeDestinationPort = destinationGate.addPort(NLFactory.createPort(selfLoopPortName, "", destinationGate, NLPort.NLPortDirection.DIR_OUT, edgeKind, false, null, destinationIsTop ? NLParameters.NLParametersFlag.INNER_VISIBLE : NLParameters.NLParametersFlag.OUTER_VISIBLE));
            }
            NLFactory.createCommonSignalToPortConnection(edgeDestinationPort, newEdge);
            KLayDiagramDebug.debugInfo(KLayDiagramDebug.DebugRegion.FLOW_DIAGRAM_CONSTRUCTION, "Transformed signal to edge", newEdgeName);
        }
        if (forceIsBidir) {
            newEdge.addFlag(NLParameters.NLParametersFlag.IS_BIDIRECTIONAL_EDGE);
        }
    }

    public boolean isSequentialAlwaysBlock() {
        return false;
    }

    @NotNull
    public List<NLPort> getSourcePorts() {
        ArrayList<NLPort> sourcePorts = new ArrayList<NLPort>();
        for (NLPort ownPort : this.getPorts()) {
            if (!NLUtils.isDestinationPort(ownPort)) continue;
            for (NLConnection connection : ownPort.getConnections()) {
                sourcePorts.addAll(connection.getSourcePorts());
            }
            sourcePorts.remove(ownPort);
        }
        return sourcePorts;
    }

    @NotNull
    public List<NLPort> getDestinationPorts() {
        ArrayList<NLPort> destinationPorts = new ArrayList<NLPort>();
        for (NLPort ownPort : this.getPorts()) {
            if (!NLUtils.isSourcePort(ownPort)) continue;
            for (NLConnection connection : ownPort.getConnections()) {
                destinationPorts.addAll(connection.getDestinationPorts());
            }
            destinationPorts.remove(ownPort);
        }
        return destinationPorts;
    }

    @NotNull
    public List<NLGate> getSourceGates() {
        ArrayList<NLGate> sourceGates = new ArrayList<NLGate>();
        for (NLPort sourcePort : this.getSourcePorts()) {
            sourceGates.add(sourcePort.getEnclosingGate());
        }
        sourceGates.remove(this);
        return sourceGates;
    }

    @NotNull
    public List<NLGate> getDestinationGates() {
        ArrayList<NLGate> destinationGates = new ArrayList<NLGate>();
        for (NLPort destinationPort : this.getDestinationPorts()) {
            destinationGates.add(destinationPort.getEnclosingGate());
        }
        destinationGates.remove(this);
        return destinationGates;
    }

    public boolean hasAncestor(NLGate gate) {
        if (gate == null) {
            return false;
        }
        NLInstanceGate enclosingGate = this.getEnclosingGate();
        do {
            if (enclosingGate != gate) continue;
            return true;
        } while (enclosingGate != null && (enclosingGate = enclosingGate.getEnclosingGate()) != null);
        return false;
    }

    public NLGate getClosestAncestorInstanceSkippingBlocks() {
        if (this.kind == NLGateKind.INSTANCE) {
            return this;
        }
        NLInstanceGate parent = this.getEnclosingGate();
        while (parent != null) {
            switch (parent.kind) {
                case BLOCK: {
                    break;
                }
                case INSTANCE: {
                    return parent;
                }
                default: {
                    return null;
                }
            }
            parent = parent.getEnclosingGate();
        }
        return null;
    }

    public void setKind(NLGateKind kind) {
        this.kind = kind;
    }

    public NLGateKind getKind() {
        return this.kind;
    }

    @Override
    public void setParameters(NLParameters parameters) {
        Boolean showPortWidthInfo = null;
        Boolean showPortFullyQualifiedType = null;
        if (this.getParameters() != null) {
            showPortWidthInfo = this.getParameters().hasSchematicShowPortWidth();
            showPortFullyQualifiedType = this.getParameters().hasSchematicShowPortFullyQualifiedType();
        }
        super.setParameters(parameters);
        if (showPortWidthInfo != null && showPortFullyQualifiedType != null) {
            parameters.setFlag(NLParameters.NLParametersFlag.DIAGRAM_SHOW_PORT_WIDTH, showPortWidthInfo);
            parameters.setFlag(NLParameters.NLParametersFlag.DIAGRAM_SHOW_PORT_FULLY_QUALIFIED_NAME, showPortFullyQualifiedType);
        }
    }

    @Override
    public boolean hasGoToSource() {
        Collection<GoToInfo> goToInfo = this.getGoToSource();
        if (goToInfo == null || goToInfo.isEmpty()) {
            KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.NL_DIAGRAM_ACTION, "Go to source null for", this);
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.kind == null ? 0 : this.kind.hashCode());
        result = 31 * result + (this.mapping == null ? 0 : this.mapping.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        NLGate other = (NLGate)obj;
        if (this.kind != other.kind) {
            return false;
        }
        if (this.mapping == null ? other.mapping != null : !this.mapping.equals(other.mapping)) {
            return false;
        }
        NLInstanceGate thisEnclosingGate = this.getEnclosingGate();
        NLInstanceGate otherEnclosingGate = other.getEnclosingGate();
        return !(thisEnclosingGate == null ? otherEnclosingGate != null : !thisEnclosingGate.equals(otherEnclosingGate));
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    protected void dispose() {
        super.dispose();
        this.mapping = null;
        if (this.ports != null) {
            for (NLPort port : this.getPorts()) {
                port.dispose();
            }
            this.ports = null;
        }
        this.label = null;
    }
}

