/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.netlist.model;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import ro.amiq.dvt.diagrams.netlist.model.NLConnection;
import ro.amiq.dvt.diagrams.netlist.model.NLFactory;
import ro.amiq.dvt.diagrams.netlist.model.NLGate;
import ro.amiq.dvt.diagrams.netlist.model.NLGateKind;
import ro.amiq.dvt.diagrams.netlist.model.NLInstanceGate;
import ro.amiq.dvt.diagrams.netlist.model.NLParameters;
import ro.amiq.dvt.diagrams.netlist.model.NLPort;
import ro.amiq.dvt.model.reflection.GoToInfo;

public class NLImplicitGate
extends NLInstanceGate {
    private static final Set<String> RESERVED_WORDS = Set.of("default", "others");
    private NLGate connectedGate;

    protected NLImplicitGate(String name, NLInstanceGate enclosingGate) {
        super(name, enclosingGate);
        this.setParameters(NLFactory.createParameters());
        this.setKind(NLGateKind.IMPLICIT);
    }

    public NLGate getConnectedGate() {
        return this.connectedGate;
    }

    public void setConnectedGate(NLGate connectedGate) {
        this.connectedGate = connectedGate;
    }

    @Override
    public Collection<GoToInfo> getGoToSource() {
        return Collections.emptyList();
    }

    @Override
    public NLGate getCopy(NLInstanceGate enclosingGate) {
        NLImplicitGate copy = new NLImplicitGate(this.getName(), enclosingGate);
        copy.setParameters(this.getParameters().getCopy());
        copy.setLabel(this.getLabel());
        copy.setKind(this.getKind());
        ((NLGate)copy).setMapping(this.getMapping());
        return copy;
    }

    public boolean hasAllSignalsInvisible() {
        for (NLPort port : this.getPorts()) {
            for (NLConnection connection : port.getConnections()) {
                if (!connection.hasFlag(NLParameters.NLParametersFlag.IS_VISIBLE)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isReservedWord(String word) {
        return word != null && RESERVED_WORDS.contains(word);
    }
}

