/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.netlist.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.klay.KLayDiagramDebug;
import ro.amiq.dvt.diagrams.netlist.DMemoryAccessor;
import ro.amiq.dvt.diagrams.netlist.model.INLViewSelectable2;
import ro.amiq.dvt.diagrams.netlist.model.NLCache;
import ro.amiq.dvt.diagrams.netlist.model.NLConnection;
import ro.amiq.dvt.diagrams.netlist.model.NLELInstanceGate;
import ro.amiq.dvt.diagrams.netlist.model.NLFactory;
import ro.amiq.dvt.diagrams.netlist.model.NLGate;
import ro.amiq.dvt.diagrams.netlist.model.NLGateKind;
import ro.amiq.dvt.diagrams.netlist.model.NLImplicitGate;
import ro.amiq.dvt.diagrams.netlist.model.NLInstanceGateExpandState;
import ro.amiq.dvt.diagrams.netlist.model.NLLogicStatement;
import ro.amiq.dvt.diagrams.netlist.model.NLParameters;
import ro.amiq.dvt.diagrams.netlist.model.NLPort;
import ro.amiq.dvt.diagrams.netlist.model.NLPortLabelOptions;
import ro.amiq.dvt.diagrams.netlist.model.NLTCInstanceGate;
import ro.amiq.dvt.diagrams.netlist.utils.NLUtils;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.model.DiagramInstanceWrapper;
import ro.amiq.dvt.logic.form.LFConverterOptions;
import ro.amiq.dvt.logic.form.LFOperatorConverter;
import ro.amiq.dvt.logic.form.LogicForm;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.HierarchicalElement;
import ro.amiq.dvt.model.reflection.IRfBlockElement;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfMethodElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.IRfPredefinedGate;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.IRfWrapper;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.model.reflection.RfElementPathInProject;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.HidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorWrapper;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidAccessArgs;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbSegment;
import ro.amiq.dvt.ui.trace.connections.model.TCConnSignal;
import ro.amiq.dvt.ui.trace.connections.model.TCNode;
import ro.amiq.dvt.ui.trace.connections.model.TCStatement;

public class NLInstanceGate
extends NLGate
implements INLViewSelectable2 {
    protected Map<String, NLConnection> signals;
    protected Map<String, NLGate> subGates;
    protected IRfDesignElement design;
    protected RfElementPathInProject elementPathInProject;
    private static final HidOperatorQualifier[] SEARCH_ASSIGNS = new HidOperatorQualifier[]{HidOperatorQualifier.IS_DECLARATION_ASSIGN, HidOperatorQualifier.IS_CONTINUOUS_ASSIGN, HidOperatorQualifier.IS_SELECT_CONTINUOUS_ASSIGN, HidOperatorQualifier.IS_ALIAS};
    public static final Set<HidFlatteningOption> ASSIGN_HID_FLATTENING = EnumSet.of(HidFlatteningOption.IGNORE_CONSTANTS);
    public static final IProgressMonitor NULL_PROGRESS_MONITOR = new NullProgressMonitor();

    protected NLInstanceGate(String name, NLInstanceGate enclosingGate) {
        super(name, enclosingGate);
    }

    @Override
    protected NLInstanceGate init(Object source) {
        if (this.isInit()) {
            return this;
        }
        NLGateKind gateKind = this.translateToValidInstanceGate(source);
        if (gateKind == null) {
            return null;
        }
        this.setKind(gateKind);
        this.setMapping(source);
        switch (gateKind) {
            case INSTANCE: {
                return this.initAsInstance(source);
            }
            case DESIGN: 
            case BLOCK: {
                return this.initAsDesign(source);
            }
        }
        return null;
    }

    protected NLGateKind translateToValidInstanceGate(Object element) {
        if (element instanceof IRfInstanceElement) {
            return NLGateKind.INSTANCE;
        }
        IRfNamedElement.ElementKind designKind = DesignUtils.getDesignKind(element);
        if (designKind == IRfNamedElement.ElementKind.VHDL_BLOCK || designKind == IRfNamedElement.ElementKind.VLOG_GENERATE) {
            return NLGateKind.BLOCK;
        }
        if (designKind != IRfNamedElement.ElementKind.UNKNOWN) {
            return NLGateKind.DESIGN;
        }
        return null;
    }

    @Override
    protected void setMapping(Object mapping) {
        super.setMapping(mapping);
        if (mapping instanceof IRfNamedElement) {
            this.elementPathInProject = RfElementPath.pathInProject((IRfNamedElement)mapping);
        }
    }

    @Override
    public Object getMapping() {
        Object mapping = super.getMapping();
        if (mapping instanceof IRfNamedElement && ((IRfNamedElement)mapping).hasNoDefs(false) && this.elementPathInProject != null) {
            IRfNamedElement newMapping = this.elementPathInProject.toNamedElement();
            if (newMapping != null) {
                super.setMapping(newMapping);
            }
            return newMapping;
        }
        return mapping;
    }

    public IRfSingleLangProject getRfProject() {
        IRfNamedElement mapping2 = this.getMapping(IRfNamedElement.class);
        return mapping2 != null ? mapping2.getRfProject() : null;
    }

    protected NLInstanceGate initAsInstance(Object instance) {
        if (!(instance instanceof IRfInstanceElement)) {
            return this;
        }
        this.addPorts((IRfInstanceElement)instance, NLParameters.NLParametersFlag.OUTER_VISIBLE, null);
        this.addInstanceParameters();
        return this;
    }

    protected void addInstancePortConnections() {
    }

    protected void addPorts(IRfNamedElement element, NLParameters.NLParametersFlag portVisibilityFlag, ElementPath instancePath) {
        if (element == null) {
            return;
        }
        for (IRfPortElement portElement : DesignUtils.getPorts(DesignUtils.DesignRequest.of(element, instancePath, null, true, this.getMemoryAccessor()), true, NLCache.INSTANCE.getDummyPortMap())) {
            NLPort existingPort = this.getPort(portElement);
            if (existingPort != null) {
                existingPort.addFlag(portVisibilityFlag);
                KLayDiagramDebug.debugInfo(KLayDiagramDebug.DebugRegion.NL_MODEL_CONSTRUCTION, "Gate already has port", portElement);
                continue;
            }
            boolean isBundleType = DesignUtils.isInterfacePort(portElement);
            boolean isUnknownDesignPort = DesignUtils.isUnknownDesignPort(portElement);
            NLPortLabelOptions portLabelOptions = NLPortLabelOptions.getFromParameters(this.getParameters());
            NLPort port = this.addPort(NLFactory.createPort(NLUtils.getNLName(portElement), NLUtils.getNLLabel(portElement, instancePath, portLabelOptions), this, NLUtils.getPortDirectionFrom(portElement), isBundleType ? NLConnection.NLConnectionKind.BUNDLE_SIGNAL : null, isUnknownDesignPort, NLFactory.createGoTo(portElement, null), portVisibilityFlag));
            if (portLabelOptions.hasFlag(NLPortLabelOptions.NLPortLabelOptionsFlag.DIAGRAM_SHOW_PORT_FULLY_QUALIFIED_TYPE)) {
                port.setQualifiedName(portElement.getQualifiedNameForDiagram(instancePath));
            }
            KLayDiagramDebug.debugInfo(KLayDiagramDebug.DebugRegion.NL_MODEL_CONSTRUCTION, "Added port", portElement);
        }
    }

    protected DMemoryAccessor getMemoryAccessor() {
        return null;
    }

    protected IRfNamedElement getEnclosingDesignOrInstance(NLInstanceGate enclosingGate) {
        return enclosingGate.getMapping(IRfNamedElement.class);
    }

    protected void addInstancePortConnection(IRfPortElement portElement, Set<TCConnSignal> conns, NLInstanceGate enclosingGate, IRfNamedElement enclosingDesignOrInstance, ElementPath instancePath, ELInstance closestAncestorInstance) {
        if (conns == null || conns.isEmpty() || enclosingGate == null) {
            KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.NL_MODEL_CONSTRUCTION, "Port not connected to any signal", portElement);
            return;
        }
        NLPort port = this.getPort(portElement);
        if (port == null) {
            KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.NL_MODEL_CONSTRUCTION, "Could not find port for port connection", enclosingGate, port);
            return;
        }
        port.addFlag(NLParameters.NLParametersFlag.IS_PORT_IN_PORT_CONNECTION);
        Optional<TCConnSignal> connWithOperator = conns.stream().filter(c -> c.getEnclosingOperator(enclosingDesignOrInstance, closestAncestorInstance) != null).findFirst();
        if (!connWithOperator.isPresent() || port.isInterfacePort()) {
            this.addInstancePortConnectionWithoutGate(port, conns, enclosingGate, enclosingDesignOrInstance, closestAncestorInstance, instancePath);
        } else {
            this.addInstancePortConnectionWithGate(port, conns, enclosingGate, enclosingDesignOrInstance, closestAncestorInstance, connWithOperator.get().getEnclosingOperator(enclosingDesignOrInstance, closestAncestorInstance), instancePath);
        }
    }

    protected ELInstance getClosestAncestorInstance() {
        NLGate closestAncestorInstanceGate = this.getClosestAncestorInstanceSkippingBlocks();
        if (closestAncestorInstanceGate instanceof NLELInstanceGate) {
            DiagramInstanceWrapper mapping = closestAncestorInstanceGate.getMapping(DiagramInstanceWrapper.class);
            return mapping != null ? mapping.getInstance() : null;
        }
        if (closestAncestorInstanceGate instanceof NLTCInstanceGate) {
            TCNode mapping = closestAncestorInstanceGate.getMapping(TCNode.class);
            return mapping != null ? mapping.getELInstance() : null;
        }
        return null;
    }

    private void addInstancePortConnectionWithoutGate(NLPort port, Set<TCConnSignal> conns, NLInstanceGate enclosingGate, IRfNamedElement enclosingDesignOrInstance, ELInstance closestAncestorInstance, ElementPath instancePath) {
        DesignUtils.DesignRequest designRequest = DesignUtils.DesignRequest.of(enclosingDesignOrInstance, instancePath, null, true, this.getMemoryAccessor());
        for (TCConnSignal conn : conns) {
            IRfNamedElement targetSignal = NLUtils.resolveSignal(conn.signal, designRequest, closestAncestorInstance, false, null);
            if (targetSignal != null) {
                NLInstanceGate targetGate = NLUtils.findEnclosingScopeGate(enclosingGate, targetSignal.getEnclosingScope());
                if (this.makeConnection(port, targetGate, targetSignal)) continue;
                KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.NL_MODEL_CONSTRUCTION, "Could not connect port to signal", port, targetGate, targetSignal);
                continue;
            }
            if (!(conn.signal instanceof HidImplicit)) continue;
            NLFactory.createImplicitGateAndConnection(port, enclosingGate, conn);
        }
    }

    private void addInstancePortConnectionWithGate(NLPort port, Set<TCConnSignal> conns, NLInstanceGate enclosingGate, IRfNamedElement enclosingDesignOrInstance, ELInstance closestAncestorInstance, IHidOperator enclosingOperator, ElementPath instancePath) {
        TCStatement statement = conns.iterator().next().statement;
        if (statement == null) {
            KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.NL_MODEL_CONSTRUCTION, "Could not find signal expression statement", enclosingOperator);
            this.addInstancePortConnectionWithoutGate(port, conns, enclosingGate, enclosingDesignOrInstance, closestAncestorInstance, instancePath);
            return;
        }
        NLLogicStatement logicStatement = NLLogicStatement.of(null, statement);
        boolean isOutputPort = port.getDirection() == NLPort.NLPortDirection.DIR_OUT;
        DesignUtils.SupplierInDesign<LogicForm> logicSupplier = DesignUtils.getLogicSupplier2(conns, isOutputPort, NLUtils.isDiagramsShowConstants(this));
        if (logicSupplier == null) {
            KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.NL_MODEL_CONSTRUCTION, "Could not create signal expression supplier", enclosingOperator);
            this.addInstancePortConnectionWithoutGate(port, conns, enclosingGate, enclosingDesignOrInstance, closestAncestorInstance, instancePath);
            return;
        }
        LogicForm signalExpression = logicSupplier.get(enclosingDesignOrInstance, closestAncestorInstance);
        if (signalExpression == null) {
            KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.NL_MODEL_CONSTRUCTION, "Could not create signal expression", enclosingOperator);
            this.addInstancePortConnectionWithoutGate(port, conns, enclosingGate, enclosingDesignOrInstance, closestAncestorInstance, instancePath);
            return;
        }
        NLConnection dummySignal = NLFactory.createSignalExpressionSignal(signalExpression, statement, enclosingGate, isOutputPort);
        if (!NLFactory.createCommonSignalToPortConnection(port, dummySignal)) {
            KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.NL_MODEL_CONSTRUCTION, "Could not connect signal expression", enclosingOperator);
            this.addInstancePortConnectionWithoutGate(port, conns, enclosingGate, enclosingDesignOrInstance, closestAncestorInstance, instancePath);
            return;
        }
        logicStatement.logic = signalExpression;
        statement.goToInfo.text = "";
        NLGate subGate = enclosingGate.getSubGate(logicStatement);
        if (subGate != null) {
            return;
        }
        enclosingGate.addSubGate(NLFactory.createGate(logicStatement, enclosingGate));
    }

    protected void addInstanceParameters() {
        IRfDesignElement design = this.getDesign();
        this.getParameters().setFlag(NLParameters.NLParametersFlag.IS_PRIMITIVE_INSTANCE, DesignUtils.getDesignKind(design) == IRfNamedElement.ElementKind.VLOG_PRIMITIVE);
    }

    protected NLInstanceGate initAsDesign(Object elem) {
        if (!(elem instanceof IRfDesignElement)) {
            return this;
        }
        IRfDesignElement design = (IRfDesignElement)elem;
        this.addPorts(design, NLParameters.NLParametersFlag.INNER_VISIBLE, null);
        if (this.hasFlag(NLParameters.NLParametersFlag.IS_GATE_AS_BLOCK)) {
            return this;
        }
        this.addSignals(design, null);
        this.addInternalSignalConnections(this.getPorts());
        this.addInstanceGates(design);
        this.addLogicGates(design);
        this.addBlockGates(design);
        return this;
    }

    protected void addSignals(IRfDesignElement design, ElementPath instancePath) {
        if (design == null) {
            return;
        }
        Collection<? extends IRfFieldElement> internalSignals = design.getLocalSignals();
        if (internalSignals == null || internalSignals.isEmpty()) {
            return;
        }
        for (IRfNamedElement iRfNamedElement : internalSignals) {
            if (!DesignUtils.isValidSignalCandidate(iRfNamedElement, instancePath)) continue;
            if (this.getSignal(iRfNamedElement) != null) {
                KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.NL_MODEL_CONSTRUCTION, "Gate already has signal", iRfNamedElement);
                continue;
            }
            boolean isBundleType = DesignUtils.isInterfacePort(iRfNamedElement) || DesignUtils.isCompositeSignal(iRfNamedElement);
            this.addSignal(NLFactory.createConnection(NLUtils.getNLName(iRfNamedElement), NLUtils.getNLLabel(iRfNamedElement), this, isBundleType ? NLConnection.NLConnectionKind.BUNDLE_SIGNAL : null, NLFactory.createGoTo(iRfNamedElement, null)));
            KLayDiagramDebug.debugInfo(KLayDiagramDebug.DebugRegion.NL_MODEL_CONSTRUCTION, "Added signal", iRfNamedElement);
        }
    }

    protected void addInternalSignalConnections(Collection<NLPort> ports) {
        for (NLPort port : ports) {
            String portName = port.getName();
            NLConnection internalSignal = this.getSignal(portName);
            if (internalSignal == null) {
                internalSignal = this.addSignal(NLFactory.createConnection(portName, port.getLabel(), this, port.getKind(), port.getGoToSource()));
                KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.NL_MODEL_CONSTRUCTION, "Signal had to be created", internalSignal);
            }
            NLFactory.createCommonSignalToPortConnection(port, internalSignal);
        }
    }

    protected void addInstanceGates(IRfNamedElement design) {
        Collection<? extends IRfInstanceElement> subInstances = null;
        if (design instanceof IRfDesignElement) {
            subInstances = ((IRfDesignElement)design).getLocalInstances();
        }
        if (subInstances == null || subInstances.isEmpty()) {
            return;
        }
        for (IRfInstanceElement iRfInstanceElement : subInstances) {
            this.addSubGate(NLFactory.createGate(iRfInstanceElement, this));
        }
    }

    protected void addLogicGates(IRfNamedElement design) {
        if (!(design instanceof IRfDesignElement)) {
            return;
        }
        String filePath = DesignUtils.getFilePath(design);
        ArrayList<HidOperatorWrapper> assigns = new ArrayList<HidOperatorWrapper>();
        DesignUtils.collectLocalOperatorsWithPaths(assigns, design, SEARCH_ASSIGNS);
        this.collectVHDLProcedureCalls(assigns, design);
        this.collectVLOGPredefinedGates(assigns, design);
        this.addAssignLogicGates(assigns, design, filePath);
        LinkedHashMap<IRfNamedElement, LogicForm> concurrentBlocksLogic = new LinkedHashMap<IRfNamedElement, LogicForm>(4);
        DesignUtils.collectConcurrentBlocksWithOperators(design, concurrentBlocksLogic, LFConverterOptions.NO_NULL_DRIVERS_ASSOCIATIONS, ASSIGN_HID_FLATTENING, NULL_PROGRESS_MONITOR);
        this.addAlwaysBlockLogicGates(concurrentBlocksLogic, null, false);
        LinkedHashMap<IRfNamedElement, LogicForm> sequentialBlocksLogic = new LinkedHashMap<IRfNamedElement, LogicForm>(4);
        DesignUtils.collectSequentialBlocksWithOperators2(design, sequentialBlocksLogic, concurrentBlocksLogic.keySet(), LFConverterOptions.NL_INSTANCE_SET, ASSIGN_HID_FLATTENING, NULL_PROGRESS_MONITOR);
        this.addAlwaysBlockLogicGates(sequentialBlocksLogic, null, true);
    }

    private void collectVLOGPredefinedGates(List<HidOperatorWrapper> assigns, IRfNamedElement design) {
        if (!(design instanceof IRfPredefinedGate)) {
            return;
        }
        IRfInstanceElement instance = this.getMapping(IRfInstanceElement.class);
        GoToInfo goToInfo = GoToInfo.sourceOf(instance);
        if (goToInfo == null) {
            return;
        }
        IHidOperator operatorForPredefinedGateInstance = DesignUtils.makeOperatorForPredefinedGateInstance((IRfPredefinedGate)design, instance, goToInfo, NLCache.INSTANCE.getDummyPortMap(), null, DesignUtils.PORT_CONNECTION_HID_FLATTENING);
        if (operatorForPredefinedGateInstance instanceof HidOperator) {
            assigns.add(HidOperatorWrapper.of((HidOperator)operatorForPredefinedGateInstance, null));
        }
    }

    protected void addAssignLogicGates(List<HidOperatorWrapper> assigns, IRfNamedElement searchElementType, String filePath) {
        IRfNamedElement mapping;
        LanguageKind languageKind;
        if (assigns == null) {
            return;
        }
        LanguageKind languageKind2 = languageKind = searchElementType != null ? searchElementType.getLanguageKind() : null;
        if (filePath == null && searchElementType instanceof IRfPredefinedGate && (mapping = this.getMapping(IRfNamedElement.class)) instanceof IRfInstanceElement) {
            filePath = DesignUtils.getFilePath(mapping);
        }
        LFOperatorConverter converter = new LFOperatorConverter(LFConverterOptions.EMPTY_SET, NLUtils.isDiagramsShowConstants(this) ? HidFlatteningOption.IMPLICITS_IN_SELECTS_AND_ARGS_EXCLUDED : ASSIGN_HID_FLATTENING, GoToInfo.sourceSupplierFor(filePath, languageKind), NULL_PROGRESS_MONITOR);
        for (HidOperatorWrapper assign : assigns) {
            NLLogicStatement logicStatement;
            LogicForm logic;
            HidOperator operator = (HidOperator)assign.hidObject;
            if (operator == null) continue;
            String path = assign.path != null ? assign.path.path : filePath;
            GoToInfo goToInfo = GoToInfo.sourceOf(operator, path, "", languageKind);
            TCStatement statement = TCStatement.of(operator.hasOccurrence(HidOperatorQualifier.IS_ALIAS) ? TCStatement.TCStatementKind.ALIAS : TCStatement.TCStatementKind.ASSIGN, goToInfo);
            if (statement == null || (logic = LogicForm.normOf(converter.convert(operator, searchElementType))) == null || this.getSubGate(logicStatement = NLLogicStatement.of(logic, statement)) != null) continue;
            NLGate subGate = this.addSubGate(NLFactory.createGate(logicStatement, this));
            if (!this.hasFlag(NLParameters.NLParametersFlag.IS_PRIMITIVE_INSTANCE)) continue;
            NLUtils.makeInvisible(subGate);
        }
    }

    public void addAlwaysBlockLogicGates(Map<IRfNamedElement, LogicForm> blocksWithOperators, Consumer<NLGate> handlerNew, boolean isSequential) {
        if (blocksWithOperators == null || blocksWithOperators.isEmpty()) {
            return;
        }
        for (Map.Entry<IRfNamedElement, LogicForm> operatorsPerBlock : blocksWithOperators.entrySet()) {
            IRfNamedElement block = operatorsPerBlock.getKey();
            LogicForm logicForm = operatorsPerBlock.getValue();
            if (logicForm == null || logicForm.isEmpty()) {
                KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.NL_MODEL_CONSTRUCTION, "Could not add logic gate for ", block);
                continue;
            }
            TCStatement statement = null;
            IRfDefElement decl = block.getDeclaration();
            if (decl != null) {
                ParserPath fileParserPath = decl.getParserPath();
                String filePath = fileParserPath != null ? fileParserPath.path : null;
                GoToInfo marker = logicForm.content.get(0).getMarker();
                int virtualOffset = marker != null ? marker.virtualOffset : -1;
                GoToInfo goToInfo = GoToInfo.of(filePath, decl.getStartOffset(), virtualOffset, decl.getStartLine(), decl.getEndLine(), "", decl.getLanguageKind());
                statement = TCStatement.of(isSequential ? TCStatement.TCStatementKind.SEQUENTIAL_ALWAYS_BLOCK : TCStatement.TCStatementKind.CONCURRENT_ALWAYS_BLOCK, goToInfo);
            }
            if (statement == null) {
                KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.NL_MODEL_CONSTRUCTION, "Could not create statement for ", block);
                continue;
            }
            NLLogicStatement logicStatement = NLLogicStatement.of(logicForm, statement);
            NLGate logicGate = this.getSubGate(logicStatement);
            if (logicGate != null) continue;
            statement.goToInfo.text = "";
            logicGate = this.addSubGate(NLFactory.createGate(logicStatement, this));
            if (logicGate == null) {
                KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.NL_MODEL_CONSTRUCTION, "Could not create logic gate for ", logicStatement);
                continue;
            }
            if (handlerNew == null) continue;
            handlerNew.accept(logicGate);
        }
    }

    private void collectVHDLProcedureCalls(final List<HidOperatorWrapper> assigns, IRfNamedElement design) {
        if (design == null) {
            return;
        }
        IHidHolder hidHolder = design.getHidHolder();
        if (HidUtils.isHidHolder(hidHolder) && LanguageKind.VHDL == ((HidHolder)hidHolder).getLanguageKind()) {
            hidHolder.visitHidObject(null, new IHidVisitor<HidAccess>(){
                ParserPath parsetPath;

                @Override
                public void setHolder(IHidHolder holder) {
                }

                @Override
                public void setParserPath(ParserPath parserPath) {
                    this.parsetPath = parserPath;
                }

                @Override
                public boolean visit(HidAccess access) {
                    if (!access.isMethodCall(false)) {
                        return true;
                    }
                    ArrayList<IHid> gateDrivers = new ArrayList<IHid>();
                    ArrayList<IHid> gateLoads = new ArrayList<IHid>();
                    IRfNamedElement resolvedMethod = HidUtils.getResolvedElement(access.getParentHid());
                    if (resolvedMethod instanceof IRfWrapper) {
                        resolvedMethod = ((IRfWrapper)((Object)resolvedMethod)).getNamedElement(IRfMethodElement.class);
                    }
                    if (!(resolvedMethod instanceof IRfMethodElement) || !((IRfMethodElement)resolvedMethod).isTask()) {
                        return true;
                    }
                    MethodCall methodCall = ((IHidAccessArgs)((Object)access)).getMethodCall();
                    if (methodCall == null || methodCall.argumentValuesMap == null) {
                        return true;
                    }
                    for (Map.Entry<IRfFieldElement, Set<IHid>> entry : methodCall.argumentValuesMap.entrySet()) {
                        IRfFieldElement formal = entry.getKey();
                        if (formal.isOutput()) {
                            gateLoads.addAll((Collection)entry.getValue());
                            continue;
                        }
                        gateDrivers.addAll((Collection)entry.getValue());
                    }
                    HidOccurrence occurrence = access.getOccurrence();
                    GoToInfo goToInfo = GoToInfo.of(this.parsetPath.path, occurrence.getOffset(), occurrence.getVirtualOffset(), occurrence.getLine(), HidUtils.toString(access.getParentHid(), false, false), access.getLanguageKind());
                    IHidOperator operator = DesignUtils.makeStandInOperator(gateLoads, gateDrivers, goToInfo);
                    if (operator instanceof HidOperator) {
                        assigns.add(HidOperatorWrapper.of((HidOperator)operator, this.parsetPath));
                    }
                    return true;
                }

                @Override
                public Class<HidAccess> getType() {
                    return HidAccess.class;
                }
            });
        }
    }

    private void addBlockGates(IRfNamedElement design) {
        Collection<? extends IRfBlockElement> blocksWithPrefix = null;
        if (design instanceof IRfDesignElement) {
            blocksWithPrefix = ((IRfDesignElement)design).getLocalGenerateBlocks();
        }
        if (blocksWithPrefix == null || blocksWithPrefix.isEmpty()) {
            return;
        }
        for (IRfBlockElement iRfBlockElement : blocksWithPrefix) {
            this.addSubGate(NLFactory.createGate(iRfBlockElement, this));
        }
    }

    @Override
    public NLPort getPort(IRfNamedElement port) {
        return super.getPort(port instanceof HierarchicalElement ? ((HierarchicalElement)port).getFirstSegment() : port);
    }

    @Override
    public Collection<GoToInfo> getGoToSource() {
        return NLFactory.createGoTo(this.getMapping(), null);
    }

    @Override
    public NLInstanceGate getTopGate() {
        NLInstanceGate top = this;
        while (top.getEnclosingGate() != null) {
            top = top.getEnclosingGate();
        }
        return top;
    }

    public NLGate addSubGate(NLGate gate) {
        if (gate == null) {
            return null;
        }
        if (this.subGates == null) {
            this.subGates = new LinkedHashMap<String, NLGate>();
        }
        this.subGates.put(gate.getName(), gate);
        return gate;
    }

    public NLGate removeSubGate(NLGate gate) {
        if (gate == null || this.subGates == null) {
            return null;
        }
        return this.subGates.remove(gate.getName());
    }

    public NLGate getSubGate(String name) {
        if (name == null) {
            return null;
        }
        return this.subGates != null ? this.subGates.get(name) : null;
    }

    @NotNull
    public Collection<? extends NLGate> getSubGates() {
        if (this.subGates == null) {
            return Collections.emptySet();
        }
        return this.subGates.values();
    }

    public void setSubGates(Map<String, NLGate> gates) {
        this.subGates = gates;
    }

    public NLGate getSubGate(Object element) {
        return this.getSubGate(NLUtils.getNLName(element));
    }

    public boolean hasSubGates() {
        return this.subGates != null && !this.subGates.isEmpty();
    }

    public NLConnection addSignal(NLConnection signal) {
        if (signal == null) {
            return null;
        }
        if (this.signals == null) {
            this.signals = new LinkedHashMap<String, NLConnection>();
        }
        this.signals.put(signal.getName(), signal);
        return signal;
    }

    public NLConnection getSignal(String name) {
        return this.signals != null ? this.signals.get(name) : null;
    }

    public NLConnection getSignal(IRfNamedElement signal) {
        return this.getSignal(NLUtils.getNLName(signal));
    }

    @NotNull
    public Collection<NLConnection> getSignals() {
        if (this.signals == null) {
            return Collections.emptySet();
        }
        return this.signals.values();
    }

    public void setSignals(Map<String, NLConnection> signals) {
        this.signals = signals;
    }

    public boolean hasSignals() {
        return this.signals != null && !this.signals.isEmpty();
    }

    public NLConnection removeSignal(NLConnection signal) {
        if (signal == null || this.signals == null) {
            return null;
        }
        return this.signals.remove(signal.getName());
    }

    public NLPort removePort(NLPort port) {
        if (port == null || this.ports == null) {
            return null;
        }
        return (NLPort)this.ports.remove(port.getName());
    }

    public IRfDesignElement getDesign() {
        if (this.design != null && !this.design.hasNoDefs(false)) {
            return this.design;
        }
        this.design = DesignUtils.getDesign(DesignUtils.DesignRequest.of(this.getMapping(IRfNamedElement.class), true));
        return this.design;
    }

    public LanguageKind getLanguageKind() {
        IRfNamedElement namedElement = this.getMapping(IRfNamedElement.class);
        return namedElement != null ? namedElement.getLanguageKind() : LanguageKind.VLOG;
    }

    public NLInstanceGate expand(Set<Object> visited) {
        if (this.getExpandState() == NLInstanceGateExpandState.EXPANDED) {
            return this;
        }
        if (this.getKind() != NLGateKind.INSTANCE && this.getKind() != NLGateKind.BUNDLE && this.getKind() != NLGateKind.BLOCK && this.getKind() != NLGateKind.DESIGN) {
            return this;
        }
        IRfDesignElement expandedDesign = this.getDesign();
        if (expandedDesign == null) {
            return this;
        }
        if (visited != null && visited.contains(expandedDesign)) {
            return this;
        }
        this.initAsDesign(expandedDesign);
        return this;
    }

    public NLInstanceGate collapse() {
        if (this.getExpandState() == NLInstanceGateExpandState.COLLAPSED) {
            return this;
        }
        if (this.getKind() != NLGateKind.INSTANCE && this.getKind() != NLGateKind.BUNDLE) {
            return this;
        }
        this.initAsInstance(this.getMapping(IRfInstanceElement.class));
        return this;
    }

    public NLInstanceGateExpandState getExpandState() {
        if (this.signals == null && this.subGates == null) {
            return NLInstanceGateExpandState.COLLAPSED;
        }
        boolean completelyVisible = true;
        boolean completelyInvisible = true;
        if (this.signals != null) {
            for (NLConnection signal : this.signals.values()) {
                if (signal.hasFlag(NLParameters.NLParametersFlag.IS_VISIBLE)) continue;
                completelyVisible = false;
            }
        }
        if (this.subGates != null) {
            for (NLGate subGate : this.subGates.values()) {
                if (subGate.getKind() == NLGateKind.BUNDLE) continue;
                if (subGate.hasFlag(NLParameters.NLParametersFlag.IS_VISIBLE)) {
                    completelyInvisible = false;
                    continue;
                }
                completelyVisible = false;
            }
        }
        if (this.ports != null) {
            for (NLPort port : this.ports.values()) {
                if (port.hasFlag(NLParameters.NLParametersFlag.IS_VISIBLE)) continue;
                completelyVisible = false;
            }
        }
        if (completelyVisible) {
            return NLInstanceGateExpandState.EXPANDED;
        }
        if (completelyInvisible) {
            return NLInstanceGateExpandState.INVISIBLE;
        }
        return NLInstanceGateExpandState.PARTIALLY_EXPANDED;
    }

    @Override
    public boolean hasGoToDeclaration() {
        if (this.kind != NLGateKind.DESIGN && this.kind != NLGateKind.INSTANCE) {
            return false;
        }
        IRfDesignElement design = this.getDesign();
        return design instanceof IRfDesignElement && !design.isPredefined();
    }

    @Override
    public void goToDeclaration(IProject project, boolean activateEditor) {
        Collection<GoToInfo> goToDeclaration = NLFactory.createGoTo(this.getDesign(), this.getMapping(IRfNamedElement.class));
        if (goToDeclaration != null && !goToDeclaration.isEmpty()) {
            for (GoToInfo marker : goToDeclaration) {
                marker.open(project, activateEditor);
            }
        } else {
            KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.NL_DIAGRAM_ACTION, "Go to declaration null for", this);
        }
    }

    @Override
    public boolean hasStepInto() {
        if (!this.hasGoToDeclaration()) {
            return false;
        }
        if (this.hasFlag(NLParameters.NLParametersFlag.IS_GATE_WITH_FLOW_CONNECTION)) {
            IRfDesignElement design = this.getDesign();
            if (!(design instanceof IRfDesignElement)) {
                return false;
            }
            ArrayList<IRfInstanceElement> instances = new ArrayList<IRfInstanceElement>();
            DesignUtils.getInstancesIncludingGenerate(instances, design, false);
            return !instances.isEmpty();
        }
        return true;
    }

    @Override
    public INLViewSelectable2.StepIntoWrapper stepInto() {
        IRfDesignElement design = this.getDesign();
        if (!(design instanceof IRfDesignElement) || design.isPredefined()) {
            return null;
        }
        if (this.getMapping(IRfNamedElement.class) == null && this.getMapping(DiagramInstanceWrapper.class) == null) {
            return null;
        }
        return INLViewSelectable2.StepIntoWrapper.of(this, this.hasFlag(NLParameters.NLParametersFlag.IS_GATE_WITH_FLOW_CONNECTION), NLUtils.getGatePathToTop(this));
    }

    public List<BreadcrumbSegment> getPathSegments() {
        return NLUtils.getPathSegments(this);
    }

    @Override
    protected void dispose() {
        super.dispose();
        if (this.signals != null) {
            for (NLConnection nLConnection : this.getSignals()) {
                nLConnection.dispose();
            }
            this.signals = null;
        }
        if (this.subGates != null) {
            for (NLGate nLGate : this.getSubGates()) {
                nLGate.dispose();
            }
            this.subGates = null;
        }
        this.design = null;
    }

    @Override
    public NLGate getCopy(NLInstanceGate enclosingGate) {
        NLInstanceGate copy = new NLInstanceGate(this.getName(), enclosingGate);
        copy.setParameters(this.getParameters().getCopy());
        copy.setLabel(this.getLabel());
        copy.setKind(this.getKind());
        ((NLGate)copy).setMapping(this.getMapping());
        return copy;
    }

    public DMemoryAccessor getMemAccessor() {
        return null;
    }

    public NLImplicitGate getConnectedImplicitGate() {
        NLInstanceGate enclosingGate = this.getEnclosingGate();
        for (NLGate nLGate : enclosingGate.getSubGates()) {
            if (!NLUtils.isImplicitGate(nLGate) || ((NLImplicitGate)nLGate).getConnectedGate() != this) continue;
            return (NLImplicitGate)nLGate;
        }
        return null;
    }
}

