/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.netlist.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.diagrams.klay.KLayDiagramDebug;
import ro.amiq.dvt.diagrams.netlist.DMemoryAccessor;
import ro.amiq.dvt.diagrams.netlist.model.NLConnection;
import ro.amiq.dvt.diagrams.netlist.model.NLELInstanceGate;
import ro.amiq.dvt.diagrams.netlist.model.NLFactory;
import ro.amiq.dvt.diagrams.netlist.model.NLGate;
import ro.amiq.dvt.diagrams.netlist.model.NLGateKind;
import ro.amiq.dvt.diagrams.netlist.model.NLImplicitGate;
import ro.amiq.dvt.diagrams.netlist.model.NLInstanceGate;
import ro.amiq.dvt.diagrams.netlist.model.NLLogicStatement;
import ro.amiq.dvt.diagrams.netlist.model.NLParameters;
import ro.amiq.dvt.diagrams.netlist.model.NLPort;
import ro.amiq.dvt.diagrams.netlist.model.NLTCInstanceGate;
import ro.amiq.dvt.diagrams.netlist.utils.NLUtils;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.model.DiagramInstanceWrapper;
import ro.amiq.dvt.logic.form.LogicForm;
import ro.amiq.dvt.logic.form.model.LFFanIn;
import ro.amiq.dvt.logic.form.model.LFProgram;
import ro.amiq.dvt.logic.form.model.LFResolvedFanIn;
import ro.amiq.dvt.logic.form.utils.LFUtils;
import ro.amiq.dvt.model.reflection.DummyPort;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.HierarchicalElement;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.trace.connections.model.TCStatement;

public class NLLogicGate
extends NLInstanceGate {
    protected NLLogicGate(String name, NLInstanceGate enclosingGate) {
        super(name, enclosingGate);
    }

    @Override
    protected NLLogicGate init(Object source) {
        if (this.isInit()) {
            return this;
        }
        if (!(source instanceof NLLogicStatement)) {
            return null;
        }
        this.setKind(NLGateKind.LOGIC);
        this.setMapping(source);
        boolean isFlowSequentialLogic = NLLogicStatement.FLOW_SEQ.equals(source);
        return isFlowSequentialLogic ? this.initAsFlowLogic() : this.initAsLogic((NLLogicStatement)source);
    }

    private NLLogicGate initAsFlowLogic() {
        return this;
    }

    protected NLLogicGate initAsLogic(NLLogicStatement source) {
        NLInstanceGate enclosingGate = this.getEnclosingGate();
        Object mapping2 = enclosingGate instanceof NLELInstanceGate ? enclosingGate.getMapping(DiagramInstanceWrapper.class) : enclosingGate.getMapping(IRfNamedElement.class);
        ElementPath instancePath = null;
        IRfNamedElement element = null;
        if (mapping2 instanceof DiagramInstanceWrapper) {
            element = ((DiagramInstanceWrapper)mapping2).getDescription();
            instancePath = ((DiagramInstanceWrapper)mapping2).getHierarchyPath();
        } else if (mapping2 instanceof IRfNamedElement) {
            element = (IRfNamedElement)mapping2;
        }
        DesignUtils.DesignRequest designRequest = DesignUtils.DesignRequest.of(element, instancePath, null, true, this.getMemoryAccessor());
        switch (source.statement.kind) {
            case ALIAS: {
                return this.initAsLogicAlias(source, enclosingGate, designRequest);
            }
            case PORT_CONNECTION: 
            case ASSIGN: 
            case PORT_EXPRESSION: {
                return this.initAsLogicAssign(source, enclosingGate, designRequest);
            }
            case CONCURRENT_ALWAYS_BLOCK: 
            case SEQUENTIAL_ALWAYS_BLOCK: {
                return this.initAsLogicAlwaysBlock(source, enclosingGate, designRequest);
            }
        }
        return null;
    }

    private NLLogicGate initAsLogicAlwaysBlock(NLLogicStatement source, NLInstanceGate enclosingGate, DesignUtils.DesignRequest designRequest) {
        boolean hasDrivers = false;
        boolean hasLoads = false;
        LogicForm logic = source.logic;
        ELInstance closestAncestorInstance = enclosingGate.getClosestAncestorInstance();
        Map<IRfNamedElement, Set<IRfNamedElement>> mapResolvedFanIns = LFUtils.mapFanInSignals(logic, ASSIGN_HID_FLATTENING, hid -> {
            IRfNamedElement resolveSignal = NLUtils.resolveSignal(hid, designRequest, closestAncestorInstance, true, null);
            if (resolveSignal == null && hid.getElement() == null) {
                KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.NL_MODEL_CONSTRUCTION, "Could not resolve signal", hid, source);
                return null;
            }
            return resolveSignal;
        });
        boolean showDetails = mapResolvedFanIns.size() > 1;
        for (Map.Entry<IRfNamedElement, Set<IRfNamedElement>> entry : mapResolvedFanIns.entrySet()) {
            IRfNamedElement load = entry.getKey();
            Set<IRfNamedElement> drivers = entry.getValue();
            boolean hasInternalLoad = false;
            if (load == null) continue;
            if (NLUtils.isVlogOrVHDLVariable(load) && showDetails) {
                hasInternalLoad = true;
                NLConnection internalSignal = this.getSignal(load);
                if (internalSignal == null) {
                    internalSignal = this.addSignal(NLFactory.createConnection(NLUtils.getNLName(load), NLUtils.getNLLabel(load), this, null, NLFactory.createGoTo(load, null)));
                }
            } else {
                NLPort port = this.addPortAndMakeConnection(load, NLPort.NLPortDirection.DIR_OUT, this, enclosingGate);
                hasLoads |= port != null;
                if (showDetails && port != null) {
                    port.addFlag(NLParameters.NLParametersFlag.INNER_VISIBLE);
                    Object internalSignal = this.getSignal(this.getLogicPortAndConnectionName(load));
                    if (internalSignal == null) {
                        internalSignal = this.addSignal(NLFactory.createConnection(this.getLogicPortAndConnectionName(load), this.getLogicPortAndConnectionLabel(load), this, null, port.getGoToSource()));
                    }
                    if (!NLFactory.createCommonSignalToPortConnection(port, (NLConnection)internalSignal)) {
                        KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.NL_MODEL_CONSTRUCTION, "Could not connect port to internal signal", port, internalSignal);
                    }
                }
            }
            for (IRfNamedElement driver : drivers) {
                if (driver == null) continue;
                if (NLUtils.isVlogOrVHDLVariable(driver) && showDetails) {
                    NLConnection internalSignal = this.getSignal(driver);
                    if (internalSignal != null) continue;
                    internalSignal = this.addSignal(NLFactory.createConnection(NLUtils.getNLName(driver), NLUtils.getNLLabel(driver), this, null, NLFactory.createGoTo(driver, null)));
                    continue;
                }
                NLPort port = this.addPortAndMakeConnection(driver, NLPort.NLPortDirection.DIR_IN, this, enclosingGate);
                hasDrivers |= port != null;
                if (!showDetails || port == null) continue;
                port.addFlag(NLParameters.NLParametersFlag.INNER_VISIBLE);
                NLConnection internalSignal = this.getSignal(driver);
                if (internalSignal == null) {
                    internalSignal = this.addSignal(NLFactory.createConnection(NLUtils.getNLName(driver), NLUtils.getNLLabel(driver), this, null, port.getGoToSource()));
                }
                if (NLFactory.createCommonSignalToPortConnection(port, internalSignal)) continue;
                KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.NL_MODEL_CONSTRUCTION, "Could not connect port to internal signal", port, internalSignal);
            }
            if (!hasLoads && !hasInternalLoad) continue;
            if (!showDetails) break;
            this.addFlag(NLParameters.NLParametersFlag.IS_DETAILED_LOGIC_GATE);
            LFResolvedFanIn resolvedFanIn = LFResolvedFanIn.of(load, drivers, null);
            NLGate internalGate = this.addSubGate(NLFactory.createGate(resolvedFanIn, this, null));
            if (internalGate != null) continue;
            KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.NL_MODEL_CONSTRUCTION, "Could not resolve internal logic gate for", resolvedFanIn);
        }
        return this.validateLogicGate(source.statement.goToInfo, logic, hasLoads, hasDrivers);
    }

    protected NLLogicGate validateLogicGate(GoToInfo source, LogicForm logic, boolean hasLoads, boolean hasDrivers) {
        if (!hasDrivers) {
            KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.NL_MODEL_CONSTRUCTION, "Logic gate is without drivers", source);
        }
        if (!hasLoads) {
            KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.NL_MODEL_CONSTRUCTION, "Logic gate is without loads", source);
            this.removeConnectedImplicitGate();
            for (NLPort addedPort : this.getPorts()) {
                for (NLConnection conn : new ArrayList<NLConnection>(addedPort.getConnections())) {
                    NLFactory.removeSignalToPortConnection(addedPort, conn);
                    KLayDiagramDebug.debugInfo(KLayDiagramDebug.DebugRegion.NL_MODEL_CONSTRUCTION, "Removed logic connection", addedPort, conn);
                }
            }
            this.dispose();
            return null;
        }
        return this;
    }

    private NLLogicGate initAsLogicAlias(NLLogicStatement source, NLInstanceGate enclosingGate, DesignUtils.DesignRequest designRequest) {
        boolean[] hasLoads = new boolean[1];
        LogicForm logic = source.logic;
        for (LFProgram prog : logic.content) {
            LFUtils.checkFanInOfProgram(prog, fanIn -> {
                blArray[0] = hasLoads[0] | this.resolveAndMakeConnection(fanIn.getCenter(), nLLogicStatement.statement, NLPort.NLPortDirection.DIR_INOUT, designRequest, enclosingGate);
                return true;
            });
        }
        return this.validateLogicGate(source.statement.goToInfo, logic, hasLoads[0], true);
    }

    private NLLogicGate initAsLogicAssign(NLLogicStatement source, NLInstanceGate enclosingGate, DesignUtils.DesignRequest designRequest) {
        boolean hasLoads = false;
        boolean hasDrivers = false;
        LogicForm logic = source.logic;
        for (LFProgram prog : logic.content) {
            LFFanIn fanIn = LFUtils.getExtendedFanInOfProgram(prog, NLUtils.isDiagramsShowConstants(enclosingGate) ? HidFlatteningOption.IMPLICITS_IN_SELECTS_AND_ARGS_EXCLUDED : ASSIGN_HID_FLATTENING);
            hasLoads |= this.resolveAndMakeConnection(fanIn.getCenter(), source.statement, NLPort.NLPortDirection.DIR_OUT, designRequest, enclosingGate);
            for (IHid driverHid : fanIn.getBorder()) {
                hasDrivers |= this.resolveAndMakeConnection(driverHid, source.statement, NLPort.NLPortDirection.DIR_IN, designRequest, enclosingGate);
            }
        }
        return this.validateLogicGate(source.statement.goToInfo, logic, hasLoads, hasDrivers);
    }

    private boolean resolveAndMakeConnection(IHid hid, TCStatement statement, NLPort.NLPortDirection portDirection, DesignUtils.DesignRequest designRequest, NLInstanceGate enclosingGate) {
        ELInstance closestAncestorInstance = enclosingGate.getClosestAncestorInstance();
        IRfNamedElement targetSignal = NLUtils.resolveSignal(hid, designRequest, closestAncestorInstance, true, null);
        if (targetSignal != null) {
            NLInstanceGate targetGate = NLUtils.findEnclosingScopeGate(enclosingGate, targetSignal.getEnclosingScope());
            return this.addLogicPortAndMakeConnection(targetGate, targetSignal, portDirection);
        }
        return this.makeImplicitConnection(hid, statement, portDirection, designRequest, enclosingGate);
    }

    /*
     * WARNING - void declaration
     */
    private boolean makeImplicitConnection(IHid hid, TCStatement statement, NLPort.NLPortDirection portDirection, DesignUtils.DesignRequest designRequest, NLInstanceGate enclosingGate) {
        void hidImplicit;
        HidImplicit hidImplicit2;
        if (portDirection == NLPort.NLPortDirection.DIR_OUT) {
            return false;
        }
        IHid iHid = hid;
        if (!(iHid instanceof HidImplicit) || (hidImplicit2 = (HidImplicit)iHid) != (HidImplicit)iHid || hidImplicit.isID()) {
            return false;
        }
        if (hid.getName().isEmpty() || NLImplicitGate.isReservedWord(hid.getName())) {
            return false;
        }
        NLPort port = this.addConstantLogicPort((HidImplicit)hid, designRequest.instanceOrDesign, portDirection);
        NLFactory.createImplicitGateAndConnection(port, enclosingGate, (HidImplicit)hid, statement);
        return port != null;
    }

    protected NLPort addLogicPort(IRfNamedElement targetSignal, NLPort.NLPortDirection portDirection) {
        String selfLoopPortName;
        if (targetSignal == null) {
            return null;
        }
        String portName = this.getLogicPortAndConnectionName(targetSignal);
        String portLabel = this.getLogicPortAndConnectionLabel(targetSignal);
        NLConnection.NLConnectionKind portType = NLConnection.NLConnectionKind.COMMON_SIGNAL;
        NLPort existingPort = this.getPort(portName);
        if (existingPort == null) {
            existingPort = this.addPort(NLFactory.createPort(portName, portLabel, this, portDirection, portType, false, NLFactory.createGoTo(targetSignal, null), NLParameters.NLParametersFlag.OUTER_VISIBLE));
        } else if (portDirection != existingPort.getDirection() && (existingPort = this.getPort(selfLoopPortName = NLUtils.getSelfLoopPortName(portName))) == null) {
            existingPort = this.addPort(NLFactory.createPort(selfLoopPortName, portLabel, this, portDirection, portType, false, NLFactory.createGoTo(targetSignal, null), NLParameters.NLParametersFlag.OUTER_VISIBLE));
        }
        return existingPort;
    }

    private NLPort addConstantLogicPort(HidImplicit hid, IRfNamedElement enclosingDesignOrInstance, NLPort.NLPortDirection portDirection) {
        if (hid == null || enclosingDesignOrInstance == null) {
            return null;
        }
        String constantName = HidUtils.toString(hid, true, true);
        DummyPort constant = new DummyPort(constantName, null, this.getDummyPortDirection(portDirection), enclosingDesignOrInstance, DVTImages.OUTLINE_NODIR_PORT);
        return this.addLogicPort(constant, portDirection);
    }

    public void makeConnectedImplicitGateVisible() {
        for (NLPort sourcePort : this.getSourcePorts()) {
            if (!sourcePort.isImplicitPort()) continue;
            NLUtils.makeGateAndPortsVisible(sourcePort.getEnclosingGate());
            for (NLConnection conn : sourcePort.getConnections()) {
                NLUtils.makeVisible(conn);
            }
        }
    }

    private void removeConnectedImplicitGate() {
        NLImplicitGate connectedImplicitGate = this.getConnectedImplicitGate();
        if (connectedImplicitGate == null) {
            return;
        }
        NLInstanceGate enclosingGate = this.getEnclosingGate();
        if (enclosingGate == null) {
            return;
        }
        for (NLPort port : new ArrayList<NLPort>(connectedImplicitGate.getPorts())) {
            for (NLConnection conn : new ArrayList<NLConnection>(port.getConnections())) {
                enclosingGate.removeSignal(conn);
            }
        }
        enclosingGate.removeSubGate(connectedImplicitGate);
    }

    private DummyPort.DummyPortDirection getDummyPortDirection(NLPort.NLPortDirection direction) {
        switch (direction) {
            case DIR_OUT: {
                return DummyPort.DummyPortDirection.OUTPUT;
            }
            case DIR_IN: {
                return DummyPort.DummyPortDirection.INPUT;
            }
        }
        return DummyPort.DummyPortDirection.INOUT;
    }

    protected String getLogicPortAndConnectionName(IRfNamedElement targetSignal) {
        return NLUtils.getNLName(targetSignal instanceof HierarchicalElement ? ((HierarchicalElement)targetSignal).getFullNameExcludingHiddenSegments() : targetSignal);
    }

    protected String getLogicPortAndConnectionLabel(IRfNamedElement targetSignal) {
        return NLUtils.getNLLabel(targetSignal instanceof HierarchicalElement ? ((HierarchicalElement)targetSignal).getFullNameExcludingHiddenSegments() : targetSignal);
    }

    @Override
    public NLPort getPort(IRfNamedElement port) {
        return super.getPort(this.getLogicPortAndConnectionName(port));
    }

    private boolean addLogicPortAndMakeConnection(NLInstanceGate targetGate, IRfNamedElement targetSignal, NLPort.NLPortDirection portDirection) {
        NLPort logicPort = this.addLogicPort(targetSignal, portDirection);
        if (logicPort == null) {
            KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.NL_MODEL_CONSTRUCTION, "Could not create logic port for signal", targetSignal);
            return false;
        }
        if (!this.makeConnection(logicPort, targetGate, targetSignal) && !(targetGate instanceof NLTCInstanceGate)) {
            KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.NL_MODEL_CONSTRUCTION, "Could not connect logic port to signal", logicPort, targetSignal);
        }
        return true;
    }

    public boolean isAlias() {
        NLLogicStatement mapping = this.getMapping(NLLogicStatement.class);
        return mapping != null ? TCStatement.TCStatementKind.ALIAS == mapping.statement.kind : false;
    }

    public boolean isAssign() {
        NLLogicStatement mapping = this.getMapping(NLLogicStatement.class);
        return mapping != null ? TCStatement.TCStatementKind.ASSIGN == mapping.statement.kind : false;
    }

    public boolean isConcurrentAlwaysBlock() {
        NLLogicStatement mapping = this.getMapping(NLLogicStatement.class);
        return mapping != null ? TCStatement.TCStatementKind.CONCURRENT_ALWAYS_BLOCK == mapping.statement.kind : false;
    }

    @Override
    public boolean isSequentialAlwaysBlock() {
        NLLogicStatement mapping = this.getMapping(NLLogicStatement.class);
        return mapping != null ? TCStatement.TCStatementKind.SEQUENTIAL_ALWAYS_BLOCK == mapping.statement.kind : false;
    }

    public boolean isAlwaysBlock() {
        return this.isConcurrentAlwaysBlock() || this.isSequentialAlwaysBlock();
    }

    protected NLPort addPortAndMakeConnection(IRfNamedElement targetSignal, NLPort.NLPortDirection portDirection, NLLogicGate enclosingLogicGate, NLInstanceGate enclosingGate) {
        if (targetSignal == null) {
            return null;
        }
        NLPort port = this.addLogicPort(targetSignal, portDirection);
        IRfScopeElement targetScope = targetSignal.getEnclosingScope();
        NLInstanceGate targetGate = NLUtils.findEnclosingScopeGate(enclosingGate, targetScope);
        if (targetGate == null && targetScope instanceof IRfActionBlockElement && !(targetSignal instanceof HierarchicalElement)) {
            if (enclosingLogicGate.getSignal(targetSignal) == null) {
                NLConnection internalSignal = enclosingLogicGate.addSignal(NLFactory.createConnection(NLUtils.getNLName(targetSignal), NLUtils.getNLLabel(targetSignal), this, null, NLFactory.createGoTo(targetSignal, null)));
                NLFactory.createCommonSignalToPortConnection(port, internalSignal);
            }
            targetGate = enclosingLogicGate;
        }
        if (!this.makeConnection(port, targetGate, targetSignal)) {
            KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.NL_MODEL_CONSTRUCTION, "Could not connect port to signal", port, targetGate, targetSignal);
        }
        return port;
    }

    @Override
    protected DMemoryAccessor getMemoryAccessor() {
        return this.getEnclosingGate().getMemoryAccessor();
    }

    @Override
    public NLGate getCopy(NLInstanceGate enclosingGate) {
        NLLogicGate copy = new NLLogicGate(this.getName(), enclosingGate);
        copy.setParameters(this.getParameters().getCopy());
        copy.setLabel(this.getLabel());
        copy.setKind(this.getKind());
        ((NLGate)copy).setMapping(this.getMapping());
        return copy;
    }

    public static class NLInternalLogicGate
    extends NLLogicGate {
        protected NLInternalLogicGate(String name, NLLogicGate enclosingGate) {
            super(name, enclosingGate);
        }

        @Override
        protected NLInternalLogicGate init(Object source) {
            if (this.isInit()) {
                return this;
            }
            if (!(source instanceof LFResolvedFanIn)) {
                return null;
            }
            this.setKind(NLGateKind.LOGIC);
            this.setMapping(source);
            return this.initAsInternalLogicGate2((LFResolvedFanIn)source);
        }

        @Override
        public NLLogicGate getEnclosingGate() {
            return (NLLogicGate)super.getEnclosingGate();
        }

        private NLInternalLogicGate initAsInternalLogicGate(LFResolvedFanIn source) {
            boolean hasLoads = false;
            boolean hasDrivers = false;
            NLLogicGate enclosingLogicGate = this.getEnclosingGate();
            NLInstanceGate enclosingGate = enclosingLogicGate.getEnclosingGate();
            hasLoads |= this.addPortAndMakeConnection(source.getCenter(), NLPort.NLPortDirection.DIR_OUT, enclosingLogicGate, enclosingGate) != null;
            for (IRfNamedElement driver : source.getBorder()) {
                hasDrivers |= this.addPortAndMakeConnection(driver, NLPort.NLPortDirection.DIR_IN, enclosingLogicGate, enclosingGate) != null;
            }
            return (NLInternalLogicGate)this.validateLogicGate(source.getMarker(), null, hasLoads, hasDrivers);
        }

        private NLInternalLogicGate initAsInternalLogicGate2(LFResolvedFanIn source) {
            boolean hasLoads = false;
            boolean hasDrivers = false;
            NLLogicGate enclosingLogicGate = this.getEnclosingGate();
            IRfNamedElement load = source.getCenter();
            NLPort port = this.addLogicPort(load, NLPort.NLPortDirection.DIR_OUT);
            hasLoads |= this.makeConnection(port, enclosingLogicGate, load);
            for (IRfNamedElement driver : source.getBorder()) {
                port = this.addLogicPort(driver, NLPort.NLPortDirection.DIR_IN);
                hasDrivers |= this.makeConnection(port, enclosingLogicGate, driver);
            }
            return (NLInternalLogicGate)this.validateLogicGate(source.getMarker(), null, hasLoads, hasDrivers);
        }

        @Override
        protected String getLogicPortAndConnectionName(IRfNamedElement targetSignal) {
            return NLUtils.getNLName(targetSignal instanceof HierarchicalElement ? ((HierarchicalElement)targetSignal).getFullName() : targetSignal);
        }

        @Override
        protected String getLogicPortAndConnectionLabel(IRfNamedElement targetSignal) {
            return NLUtils.getNLLabel(targetSignal instanceof HierarchicalElement ? ((HierarchicalElement)targetSignal).getFullName() : targetSignal);
        }

        @Override
        public NLGate getCopy(NLInstanceGate enclosingGate) {
            NLInternalLogicGate copy = new NLInternalLogicGate(this.getName(), (NLLogicGate)enclosingGate);
            copy.setParameters(this.getParameters().getCopy());
            copy.setLabel(this.getLabel());
            copy.setKind(this.getKind());
            ((NLGate)copy).setMapping(this.getMapping());
            return copy;
        }
    }
}

