/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.netlist.model;

import java.util.Collection;
import java.util.Collections;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.netlist.model.NLFactory;
import ro.amiq.dvt.diagrams.netlist.model.NLGateKind;
import ro.amiq.dvt.diagrams.netlist.model.NLInstanceGate;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.power.format.upf.DVTUPFPowerSwitchInfo;

public class NLPDSwitchGate
extends NLInstanceGate {
    protected NLPDSwitchGate(String name, NLInstanceGate enclosingGate) {
        super(name, enclosingGate);
    }

    @Override
    protected NLInstanceGate init(Object source) {
        this.setMapping(source);
        this.setParameters(NLFactory.createParameters());
        this.setKind(NLGateKind.POWER_SWITCH);
        return this;
    }

    @Override
    public Collection<GoToInfo> getGoToSource() {
        DVTUPFPowerSwitchInfo switchInfo = this.getPFSwitchInfo();
        if (switchInfo == null) {
            return null;
        }
        return Collections.singleton(GoToInfo.of(switchInfo.getFilePath(), -1, -1, switchInfo.getStartLine(), switchInfo.getEndLine(), switchInfo.getName(), LanguageKind.PF));
    }

    public DVTUPFPowerSwitchInfo getPFSwitchInfo() {
        return this.getMapping(DVTUPFPowerSwitchInfo.class);
    }

    public String getPowerSwichName() {
        DVTUPFPowerSwitchInfo switchInfo = this.getPFSwitchInfo();
        if (switchInfo == null) {
            return "";
        }
        return switchInfo.getName();
    }
}

