/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.netlist.model;

import ro.amiq.dvt.model.reflection.ElementPath;

public class NLParameters {
    private long flags = 0L;
    private ElementPath topPath;

    public static final NLParameters getDefault() {
        return new NLParameters().addFlag(NLParametersFlag.IS_VISIBLE);
    }

    public NLParameters addFlag(NLParametersFlag flag) {
        if (flag == null) {
            return this;
        }
        this.flags |= flag.value();
        return this;
    }

    public NLParameters removeFlag(NLParametersFlag flag) {
        if (flag == null) {
            return this;
        }
        long flagValue = flag.value();
        if ((this.flags & flagValue) != 0L) {
            this.flags &= flagValue ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return this;
    }

    public NLParameters removeAllFlags() {
        this.flags = 0L;
        return this;
    }

    public NLParameters setFlag(NLParametersFlag flag, boolean value) {
        if (value) {
            this.addFlag(flag);
        } else {
            this.removeFlag(flag);
        }
        return this;
    }

    public boolean hasFlag(NLParametersFlag flag) {
        if (flag == null) {
            return this.flags == 0L;
        }
        return (this.flags & flag.value()) != 0L;
    }

    public boolean hasFlags(long flagValues) {
        return (this.flags & flagValues) != 0L;
    }

    public boolean isVisible() {
        return this.hasFlag(NLParametersFlag.IS_VISIBLE);
    }

    public boolean hasSchematicShowPortWidth() {
        return this.hasFlag(NLParametersFlag.DIAGRAM_SHOW_PORT_WIDTH);
    }

    public boolean hasSchematicShowPortFullyQualifiedType() {
        return this.hasFlag(NLParametersFlag.DIAGRAM_SHOW_PORT_FULLY_QUALIFIED_NAME);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        NLParametersFlag[] nLParametersFlagArray = NLParametersFlag.values();
        int n = nLParametersFlagArray.length;
        int n2 = 0;
        while (n2 < n) {
            NLParametersFlag flag = nLParametersFlagArray[n2];
            if ((this.flags & flag.value()) != 0L) {
                result.append((Object)flag).append(" | ");
            }
            ++n2;
        }
        return result.toString();
    }

    public NLParameters addTopPath(ElementPath topPath) {
        this.topPath = topPath;
        return this;
    }

    public ElementPath getTopPath() {
        return this.topPath;
    }

    public boolean hasPath() {
        return this.topPath != null;
    }

    public NLParameters getCopy() {
        NLParameters copy = new NLParameters();
        copy.flags = this.flags;
        copy.topPath = this.topPath;
        return copy;
    }

    public static enum NLParametersFlag {
        IS_VISIBLE,
        INNER_VISIBLE,
        OUTER_VISIBLE,
        IS_FOCUSED,
        IS_ACTION_SELECTED,
        IS_ENCLOSING_ACTION_SELECTED,
        IS_RELEVANT,
        IS_DELETED,
        IS_FILTERED,
        TO_EXPAND,
        TO_COLLAPSE,
        IS_PLAIN_ASSIGN,
        IS_BIDIRECTIONAL_EDGE,
        IS_GATE_WITH_FLOW_CONNECTION,
        IS_GATE_AS_BLOCK,
        IS_PRIMITIVE_INSTANCE,
        IS_UNKNOWN_DESIGN_PORT,
        IS_PORT_IN_PORT_CONNECTION,
        IS_TRACE_SOURCE,
        IS_TRACE_DESTINATION,
        IS_TRACE_START,
        IS_DETAILED_LOGIC_GATE,
        SHOW_SOURCES,
        SHOW_DESTINATIONS,
        IS_REFACTORING_CONFLICT,
        IS_REFACTORING_INITIAL_GATE,
        SCHEMATIC_SHOW_CONSTANTS,
        DIAGRAM_SHOW_PORT_WIDTH,
        DIAGRAM_SHOW_PORT_FULLY_QUALIFIED_NAME;


        public long value() {
            int ordinal = this.ordinal();
            long result = 1L << ordinal;
            return result;
        }
    }
}

