/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.netlist.model;

import de.cau.cs.kieler.core.kgraph.KPort;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.diagrams.klay.KLayDiagramDebug;
import ro.amiq.dvt.diagrams.netlist.model.INLViewLabeled;
import ro.amiq.dvt.diagrams.netlist.model.INLViewSelectable;
import ro.amiq.dvt.diagrams.netlist.model.NLAbstractBase;
import ro.amiq.dvt.diagrams.netlist.model.NLConnection;
import ro.amiq.dvt.diagrams.netlist.model.NLFlowSequentialLogicGate;
import ro.amiq.dvt.diagrams.netlist.model.NLGate;
import ro.amiq.dvt.diagrams.netlist.model.NLGateKind;
import ro.amiq.dvt.diagrams.netlist.model.NLParameters;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.NotNull;

public class NLPort
extends NLAbstractBase
implements INLViewLabeled,
INLViewSelectable {
    private NLPortDirection direction;
    private NLConnection.NLConnectionKind kind;
    private Map<NLConnection, NLConnection> connections;
    private Collection<GoToInfo> goToSource;
    private KPort cachedKPort;
    private String pfInfo;
    private String qualifiedName;
    private String waveformValue;
    public static final String INTERNAL_SAME_NAMED_PORT_SUFFIX = "__dvt__internal__me__port";
    public static final NLPortDirection INTERNAL_SAME_NAMED_PORT_DIRECTION = NLPortDirection.DIR_INOUT;
    public static final String SELF_LOOP_PORT_SUFFIX = "__dvt__internal__self__loop_ port";

    protected NLPort(String name, NLGate enclosingGate, NLPortDirection portDirection, NLConnection.NLConnectionKind kind) {
        super(name, enclosingGate);
        this.direction = portDirection == NLPortDirection.DIR_BUFFER ? NLPortDirection.DIR_INOUT : portDirection;
        this.kind = kind;
    }

    public NLPortDirection getDirection() {
        return this.direction;
    }

    public void setDirection(NLPortDirection direction) {
        this.direction = direction;
    }

    public NLConnection.NLConnectionKind getKind() {
        return this.kind;
    }

    public void setKind(NLConnection.NLConnectionKind kind) {
        this.kind = kind;
    }

    public boolean hasConnections() {
        return this.connections != null && !this.connections.isEmpty();
    }

    @NotNull
    public Collection<NLConnection> getConnections() {
        if (this.connections == null) {
            return Collections.emptySet();
        }
        return this.connections.values();
    }

    public int getNofConnections() {
        if (this.connections == null) {
            return 0;
        }
        return this.connections.size();
    }

    public void setGoToInfo(Collection<GoToInfo> sourceInfo) {
        this.goToSource = sourceInfo;
    }

    @Override
    public Collection<GoToInfo> getGoToSource() {
        return this.goToSource;
    }

    public KPort getCachedKPort() {
        return this.cachedKPort;
    }

    public void setCachedKPort(KPort cachedKPort) {
        this.cachedKPort = cachedKPort;
    }

    @NotNull
    public List<NLConnection> getInternalConnections() {
        if (this.connections == null) {
            return Collections.emptyList();
        }
        NLGate enclosingGate = this.getEnclosingGate();
        ArrayList<NLConnection> internalConns = new ArrayList<NLConnection>(2);
        for (NLConnection conn : this.getConnections()) {
            if (conn.getEnclosingGate() != enclosingGate) continue;
            internalConns.add(conn);
        }
        return internalConns;
    }

    @NotNull
    public List<NLConnection> getExternalConnections() {
        if (this.connections == null) {
            return Collections.emptyList();
        }
        NLGate enclosingGate = this.getEnclosingGate();
        ArrayList<NLConnection> externalConns = new ArrayList<NLConnection>(2);
        for (NLConnection conn : this.getConnections()) {
            if (conn.getEnclosingGate() == enclosingGate) continue;
            externalConns.add(conn);
        }
        return externalConns;
    }

    public void addConnection(NLConnection conn) {
        if (this.connections == null) {
            this.connections = new LinkedHashMap<NLConnection, NLConnection>(2);
        }
        this.connections.put(conn, conn);
    }

    public boolean removeConnection(NLConnection conn) {
        if (this.connections == null) {
            return false;
        }
        return this.connections.remove(conn) != null;
    }

    public boolean isEdgePort() {
        return this.kind == NLConnection.NLConnectionKind.COMMON_EDGE || this.kind == NLConnection.NLConnectionKind.BUNDLE_EDGE;
    }

    public boolean isSignalPort() {
        return this.kind == NLConnection.NLConnectionKind.COMMON_SIGNAL || this.kind == NLConnection.NLConnectionKind.BUNDLE_SIGNAL;
    }

    public boolean isInterfacePort() {
        return this.kind == NLConnection.NLConnectionKind.BUNDLE_SIGNAL || this.kind == NLConnection.NLConnectionKind.BUNDLE_EDGE;
    }

    public boolean isImplicitPort() {
        return this.kind == NLConnection.NLConnectionKind.IMPLICIT_SIGNAL;
    }

    public boolean isUnknownDesignPort() {
        return this.hasFlag(NLParameters.NLParametersFlag.IS_UNKNOWN_DESIGN_PORT);
    }

    public boolean isTopGatePort() {
        NLGate enclosingGate = this.getEnclosingGate();
        return enclosingGate != null && enclosingGate.isTopGate();
    }

    public boolean isFlowSequentialPort() {
        NLGate enclosingGate = this.getEnclosingGate();
        return enclosingGate instanceof NLFlowSequentialLogicGate;
    }

    public boolean isPortInBidirectionalConnection() {
        if (this.connections == null) {
            return false;
        }
        for (NLConnection connection : this.connections.values()) {
            if (!connection.hasFlag(NLParameters.NLParametersFlag.IS_BIDIRECTIONAL_EDGE)) continue;
            return true;
        }
        return false;
    }

    public NLPort getCopy(NLGate enclosingGate) {
        NLPort copy = new NLPort(this.getName(), enclosingGate, this.getDirection(), this.getKind());
        copy.setParameters(this.getParameters().getCopy());
        copy.setGoToInfo(this.getGoToSource());
        copy.setLabel(this.getLabel());
        copy.setPfInfo(this.getPfInfo());
        copy.setQualifiedName(this.getQualifiedName());
        copy.setWaveformValue(this.getWaveformValue());
        return copy;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.direction == null ? 0 : this.direction.hashCode());
        result = 31 * result + (this.kind == null ? 0 : this.kind.hashCode());
        NLGate enclosingGate = this.getEnclosingGate();
        result = 31 * result + (enclosingGate == null ? 0 : enclosingGate.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        NLPort other = (NLPort)obj;
        if (this.direction != other.direction) {
            return false;
        }
        if (this.kind != other.kind) {
            return false;
        }
        NLGate enclosingGate = this.getEnclosingGate();
        NLGate otherEnclosingGate = other.getEnclosingGate();
        return !(enclosingGate == null ? otherEnclosingGate != null : !enclosingGate.equals(otherEnclosingGate));
    }

    @Override
    public String toString() {
        if (this.isEdgePort()) {
            return this.getName();
        }
        NLGate enclosingGate = this.getEnclosingGate();
        return String.valueOf(enclosingGate.getKind() == NLGateKind.LOGIC ? enclosingGate.toString() : enclosingGate.getLabel()) + " . " + this.getLabel();
    }

    @Override
    protected void dispose() {
        super.dispose();
        this.connections = null;
        this.goToSource = null;
    }

    @Override
    public boolean hasGoToSource() {
        Collection<GoToInfo> goToInfo = this.getGoToSource();
        if (goToInfo == null || goToInfo.isEmpty()) {
            KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.NL_DIAGRAM_ACTION, "Go to source null for", this);
            return false;
        }
        return true;
    }

    @Override
    public Collection<NLPort> getSourcePorts() {
        LinkedHashSet<NLPort> sourcePorts = new LinkedHashSet<NLPort>();
        for (NLConnection connection : this.getConnections()) {
            sourcePorts.addAll(connection.getSourcePorts());
        }
        sourcePorts.remove(this);
        return sourcePorts;
    }

    @Override
    public Collection<NLPort> getDestinationPorts() {
        LinkedHashSet<NLPort> destinationPorts = new LinkedHashSet<NLPort>();
        for (NLConnection connection : this.getConnections()) {
            destinationPorts.addAll(connection.getDestinationPorts());
        }
        destinationPorts.remove(this);
        return destinationPorts;
    }

    @Override
    public Collection<NLGate> getSourceGates() {
        return null;
    }

    @Override
    public Collection<NLGate> getDestinationGates() {
        return null;
    }

    public String getPfInfo() {
        return this.pfInfo;
    }

    public void setPfInfo(String pfInfo) {
        this.pfInfo = pfInfo;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public void setQualifiedName(String qualifiedName) {
        this.qualifiedName = qualifiedName;
    }

    public boolean isBusNamePort() {
        return this.getName() != null && this.getName().contains(INTERNAL_SAME_NAMED_PORT_SUFFIX);
    }

    public boolean isMirroredPort() {
        return this.getName() != null && this.getName().contains("_MIRROR_DUMMY_PORT_SUFFIX");
    }

    public String getWaveformValue() {
        return this.waveformValue;
    }

    public void setWaveformValue(String waveformValue) {
        this.waveformValue = waveformValue;
    }

    public static enum NLPortDirection {
        DIR_NONE,
        DIR_IN,
        DIR_OUT,
        DIR_INOUT,
        DIR_REF,
        DIR_BUFFER,
        DIR_LINKAGE;

    }
}

