/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.netlist.model;

import java.util.Collection;
import ro.amiq.dvt.diagrams.netlist.model.NLConnection;
import ro.amiq.dvt.diagrams.netlist.model.NLGate;
import ro.amiq.dvt.diagrams.netlist.model.NLGateKind;
import ro.amiq.dvt.diagrams.netlist.model.NLInstanceGate;
import ro.amiq.dvt.diagrams.netlist.model.NLPort;
import ro.amiq.dvt.diagrams.netlist.utils.NLUtils;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.IRfPortElement;

public class NLPortGate
extends NLGate {
    protected NLPort.NLPortDirection direction;

    protected NLPortGate(String name, NLInstanceGate enclosingGate) {
        super(name, enclosingGate);
    }

    @Override
    protected NLPortGate init(Object source) {
        if (this.isInit()) {
            return this;
        }
        if (!(source instanceof IRfPortElement)) {
            return null;
        }
        this.setKind(NLGateKind.PORT);
        this.setMapping(source);
        this.direction = NLUtils.getPortDirectionFrom((IRfPortElement)source);
        this.addSameNamedSignalAndPort(NLConnection.NLConnectionKind.COMMON_SIGNAL);
        return this;
    }

    @Override
    public NLPort getPort(String name) {
        return this.getSameNamedPort();
    }

    public NLPort.NLPortDirection getDirection() {
        return this.direction;
    }

    public boolean isInput() {
        return this.direction == NLPort.NLPortDirection.DIR_IN;
    }

    public boolean isOutput() {
        return this.direction == NLPort.NLPortDirection.DIR_OUT;
    }

    public boolean isInout() {
        return this.direction == NLPort.NLPortDirection.DIR_INOUT;
    }

    @Override
    public Collection<GoToInfo> getGoToSource() {
        return null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.direction == null ? 0 : this.direction.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        NLPortGate other = (NLPortGate)obj;
        return this.direction == other.direction;
    }

    @Override
    protected void dispose() {
        super.dispose();
        this.direction = NLPort.NLPortDirection.DIR_NONE;
    }

    @Override
    public NLGate getCopy(NLInstanceGate enclosingGate) {
        NLPortGate copy = new NLPortGate(this.getName(), enclosingGate);
        copy.setParameters(this.getParameters().getCopy());
        copy.setLabel(this.getLabel());
        copy.setKind(this.getKind());
        copy.setMapping(this.getMapping());
        return copy;
    }
}

