/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.netlist.model;

import ro.amiq.dvt.diagrams.netlist.model.NLParameters;
import ro.amiq.dvt.ui.preferences.PrefConst;

public class NLPortLabelOptions {
    private long flags;

    private static NLPortLabelOptions getDefault() {
        NLPortLabelOptions portLabelOptions = new NLPortLabelOptions();
        portLabelOptions.setFlag(NLPortLabelOptionsFlag.DIAGRAM_SHOW_PORT_WIDTH, PrefConst.getDiagramShowPortWidth());
        portLabelOptions.setFlag(NLPortLabelOptionsFlag.DIAGRAM_SHOW_PORT_FULLY_QUALIFIED_TYPE, PrefConst.getDiagramShowFullyQualifiedType());
        return portLabelOptions;
    }

    public static NLPortLabelOptions getFromParameters(NLParameters parameters) {
        if (parameters == null) {
            return NLPortLabelOptions.getDefault();
        }
        NLPortLabelOptions portLabelOptions = new NLPortLabelOptions();
        portLabelOptions.setFlag(NLPortLabelOptionsFlag.DIAGRAM_SHOW_PORT_WIDTH, parameters.hasSchematicShowPortWidth());
        portLabelOptions.setFlag(NLPortLabelOptionsFlag.DIAGRAM_SHOW_PORT_FULLY_QUALIFIED_TYPE, parameters.hasSchematicShowPortFullyQualifiedType());
        return portLabelOptions;
    }

    public static NLPortLabelOptions of(NLPortLabelOptionsFlag ... flags) {
        NLPortLabelOptions options = new NLPortLabelOptions();
        if (flags == null) {
            return options;
        }
        NLPortLabelOptionsFlag[] nLPortLabelOptionsFlagArray = flags;
        int n = flags.length;
        int n2 = 0;
        while (n2 < n) {
            NLPortLabelOptionsFlag flag = nLPortLabelOptionsFlagArray[n2];
            options.addFlag(flag);
            ++n2;
        }
        return options;
    }

    private NLPortLabelOptions addFlag(NLPortLabelOptionsFlag flag) {
        if (flag == null) {
            return this;
        }
        this.flags |= flag.value();
        return this;
    }

    private NLPortLabelOptions removeFlag(NLPortLabelOptionsFlag flag) {
        if (flag == null) {
            return this;
        }
        long flagValue = flag.value();
        if ((this.flags & flagValue) != 0L) {
            this.flags &= flagValue ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return this;
    }

    private NLPortLabelOptions setFlag(NLPortLabelOptionsFlag flag, boolean value) {
        if (value) {
            this.addFlag(flag);
        } else {
            this.removeFlag(flag);
        }
        return this;
    }

    public boolean hasFlag(NLPortLabelOptionsFlag flag) {
        if (flag == null) {
            return this.flags == 0L;
        }
        return (this.flags & flag.value()) != 0L;
    }

    public static enum NLPortLabelOptionsFlag {
        DIAGRAM_SHOW_PORT_WIDTH,
        DIAGRAM_SHOW_PORT_FULLY_QUALIFIED_TYPE;


        public long value() {
            int ordinal = this.ordinal();
            long result = 1L << ordinal;
            return result;
        }
    }
}

