/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.netlist.model;

import java.util.List;
import ro.amiq.dvt.diagrams.netlist.model.NLFactory;
import ro.amiq.dvt.diagrams.netlist.model.NLGateKind;
import ro.amiq.dvt.diagrams.netlist.model.NLInstanceGate;
import ro.amiq.dvt.diagrams.netlist.model.NLParameters;
import ro.amiq.dvt.diagrams.netlist.utils.NLUtils;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;

public class NLRefactoringGate
extends NLInstanceGate {
    private List<HidOperator> portConnections;
    boolean refactoringStart;

    protected NLRefactoringGate(String name, NLInstanceGate enclosingGate, NLGateKind kind, IRfBreadcrumbElement mapping) {
        super(name, enclosingGate);
        this.setKind(kind);
        this.setMapping(mapping);
        IRfNamedElement design = NLUtils.getNLDesign(mapping);
        this.setLabel(NLFactory.createLabel(mapping, design));
        this.setParameters(NLFactory.createParameters());
    }

    protected NLRefactoringGate(String name, NLInstanceGate enclosingGate) {
        super(name, enclosingGate);
    }

    public List<HidOperator> getPortConnections() {
        return this.portConnections;
    }

    public void setPortConnections(List<HidOperator> portConnections) {
        this.portConnections = portConnections;
    }

    public void setRefactoringStart(boolean refactoringStart) {
        this.refactoringStart = refactoringStart;
        if (refactoringStart) {
            this.addFlag(NLParameters.NLParametersFlag.IS_REFACTORING_INITIAL_GATE);
        }
    }

    public boolean isRefactoringStart() {
        return this.refactoringStart;
    }

    @Override
    public boolean hasStepInto() {
        return false;
    }

    @Override
    public boolean hasGoToDeclaration() {
        if (this.kind != NLGateKind.DESIGN && this.kind != NLGateKind.INSTANCE && this.kind != NLGateKind.REFACTORING_OK && this.kind != NLGateKind.REFACTORING_SIDE_EFFECT) {
            return false;
        }
        IRfDesignElement design = this.getDesign();
        return design instanceof IRfDesignElement && !design.isPredefined();
    }
}

