/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.netlist.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.diagrams.klay.KLayDiagramDebug;
import ro.amiq.dvt.diagrams.netlist.DMemoryAccessor;
import ro.amiq.dvt.diagrams.netlist.model.NLConnection;
import ro.amiq.dvt.diagrams.netlist.model.NLFactory;
import ro.amiq.dvt.diagrams.netlist.model.NLGate;
import ro.amiq.dvt.diagrams.netlist.model.NLGateKind;
import ro.amiq.dvt.diagrams.netlist.model.NLInstanceGate;
import ro.amiq.dvt.diagrams.netlist.model.NLInstanceGateExpandState;
import ro.amiq.dvt.diagrams.netlist.model.NLParameters;
import ro.amiq.dvt.diagrams.netlist.model.NLPort;
import ro.amiq.dvt.diagrams.netlist.utils.NLUtils;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.model.reflection.DummyInstance;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.HierarchicalElement;
import ro.amiq.dvt.model.reflection.IRfBlockElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.ui.trace.connections.model.TCNode;

public class NLTCInstanceGate
extends NLInstanceGate {
    private DMemoryAccessor memoryAccessor;

    protected NLTCInstanceGate(String name, NLInstanceGate enclosingGate, DMemoryAccessor memoryAccessor) {
        super(name, enclosingGate);
        this.memoryAccessor = memoryAccessor;
    }

    @Override
    protected NLTCInstanceGate init(Object source) {
        if (this.isInit()) {
            return this;
        }
        NLGateKind gateKind = this.translateToValidInstanceGate(source);
        if (gateKind == null) {
            return null;
        }
        this.setKind(gateKind);
        this.setMapping(source);
        switch (gateKind) {
            case INSTANCE: {
                return this.initAsTCInstance((TCNode)source);
            }
            case DESIGN: 
            case BLOCK: {
                return this.initAsTCDesign((TCNode)source);
            }
        }
        return null;
    }

    @Override
    protected NLGateKind translateToValidInstanceGate(Object element) {
        if (!(element instanceof TCNode)) {
            return null;
        }
        switch (((TCNode)element).type) {
            case INSTANCE: {
                return NLGateKind.INSTANCE;
            }
            case DESIGN: {
                return NLGateKind.DESIGN;
            }
            case BLOCK: {
                return NLGateKind.BLOCK;
            }
        }
        return null;
    }

    protected NLTCInstanceGate initAsTCInstance(TCNode node) {
        this.addTCPorts(node, NLParameters.NLParametersFlag.OUTER_VISIBLE);
        this.addInstanceParameters();
        return this;
    }

    private void addTCPorts(TCNode node, NLParameters.NLParametersFlag portVisibilityFlag) {
        if (node == null) {
            return;
        }
        for (IRfPortElement portElement : node.getHotPorts()) {
            NLPort existingPort = this.getPort(portElement);
            if (existingPort != null) {
                existingPort.addFlag(portVisibilityFlag);
                KLayDiagramDebug.debugInfo(KLayDiagramDebug.DebugRegion.NL_MODEL_CONSTRUCTION, "Gate already has port", portElement);
                continue;
            }
            boolean isBundleType = DesignUtils.isInterfacePort(portElement) || DesignUtils.isCompositeSignal(portElement);
            boolean isUnknownDesignPort = DesignUtils.isUnknownDesignPort(portElement);
            this.addPort(NLFactory.createPort(NLUtils.getNLName(portElement), NLUtils.getNLLabel(portElement), this, NLUtils.getPortDirectionFrom(portElement), isBundleType ? NLConnection.NLConnectionKind.BUNDLE_SIGNAL : null, isUnknownDesignPort, NLFactory.createGoTo(portElement, null), portVisibilityFlag));
            KLayDiagramDebug.debugInfo(KLayDiagramDebug.DebugRegion.NL_MODEL_CONSTRUCTION, "Added hot port", portElement);
        }
    }

    protected NLTCInstanceGate initAsTCDesign(TCNode node) {
        this.addTCSignals(node);
        this.addTCPorts(node, NLParameters.NLParametersFlag.INNER_VISIBLE);
        this.addInternalSignalConnections(this.getPorts());
        if (this.memoryAccessor == null || !this.memoryAccessor.hasELMemory()) {
            this.addTCInstanceGates(node);
            this.addTCBlockGates(node);
            return this;
        }
        ElementPath elementPath = node.getElementPath();
        if (elementPath == null) {
            return this;
        }
        ELInstance instance = this.memoryAccessor.getInstanceFor(elementPath);
        if (instance == null) {
            return this;
        }
        IRfInstanceElement description = instance.getDescription();
        List<Object> nodes = new ArrayList<TCNode>(1);
        if (description instanceof DummyInstance && ((DummyInstance)description).isGenerateInstance()) {
            nodes = this.getResolvedLocalGenerates(node);
        } else {
            nodes.add(node);
        }
        HashMap<IRfNamedElement, TCNode> genBlocksToAdd = new HashMap<IRfNamedElement, TCNode>();
        for (TCNode tCNode : nodes) {
            this.addELTCInstancesGates(genBlocksToAdd, tCNode);
        }
        this.addELTCBlockGates(genBlocksToAdd);
        return this;
    }

    private List<TCNode> getResolvedLocalGenerates(TCNode node) {
        ElementPath elementPath = node.getElementPath();
        if (elementPath == null) {
            return Collections.emptyList();
        }
        ELInstance instance = this.memoryAccessor.getInstanceFor(elementPath);
        if (instance == null) {
            return Collections.emptyList();
        }
        IRfNamedElement generateBinding = instance.getBinding(false);
        if (!(generateBinding instanceof IRfBlockElement)) {
            return Collections.emptyList();
        }
        if (!((IRfBlockElement)generateBinding).isLoopGenerate()) {
            return Arrays.asList(node);
        }
        TCNode parentNode = node.parent;
        ArrayList<TCNode> children = new ArrayList<TCNode>();
        for (TCNode childNode : parentNode.getChildren()) {
            ELInstance childInstance;
            ElementPath childPath;
            if (childNode.type != TCNode.TCNodeType.BLOCK || (childPath = childNode.getElementPath()) == null || (childInstance = this.memoryAccessor.getInstanceFor(childPath)) == null || childNode.type != TCNode.TCNodeType.BLOCK || generateBinding != childInstance.getBinding(false)) continue;
            children.add(childNode);
        }
        return children;
    }

    private void addELTCInstancesGates(Map<IRfNamedElement, TCNode> genBlocksToAdd, TCNode node) {
        if (node == null) {
            return;
        }
        ElementPath elementPath = node.getElementPath();
        if (elementPath == null) {
            return;
        }
        ELInstance instance = this.memoryAccessor.getInstanceFor(elementPath);
        boolean isELBlock = instance != null && this.memoryAccessor.isBlock(instance.getHierarchyPath());
        for (TCNode child : node.getChildren()) {
            ElementPath childPath = child.getElementPath();
            if (childPath == null) {
                this.addSubGate(child);
                continue;
            }
            ELInstance childInstance = this.memoryAccessor.getInstanceFor(childPath);
            if (childInstance == null) {
                this.addSubGate(child);
                continue;
            }
            IRfInstanceElement description = childInstance.getDescription();
            if (description instanceof DummyInstance && ((DummyInstance)description).isGenerateInstance()) {
                genBlocksToAdd.putIfAbsent(((DummyInstance)description).design, child);
                continue;
            }
            if (isELBlock) {
                this.setInstanceGenblockPrefix(child);
            }
            this.addSubGate(child);
        }
    }

    private void setInstanceGenblockPrefix(TCNode node) {
        ElementPath elementPath = node.getElementPath();
        if (elementPath == null) {
            return;
        }
        ELInstance instance = this.memoryAccessor.getInstanceFor(elementPath);
        if (instance == null) {
            return;
        }
        ElementPath parentPath = elementPath.removeLastSegment();
        ELInstance parentInstance = this.memoryAccessor.getInstanceFor(parentPath);
        if (parentInstance == null) {
            return;
        }
        ArrayList<String> prefixes = new ArrayList<String>();
        IRfInstanceElement parentDescription = parentInstance.getDescription();
        while (parentDescription instanceof DummyInstance && ((DummyInstance)parentDescription).isGenerateInstance()) {
            prefixes.add(parentDescription.toString());
            parentPath = parentPath.removeLastSegment();
            parentInstance = this.memoryAccessor.getInstanceFor(parentPath);
            if (parentInstance == null) break;
            parentDescription = parentInstance.getDescription();
        }
        if (prefixes.isEmpty()) {
            return;
        }
        StringBuilder prefix = new StringBuilder();
        int i = prefixes.size() - 1;
        while (i >= 0) {
            prefix.append((String)prefixes.get(i)).append(".");
            --i;
        }
        node.setGenblockPrefixPrefixForDiagram(prefix.toString());
    }

    private void addSubGate(TCNode node) {
        if (node.type == TCNode.TCNodeType.INSTANCE && node.hasHotSignals()) {
            this.addSubGate(NLFactory.createGate(node, this, this.memoryAccessor));
        }
    }

    private void addELTCBlockGates(Map<IRfNamedElement, TCNode> genBlocksToAdd) {
        for (TCNode genBlock : genBlocksToAdd.values()) {
            this.addSubGate(NLFactory.createGate(genBlock, this, this.memoryAccessor));
        }
    }

    private void addTCSignals(TCNode node) {
        if (node == null) {
            return;
        }
        List<IRfNamedElement> hotSignals = node.getHotSignals();
        if (hotSignals.isEmpty()) {
            KLayDiagramDebug.debugInfo(KLayDiagramDebug.DebugRegion.NL_MODEL_CONSTRUCTION, "TC gate has NO hot signals", new Object[0]);
            return;
        }
        for (IRfNamedElement hotSignal : hotSignals) {
            if (hotSignal instanceof HierarchicalElement) {
                hotSignal = ((HierarchicalElement)hotSignal).getFirstSegment();
            }
            if (this.getSignal(hotSignal) != null) {
                KLayDiagramDebug.debugInfo(KLayDiagramDebug.DebugRegion.NL_MODEL_CONSTRUCTION, "TC gate already has signal", hotSignal);
                continue;
            }
            boolean isBundleType = DesignUtils.isInterfacePort(hotSignal) || DesignUtils.isInterfaceInstance(hotSignal) || DesignUtils.isCompositeSignal(hotSignal);
            this.addSignal(NLFactory.createConnection(NLUtils.getNLName(hotSignal), NLUtils.getNLLabel(hotSignal), this, isBundleType ? NLConnection.NLConnectionKind.BUNDLE_SIGNAL : null, NLFactory.createGoTo(hotSignal, null)));
            KLayDiagramDebug.debugInfo(KLayDiagramDebug.DebugRegion.NL_MODEL_CONSTRUCTION, "Added hot signal", hotSignal);
        }
    }

    private void addTCInstanceGates(TCNode node) {
        if (node == null) {
            return;
        }
        for (TCNode child : node.getChildren()) {
            if (child.type != TCNode.TCNodeType.INSTANCE || !child.hasHotSignals()) continue;
            this.addSubGate(NLFactory.createGate(child, this, null));
        }
    }

    private void addTCBlockGates(TCNode node) {
        if (node == null) {
            return;
        }
        for (TCNode child : node.getChildren()) {
            if (child.type != TCNode.TCNodeType.BLOCK) continue;
            this.addSubGate(NLFactory.createGate(child, this, null));
        }
    }

    @Override
    public <T> T getMapping(Class<T> type) {
        IRfNamedElement nodeElement;
        Object mapping = this.getMapping();
        if (type.isInstance(mapping)) {
            return type.cast(mapping);
        }
        if (mapping instanceof TCNode && type.isInstance(nodeElement = ((TCNode)mapping).namedElement)) {
            return type.cast(nodeElement);
        }
        return null;
    }

    @Override
    public IRfDesignElement getDesign() {
        if (this.design != null) {
            return this.design;
        }
        TCNode node = this.getMapping(TCNode.class);
        if (node == null) {
            return null;
        }
        this.design = DesignUtils.getDesign(node.designRequest());
        return this.design;
    }

    @Override
    public boolean hasStepInto() {
        return false;
    }

    @Override
    public boolean hasGoToDeclaration() {
        return false;
    }

    @Override
    public NLTCInstanceGate expand(Set<Object> visited) {
        if (this.getExpandState() != NLInstanceGateExpandState.COLLAPSED) {
            return this;
        }
        if (this.getKind() != NLGateKind.INSTANCE && this.getKind() != NLGateKind.BUNDLE) {
            return this;
        }
        IRfDesignElement design = this.getDesign();
        if (design == null) {
            return this;
        }
        if (visited != null && visited.contains(design)) {
            return this;
        }
        this.initAsTCDesign(this.getMapping(TCNode.class));
        return this;
    }

    @Override
    public NLInstanceGate collapse() {
        if (this.getExpandState() == NLInstanceGateExpandState.COLLAPSED) {
            return this;
        }
        if (this.getKind() != NLGateKind.INSTANCE && this.getKind() != NLGateKind.BUNDLE) {
            return this;
        }
        this.initAsTCInstance(this.getMapping(TCNode.class));
        return this;
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.kind == null ? 0 : this.kind.hashCode());
        result = 31 * result + (this.mapping == null ? 0 : this.mapping.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NLTCInstanceGate other = (NLTCInstanceGate)obj;
        if (this.kind != other.kind) {
            return false;
        }
        return !(this.mapping == null ? other.mapping != null : !this.mapping.equals(other.mapping));
    }

    @Override
    public NLGate getCopy(NLInstanceGate enclosingGate) {
        NLTCInstanceGate copy = new NLTCInstanceGate(this.getName(), enclosingGate, this.memoryAccessor);
        copy.setParameters(this.getParameters().getCopy());
        copy.setLabel(this.getLabel());
        copy.setKind(this.getKind());
        ((NLGate)copy).setMapping(this.getMapping());
        return copy;
    }
}

