/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.netlist.rendering;

import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KLabel;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.kgraph.KPort;
import de.cau.cs.kieler.core.krendering.KColor;
import de.cau.cs.kieler.core.krendering.KFontBold;
import de.cau.cs.kieler.core.krendering.KFontItalic;
import de.cau.cs.kieler.core.krendering.KFontName;
import de.cau.cs.kieler.core.krendering.KFontSize;
import de.cau.cs.kieler.core.krendering.KRendering;
import de.cau.cs.kieler.core.krendering.KStyle;
import de.cau.cs.kieler.core.krendering.KText;
import de.cau.cs.kieler.core.krendering.LineStyle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import ro.amiq.dvt.diagrams.klay.rendering.KLayStyleFactory;
import ro.amiq.dvt.diagrams.netlist.NLDiagramImporter;
import ro.amiq.dvt.diagrams.netlist.model.NLAbstractBase;
import ro.amiq.dvt.diagrams.netlist.model.NLConnection;
import ro.amiq.dvt.diagrams.netlist.model.NLGate;
import ro.amiq.dvt.diagrams.netlist.model.NLParameters;
import ro.amiq.dvt.diagrams.netlist.model.NLPort;
import ro.amiq.dvt.diagrams.netlist.rendering.INLRendering;
import ro.amiq.dvt.diagrams.netlist.rendering.NLDefaultRendering;
import ro.amiq.dvt.diagrams.netlist.rendering.NLRendering;
import ro.amiq.dvt.diagrams.netlist.utils.INLFilter;
import ro.amiq.dvt.diagrams.netlist.utils.NLConfig;
import ro.amiq.dvt.diagrams.netlist.utils.NLUtils;
import ro.amiq.dvt.draw.utils.ColorFactory;
import ro.amiq.dvt.draw.utils.FontFactory;
import ro.amiq.dvt.model.reflection.NotNull;

public interface NLRenderingUtils {
    public static final KLayStyleFactory STYLE_FACTORY = KLayStyleFactory.INSTANCE;

    public static void renderGate(KNode node, NLGate gate, NLDiagramImporter.Bundle bundle) {
        INLFilter filter;
        KRendering gateRendering = NLRenderingUtils.getGateRenderingOrDefault(gate);
        if (gateRendering == null) {
            return;
        }
        RGB customBackgroundRGB = null;
        if (bundle.config.hasFilters() && (filter = bundle.config.getFilterSet().getBlockColoringFilter(gate)) != null) {
            customBackgroundRGB = filter.getColor();
        }
        int hLevel = NLUtils.getHLevel(gate);
        EList styles = gateRendering.getStyles();
        KColor bgColor = customBackgroundRGB != null ? KLayStyleFactory.createColorFromRGB(ColorFactory.getInstance().depthRGB(customBackgroundRGB, bundle.maxHDepth, hLevel)) : NLRenderingUtils.getColorOrDefault(bundle.config, gate, INLRendering.RenderingLayer.BACKGROUND, hLevel, bundle.maxHDepth);
        int bgAlpha = NLRenderingUtils.getAlphaOrDefault(gate, INLRendering.RenderingLayer.BACKGROUND, hLevel, bundle.maxHDepth);
        styles.add((Object)STYLE_FACTORY.createBackground(bgColor, bgAlpha));
        KColor fgColor = NLRenderingUtils.getColorOrDefault(bundle.config, gate, INLRendering.RenderingLayer.FOREGROUND, hLevel, bundle.maxHDepth);
        int fgAlpha = NLRenderingUtils.getAlphaOrDefault(gate, INLRendering.RenderingLayer.FOREGROUND, hLevel, bundle.maxHDepth);
        styles.add((Object)STYLE_FACTORY.createForeground(fgColor, fgAlpha));
        float lineWidth = NLRenderingUtils.getLineWidthOrDefault(INLRendering.RenderingLayer.FOREGROUND, gate);
        styles.add((Object)STYLE_FACTORY.createLineWidth(lineWidth));
        LineStyle lineStyle = NLRenderingUtils.getLineStyleOrDefault(gate);
        styles.add((Object)STYLE_FACTORY.createLineStyle(lineStyle));
        bgColor = NLRenderingUtils.getColorOrDefault(bundle.config, gate, INLRendering.RenderingLayer.BACKGROUND_SELECTION, hLevel, bundle.maxHDepth);
        bgAlpha = NLRenderingUtils.getAlphaOrDefault(gate, INLRendering.RenderingLayer.BACKGROUND_SELECTION, hLevel, bundle.maxHDepth);
        styles.add((Object)STYLE_FACTORY.createSelectionBackground(bgColor, bgAlpha));
        fgColor = NLRenderingUtils.getColorOrDefault(bundle.config, gate, INLRendering.RenderingLayer.FOREGROUND_SELECTION, hLevel, bundle.maxHDepth);
        fgAlpha = NLRenderingUtils.getAlphaOrDefault(gate, INLRendering.RenderingLayer.FOREGROUND_SELECTION, hLevel, bundle.maxHDepth);
        styles.add((Object)STYLE_FACTORY.createSelectionForeground(fgColor, fgAlpha));
        lineWidth = NLRenderingUtils.getLineWidthOrDefault(INLRendering.RenderingLayer.FOREGROUND_SELECTION, gate);
        styles.add((Object)STYLE_FACTORY.createSelectionLineWidth(lineWidth));
        node.getData().add((Object)gateRendering);
    }

    public static void renderDummyGate(KNode dummyNode) {
        KRendering gateRendering = NLRenderingUtils.getDummyGateRenderingOrDefault();
        if (gateRendering == null) {
            return;
        }
        EList styles = gateRendering.getStyles();
        KColor bgColor = KLayStyleFactory.createColorFromRGB(ColorFactory.getInstance().getRGB(255, 255, 255));
        int bgAlpha = 0;
        styles.add((Object)STYLE_FACTORY.createBackground(bgColor, bgAlpha));
        KColor fgColor = KLayStyleFactory.createColorFromRGB(ColorFactory.getInstance().getRGB(255, 255, 255));
        int fgAlpha = 0;
        styles.add((Object)STYLE_FACTORY.createForeground(fgColor, fgAlpha));
        dummyNode.getData().add((Object)gateRendering);
    }

    public static void renderLabel(KLabel label, NLAbstractBase elem, NLDiagramImporter.Bundle bundle) {
        KText labelRendering = NLRenderingUtils.getLabelRenderingOrDefault();
        if (labelRendering == null) {
            return;
        }
        EList styles = labelRendering.getStyles();
        int size = NLRenderingUtils.getFontSizeOrDefault(elem);
        styles.add((Object)STYLE_FACTORY.createFontSize(size));
        String fontName = NLRenderingUtils.getFontNameOrDefault(elem);
        styles.add((Object)STYLE_FACTORY.createFontName(fontName));
        KFontBold fontBold = NLRenderingUtils.getFontBoldOrDefault(elem);
        styles.add((Object)fontBold);
        KFontItalic fontItalic = NLRenderingUtils.getFontItalicOrDefault(elem);
        styles.add((Object)fontItalic);
        KColor fgColor = NLRenderingUtils.getColorOrDefault(bundle.config, elem, INLRendering.RenderingLayer.FOREGROUND_LABEL, 0, bundle.maxHDepth);
        int fgAlpha = NLRenderingUtils.getAlphaOrDefault(elem, INLRendering.RenderingLayer.FOREGROUND_LABEL, 0, bundle.maxHDepth);
        styles.add((Object)STYLE_FACTORY.createForeground(fgColor, fgAlpha));
        KColor labelBgColor = NLRenderingUtils.getColorOrDefault(bundle.config, elem, INLRendering.RenderingLayer.BACKGROUND_LABEL, 0, bundle.maxHDepth);
        if (labelBgColor != null) {
            int bgAlpha = NLRenderingUtils.getAlphaOrDefault(elem, INLRendering.RenderingLayer.BACKGROUND_LABEL, 0, bundle.maxHDepth);
            styles.add((Object)STYLE_FACTORY.createBackground(labelBgColor, bgAlpha));
        }
        fgColor = NLRenderingUtils.getColorOrDefault(bundle.config, elem, INLRendering.RenderingLayer.LABEL_SELECTION, 0, bundle.maxHDepth);
        fgAlpha = NLRenderingUtils.getAlphaOrDefault(elem, INLRendering.RenderingLayer.LABEL_SELECTION, 0, bundle.maxHDepth);
        styles.add((Object)STYLE_FACTORY.createSelectionForeground(fgColor, fgAlpha));
        label.getData().add((Object)labelRendering);
    }

    public static void renderEdge(KEdge edge, NLConnection nlSignal, NLDiagramImporter.Bundle bundle) {
        INLFilter filter;
        KRendering edgeRendering = NLRenderingUtils.getEdgeRenderingOrDefault(nlSignal);
        if (edgeRendering == null) {
            return;
        }
        RGB customBackgroundRGB = null;
        if (bundle.config.hasFilters() && !nlSignal.hasFlag(NLParameters.NLParametersFlag.IS_FOCUSED) && (filter = bundle.config.getFilterSet().getConnectionColoringFilter(nlSignal)) != null) {
            customBackgroundRGB = filter.getColor();
        }
        EList styles = edgeRendering.getStyles();
        KColor fgColor = customBackgroundRGB != null ? KLayStyleFactory.createColorFromRGB(customBackgroundRGB) : NLRenderingUtils.getColorOrDefault(bundle.config, nlSignal, INLRendering.RenderingLayer.FOREGROUND, 0, 1);
        int fgAlpha = NLRenderingUtils.getAlphaOrDefault(nlSignal, INLRendering.RenderingLayer.FOREGROUND, 0, 1);
        styles.add((Object)STYLE_FACTORY.createForeground(fgColor, fgAlpha));
        float lineWidth = customBackgroundRGB != null || nlSignal.hasFlag(NLParameters.NLParametersFlag.IS_FOCUSED) ? 2.0f : NLRenderingUtils.getLineWidthOrDefault(INLRendering.RenderingLayer.FOREGROUND, nlSignal);
        styles.add((Object)STYLE_FACTORY.createLineWidth(lineWidth));
        LineStyle lineStyle = NLRenderingUtils.getLineStyleOrDefault(nlSignal);
        styles.add((Object)STYLE_FACTORY.createLineStyle(lineStyle));
        fgColor = NLRenderingUtils.getColorOrDefault(bundle.config, nlSignal, INLRendering.RenderingLayer.FOREGROUND_SELECTION, 0, 1);
        fgAlpha = NLRenderingUtils.getAlphaOrDefault(nlSignal, INLRendering.RenderingLayer.FOREGROUND_SELECTION, 0, 1);
        styles.add((Object)STYLE_FACTORY.createSelectionForeground(fgColor, fgAlpha));
        lineWidth = NLRenderingUtils.getLineWidthOrDefault(INLRendering.RenderingLayer.FOREGROUND_SELECTION, nlSignal);
        styles.add((Object)STYLE_FACTORY.createSelectionLineWidth(lineWidth));
        edge.getData().add((Object)edgeRendering);
    }

    public static void renderPort(KPort port, NLPort nlPort, NLDiagramImporter.Bundle bundle) {
        INLFilter filter;
        KRendering portRendering = NLRenderingUtils.getPortRenderingOrDefault(nlPort);
        if (portRendering == null) {
            return;
        }
        RGB customForegroundRGB = null;
        if (nlPort.getLabel() != null && !nlPort.getLabel().isEmpty() && bundle.config.getFilterSet() != null && (filter = bundle.config.getFilterSet().getPortColoringFilter(nlPort)) != null) {
            customForegroundRGB = filter.getColor();
        }
        EList styles = portRendering.getStyles();
        KColor bgColor = NLRenderingUtils.getColorOrDefault(bundle.config, nlPort, INLRendering.RenderingLayer.BACKGROUND, 0, 1);
        int bgAlpha = NLRenderingUtils.getAlphaOrDefault(nlPort, INLRendering.RenderingLayer.BACKGROUND, 0, 1);
        styles.add((Object)STYLE_FACTORY.createBackground(bgColor, bgAlpha));
        KColor fgColor = customForegroundRGB != null ? KLayStyleFactory.createColorFromRGB(customForegroundRGB) : NLRenderingUtils.getColorOrDefault(bundle.config, nlPort, INLRendering.RenderingLayer.FOREGROUND, 0, 1);
        int fgAlpha = NLRenderingUtils.getAlphaOrDefault(nlPort, INLRendering.RenderingLayer.FOREGROUND, 0, 1);
        styles.add((Object)STYLE_FACTORY.createForeground(fgColor, fgAlpha));
        bgColor = NLRenderingUtils.getColorOrDefault(bundle.config, nlPort, INLRendering.RenderingLayer.BACKGROUND_SELECTION, 0, 1);
        bgAlpha = NLRenderingUtils.getAlphaOrDefault(nlPort, INLRendering.RenderingLayer.BACKGROUND_SELECTION, 0, 1);
        styles.add((Object)STYLE_FACTORY.createSelectionBackground(bgColor, bgAlpha));
        fgColor = NLRenderingUtils.getColorOrDefault(bundle.config, nlPort, INLRendering.RenderingLayer.FOREGROUND_SELECTION, 0, 1);
        fgAlpha = NLRenderingUtils.getAlphaOrDefault(nlPort, INLRendering.RenderingLayer.FOREGROUND_SELECTION, 0, 1);
        styles.add((Object)STYLE_FACTORY.createSelectionForeground(fgColor, fgAlpha));
        port.getData().add((Object)portRendering);
    }

    public static FontData getFontData(KLabel label) {
        if (label == null) {
            return null;
        }
        KRendering text = (KRendering)label.getData(KRendering.class);
        if (!(text instanceof KText)) {
            return null;
        }
        String fontName = null;
        int fontSize = 0;
        int fontStyle = 0;
        EList styles = text.getStyles();
        for (KStyle style : styles) {
            if (style instanceof KFontSize) {
                fontSize = ((KFontSize)style).getSize();
                continue;
            }
            if (style instanceof KFontName) {
                fontName = ((KFontName)style).getName();
                continue;
            }
            if (style instanceof KFontBold && ((KFontBold)style).isBold()) {
                fontStyle |= 1;
                continue;
            }
            if (!(style instanceof KFontItalic) || !((KFontItalic)style).isItalic()) continue;
            fontStyle |= 2;
        }
        return FontFactory.getInstance().getFontData(fontName, fontSize, fontStyle);
    }

    @NotNull
    public static KRendering getGateRenderingOrDefault(NLGate gate) {
        KRendering rendering = NLRendering.getInstance().getGateRendering(gate);
        if (rendering != null) {
            return rendering;
        }
        return NLDefaultRendering.getInstance().getGateRendering(gate);
    }

    @NotNull
    public static KRendering getDummyGateRenderingOrDefault() {
        KRendering rendering = NLRendering.getInstance().getDummyGateRendering();
        if (rendering != null) {
            return rendering;
        }
        return NLDefaultRendering.getInstance().getDummyGateRendering();
    }

    @NotNull
    public static KRendering getEdgeRenderingOrDefault(NLConnection nlSignal) {
        KRendering rendering = NLRendering.getInstance().getEdgeRendering(nlSignal);
        if (rendering != null) {
            return rendering;
        }
        return NLDefaultRendering.getInstance().getEdgeRendering(nlSignal);
    }

    @NotNull
    public static KRendering getPortRenderingOrDefault(NLPort nlPort) {
        KRendering rendering = NLRendering.getInstance().getPortRendering(nlPort);
        if (rendering != null) {
            return rendering;
        }
        return NLDefaultRendering.getInstance().getPortRendering(nlPort);
    }

    @NotNull
    public static KText getLabelRenderingOrDefault() {
        KText rendering = NLRendering.getInstance().getLabelRendering();
        if (rendering != null) {
            return rendering;
        }
        return NLDefaultRendering.getInstance().getLabelRendering();
    }

    @NotNull
    public static KColor getColorOrDefault(NLConfig config, NLAbstractBase object, INLRendering.RenderingLayer layer, int currentDepth, int maxDepth) {
        KColor color = NLRendering.getInstance().getColor(config, object, layer, currentDepth, maxDepth);
        if (color != null) {
            return color;
        }
        return NLDefaultRendering.getInstance().getColor(config, object, layer, currentDepth, maxDepth);
    }

    @NotNull
    public static int getAlphaOrDefault(NLAbstractBase object, INLRendering.RenderingLayer layer, int currentDepth, int maxDepth) {
        int alpha = NLRendering.getInstance().getAlpha(object, layer, currentDepth, maxDepth);
        if (alpha > -1) {
            return alpha;
        }
        return NLDefaultRendering.getInstance().getAlpha(object, layer, currentDepth, maxDepth);
    }

    @NotNull
    public static int getFontSizeOrDefault(NLAbstractBase object) {
        int fontSize = NLRendering.getInstance().getFontSize(object);
        if (fontSize > -1) {
            return fontSize;
        }
        return NLDefaultRendering.getInstance().getFontSize(object);
    }

    @NotNull
    public static String getFontNameOrDefault(NLAbstractBase object) {
        String fontName = NLRendering.getInstance().getFontName(object);
        if (fontName != null) {
            return fontName;
        }
        return NLDefaultRendering.getInstance().getFontName(object);
    }

    @NotNull
    public static KFontBold getFontBoldOrDefault(NLAbstractBase object) {
        KFontBold fontBold = NLRendering.getInstance().getFontBold(object);
        if (fontBold != null) {
            return fontBold;
        }
        return NLDefaultRendering.getInstance().getFontBold(object);
    }

    @NotNull
    public static KFontItalic getFontItalicOrDefault(NLAbstractBase object) {
        KFontItalic fontItalic = NLRendering.getInstance().getFontItalic(object);
        if (fontItalic != null) {
            return fontItalic;
        }
        return NLDefaultRendering.getInstance().getFontItalic(object);
    }

    @NotNull
    public static float getLineWidthOrDefault(INLRendering.RenderingLayer layer, NLAbstractBase object) {
        float lineWidth = NLRendering.getInstance().getLineWidth(layer, object);
        if (lineWidth > -1.0f) {
            return lineWidth;
        }
        return NLDefaultRendering.getInstance().getLineWidth(layer, object);
    }

    @NotNull
    public static LineStyle getLineStyleOrDefault(NLAbstractBase object) {
        LineStyle lineStyle = NLRendering.getInstance().getLineStyle(object);
        if (lineStyle != null) {
            return lineStyle;
        }
        return NLDefaultRendering.getInstance().getLineStyle(object);
    }
}

