/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.netlist.rendering.gui;

import de.cau.cs.kieler.core.krendering.KColor;
import de.cau.cs.kieler.core.krendering.KFontBold;
import de.cau.cs.kieler.core.krendering.KFontItalic;
import de.cau.cs.kieler.core.krendering.KRendering;
import de.cau.cs.kieler.core.krendering.KRenderingFactory;
import de.cau.cs.kieler.core.krendering.KText;
import de.cau.cs.kieler.core.krendering.LineStyle;
import org.eclipse.swt.graphics.RGB;
import ro.amiq.dvt.diagrams.klay.rendering.KLayStyleFactory;
import ro.amiq.dvt.diagrams.netlist.model.NLAbstractBase;
import ro.amiq.dvt.diagrams.netlist.model.NLConnection;
import ro.amiq.dvt.diagrams.netlist.model.NLGate;
import ro.amiq.dvt.diagrams.netlist.model.NLGateKind;
import ro.amiq.dvt.diagrams.netlist.model.NLInstanceGate;
import ro.amiq.dvt.diagrams.netlist.model.NLLogicGate;
import ro.amiq.dvt.diagrams.netlist.model.NLPDInstanceGate;
import ro.amiq.dvt.diagrams.netlist.model.NLParameters;
import ro.amiq.dvt.diagrams.netlist.model.NLPort;
import ro.amiq.dvt.diagrams.netlist.model.NLPortGate;
import ro.amiq.dvt.diagrams.netlist.model.NLRefactoringGate;
import ro.amiq.dvt.diagrams.netlist.rendering.INLRendering;
import ro.amiq.dvt.diagrams.netlist.rendering.NLDefaultRendering;
import ro.amiq.dvt.diagrams.netlist.rendering.NLDefaultRenderingConstants;
import ro.amiq.dvt.diagrams.netlist.utils.NLConfig;
import ro.amiq.dvt.diagrams.netlist.utils.NLConfiguration;
import ro.amiq.dvt.diagrams.netlist.utils.NLUtils;
import ro.amiq.dvt.draw.utils.ColorFactory;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.power.format.DVTPFModel;
import ro.amiq.dvt.utils.Utils;

public class NLDefaultGUIRendering
extends NLDefaultRendering {
    public static final KRenderingFactory FACTORY = KRenderingFactory.eINSTANCE;

    @Override
    public KRendering getGateRendering(NLGate gate) {
        return FACTORY.createKRectangle();
    }

    @Override
    public KRendering getDummyGateRendering() {
        return FACTORY.createKRectangle();
    }

    @Override
    public KRendering getEdgeRendering(NLConnection edge) {
        return FACTORY.createKPolyline();
    }

    @Override
    public KRendering getPortRendering(NLPort edge) {
        return FACTORY.createKRectangle();
    }

    @Override
    public KText getLabelRendering() {
        return FACTORY.createKText();
    }

    @Override
    @NotNull
    public KColor getBackgroundSelectionColor(NLAbstractBase object, int hLevel, int hDepth) {
        if (object instanceof NLGate) {
            return KLayStyleFactory.createColorFromRGB(NLDefaultRenderingConstants.SEL_BG_ANY_GATE_RGB);
        }
        return KLayStyleFactory.createColorFromRGB(NLDefaultRenderingConstants.SEL_DEFAULT_RGB);
    }

    @Override
    @NotNull
    public KColor getForegroundSelectionColor(NLAbstractBase object, int hLevel, int hDepth) {
        if (object instanceof NLGate) {
            if (!((NLGate)object).isTopGate()) {
                return KLayStyleFactory.createColorFromRGB(NLDefaultRenderingConstants.SEL_FG_ANY_GATE_RGB);
            }
            if (((NLGate)object).getKind() == NLGateKind.REFACTORING_INVISIBLE_GATE || ((NLGate)object).getKind() == NLGateKind.IMPLICIT) {
                return KLayStyleFactory.createColorFromRGB(NLDefaultRenderingConstants.REFACTORING_INVISIBLE_GATE_RGB);
            }
            return KLayStyleFactory.createColorFromRGB(NLDefaultRenderingConstants.SEL_FG_TOP_GATE_RGB);
        }
        if (object instanceof NLPort && ((NLPort)object).getKind() == NLConnection.NLConnectionKind.IMPLICIT_SIGNAL) {
            return KLayStyleFactory.createColorFromRGB(NLDefaultRenderingConstants.REFACTORING_INVISIBLE_GATE_RGB);
        }
        if (object instanceof NLConnection) {
            return KLayStyleFactory.createColorFromRGB(NLDefaultRenderingConstants.SEL_FG_CONNECTION_RGB);
        }
        return KLayStyleFactory.createColorFromRGB(NLDefaultRenderingConstants.SEL_DEFAULT_RGB);
    }

    @Override
    @NotNull
    public KColor getForegroundColor(NLAbstractBase object, int hLevel, int hDepth) {
        if (object instanceof NLPort && ((NLPort)object).getKind() == NLConnection.NLConnectionKind.IMPLICIT_SIGNAL) {
            return KLayStyleFactory.createColorFromRGB(NLDefaultRenderingConstants.REFACTORING_INVISIBLE_GATE_RGB);
        }
        if (object != null && object.hasFlag(NLParameters.NLParametersFlag.IS_FOCUSED)) {
            if (object instanceof NLGate) {
                return KLayStyleFactory.createColorFromRGB(NLDefaultRenderingConstants.ACTION_FG_GATE_RGB);
            }
            if (object instanceof NLConnection) {
                return KLayStyleFactory.createColorFromRGB(NLDefaultRenderingConstants.ACTION_FG_SIGNAL_RGB);
            }
            if (object instanceof NLPort) {
                return KLayStyleFactory.createColorFromRGB(NLDefaultRenderingConstants.ACTION_FG_PORT_RGB);
            }
        }
        if (object instanceof NLGate && ((NLGate)object).getKind() == NLGateKind.REFACTORING_INVISIBLE_GATE) {
            return KLayStyleFactory.createColorFromRGB(NLDefaultRenderingConstants.REFACTORING_INVISIBLE_GATE_RGB);
        }
        if (object != null && object.hasFlag(NLParameters.NLParametersFlag.IS_REFACTORING_CONFLICT)) {
            return KLayStyleFactory.createColorFromRGB(NLDefaultRenderingConstants.FG_REFACTORING_CONFLICT_RGB);
        }
        if (object != null && object.hasFlag(NLParameters.NLParametersFlag.IS_REFACTORING_INITIAL_GATE)) {
            return KLayStyleFactory.createColorFromRGB(NLDefaultRenderingConstants.FG_REFACTORING_INITIAL_GATE_RGB);
        }
        if (object == null || hLevel >= hDepth) {
            return KLayStyleFactory.createColorFromRGB(NLDefaultRenderingConstants.DEFAULT_FG_RGB);
        }
        if (object instanceof NLConnection) {
            NLConnection nlConn = (NLConnection)object;
            if (nlConn.isInterfaceConnection()) {
                return KLayStyleFactory.createColorFromRGB(NLDefaultRenderingConstants.FG_INTERFACE_CONNECTION_RGB);
            }
            if (nlConn.isEdge()) {
                return nlConn.isBidirectional() ? KLayStyleFactory.createColorFromRGB(NLDefaultRenderingConstants.FG_BIDIR_EDGE_RGB) : KLayStyleFactory.createColorFromRGB(NLDefaultRenderingConstants.FG_UNI_EDGE_RGB);
            }
            if (nlConn.isSignal()) {
                return KLayStyleFactory.createColorFromRGB(NLDefaultRenderingConstants.FG_SIGNAL_RGB);
            }
        }
        return KLayStyleFactory.createColorFromRGB(NLDefaultRenderingConstants.DEFAULT_FG_RGB);
    }

    @Override
    @NotNull
    public KColor getLabelForegroundSelectionColor(NLAbstractBase object, int hLevel, int hDepth) {
        if (object instanceof NLPort) {
            return KLayStyleFactory.createColorFromRGB(NLDefaultRenderingConstants.SEL_FG_LABEL_RGB);
        }
        return KLayStyleFactory.createColorFromRGB(NLDefaultRenderingConstants.SEL_DEFAULT_RGB);
    }

    @Override
    @NotNull
    public KColor getBackgroundColor(NLConfig config, NLAbstractBase object, int hLevel, int hDepth) {
        if (object == null || hLevel >= hDepth) {
            return KLayStyleFactory.createColorFromRGB(NLDefaultRenderingConstants.DEFAULT_BG_RGB);
        }
        if (object instanceof NLPort) {
            boolean isSource = object.hasFlag(NLParameters.NLParametersFlag.IS_TRACE_SOURCE);
            boolean isDestination = object.hasFlag(NLParameters.NLParametersFlag.IS_TRACE_DESTINATION);
            if (isSource) {
                return KLayStyleFactory.createColorFromRGB(NLDefaultRenderingConstants.DRIVER_RED);
            }
            if (isDestination) {
                return KLayStyleFactory.createColorFromRGB(NLDefaultRenderingConstants.LOAD_GREEN);
            }
            if (((NLPort)object).getKind() == NLConnection.NLConnectionKind.IMPLICIT_SIGNAL) {
                return KLayStyleFactory.createColorFromRGB(NLDefaultRenderingConstants.REFACTORING_INVISIBLE_GATE_RGB);
            }
            return KLayStyleFactory.createColorFromRGB(NLDefaultRenderingConstants.BG_INSTANCE_PORT_RGB);
        }
        if (object instanceof NLConnection) {
            if (((NLConnection)object).isImplicitSignal()) {
                return KLayStyleFactory.createColorFromRGB(NLDefaultRenderingConstants.REFACTORING_INVISIBLE_GATE_RGB);
            }
            return KLayStyleFactory.createColorFromRGB(NLDefaultRenderingConstants.BG_CONNECTION_RGB);
        }
        if (hLevel <= 0 && !(object instanceof NLRefactoringGate)) {
            return KLayStyleFactory.createColorFromRGB(NLDefaultRenderingConstants.BG_TOP_INSTANCE_RGB);
        }
        if (object instanceof NLGate) {
            RGB startingGateRGB = NLDefaultRenderingConstants.BG_ANY_GATE_RGB;
            switch (((NLGate)object).getKind()) {
                case BLOCK: {
                    startingGateRGB = NLDefaultRenderingConstants.BG_BLOCK_GATE_RGB;
                    break;
                }
                case BUNDLE: {
                    startingGateRGB = NLDefaultRenderingConstants.BG_BUNDLE_GATE_RGB;
                    break;
                }
                case DESIGN: {
                    startingGateRGB = NLDefaultRenderingConstants.BG_DESIGN_GATE_RGB;
                    break;
                }
                case INSTANCE: {
                    if (object.hasFlag(NLParameters.NLParametersFlag.IS_PRIMITIVE_INSTANCE)) {
                        startingGateRGB = NLDefaultRenderingConstants.BG_ASSIGN_GATE_RGB;
                        break;
                    }
                    if (config.getFlags().contains((Object)NLConfiguration.FOR_SPECADOR)) {
                        startingGateRGB = NLDefaultRenderingConstants.BG_SPECADOR_INSTANCE_GATE_RGB;
                        break;
                    }
                    startingGateRGB = NLDefaultRenderingConstants.BG_INSTANCE_GATE_RGB;
                    break;
                }
                case POWER_SWITCH: {
                    startingGateRGB = NLDefaultRenderingConstants.BG_BUNDLE_GATE_RGB;
                    break;
                }
                case POWER_DOMAIN: {
                    RGB rGB = startingGateRGB = object instanceof NLPDInstanceGate ? ((NLPDInstanceGate)object).getColor() : null;
                    if (startingGateRGB != null) break;
                    startingGateRGB = NLDefaultRenderingConstants.BG_INSTANCE_GATE_RGB;
                    break;
                }
                case REFACTORING_OK: {
                    startingGateRGB = NLDefaultRenderingConstants.BG_REFACTORING_OK_RGB;
                    break;
                }
                case REFACTORING_SIDE_EFFECT: 
                case REFACTORING_SIDE_UNCONNECTED: {
                    startingGateRGB = NLDefaultRenderingConstants.BG_REFACTORING_SIDE_EFFECT_RGB;
                    break;
                }
                case REFACTORING_INVISIBLE_GATE: 
                case IMPLICIT: {
                    startingGateRGB = NLDefaultRenderingConstants.REFACTORING_INVISIBLE_GATE_RGB;
                    break;
                }
                case LOGIC: {
                    NLLogicGate logicGate = (NLLogicGate)object;
                    if (logicGate.isAssign() || logicGate.isAlias()) {
                        startingGateRGB = NLDefaultRenderingConstants.BG_ASSIGN_GATE_RGB;
                        break;
                    }
                    if (!logicGate.isAlwaysBlock()) break;
                    startingGateRGB = logicGate.isSequentialAlwaysBlock() ? NLDefaultRenderingConstants.BG_SEQ_ALWAYS_BLOCK_GATE_RGB : NLDefaultRenderingConstants.BG_CONC_ALWAYS_BLOCK_GATE_RGB;
                    break;
                }
                case PORT: {
                    NLPortGate portGate = (NLPortGate)object;
                    if (portGate.isInput()) {
                        startingGateRGB = NLDefaultRenderingConstants.BG_INPUT_PORT_GATE_RGB;
                        break;
                    }
                    if (portGate.isOutput()) {
                        startingGateRGB = NLDefaultRenderingConstants.BG_OUTPUT_PORT_GATE_RGB;
                        break;
                    }
                    startingGateRGB = NLDefaultRenderingConstants.BG_INOUT_PORT_GATE_RGB;
                    break;
                }
            }
            return KLayStyleFactory.createColorFromRGB(ColorFactory.getInstance().depthRGB(startingGateRGB, hDepth, hLevel));
        }
        return KLayStyleFactory.createColorFromRGB(NLDefaultRenderingConstants.DEFAULT_BG_RGB);
    }

    @Override
    @NotNull
    public KColor getForegroundLabelColor(NLAbstractBase object, int hLevel, int hDepth) {
        if (object instanceof NLPort && object.hasFlag(NLParameters.NLParametersFlag.IS_FOCUSED)) {
            return KLayStyleFactory.createColorFromRGB(NLDefaultRenderingConstants.ACTION_FG_PORT_RGB);
        }
        return KLayStyleFactory.createColorFromRGB(NLDefaultRenderingConstants.DEFAULT_FG_RGB);
    }

    @Override
    @NotNull
    public KColor getBackgroundLabelColor(NLAbstractBase object, int hLevel, int hDepth) {
        if (!(object instanceof NLInstanceGate) || !Utils.isDiagramsShowPDInfo()) {
            return null;
        }
        DVTPFModel upfModel = NLUtils.getPFModel(object);
        if (upfModel == null) {
            return null;
        }
        ElementPath path = NLUtils.getGatePathToTop((NLInstanceGate)object);
        if (path == null) {
            return null;
        }
        RGB upfBgRGBForPath = upfModel.getPDBgRGBForPath(path);
        if (upfBgRGBForPath == null) {
            return null;
        }
        return KLayStyleFactory.createColorFromRGB(upfBgRGBForPath);
    }

    @Override
    public int getAlpha(NLAbstractBase object, INLRendering.RenderingLayer layer, int hLevel, int hDepth) {
        if (object instanceof NLPort var5_6 && port.isMirroredPort()) {
            return 0;
        }
        if (object instanceof NLGate && (((NLGate)object).getKind() == NLGateKind.REFACTORING_INVISIBLE_GATE || ((NLGate)object).getKind() == NLGateKind.IMPLICIT)) {
            return 0;
        }
        if (!(object instanceof NLGate) || layer != INLRendering.RenderingLayer.BACKGROUND) {
            return 255;
        }
        NLGateKind gateKind = NLUtils.getGateKind((NLGate)object);
        if (gateKind == NLGateKind.LOGIC || gateKind == NLGateKind.BUNDLE) {
            return 0;
        }
        if (object.hasFlag(NLParameters.NLParametersFlag.IS_PRIMITIVE_INSTANCE)) {
            return 0;
        }
        return 255;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getFontSize(NLAbstractBase object) {
        void var3_4;
        NLPort hasLogicGateFontSize2;
        if (object instanceof NLGate) {
            boolean hasLogicGateFontSize2 = NLUtils.isLogicGate(object) || object.hasFlag(NLParameters.NLParametersFlag.IS_PRIMITIVE_INSTANCE);
            return hasLogicGateFontSize2 ? 10 : 12;
        }
        NLAbstractBase nLAbstractBase = object;
        if (nLAbstractBase instanceof NLPort && (hasLogicGateFontSize2 = (NLPort)nLAbstractBase) == (NLPort)var3_4) {
            void port;
            NLGate enclosingGate = port.getEnclosingGate();
            if (port.isBusNamePort()) {
                return 9;
            }
            boolean hasLogicPortFontSize = NLUtils.isLogicGate(enclosingGate) || enclosingGate.hasFlag(NLParameters.NLParametersFlag.IS_PRIMITIVE_INSTANCE);
            return hasLogicPortFontSize ? 8 : 8;
        }
        if (object instanceof NLConnection) {
            return 8;
        }
        return 0;
    }

    @Override
    public String getFontName(NLAbstractBase object) {
        return "Ubuntu Mono";
    }

    @Override
    @NotNull
    public KFontBold getFontBold(NLAbstractBase object) {
        KFontBold fontBold = FACTORY.createKFontBold();
        if (object instanceof NLPort var3_4 && !port.isBusNamePort() || object instanceof NLConnection) {
            fontBold.setBold(false);
        }
        return fontBold;
    }

    @Override
    @NotNull
    public KFontItalic getFontItalic(NLAbstractBase object) {
        KFontItalic fontItalic = FACTORY.createKFontItalic();
        fontItalic.setItalic(false);
        return fontItalic;
    }

    @Override
    @NotNull
    public float getLineWidth(INLRendering.RenderingLayer layer, NLAbstractBase object) {
        if (layer == INLRendering.RenderingLayer.FOREGROUND_SELECTION) {
            return 3.0f;
        }
        if (object instanceof NLGate && (((NLGate)object).hasFlag(NLParameters.NLParametersFlag.IS_FOCUSED) || ((NLGate)object).hasFlag(NLParameters.NLParametersFlag.IS_REFACTORING_CONFLICT) || ((NLGate)object).hasFlag(NLParameters.NLParametersFlag.IS_REFACTORING_INITIAL_GATE))) {
            return 3.0f;
        }
        if (object instanceof NLConnection && ((NLConnection)object).isInterfaceConnection()) {
            return 2.0f;
        }
        return 1.0f;
    }

    @Override
    @NotNull
    public LineStyle getLineStyle(NLAbstractBase object) {
        return object instanceof NLGate && ((NLGate)object).getKind() == NLGateKind.BLOCK ? NLDefaultRenderingConstants.LINE_STYLE_BLOCK_GATE : NLDefaultRenderingConstants.DEFAULT_LINE_STYLE;
    }
}

