/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.netlist.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.diagrams.DProgressMonitor;
import ro.amiq.dvt.diagrams.exceptions.DCanceledException;
import ro.amiq.dvt.diagrams.netlist.model.NLAbstractBase;
import ro.amiq.dvt.diagrams.netlist.model.NLConnection;
import ro.amiq.dvt.diagrams.netlist.model.NLGate;
import ro.amiq.dvt.diagrams.netlist.model.NLGateKind;
import ro.amiq.dvt.diagrams.netlist.model.NLInstanceGate;
import ro.amiq.dvt.diagrams.netlist.model.NLLogicGate;
import ro.amiq.dvt.diagrams.netlist.model.NLParameters;
import ro.amiq.dvt.diagrams.netlist.model.NLPort;
import ro.amiq.dvt.diagrams.netlist.utils.NLConfig;
import ro.amiq.dvt.diagrams.netlist.utils.NLUtils;

public class NLAdvancedFiltersProcessors {
    private NLAdvancedFiltersProcessors() {
    }

    public static void showConnectiosBetweenGates(Set<NLInstanceGate> gates, NLConfig config, DProgressMonitor monitor) throws DCanceledException {
        NLAdvancedFiltersProcessors.checkCanceled(monitor);
        if (gates.size() < 2) {
            return;
        }
        LinkedHashMap<NLLogicGate, Set<NLInstanceGate>> logicInstanceMap = new LinkedHashMap<NLLogicGate, Set<NLInstanceGate>>();
        for (NLInstanceGate gate : gates) {
            NLAdvancedFiltersProcessors.checkCanceled(monitor);
            NLUtils.makeGateAndPortsVisible(gate);
            NLAdvancedFiltersProcessors.makeEnclosingGatesVisible(gate, null, true, monitor);
            gate.addFlag(NLParameters.NLParametersFlag.IS_RELEVANT);
            gate.addFlag(NLParameters.NLParametersFlag.IS_FOCUSED);
            NLAdvancedFiltersProcessors.findConnectionsBetween(gate, gates, null, null, new LinkedHashSet<NLPort>(), logicInstanceMap, config, monitor);
        }
    }

    public static void showConnectionsOfGate(NLInstanceGate gate, NLConfig config, boolean showInternalLogic, DProgressMonitor monitor, boolean isFlowDiagram) throws DCanceledException {
        NLAdvancedFiltersProcessors.checkCanceled(monitor);
        if (gate == null || gate.getKind() != NLGateKind.INSTANCE && gate.getKind() != NLGateKind.DESIGN && gate.getKind() != NLGateKind.LOGIC && gate.getKind() != NLGateKind.BUNDLE) {
            return;
        }
        NLUtils.makeGateAndPortsVisible(gate);
        gate.addFlag(NLParameters.NLParametersFlag.IS_RELEVANT);
        gate.addFlag(NLParameters.NLParametersFlag.IS_FOCUSED);
        LinkedHashSet<NLInstanceGate> initialEnclosingGates = new LinkedHashSet<NLInstanceGate>();
        NLAdvancedFiltersProcessors.makeEnclosingGatesVisible(gate, initialEnclosingGates, true, monitor);
        LinkedHashSet<NLAbstractBase> visitedInputs = new LinkedHashSet<NLAbstractBase>();
        LinkedHashSet<NLAbstractBase> visitedOutputs = new LinkedHashSet<NLAbstractBase>();
        for (NLPort port : gate.getPorts()) {
            NLAdvancedFiltersProcessors.checkCanceled(monitor);
            if (port.getDirection() == NLPort.NLPortDirection.DIR_IN || port.getDirection() == NLPort.NLPortDirection.DIR_INOUT) {
                NLAdvancedFiltersProcessors.portImplications(port, visitedInputs, initialEnclosingGates, config, false, showInternalLogic, monitor, isFlowDiagram);
                continue;
            }
            if (port.getDirection() != NLPort.NLPortDirection.DIR_OUT) continue;
            NLAdvancedFiltersProcessors.portImplications(port, visitedOutputs, initialEnclosingGates, config, false, showInternalLogic, monitor, isFlowDiagram);
        }
        initialEnclosingGates = null;
    }

    public static void portImplications(NLPort port, Set<NLAbstractBase> visited, Set<NLInstanceGate> initialEnclosingGates, NLConfig config, boolean strictlyInward, boolean showInternalLogic, DProgressMonitor monitor, boolean isFlowDiagram) throws DCanceledException {
        NLAdvancedFiltersProcessors.checkCanceled(monitor);
        port.addFlag(NLParameters.NLParametersFlag.OUTER_VISIBLE);
        if (visited.contains(port)) {
            return;
        }
        visited.add(port);
        for (NLConnection connection : port.getExternalConnections()) {
            NLAdvancedFiltersProcessors.checkCanceled(monitor);
            if (!strictlyInward || connection.getEnclosingGate().equals(port.getEnclosingGate())) {
                NLAdvancedFiltersProcessors.connectionImplications(connection, port, visited, initialEnclosingGates, config, showInternalLogic, monitor, isFlowDiagram);
            }
            if (!connection.hasFlag(NLParameters.NLParametersFlag.IS_VISIBLE)) continue;
            NLUtils.makeVisible(port);
            port.addFlag(NLParameters.NLParametersFlag.IS_RELEVANT);
        }
    }

    private static void connectionImplications(NLConnection connection, NLPort startPort, Set<NLAbstractBase> visited, Set<NLInstanceGate> initialEnclosingGates, NLConfig config, boolean showInternalLogic, DProgressMonitor monitor, boolean isFlowDiagram) throws DCanceledException {
        NLAdvancedFiltersProcessors.checkCanceled(monitor);
        if (visited.contains(connection)) {
            return;
        }
        visited.add(connection);
        NLPort.NLPortDirection direction = startPort.getDirection();
        Collection<NLPort> ports = null;
        boolean reverse = connection.getEnclosingGate().equals(startPort.getEnclosingGate());
        if (direction == NLPort.NLPortDirection.DIR_INOUT) {
            ports = new ArrayList<NLPort>(connection.getTargets());
        } else if (direction == NLPort.NLPortDirection.DIR_IN) {
            ports = !reverse ? connection.getSourcePorts() : connection.getDestinationPorts();
        } else if (direction == NLPort.NLPortDirection.DIR_OUT) {
            ports = !reverse ? connection.getDestinationPorts() : connection.getSourcePorts();
        }
        if (ports == null || ports.isEmpty()) {
            return;
        }
        for (NLPort port : ports) {
            NLAdvancedFiltersProcessors.checkCanceled(monitor);
            port.addFlag(NLParameters.NLParametersFlag.IS_VISIBLE);
            if (port.getEnclosingGate().equals(connection.getEnclosingGate())) {
                port.addFlag(NLParameters.NLParametersFlag.INNER_VISIBLE);
            } else {
                port.addFlag(NLParameters.NLParametersFlag.OUTER_VISIBLE);
            }
            NLGate gate = port.getEnclosingGate();
            if (gate instanceof NLLogicGate.NLInternalLogicGate && !showInternalLogic) continue;
            if (!connection.hasFlag(NLParameters.NLParametersFlag.IS_VISIBLE)) {
                NLUtils.makeVisible(connection);
                connection.addFlag(NLParameters.NLParametersFlag.IS_RELEVANT);
            }
            NLUtils.makeGateAndPortsVisible(gate);
            gate.addFlag(NLParameters.NLParametersFlag.IS_RELEVANT);
            port.addFlag(NLParameters.NLParametersFlag.IS_RELEVANT);
            if (gate.isTopGate()) continue;
            NLAdvancedFiltersProcessors.makeEnclosingGatesVisible(gate, initialEnclosingGates, false, monitor);
            if (gate.getKind() == NLGateKind.INSTANCE && !initialEnclosingGates.contains(gate)) {
                NLAdvancedFiltersProcessors.portImplications(port, visited, initialEnclosingGates, config, true, showInternalLogic, monitor, isFlowDiagram);
            } else {
                NLAdvancedFiltersProcessors.portImplications(port, visited, initialEnclosingGates, config, false, showInternalLogic, monitor, isFlowDiagram);
            }
            if (!isFlowDiagram || !NLUtils.isLogicGate(gate)) continue;
            NLAdvancedFiltersProcessors.logicGateImplications(gate, port, visited, initialEnclosingGates, config, showInternalLogic, monitor, isFlowDiagram);
        }
    }

    private static void logicGateImplications(NLGate gate, NLPort startPort, Set<NLAbstractBase> visited, Set<NLInstanceGate> initialEnclosingGates, NLConfig config, boolean showInternalLogic, DProgressMonitor monitor, boolean isFlowDiagram) throws DCanceledException {
        NLAdvancedFiltersProcessors.checkCanceled(monitor);
        if (visited.contains(gate)) {
            return;
        }
        visited.add(gate);
        NLPort.NLPortDirection direction = startPort.getDirection();
        ArrayList<NLPort.NLPortDirection> acceptedDirections = new ArrayList<NLPort.NLPortDirection>(3);
        acceptedDirections.add(NLPort.NLPortDirection.DIR_INOUT);
        if (direction == NLPort.NLPortDirection.DIR_IN) {
            acceptedDirections.add(NLPort.NLPortDirection.DIR_OUT);
        } else if (direction == NLPort.NLPortDirection.DIR_OUT) {
            acceptedDirections.add(NLPort.NLPortDirection.DIR_IN);
        } else {
            acceptedDirections.add(NLPort.NLPortDirection.DIR_IN);
            acceptedDirections.add(NLPort.NLPortDirection.DIR_OUT);
        }
        for (NLPort port : gate.getPorts()) {
            if (port.equals(startPort) || !acceptedDirections.contains((Object)port.getDirection())) continue;
            NLAdvancedFiltersProcessors.portImplications(port, visited, initialEnclosingGates, config, false, showInternalLogic, monitor, isFlowDiagram);
        }
    }

    private static void findConnectionsBetween(NLInstanceGate gate, Set<NLInstanceGate> destinations, NLPort startPort, List<NLAbstractBase> collected, Set<NLPort> visitedLogicPorts, Map<NLLogicGate, Set<NLInstanceGate>> logicInstanceMap, NLConfig config, DProgressMonitor monitor) throws DCanceledException {
        NLAdvancedFiltersProcessors.checkCanceled(monitor);
        if (startPort != null) {
            NLAdvancedFiltersProcessors.checkPort(startPort, gate, false, true, destinations, collected, visitedLogicPorts, logicInstanceMap, config, monitor);
        } else {
            for (NLPort port : gate.getPorts()) {
                NLAdvancedFiltersProcessors.checkCanceled(monitor);
                if (!gate.isTopGate() && (port.getDirection() == NLPort.NLPortDirection.DIR_OUT || port.getDirection() == NLPort.NLPortDirection.DIR_INOUT) || gate.isTopGate() && (port.getDirection() == NLPort.NLPortDirection.DIR_IN || port.getDirection() == NLPort.NLPortDirection.DIR_INOUT)) {
                    NLAdvancedFiltersProcessors.checkPort(port, gate, false, true, destinations, new ArrayList<NLAbstractBase>(), visitedLogicPorts, logicInstanceMap, config, monitor);
                }
                if (gate.isTopGate() || port.getDirection() != NLPort.NLPortDirection.DIR_IN && port.getDirection() != NLPort.NLPortDirection.DIR_INOUT) continue;
                NLAdvancedFiltersProcessors.checkPort(port, gate, true, false, destinations, new ArrayList<NLAbstractBase>(), visitedLogicPorts, logicInstanceMap, config, monitor);
            }
        }
    }

    private static void checkPort(NLPort port, NLInstanceGate initialGate, boolean strictlyDownward, boolean checkUpward, Set<NLInstanceGate> destinations, List<NLAbstractBase> collected, Set<NLPort> visitedLogicPorts, Map<NLLogicGate, Set<NLInstanceGate>> logicInstanceMap, NLConfig config, DProgressMonitor monitor) throws DCanceledException {
        NLAdvancedFiltersProcessors.checkCanceled(monitor);
        if (collected.contains(port)) {
            return;
        }
        collected.add(port);
        for (NLConnection connection : port.getConnections()) {
            NLAdvancedFiltersProcessors.checkCanceled(monitor);
            if (!strictlyDownward ? !initialGate.isTopGate() && connection.getEnclosingGate().equals(port.getEnclosingGate()) : !initialGate.isTopGate() && !connection.getEnclosingGate().equals(port.getEnclosingGate())) continue;
            collected.add(connection);
            NLAdvancedFiltersProcessors.checkConnection(connection, initialGate, checkUpward, destinations, collected, visitedLogicPorts, logicInstanceMap, config, monitor);
            collected.remove(connection);
        }
        collected.remove(port);
    }

    /*
     * Unable to fully structure code
     */
    private static void checkConnection(NLConnection connection, NLInstanceGate initialGate, boolean checkUpward, Set<NLInstanceGate> destinations, List<NLAbstractBase> collected, Set<NLPort> visitedLogicPorts, Map<NLLogicGate, Set<NLInstanceGate>> logicInstanceMap, NLConfig config, DProgressMonitor monitor) throws DCanceledException {
        NLAdvancedFiltersProcessors.checkCanceled(monitor);
        for (NLPort destPort : connection.getDestinationPorts()) {
            block13: {
                NLAdvancedFiltersProcessors.checkCanceled(monitor);
                if (collected.contains(destPort) || (enclosingGate = destPort.getEnclosingGate()) instanceof NLLogicGate.NLInternalLogicGate) continue;
                if (!enclosingGate.isTopGate() && enclosingGate.equals(connection.getEnclosingGate()) && checkUpward) {
                    collected.add(enclosingGate);
                    if (destinations.contains(enclosingGate)) {
                        NLUtils.makeVisible(new NLAbstractBase[]{connection});
                        connection.addFlag(NLParameters.NLParametersFlag.IS_RELEVANT);
                        for (NLPort target : connection.getDestinationPorts()) {
                            if (!target.getEnclosingGate().equals(enclosingGate)) continue;
                            NLUtils.makeVisible(new NLAbstractBase[]{target});
                            target.addFlag(NLParameters.NLParametersFlag.IS_RELEVANT);
                        }
                        NLAdvancedFiltersProcessors.makeVisibleCollected(collected, logicInstanceMap, enclosingGate, monitor);
                    } else {
                        NLAdvancedFiltersProcessors.findConnectionsBetween(initialGate, destinations, destPort, collected, new LinkedHashSet<NLPort>(), logicInstanceMap, config, monitor);
                        continue;
                    }
                }
                if (enclosingGate.getKind() == NLGateKind.INSTANCE) {
                    for (NLConnection conn : destPort.getConnections()) {
                        NLAdvancedFiltersProcessors.checkCanceled(monitor);
                        if (conn.equals(connection) || !conn.getEnclosingGate().equals(enclosingGate)) continue;
                        collected.add(enclosingGate);
                        collected.add(destPort);
                        collected.add(conn);
                        NLAdvancedFiltersProcessors.checkConnection(conn, initialGate, false, destinations, collected, visitedLogicPorts, logicInstanceMap, config, monitor);
                        collected.remove(enclosingGate);
                        collected.remove(destPort);
                        collected.remove(conn);
                    }
                }
                collected.add(destPort);
                if (destinations.contains(enclosingGate) && !enclosingGate.equals(initialGate) && !collected.contains(enclosingGate)) {
                    NLAdvancedFiltersProcessors.makeVisibleCollected(collected, logicInstanceMap, enclosingGate, monitor);
                    collected.remove(destPort);
                    continue;
                }
                if (enclosingGate.getKind() != NLGateKind.LOGIC) break block13;
                if (collected.contains(enclosingGate)) {
                    collected.remove(destPort);
                    continue;
                }
                if (!visitedLogicPorts.contains(destPort)) ** GOTO lbl58
                if (NLUtils.isVisible(new NLAbstractBase[]{enclosingGate}) && !collected.contains(enclosingGate)) {
                    if (!(logicInstanceMap.get(enclosingGate) == null || logicInstanceMap.get(enclosingGate).size() <= 1 && initialGate.equals(logicInstanceMap.get(enclosingGate).iterator().next()))) {
                        NLAdvancedFiltersProcessors.makeVisibleCollected(collected, logicInstanceMap, null, monitor);
                    }
                } else {
                    collected.remove(destPort);
                    continue;
lbl58:
                    // 1 sources

                    visitedLogicPorts.add(destPort);
                }
                collected.add(enclosingGate);
                for (NLPort logicPort : enclosingGate.getPorts()) {
                    if (logicPort.getDirection() != NLPort.NLPortDirection.DIR_OUT && logicPort.getDirection() != NLPort.NLPortDirection.DIR_INOUT) continue;
                    NLAdvancedFiltersProcessors.checkPort(logicPort, initialGate, false, checkUpward, destinations, collected, visitedLogicPorts, logicInstanceMap, config, monitor);
                }
                collected.remove(enclosingGate);
                collected.remove(destPort);
                continue;
            }
            collected.remove(destPort);
        }
    }

    private static void makeVisibleCollected(List<NLAbstractBase> collected, Map<NLLogicGate, Set<NLInstanceGate>> logicInstanceMap, NLGate enclosingGate, DProgressMonitor monitor) throws DCanceledException {
        NLAdvancedFiltersProcessors.checkCanceled(monitor);
        for (NLAbstractBase element : collected) {
            NLAdvancedFiltersProcessors.checkCanceled(monitor);
            if (element instanceof NLGate) {
                NLUtils.makeGateAndPortsVisible((NLGate)element);
            } else {
                NLUtils.makeVisible(element);
            }
            if (element instanceof NLPort) {
                element.addFlag(NLParameters.NLParametersFlag.OUTER_VISIBLE);
                if (enclosingGate instanceof NLInstanceGate) {
                    element.addFlag(NLParameters.NLParametersFlag.INNER_VISIBLE);
                }
            }
            element.addFlag(NLParameters.NLParametersFlag.IS_RELEVANT);
            if (element instanceof NLGate && ((NLGate)element).getKind() == NLGateKind.LOGIC && enclosingGate != null) {
                if (logicInstanceMap.containsKey(element)) {
                    logicInstanceMap.get(element).add((NLInstanceGate)enclosingGate);
                } else {
                    logicInstanceMap.put((NLLogicGate)element, new LinkedHashSet());
                    logicInstanceMap.get(element).add((NLInstanceGate)enclosingGate);
                }
            }
            if (!(element instanceof NLGate)) continue;
            NLAdvancedFiltersProcessors.makeEnclosingGatesVisible((NLGate)element, null, false, monitor);
        }
    }

    private static void makeEnclosingGatesVisible(NLGate gate, Set<NLInstanceGate> initialEnclosingGates, boolean force, DProgressMonitor monitor) throws DCanceledException {
        NLAdvancedFiltersProcessors.checkCanceled(monitor);
        NLInstanceGate enclosingGate = gate.getEnclosingGate();
        while (enclosingGate != null && !enclosingGate.isTopGate()) {
            NLAdvancedFiltersProcessors.checkCanceled(monitor);
            if (initialEnclosingGates != null && gate.hasFlag(NLParameters.NLParametersFlag.IS_FOCUSED)) {
                initialEnclosingGates.add(enclosingGate);
            }
            NLUtils.makeGateAndPortsVisible(enclosingGate);
            enclosingGate.addFlag(NLParameters.NLParametersFlag.IS_RELEVANT);
            if (force) {
                enclosingGate.addFlag(NLParameters.NLParametersFlag.IS_ENCLOSING_ACTION_SELECTED);
            }
            enclosingGate = enclosingGate.getEnclosingGate();
        }
    }

    private static void checkCanceled(DProgressMonitor monitor) throws DCanceledException {
        if (monitor != null) {
            monitor.checkCanceled();
        }
    }
}

