/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.netlist.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import ro.amiq.dvt.diagrams.DProgressMonitor;
import ro.amiq.dvt.diagrams.exceptions.DCanceledException;
import ro.amiq.dvt.diagrams.netlist.model.NLAbstractBase;
import ro.amiq.dvt.diagrams.netlist.model.NLBundleGate;
import ro.amiq.dvt.diagrams.netlist.model.NLConnection;
import ro.amiq.dvt.diagrams.netlist.model.NLFactory;
import ro.amiq.dvt.diagrams.netlist.model.NLGate;
import ro.amiq.dvt.diagrams.netlist.model.NLInstanceGate;
import ro.amiq.dvt.diagrams.netlist.model.NLParameters;
import ro.amiq.dvt.diagrams.netlist.model.NLPort;
import ro.amiq.dvt.diagrams.netlist.utils.NLUtils;
import ro.amiq.dvt.model.reflection.IRfCompositeTypeElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.util.DesignUtils;

public enum NLBusUtils {
    INSTANCE;

    private static final String OUTPUT_PORT_OR_CONNECTION_PREFIX = "OUTPUT_BUS_PORT_OR_CONNECTION_";
    public static final String MIRROR_DUMMY_PORT_SUFFIX = "_MIRROR_DUMMY_PORT_SUFFIX";

    public static String getOutputPortOrConnectionName(NLAbstractBase base) {
        return OUTPUT_PORT_OR_CONNECTION_PREFIX + base.getName();
    }

    public static String getOutputPortOrConnectionName(String baseName) {
        return OUTPUT_PORT_OR_CONNECTION_PREFIX + baseName;
    }

    private static String getDummyPortName(String baseName) {
        return String.valueOf(baseName) + MIRROR_DUMMY_PORT_SUFFIX;
    }

    public static String getCleanPortName(NLPort port) {
        if (port == null || port.getName() == null) {
            return "";
        }
        String portName = port.getName();
        if (portName == null) {
            return "";
        }
        return portName.replace(OUTPUT_PORT_OR_CONNECTION_PREFIX, "").replace("__dvt__internal__me__port", "").replace(MIRROR_DUMMY_PORT_SUFFIX, "");
    }

    /*
     * WARNING - void declaration
     */
    static void adjustBusBundleGates(NLInstanceGate topGate, DProgressMonitor monitor) throws DCanceledException {
        for (NLGate nLGate : new ArrayList<NLGate>(topGate.getSubGates())) {
            void bundleGate;
            NLBundleGate nLBundleGate;
            NLGate nLGate2 = nLGate;
            if (!(nLGate2 instanceof NLBundleGate) || (nLBundleGate = (NLBundleGate)nLGate2) != (NLBundleGate)nLGate2 || !bundleGate.isBusGate()) continue;
            NLBusUtils.adjustBundleGate((NLBundleGate)bundleGate, monitor);
        }
    }

    static void adjustBundleGate(NLBundleGate bundleGate, DProgressMonitor monitor) throws DCanceledException {
        if (!bundleGate.isBusGate() || bundleGate.isGateAdjusted()) {
            return;
        }
        NLInstanceGate enclosingGate = bundleGate.getEnclosingGate();
        if (bundleGate == null || enclosingGate == null) {
            return;
        }
        NLBusUtils.adjustBusPortsDirections(bundleGate, enclosingGate);
        NLBusUtils.orderBundleGatePorts(bundleGate, monitor);
        bundleGate.setGateAdjusted(true);
    }

    private static void adjustBusPortsDirections(NLBundleGate bundleGate, NLInstanceGate enclosingGate) {
        NLPort sameNamedPort = bundleGate.getSameNamedPort();
        ArrayList<NLPort> bundleGatePorts = new ArrayList<NLPort>(bundleGate.getPorts());
        for (NLPort bundlePort : bundleGatePorts) {
            if (bundlePort.getDirection() == NLPort.NLPortDirection.DIR_OUT) continue;
            if (bundlePort == sameNamedPort) {
                bundlePort.setKind(NLConnection.NLConnectionKind.COMMON_SIGNAL);
            }
            bundlePort.setDirection(NLPort.NLPortDirection.DIR_IN);
            Collection<NLPort> destinationPorts = bundlePort.getDestinationPorts();
            if (destinationPorts.isEmpty()) {
                if (!bundlePort.getSourcePorts().isEmpty()) continue;
                bundleGate.removePort(bundlePort);
                continue;
            }
            String bundlePortName = NLBusUtils.getOutputPortOrConnectionName(bundlePort);
            NLPort outputBundlePort = bundleGate.getPort(bundlePortName);
            if (outputBundlePort == null) {
                outputBundlePort = NLFactory.createPort(bundlePortName, bundlePort.getLabel(), bundlePort.getEnclosingGate(), NLPort.NLPortDirection.DIR_OUT, bundlePort.getKind(), false, bundlePort.getGoToSource(), NLParameters.NLParametersFlag.OUTER_VISIBLE);
            }
            bundleGate.addPort(outputBundlePort);
            for (NLConnection externalConn : bundlePort.getExternalConnections()) {
                String connectionName = NLBusUtils.getOutputPortOrConnectionName(externalConn);
                NLConnection outputBundleConnection = enclosingGate.getSignal(connectionName);
                if (outputBundleConnection == null) {
                    outputBundleConnection = NLFactory.createConnection(connectionName, externalConn.getName(), externalConn.getEnclosingGate(), externalConn.getKind(), externalConn.getGoToSource());
                }
                NLFactory.createCommonSignalToPortConnection(outputBundlePort, outputBundleConnection);
                for (NLPort destinationPort : destinationPorts) {
                    destinationPort.addFlag(NLParameters.NLParametersFlag.INNER_VISIBLE);
                    NLFactory.removeSignalToPortConnection(destinationPort, externalConn);
                    NLFactory.removeSignalToPortConnection(bundlePort, externalConn);
                    NLFactory.createCommonSignalToPortConnection(destinationPort, outputBundleConnection);
                }
                enclosingGate.addSignal(outputBundleConnection);
            }
            if (!bundlePort.getSourcePorts().isEmpty()) continue;
            bundleGate.removePort(bundlePort);
        }
    }

    private static void orderBundleGatePorts(NLBundleGate bundleGate, DProgressMonitor monitor) throws DCanceledException {
        NLPort dummy;
        NLUtils.checkCanceled(monitor);
        if (!bundleGate.isBusGate()) {
            return;
        }
        Collection<NLPort> ports = bundleGate.getPorts();
        if (ports == null || ports.isEmpty()) {
            return;
        }
        NLPort sameNamedPort = bundleGate.getSameNamedPort();
        NLPort outputSameNamedPort = bundleGate.getOutputSameNamedPort();
        IRfNamedElement resolvedType = DesignUtils.getResolvedType(bundleGate.getMapping());
        List<String> orderedBitFieldNames = ((IRfCompositeTypeElement)resolvedType).getOrderedBitFieldNames();
        List<NLPort> inputPorts = ports.stream().filter(p -> !p.isMirroredPort()).filter(p -> p.getDirection() != NLPort.NLPortDirection.DIR_OUT).collect(Collectors.toList());
        List<NLPort> outputPorts = ports.stream().filter(p -> !p.isMirroredPort()).filter(p -> p.getDirection() == NLPort.NLPortDirection.DIR_OUT).collect(Collectors.toList());
        if (sameNamedPort != null) {
            inputPorts.remove(sameNamedPort);
        }
        if (outputSameNamedPort != null) {
            outputPorts.remove(outputSameNamedPort);
        }
        NLBusUtils.alignByOrderedNames(bundleGate, inputPorts, outputPorts, orderedBitFieldNames, monitor);
        if (outputSameNamedPort != null) {
            outputPorts.add(0, outputSameNamedPort);
            if (sameNamedPort == null) {
                dummy = NLFactory.createPort(String.valueOf(outputSameNamedPort.getName()) + MIRROR_DUMMY_PORT_SUFFIX, null, bundleGate, NLPort.NLPortDirection.DIR_IN, NLConnection.NLConnectionKind.COMMON_SIGNAL, false, Collections.emptyList(), NLParameters.NLParametersFlag.OUTER_VISIBLE);
                inputPorts.add(0, dummy);
            }
        }
        if (sameNamedPort != null) {
            inputPorts.add(0, sameNamedPort);
            if (outputSameNamedPort == null) {
                dummy = NLFactory.createPort(String.valueOf(sameNamedPort.getName()) + MIRROR_DUMMY_PORT_SUFFIX, null, bundleGate, NLPort.NLPortDirection.DIR_OUT, NLConnection.NLConnectionKind.COMMON_SIGNAL, false, Collections.emptyList(), NLParameters.NLParametersFlag.OUTER_VISIBLE);
                outputPorts.add(0, dummy);
            }
        }
        Collections.reverse(inputPorts);
        bundleGate.getPorts().clear();
        for (NLPort port : outputPorts) {
            NLUtils.checkCanceled(monitor);
            bundleGate.addPort(port);
        }
        for (NLPort port : inputPorts) {
            NLUtils.checkCanceled(monitor);
            bundleGate.addPort(port);
        }
    }

    private static void alignByOrderedNames(NLBundleGate bundleGate, List<NLPort> inputPorts, List<NLPort> outputPorts, List<String> orderedBitFieldNames, DProgressMonitor monitor) throws DCanceledException {
        HashMap<String, NLPort> inByName = new HashMap<String, NLPort>();
        for (NLPort inputPort : inputPorts) {
            NLUtils.checkCanceled(monitor);
            inByName.put(NLBusUtils.getCleanPortName(inputPort), inputPort);
        }
        HashMap<String, NLPort> outByName = new HashMap<String, NLPort>();
        for (NLPort outputPort : outputPorts) {
            NLUtils.checkCanceled(monitor);
            outByName.put(NLBusUtils.getCleanPortName(outputPort), outputPort);
        }
        HashSet existingNames = new HashSet();
        existingNames.addAll(inByName.keySet());
        existingNames.addAll(outByName.keySet());
        ArrayList<String> existingOrderedBitFieldNames = new ArrayList<String>();
        if (orderedBitFieldNames != null && !orderedBitFieldNames.isEmpty()) {
            for (String name : orderedBitFieldNames) {
                NLUtils.checkCanceled(monitor);
                if (!existingNames.contains(name)) continue;
                existingOrderedBitFieldNames.add(name);
            }
        } else {
            existingOrderedBitFieldNames.addAll(existingNames);
            Collections.sort(existingOrderedBitFieldNames);
        }
        ArrayList<NLPort> newInputs = new ArrayList<NLPort>(existingOrderedBitFieldNames.size());
        ArrayList<NLPort> newOutputs = new ArrayList<NLPort>(existingOrderedBitFieldNames.size());
        for (String name : existingOrderedBitFieldNames) {
            NLUtils.checkCanceled(monitor);
            NLPort in = (NLPort)inByName.get(name);
            NLPort out = (NLPort)outByName.get(name);
            newInputs.add(in != null ? in : NLBusUtils.createDummyPort(bundleGate, name, NLPort.NLPortDirection.DIR_IN));
            newOutputs.add(out != null ? out : NLBusUtils.createDummyPort(bundleGate, name, NLPort.NLPortDirection.DIR_OUT));
        }
        inputPorts.clear();
        inputPorts.addAll(newInputs);
        outputPorts.clear();
        outputPorts.addAll(newOutputs);
    }

    private static NLPort createDummyPort(NLBundleGate enclosingGate, String baseName, NLPort.NLPortDirection dir) {
        String dummyName = NLBusUtils.getDummyPortName(baseName);
        return NLFactory.createPort(dummyName, null, enclosingGate, dir, NLConnection.NLConnectionKind.COMMON_SIGNAL, false, Collections.emptyList(), NLParameters.NLParametersFlag.OUTER_VISIBLE);
    }

    public static void appendBusLabel(NLBundleGate bundleGate, StringBuilder gateLabel) {
        gateLabel.append("\n(");
        String busWidth = bundleGate.getBusWidthLabel();
        if (busWidth != null) {
            gateLabel.append(busWidth).append(" ");
        }
        gateLabel.append("bus)");
    }
}

