/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.netlist.utils;

import java.util.Set;
import ro.amiq.dvt.diagrams.design.editor.actions.menu.DMenuActionKind;
import ro.amiq.dvt.diagrams.netlist.model.NLInstanceGate;
import ro.amiq.dvt.diagrams.netlist.utils.NLConfiguration;
import ro.amiq.dvt.diagrams.netlist.utils.NLFilterSet;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbInput;

public class NLConfig {
    private final Set<NLConfiguration> flags;
    private NLFilterSet activeFilters;
    private boolean reducePorts;
    private boolean reduceGates;
    private boolean hidePlainAssigns;
    private boolean flowShowBoundaryConnections;
    private NLInstanceGate topInstance;
    private DMenuActionKind actionKind;
    private BreadcrumbInput breadcrumbInput;

    public NLConfig(Set<NLConfiguration> flags, NLFilterSet filters) {
        this.flags = flags;
        this.activeFilters = filters;
        this.flowShowBoundaryConnections = true;
    }

    public NLConfig(Set<NLConfiguration> flags) {
        this(flags, null);
    }

    public NLConfig(NLConfig oldConfig) {
        this(oldConfig.getFlags(), oldConfig.getFilterSet());
        this.reduceGates = oldConfig.configReduceGates();
        this.reducePorts = oldConfig.configReducePorts();
        this.flowShowBoundaryConnections = oldConfig.configFlowShowBoundaryConnections();
    }

    public NLFilterSet getFilterSet() {
        return this.activeFilters;
    }

    public void setFilterSet(NLFilterSet set) {
        this.activeFilters = set;
    }

    public NLInstanceGate getTopInstance() {
        return this.topInstance;
    }

    public void setTopInstance(NLInstanceGate topInstance) {
        this.topInstance = topInstance;
    }

    public DMenuActionKind getActionKind() {
        return this.actionKind;
    }

    public void setActionKind(DMenuActionKind actionKind) {
        this.actionKind = actionKind;
    }

    public Set<NLConfiguration> getFlags() {
        return this.flags;
    }

    public boolean hasFilters() {
        return this.activeFilters != null;
    }

    public BreadcrumbInput getBreadcrumbInput() {
        return this.breadcrumbInput;
    }

    public void setBreadcrumbInput(BreadcrumbInput breadcrumbInput) {
        this.breadcrumbInput = breadcrumbInput;
    }

    public boolean configReducePorts() {
        return this.reducePorts;
    }

    public boolean configReduceGates() {
        return this.reduceGates;
    }

    public boolean configHidePlainAssigns() {
        return this.hidePlainAssigns;
    }

    public boolean configFlowShowBoundaryConnections() {
        return this.flowShowBoundaryConnections;
    }

    public boolean reducePorts() {
        return this.activeFilters != null ? this.activeFilters.reducePortsWithoutConnections() : this.reducePorts;
    }

    public boolean reduceGates() {
        return this.activeFilters != null ? this.activeFilters.reduceGatesWithoutPorts() : this.reduceGates;
    }

    public boolean hidePlainAssigns() {
        return this.activeFilters != null ? this.activeFilters.hidePlainAssigns() : this.hidePlainAssigns;
    }

    public void setReducePorts(boolean value) {
        this.reducePorts = value;
    }

    public void setReduceGates(boolean value) {
        this.reduceGates = value;
    }

    public void setHidePlainAssigns(boolean value) {
        this.hidePlainAssigns = value;
    }

    public boolean getSchematicShowWaveformInfo() {
        return this.flags.contains((Object)NLConfiguration.SCHEMATIC_SHOW_WAVEFORM_INFO);
    }

    public void setSchematicShowWaveformInfo(boolean value) {
        if (value) {
            this.flags.add(NLConfiguration.SCHEMATIC_SHOW_WAVEFORM_INFO);
        } else {
            this.flags.remove((Object)NLConfiguration.SCHEMATIC_SHOW_WAVEFORM_INFO);
        }
    }

    public void setHideInternalLogicGates(boolean value) {
        if (value) {
            this.flags.add(NLConfiguration.SCHEMATIC_HIDE_LOGIC_GATES);
        } else {
            this.flags.remove((Object)NLConfiguration.SCHEMATIC_HIDE_LOGIC_GATES);
        }
    }

    public void setSchematicShowConstants(boolean value) {
        if (value) {
            this.flags.add(NLConfiguration.SCHEMATIC_SHOW_CONSTANTS);
        } else {
            this.flags.remove((Object)NLConfiguration.SCHEMATIC_SHOW_CONSTANTS);
        }
    }

    public boolean getDiagramShowPortWidth() {
        return this.flags.contains((Object)NLConfiguration.DIAGRAM_SHOW_PORT_WIDTH);
    }

    public void setDiagramShowPortWidth(boolean value) {
        if (value) {
            this.flags.add(NLConfiguration.DIAGRAM_SHOW_PORT_WIDTH);
        } else {
            this.flags.remove((Object)NLConfiguration.DIAGRAM_SHOW_PORT_WIDTH);
        }
    }

    public boolean getDiagramShowPortFullyQualifiedType() {
        return this.flags.contains((Object)NLConfiguration.DIAGRAM_SHOW_FULLY_QUALIFIED_TYPE);
    }

    public void setDiagramShowPortFullyQualifiedType(boolean value) {
        if (value) {
            this.flags.add(NLConfiguration.DIAGRAM_SHOW_FULLY_QUALIFIED_TYPE);
        } else {
            this.flags.remove((Object)NLConfiguration.DIAGRAM_SHOW_FULLY_QUALIFIED_TYPE);
        }
    }

    public void setFlowShowBoundaryConnections(boolean value) {
        this.flowShowBoundaryConnections = value;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.actionKind == null ? 0 : this.actionKind.hashCode());
        result = 31 * result + (this.activeFilters == null ? 0 : this.activeFilters.hashCode());
        result = 31 * result + (this.breadcrumbInput == null ? 0 : this.breadcrumbInput.hashCode());
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + (this.hidePlainAssigns ? 1231 : 1237);
        result = 31 * result + (this.reduceGates ? 1231 : 1237);
        result = 31 * result + (this.reducePorts ? 1231 : 1237);
        result = 31 * result + (this.flowShowBoundaryConnections ? 1231 : 1237);
        result = 31 * result + (this.topInstance == null ? 0 : this.topInstance.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NLConfig other = (NLConfig)obj;
        if (this.actionKind != other.actionKind) {
            return false;
        }
        if (this.hidePlainAssigns != other.hidePlainAssigns) {
            return false;
        }
        if (this.reduceGates != other.reduceGates) {
            return false;
        }
        if (this.reducePorts != other.reducePorts) {
            return false;
        }
        if (this.flowShowBoundaryConnections != other.flowShowBoundaryConnections) {
            return false;
        }
        if (this.topInstance == null ? other.topInstance != null : !this.topInstance.equals(other.topInstance)) {
            return false;
        }
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        if (this.breadcrumbInput == null ? other.breadcrumbInput != null : !this.breadcrumbInput.equals(other.breadcrumbInput)) {
            return false;
        }
        return !(this.activeFilters == null ? other.activeFilters != null : !this.activeFilters.equals(other.activeFilters));
    }
}

