/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.netlist.utils;

import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.swt.graphics.RGB;
import ro.amiq.dvt.diagrams.netlist.utils.INLFilter;

public class NLExcludeFilter
implements INLFilter {
    private Set<INLFilter.NLFilterKind> kinds;
    private boolean include;
    private Pattern patternVlog;
    private Pattern patternVHDL;
    private Pattern pathPatternVlog;
    private Pattern pathPatternVHDL;
    private String text;
    private String path;

    public NLExcludeFilter(String text, String path, Set<INLFilter.NLFilterKind> kinds, boolean include) {
        this.text = text != null ? text : "";
        this.path = path != null ? path : "";
        this.kinds = kinds;
        this.include = include;
        try {
            this.patternVlog = this.text.isEmpty() ? null : Pattern.compile(this.text);
            this.patternVHDL = this.text.isEmpty() ? null : Pattern.compile("(?i)" + this.text);
            this.pathPatternVlog = this.path.isEmpty() ? null : Pattern.compile(this.path);
            this.pathPatternVHDL = this.path.isEmpty() ? null : Pattern.compile("(?i)" + this.path);
        }
        catch (Exception exception) {
            this.patternVlog = null;
            this.patternVHDL = null;
            this.pathPatternVlog = null;
            this.pathPatternVHDL = null;
        }
    }

    @Override
    public boolean isColorFilter() {
        return false;
    }

    @Override
    public boolean isExcludeFilter() {
        return true;
    }

    @Override
    public Set<INLFilter.NLFilterKind> getKinds() {
        return this.kinds;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Pattern getPatternVlog() {
        return this.patternVlog;
    }

    @Override
    public Pattern getPatternVHDL() {
        return this.patternVHDL;
    }

    @Override
    public Pattern getPathPatternVlog() {
        return this.pathPatternVlog;
    }

    @Override
    public Pattern getPathPatternVHDL() {
        return this.pathPatternVHDL;
    }

    @Override
    public String getFullText() {
        return String.valueOf(this.path) + this.text;
    }

    @Override
    public boolean isHide() {
        return !this.include;
    }

    @Override
    public boolean isShow() {
        return this.include;
    }

    @Override
    public boolean isColor() {
        return false;
    }

    @Override
    public RGB getColor() {
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.include ? "show " : "hide ");
        for (INLFilter.NLFilterKind kind : this.kinds) {
            sb.append(kind.name());
            sb.append(" ");
        }
        sb.append(this.getFullText());
        return sb.toString();
    }
}

