/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.netlist.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.swt.graphics.RGB;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.filters.IDiagramFilter;
import ro.amiq.dvt.diagrams.filters.IDiagramFilterSet;
import ro.amiq.dvt.diagrams.netlist.model.NLBundleGate;
import ro.amiq.dvt.diagrams.netlist.model.NLConnection;
import ro.amiq.dvt.diagrams.netlist.model.NLGate;
import ro.amiq.dvt.diagrams.netlist.model.NLGateKind;
import ro.amiq.dvt.diagrams.netlist.model.NLInstanceGate;
import ro.amiq.dvt.diagrams.netlist.model.NLLogicGate;
import ro.amiq.dvt.diagrams.netlist.model.NLPort;
import ro.amiq.dvt.diagrams.netlist.utils.INLFilter;
import ro.amiq.dvt.diagrams.netlist.utils.NLColorFilter;
import ro.amiq.dvt.diagrams.netlist.utils.NLExcludeFilter;
import ro.amiq.dvt.diagrams.netlist.utils.NLUtils;
import ro.amiq.dvt.model.reflection.ElementPath;

public class NLFilterSet
implements IDiagramFilterSet {
    private String name;
    private List<INLFilter> blockColorFilters;
    private List<INLFilter> signalColorFilters;
    private List<INLFilter> portColorFilters;
    private List<INLFilter> allFilters;
    private boolean reduceGates;
    private boolean reducePorts;
    private boolean hidePlainAssigns;

    public NLFilterSet(String name) {
        this.name = name.trim();
    }

    public List<INLFilter> getFilters() {
        if (this.allFilters == null) {
            return Collections.emptyList();
        }
        return this.allFilters;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean reduceGatesWithoutPorts() {
        return this.reduceGates;
    }

    public void setReduceGatesWithoutPorts(boolean reduceGates) {
        this.reduceGates = reduceGates;
    }

    public boolean reducePortsWithoutConnections() {
        return this.reducePorts;
    }

    public void setReducePortsWithoutConnections(boolean reducePorts) {
        this.reducePorts = reducePorts;
    }

    public boolean hidePlainAssigns() {
        return this.hidePlainAssigns;
    }

    public void setHidePlainAssigns(boolean value) {
        this.hidePlainAssigns = value;
    }

    public INLFilter getConnectionColoringFilter(NLConnection connection) {
        if (connection == null || this.signalColorFilters == null) {
            return null;
        }
        NLGate enclosingGate = connection.getEnclosingGate();
        LanguageKind languageKind = enclosingGate instanceof NLInstanceGate ? ((NLInstanceGate)enclosingGate).getLanguageKind() : LanguageKind.VLOG;
        String signalPath = NLUtils.getDiagramPath(enclosingGate).toString("/");
        INLFilter result = null;
        if (connection.isEdge()) {
            RGB color = null;
            for (NLConnection cachedSignal : connection.getCachedFlowSignals()) {
                for (INLFilter filter : this.signalColorFilters) {
                    if (!filter.matches(String.valueOf(signalPath) + "/" + cachedSignal.getLabel(), languageKind, false)) continue;
                    if (color == null) {
                        color = filter.getColor();
                        result = filter;
                        continue;
                    }
                    if (filter.getColor().equals((Object)color)) continue;
                    return null;
                }
            }
        } else {
            for (INLFilter filter : this.signalColorFilters) {
                StringBuilder edgePath = new StringBuilder(String.valueOf(signalPath) + "/" + connection.getLabel());
                this.addConnectionPfInfo(connection, edgePath);
                if (!filter.matches(edgePath.toString(), languageKind, false)) continue;
                result = filter;
            }
        }
        return result;
    }

    private void addConnectionPfInfo(NLConnection connection, StringBuilder edgePath) {
        Collection<NLPort> targetPorts = connection.getTargets();
        if (targetPorts == null) {
            return;
        }
        for (NLPort targetPort : targetPorts) {
            if (targetPort.getPfInfo() == null) continue;
            edgePath.append(targetPort.getPfInfo());
        }
    }

    public INLFilter getPortColoringFilter(NLPort port) {
        if (port == null || port.isEdgePort() || this.portColorFilters == null) {
            return null;
        }
        NLGate enclosingGate = port.getEnclosingGate();
        LanguageKind languageKind = enclosingGate instanceof NLInstanceGate ? ((NLInstanceGate)enclosingGate).getLanguageKind() : LanguageKind.VLOG;
        String portPath = String.valueOf(NLUtils.getDiagramPath(enclosingGate).toString("/")) + "/" + port.getLabel() + (port.getPfInfo() != null ? port.getPfInfo() : "");
        INLFilter result = null;
        for (INLFilter filter : this.portColorFilters) {
            if (filter.getKinds().contains((Object)INLFilter.NLFilterKind.INPUT_PORT) && port.getDirection() != NLPort.NLPortDirection.DIR_IN && port.getDirection() != NLPort.NLPortDirection.DIR_INOUT || filter.getKinds().contains((Object)INLFilter.NLFilterKind.OUTPUT_PORT) && port.getDirection() != NLPort.NLPortDirection.DIR_OUT && port.getDirection() != NLPort.NLPortDirection.DIR_INOUT || filter.getKinds().contains((Object)INLFilter.NLFilterKind.INOUT_PORT) && port.getDirection() != NLPort.NLPortDirection.DIR_INOUT || !filter.matches(portPath, languageKind, false)) continue;
            result = filter;
        }
        return result;
    }

    public INLFilter getBlockColoringFilter(NLGate gate) {
        if (gate == null || gate.isTopGate() || gate.getKind() == NLGateKind.LOGIC || this.blockColorFilters == null) {
            return null;
        }
        LanguageKind languageKind = gate instanceof NLInstanceGate ? ((NLInstanceGate)gate).getLanguageKind() : LanguageKind.VLOG;
        ElementPath elementPath = NLUtils.getDiagramPath(gate);
        String path = elementPath.toString("/");
        String type = "";
        String label = gate.getLabel();
        if (label != null && label.contains("\n")) {
            type = label.substring(label.indexOf("(") + 1, label.length() - 1);
        }
        elementPath = elementPath.removeLastSegment();
        String typePath = String.valueOf(elementPath.toString("/")) + "/" + type;
        INLFilter result = null;
        for (INLFilter filter : this.blockColorFilters) {
            if (gate instanceof NLInstanceGate && !(gate instanceof NLLogicGate) && !(gate instanceof NLBundleGate) && (filter.getKinds().contains((Object)INLFilter.NLFilterKind.INSTANCE) && filter.matches(path, languageKind, false) || filter.getKinds().contains((Object)INLFilter.NLFilterKind.TYPE) && filter.matches(typePath, languageKind, false))) {
                result = filter;
            }
            if (filter.getKinds().contains((Object)INLFilter.NLFilterKind.GATE) && filter.getText().equals(".*")) {
                if (!path.isEmpty() && !filter.matches(path, languageKind, false)) continue;
                result = filter;
                continue;
            }
            if (label == null || label.isEmpty() || !filter.matches(path, languageKind, false)) continue;
            result = filter;
        }
        return result;
    }

    public void addFilter(IDiagramFilter filter) {
        if (!(filter instanceof INLFilter)) {
            return;
        }
        INLFilter nlFilter = (INLFilter)filter;
        if (!nlFilter.isColorFilter()) {
            if (this.allFilters == null) {
                this.allFilters = new ArrayList<INLFilter>();
            }
            this.allFilters.add(nlFilter);
            return;
        }
        for (INLFilter.NLFilterKind kind : nlFilter.getKinds()) {
            switch (kind) {
                case GATE: 
                case INSTANCE: 
                case TYPE: {
                    if (this.blockColorFilters == null) {
                        this.blockColorFilters = new ArrayList<INLFilter>();
                    }
                    this.blockColorFilters.add(nlFilter);
                    break;
                }
                case PORT: 
                case INPUT_PORT: 
                case OUTPUT_PORT: 
                case INOUT_PORT: {
                    if (this.portColorFilters == null) {
                        this.portColorFilters = new ArrayList<INLFilter>();
                    }
                    this.portColorFilters.add(nlFilter);
                    break;
                }
                case SIGNAL: {
                    if (this.signalColorFilters == null) {
                        this.signalColorFilters = new ArrayList<INLFilter>();
                    }
                    this.signalColorFilters.add(nlFilter);
                }
            }
        }
    }

    public static NLFilterSet deserializeSingleSet(String stringInput, NLFilterSet initialSet) {
        NLFilterSet set;
        if (stringInput == null || stringInput.isEmpty()) {
            return null;
        }
        String[] elements = stringInput.split("\n");
        NLFilterSet nLFilterSet = set = initialSet != null ? initialSet : new NLFilterSet(elements[0].trim());
        if (set.allFilters != null) {
            set.allFilters.clear();
        }
        if (set.blockColorFilters != null) {
            set.blockColorFilters.clear();
        }
        if (set.portColorFilters != null) {
            set.portColorFilters.clear();
        }
        if (set.signalColorFilters != null) {
            set.signalColorFilters.clear();
        }
        set.reduceGates = false;
        set.reducePorts = false;
        set.hidePlainAssigns = false;
        if (elements.length == 1) {
            return set;
        }
        int start = 1;
        if ("reducePorts".equals(elements[start])) {
            set.reducePorts = true;
            ++start;
        }
        if (elements.length > start && "reduceGates".equals(elements[start])) {
            set.reduceGates = true;
            ++start;
        }
        if (elements.length > start && "hidePlainAssigns".equals(elements[start])) {
            set.hidePlainAssigns = true;
            ++start;
        }
        int i = start;
        while (i < elements.length) {
            block59: {
                RGB color;
                boolean isColorFilter;
                boolean include;
                String elementKinds;
                String expression;
                block61: {
                    String lowercaseFilter;
                    String originalFilter;
                    block62: {
                        block60: {
                            if (elements[i].trim().startsWith("#")) break block59;
                            expression = "";
                            elementKinds = "";
                            include = false;
                            isColorFilter = false;
                            color = null;
                            if (!elements[i].toLowerCase().contains("matching")) break block59;
                            originalFilter = elements[i].trim();
                            lowercaseFilter = originalFilter.toLowerCase();
                            if (!lowercaseFilter.startsWith("show")) break block60;
                            include = true;
                            elementKinds = lowercaseFilter.substring(4, lowercaseFilter.indexOf("matching"));
                            expression = originalFilter.substring(lowercaseFilter.indexOf("matching") + 8).trim();
                            break block61;
                        }
                        if (!lowercaseFilter.startsWith("hide")) break block62;
                        elementKinds = lowercaseFilter.substring(4, lowercaseFilter.indexOf("matching"));
                        expression = originalFilter.substring(lowercaseFilter.indexOf("matching") + 8).trim();
                        break block61;
                    }
                    if (!lowercaseFilter.startsWith("color")) break block59;
                    isColorFilter = true;
                    elementKinds = lowercaseFilter.substring(5, lowercaseFilter.indexOf("matching"));
                    expression = originalFilter.substring(lowercaseFilter.indexOf("matching") + 8).trim();
                    if (lowercaseFilter.contains("using")) {
                        expression = originalFilter.substring(lowercaseFilter.indexOf("matching") + 8, lowercaseFilter.indexOf("using")).trim();
                        color = IDiagramFilterSet.getRGB(lowercaseFilter.substring(lowercaseFilter.indexOf("using") + 5).trim(), expression);
                    }
                }
                if (elementKinds.trim().isEmpty() || expression.trim().isEmpty()) break block59;
                String path = "";
                if (expression.contains("/")) {
                    path = expression.substring(0, expression.lastIndexOf("/") + 1);
                    expression = expression.substring(path.length()).trim();
                }
                String[] stringKinds = elementKinds.split(",");
                EnumSet<INLFilter.NLFilterKind> kinds = EnumSet.noneOf(INLFilter.NLFilterKind.class);
                String[] stringArray = stringKinds;
                int n = stringKinds.length;
                int n2 = 0;
                while (n2 < n) {
                    block63: {
                        String kind = stringArray[n2];
                        if (kind.trim().isEmpty()) break block63;
                        switch (kind.trim()) {
                            case "port": 
                            case "ports": {
                                kinds.add(INLFilter.NLFilterKind.PORT);
                                break;
                            }
                            case "signal": 
                            case "signals": {
                                kinds.add(INLFilter.NLFilterKind.SIGNAL);
                                break;
                            }
                            case "instances": 
                            case "instance": {
                                kinds.add(INLFilter.NLFilterKind.INSTANCE);
                                break;
                            }
                            case "blocks": 
                            case "block": {
                                kinds.add(INLFilter.NLFilterKind.GATE);
                                break;
                            }
                            case "type": 
                            case "types": {
                                kinds.add(INLFilter.NLFilterKind.TYPE);
                                break;
                            }
                            case "input ports": 
                            case "input port": {
                                kinds.add(INLFilter.NLFilterKind.INPUT_PORT);
                                break;
                            }
                            case "output ports": 
                            case "output port": {
                                kinds.add(INLFilter.NLFilterKind.OUTPUT_PORT);
                                break;
                            }
                            case "inout port": 
                            case "inout ports": {
                                kinds.add(INLFilter.NLFilterKind.INOUT_PORT);
                            }
                        }
                    }
                    ++n2;
                }
                if (isColorFilter) {
                    set.addFilter(new NLColorFilter(expression, path.replaceAll(" ", ""), kinds, color));
                } else {
                    set.addFilter(new NLExcludeFilter(expression, path.replaceAll(" ", ""), kinds, include));
                }
            }
            ++i;
        }
        return set;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.allFilters == null ? 0 : this.allFilters.hashCode());
        result = 31 * result + (this.blockColorFilters == null ? 0 : this.blockColorFilters.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.portColorFilters == null ? 0 : this.portColorFilters.hashCode());
        result = 31 * result + (this.signalColorFilters == null ? 0 : this.signalColorFilters.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NLFilterSet other = (NLFilterSet)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.allFilters == null ? other.allFilters != null : !this.allFilters.equals(other.allFilters)) {
            return false;
        }
        if (this.blockColorFilters == null ? other.blockColorFilters != null : !this.blockColorFilters.equals(other.blockColorFilters)) {
            return false;
        }
        if (this.portColorFilters == null ? other.portColorFilters != null : !this.portColorFilters.equals(other.portColorFilters)) {
            return false;
        }
        return !(this.signalColorFilters == null ? other.signalColorFilters != null : !this.signalColorFilters.equals(other.signalColorFilters));
    }
}

