/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.netlist.utils;

import java.util.Iterator;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.DProgressMonitor;
import ro.amiq.dvt.diagrams.exceptions.DCanceledException;
import ro.amiq.dvt.diagrams.netlist.model.NLAbstractBase;
import ro.amiq.dvt.diagrams.netlist.model.NLConnection;
import ro.amiq.dvt.diagrams.netlist.model.NLGate;
import ro.amiq.dvt.diagrams.netlist.model.NLGateKind;
import ro.amiq.dvt.diagrams.netlist.model.NLImplicitGate;
import ro.amiq.dvt.diagrams.netlist.model.NLInstanceGate;
import ro.amiq.dvt.diagrams.netlist.model.NLLogicGate;
import ro.amiq.dvt.diagrams.netlist.model.NLParameters;
import ro.amiq.dvt.diagrams.netlist.model.NLPort;
import ro.amiq.dvt.diagrams.netlist.utils.INLFilter;
import ro.amiq.dvt.diagrams.netlist.utils.NLConfig;
import ro.amiq.dvt.diagrams.netlist.utils.NLConfiguration;
import ro.amiq.dvt.diagrams.netlist.utils.NLFilterSet;
import ro.amiq.dvt.diagrams.netlist.utils.NLProcessors;
import ro.amiq.dvt.diagrams.netlist.utils.NLUtils;
import ro.amiq.dvt.model.reflection.ElementPath;

public class NLFiltersProcessors {
    private NLFiltersProcessors() {
    }

    /*
     * Unable to fully structure code
     */
    public static void hideEverything(NLGate gate, DProgressMonitor monitor) throws DCanceledException {
        NLFiltersProcessors.checkCanceled(monitor);
        if (gate != null) ** GOTO lbl5
        return;
lbl-1000:
        // 1 sources

        {
            gate = gate.getEnclosingGate();
lbl5:
            // 2 sources

            ** while (!gate.isTopGate())
        }
lbl6:
        // 1 sources

        NLFiltersProcessors.hideEverythingDownwards(gate, monitor);
    }

    private static final void hideEverythingDownwards(NLGate gate, DProgressMonitor monitor) throws DCanceledException {
        NLFiltersProcessors.checkCanceled(monitor);
        if (gate == null) {
            return;
        }
        if (gate.isTopGate()) {
            NLUtils.makeGateAndPortsVisible(gate);
        } else {
            NLUtils.makeInvisible(gate);
        }
        Iterator<NLPort> iterator = gate.getPorts().iterator();
        while (iterator.hasNext()) {
            NLPort port = iterator.next();
            NLFiltersProcessors.checkCanceled(monitor);
            NLUtils.makeInvisible(port);
            if (!port.isEdgePort()) continue;
            iterator.remove();
        }
        if (!NLUtils.isExpanded(gate)) {
            return;
        }
        Iterator<NLConnection> iterator2 = ((NLInstanceGate)gate).getSignals().iterator();
        while (iterator2.hasNext()) {
            NLConnection connection = iterator2.next();
            NLFiltersProcessors.checkCanceled(monitor);
            NLUtils.makeInvisible(connection);
            if (!connection.isEdge()) continue;
            iterator2.remove();
        }
        for (NLGate nLGate : ((NLInstanceGate)gate).getSubGates()) {
            NLFiltersProcessors.checkCanceled(monitor);
            NLFiltersProcessors.hideEverythingDownwards(nLGate, monitor);
        }
    }

    private static void showEverything(NLGate gate, boolean showInternalLogic, DProgressMonitor monitor) throws DCanceledException {
        NLFiltersProcessors.checkCanceled(monitor);
        if (gate == null) {
            return;
        }
        for (NLPort nLPort : gate.getPorts()) {
            NLFiltersProcessors.checkCanceled(monitor);
            NLUtils.makeVisible(nLPort);
        }
        if (gate instanceof NLInstanceGate) {
            for (NLConnection nLConnection : ((NLInstanceGate)gate).getSignals()) {
                NLFiltersProcessors.checkCanceled(monitor);
                NLUtils.makeVisible(nLConnection);
            }
            for (NLGate nLGate : ((NLInstanceGate)gate).getSubGates()) {
                NLFiltersProcessors.checkCanceled(monitor);
                if (gate.hasFlag(NLParameters.NLParametersFlag.IS_DETAILED_LOGIC_GATE) && !showInternalLogic) continue;
                NLUtils.makeGateAndPortsVisible(nLGate);
                if (!(nLGate instanceof NLInstanceGate)) continue;
                NLFiltersProcessors.showEverything(nLGate, showInternalLogic, monitor);
            }
        }
    }

    public static void applyFilters(NLInstanceGate gate, NLConfig config, DProgressMonitor monitor) throws DCanceledException {
        NLFiltersProcessors.checkCanceled(monitor);
        if (!config.hasFilters()) {
            return;
        }
        NLFilterSet filterSet = config.getFilterSet();
        for (INLFilter filter : filterSet.getFilters()) {
            NLFiltersProcessors.checkCanceled(monitor);
            NLFiltersProcessors.applyFilterToAllElements(gate, filter, config, monitor);
        }
    }

    private static void applyFilterToAllElements(NLGate gate, INLFilter filter, NLConfig config, DProgressMonitor monitor) throws DCanceledException {
        NLFiltersProcessors.checkCanceled(monitor);
        if (gate == null) {
            return;
        }
        if (gate instanceof NLInstanceGate) {
            for (NLGate nLGate : ((NLInstanceGate)gate).getSubGates()) {
                NLFiltersProcessors.applyFilterToAllElements(nLGate, filter, config, monitor);
            }
        }
        ElementPath elementPath = NLUtils.getDiagramPath(gate);
        String pathString = elementPath.toString("/");
        LanguageKind languageKind = gate instanceof NLInstanceGate ? ((NLInstanceGate)gate).getLanguageKind() : LanguageKind.VLOG;
        NLFiltersProcessors.applyFilterToPorts(gate, filter, languageKind, monitor);
        NLFiltersProcessors.applyFilterToGates(gate, filter, languageKind, elementPath, config.getFlags().contains((Object)NLConfiguration.DETAILED_ALWAYS_BLOCK_LOGIC), monitor);
        NLFiltersProcessors.applyFilterToInstances(gate, filter, languageKind, elementPath, pathString, monitor);
        if (NLUtils.isImplicitGate(gate) && ((NLImplicitGate)gate).hasAllSignalsInvisible()) {
            NLUtils.makeInvisible(gate);
        }
    }

    private static void applyFilterToPorts(NLGate gate, INLFilter filter, LanguageKind languageKind, DProgressMonitor monitor) throws DCanceledException {
        NLFiltersProcessors.checkCanceled(monitor);
        if (!(filter.getKinds().contains((Object)INLFilter.NLFilterKind.PORT) || filter.getKinds().contains((Object)INLFilter.NLFilterKind.INPUT_PORT) || filter.getKinds().contains((Object)INLFilter.NLFilterKind.OUTPUT_PORT) || filter.getKinds().contains((Object)INLFilter.NLFilterKind.INOUT_PORT))) {
            return;
        }
        for (NLPort port : gate.getPorts()) {
            NLFiltersProcessors.checkCanceled(monitor);
            if (filter.getKinds().contains((Object)INLFilter.NLFilterKind.INPUT_PORT) && port.getDirection() != NLPort.NLPortDirection.DIR_IN && port.getDirection() != NLPort.NLPortDirection.DIR_INOUT || filter.getKinds().contains((Object)INLFilter.NLFilterKind.OUTPUT_PORT) && port.getDirection() != NLPort.NLPortDirection.DIR_OUT && port.getDirection() != NLPort.NLPortDirection.DIR_INOUT || filter.getKinds().contains((Object)INLFilter.NLFilterKind.INOUT_PORT) && port.getDirection() != NLPort.NLPortDirection.DIR_INOUT) continue;
            String portPath = NLUtils.getDiagramPath(gate).toString("/") + "/" + port.getName() + NLFiltersProcessors.getPortLabel(port) + (port.getPfInfo() != null ? port.getPfInfo() : "");
            if (filter.matches(portPath, languageKind, false)) {
                NLUtils.makeInvisible(true, port);
            }
            if (!filter.matches(portPath, languageKind, true) || !NLProcessors.canMakeVisible(port)) continue;
            NLUtils.makeVisible(port);
        }
    }

    private static void applyFilterToInstances(NLGate gate, INLFilter filter, LanguageKind languageKind, ElementPath path, String pathString, DProgressMonitor monitor) throws DCanceledException {
        String label;
        NLFiltersProcessors.checkCanceled(monitor);
        if (gate.getKind() != NLGateKind.INSTANCE && gate.getKind() != NLGateKind.DESIGN) {
            return;
        }
        NLFiltersProcessors.applyFilterToSignals(gate, filter, languageKind, pathString, monitor);
        if (gate.isTopGate() || !filter.getKinds().contains((Object)INLFilter.NLFilterKind.INSTANCE) && !filter.getKinds().contains((Object)INLFilter.NLFilterKind.TYPE)) {
            return;
        }
        boolean canMakeInvisible = NLProcessors.canMakeInvisible(gate);
        String type = "";
        String string = label = gate.getLabel() != null ? gate.getLabel() : "";
        if (label.contains("\n")) {
            type = label.substring(label.indexOf("(") + 1, label.length() - 1);
        }
        path = path.removeLastSegment();
        type = String.valueOf(path.toString("/")) + "/" + type;
        if (canMakeInvisible && (filter.getKinds().contains((Object)INLFilter.NLFilterKind.INSTANCE) && filter.matches(pathString, languageKind, false) || filter.getKinds().contains((Object)INLFilter.NLFilterKind.TYPE) && filter.matches(type, languageKind, false))) {
            NLUtils.makeInvisible(true, gate);
        }
        if ((filter.getKinds().contains((Object)INLFilter.NLFilterKind.INSTANCE) && filter.matches(pathString, languageKind, true) || filter.getKinds().contains((Object)INLFilter.NLFilterKind.TYPE) && filter.matches(type, languageKind, true)) && NLProcessors.canMakeVisible(gate)) {
            NLUtils.makeGateAndPortsVisible(gate);
            NLInstanceGate enclosingGate = gate.getEnclosingGate();
            while (enclosingGate != null && !enclosingGate.isTopGate()) {
                NLFiltersProcessors.checkCanceled(monitor);
                if (!NLProcessors.canMakeVisible(enclosingGate)) break;
                NLUtils.makeVisible(enclosingGate);
                enclosingGate = enclosingGate.getEnclosingGate();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void applyFilterToGates(NLGate gate, INLFilter filter, LanguageKind languageKind, ElementPath path, boolean showInternalLogic, DProgressMonitor monitor) throws DCanceledException {
        block23: {
            NLFiltersProcessors.checkCanceled(monitor);
            if (gate.isTopGate()) {
                return;
            }
            if (!filter.getKinds().contains((Object)INLFilter.NLFilterKind.GATE)) {
                return;
            }
            boolean canMakeInvisible = NLProcessors.canMakeInvisible(gate);
            boolean filtered = false;
            String pathString = path.toString("/");
            if (filter.getText().equals(".*")) {
                if (filter.getPath().isEmpty()) {
                    if (filter.isHide() && canMakeInvisible) {
                        NLUtils.makeInvisible(true, gate);
                        filtered = true;
                    } else if (filter.isShow() && NLProcessors.canMakeVisible(gate)) {
                        if (gate instanceof NLLogicGate.NLInternalLogicGate && !showInternalLogic) {
                            return;
                        }
                        NLUtils.makeGateAndPortsVisible(gate);
                        filtered = true;
                    }
                } else {
                    if (!filter.matchesPath(String.valueOf((path = path.removeLastSegment()).toString("/")) + "/", languageKind == LanguageKind.VLOG)) {
                        return;
                    }
                    if (filter.isHide() && canMakeInvisible) {
                        NLUtils.makeInvisible(true, gate);
                        filtered = true;
                    } else if (filter.isShow() && NLProcessors.canMakeVisible(gate)) {
                        if (gate instanceof NLLogicGate.NLInternalLogicGate && !showInternalLogic) {
                            return;
                        }
                        NLUtils.makeVisible(gate);
                        filtered = true;
                    }
                }
            } else if (gate.getKind() == NLGateKind.INSTANCE || gate.getKind() == NLGateKind.BLOCK) {
                if (canMakeInvisible && filter.matches(pathString, languageKind, false)) {
                    NLUtils.makeInvisible(true, gate);
                    filtered = true;
                }
                if (NLProcessors.canMakeVisible(gate) && filter.matches(pathString, languageKind, true)) {
                    void var9_10;
                    NLUtils.makeVisible(gate);
                    NLInstanceGate nLInstanceGate = gate.getEnclosingGate();
                    while (var9_10 != null && !var9_10.isTopGate()) {
                        if (!NLProcessors.canMakeVisible((NLAbstractBase)var9_10)) break;
                        NLUtils.makeVisible(new NLAbstractBase[]{var9_10});
                        NLInstanceGate nLInstanceGate2 = var9_10.getEnclosingGate();
                    }
                    filtered = true;
                }
            }
            if (!filtered || gate.getKind() != NLGateKind.BLOCK) break block23;
            if (NLUtils.isVisible(gate)) {
                for (NLGate nLGate : ((NLInstanceGate)gate).getSubGates()) {
                    if (!NLProcessors.canMakeVisible(nLGate)) continue;
                    NLUtils.makeVisible(nLGate);
                }
            } else {
                for (NLGate nLGate : ((NLInstanceGate)gate).getSubGates()) {
                    if (!NLProcessors.canMakeInvisible(nLGate)) continue;
                    NLUtils.makeInvisible(true, nLGate);
                }
            }
        }
    }

    private static void applyFilterToSignals(NLGate gate, INLFilter filter, LanguageKind languageKind, String pathString, DProgressMonitor monitor) throws DCanceledException {
        NLFiltersProcessors.checkCanceled(monitor);
        if (!filter.getKinds().contains((Object)INLFilter.NLFilterKind.SIGNAL)) {
            return;
        }
        for (NLConnection connection : ((NLInstanceGate)gate).getSignals()) {
            NLFiltersProcessors.checkCanceled(monitor);
            StringBuilder signalPath = new StringBuilder(String.valueOf(pathString) + "/" + connection.getLabel());
            for (NLPort target : connection.getTargets()) {
                if (target.getPfInfo() == null) continue;
                signalPath.append(target.getPfInfo());
            }
            if (!filter.getKinds().contains((Object)INLFilter.NLFilterKind.SIGNAL)) continue;
            if (filter.matches(signalPath.toString(), languageKind, false) && !connection.hasFlag(NLParameters.NLParametersFlag.IS_FOCUSED)) {
                NLUtils.makeInvisible(true, connection);
            }
            if (!filter.matches(signalPath.toString(), languageKind, true) || !NLProcessors.canMakeVisible(connection)) continue;
            NLUtils.makeVisible(connection);
        }
    }

    private static String getPortLabel(NLPort port) {
        if (!port.getLabel().isEmpty()) {
            return "/" + port.getLabel();
        }
        for (NLConnection connection : port.getConnections()) {
            if (!connection.isImplicitSignal()) continue;
            return "/" + connection.getLabel();
        }
        return "";
    }

    private static void checkCanceled(DProgressMonitor monitor) throws DCanceledException {
        if (monitor != null) {
            monitor.checkCanceled();
        }
    }
}

